/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JvmPauseMonitor;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.ZKDeRegisterWatcher;
import org.apache.hadoop.hive.common.ZooKeeperHiveHelper;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hadoop.hive.llap.coordinator.LlapCoordinator;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.events.NotificationEventPoll;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSources;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryExecutionService;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.PolicyProviderContainer;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeSynchronizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.session.ClearDanglingScratchDir;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.hive.registry.impl.ZookeeperUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.http.HttpServer;
import org.apache.hive.http.JdbcJarDownloadServlet;
import org.apache.hive.http.LlapServlet;
import org.apache.hive.http.security.PamAuthenticator;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.hive.service.server.HS2ActivePassiveHARegistry;
import org.apache.hive.service.server.HS2ActivePassiveHARegistryClient;
import org.apache.hive.service.server.HiveServer2Instance;
import org.apache.hive.service.servlet.HS2LeadershipStatus;
import org.apache.hive.service.servlet.HS2Peers;
import org.apache.hive.service.servlet.QueriesRESTfulAPIServlet;
import org.apache.hive.service.servlet.QueryProfileServlet;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.util.Strings;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveServer2
extends CompositeService {
    private static CountDownLatch deleteSignal;
    private static final Logger LOG;
    public static final String INSTANCE_URI_CONFIG = "hive.server2.instance.uri";
    private static final int SHUTDOWN_TIME = 60;
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;
    private CuratorFramework zKClientForPrivSync = null;
    private LeaderLatch privilegeSynchonizerLatch = null;
    private HttpServer webServer;
    private TezSessionPoolManager tezSessionPoolManager;
    private WorkloadManager wm;
    private PamAuthenticator pamAuthenticator;
    private Map<String, String> confsToPublish = new HashMap<String, String>();
    private String serviceUri;
    private boolean serviceDiscovery;
    private boolean activePassiveHA;
    private boolean recoverAms;
    private LeaderLatchListener leaderLatchListener;
    private ExecutorService leaderActionsExecutorService;
    private HS2ActivePassiveHARegistry hs2HARegistry;
    private Hive sessionHive;
    private String wmQueue;
    private AtomicBoolean isLeader = new AtomicBoolean(false);
    private SettableFuture<Boolean> isLeaderTestFuture = SettableFuture.create();
    private SettableFuture<Boolean> notLeaderTestFuture = SettableFuture.create();
    private ZooKeeperHiveHelper zooKeeperHelper = null;
    private ScheduledQueryExecutionService scheduledQueryService;
    private ACLProvider zooKeeperAclProvider;

    public HiveServer2() {
        super(HiveServer2.class.getSimpleName());
        HiveConf.setLoadHiveServer2Config((boolean)true);
    }

    @VisibleForTesting
    public HiveServer2(PamAuthenticator pamAuthenticator) {
        super(HiveServer2.class.getSimpleName());
        HiveConf.setLoadHiveServer2Config((boolean)true);
        this.pamAuthenticator = pamAuthenticator;
    }

    @VisibleForTesting
    public CLIService getCliService() {
        return this.cliService;
    }

    @VisibleForTesting
    public void setPamAuthenticator(PamAuthenticator pamAuthenticator) {
        this.pamAuthenticator = pamAuthenticator;
    }

    @VisibleForTesting
    public SettableFuture<Boolean> getIsLeaderTestFuture() {
        return this.isLeaderTestFuture;
    }

    @VisibleForTesting
    public SettableFuture<Boolean> getNotLeaderTestFuture() {
        return this.notLeaderTestFuture;
    }

    private void resetIsLeaderTestFuture() {
        this.isLeaderTestFuture = SettableFuture.create();
    }

    private void resetNotLeaderTestFuture() {
        this.notLeaderTestFuture = SettableFuture.create();
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        String llapHosts;
        try {
            if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED)) {
                MetricsFactory.init((HiveConf)hiveConf);
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not initiate the HiveServer2 Metrics system.  Metrics may not be reported.", t);
        }
        this.cliService = new CLIService(this, false);
        this.addService(this.cliService);
        final HiveServer2 hiveServer2 = this;
        Runnable oomHook = new Runnable(){

            @Override
            public void run() {
                hiveServer2.stop();
            }
        };
        boolean isHttpTransportMode = HiveServer2.isHttpTransportMode(hiveConf);
        boolean isAllTransportMode = HiveServer2.isAllTransportMode(hiveConf);
        if (isHttpTransportMode || isAllTransportMode) {
            this.thriftCLIService = new ThriftHttpCLIService(this.cliService, oomHook);
            this.addService(this.thriftCLIService);
        }
        if (!isHttpTransportMode || isAllTransportMode) {
            this.thriftCLIService = new ThriftBinaryCLIService(this.cliService, oomHook);
            this.addService(this.thriftCLIService);
        }
        super.init(hiveConf);
        try {
            hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, this.getServerHost());
        }
        catch (Throwable t) {
            throw new Error("Unable to initialize HiveServer2", t);
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_HS2_ENABLE_COORDINATOR)) {
            try {
                LlapCoordinator.initializeInstance((HiveConf)hiveConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((llapHosts = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS)) != null && !llapHosts.isEmpty()) {
            LlapRegistryService.getClient((Configuration)hiveConf);
        }
        CalcitePlanner.warmup();
        try {
            this.sessionHive = Hive.get((HiveConf)hiveConf);
        }
        catch (HiveException e) {
            throw new RuntimeException("Failed to get metastore connection", e);
        }
        HiveMaterializedViewsRegistry.get().init();
        StatsSources.initialize((HiveConf)hiveConf);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_EXECUTOR_ENABLED)) {
            this.scheduledQueryService = ScheduledQueryExecutionService.startScheduledQueryExecutorService((HiveConf)hiveConf);
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED)) {
            try {
                QueryResultsCache.initialize((HiveConf)hiveConf);
            }
            catch (Exception err) {
                throw new RuntimeException("Error initializing the query results cache", err);
            }
        }
        try {
            NotificationEventPoll.initialize((Configuration)hiveConf);
        }
        catch (Exception err) {
            throw new RuntimeException("Error initializing notification event poll", err);
        }
        this.wmQueue = hiveConf.get(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INTERACTIVE_QUEUE.varname, "").trim();
        this.zooKeeperAclProvider = this.getACLProvider(hiveConf);
        this.serviceDiscovery = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY);
        this.activePassiveHA = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ACTIVE_PASSIVE_HA_ENABLE);
        this.recoverAms = this.activePassiveHA && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_AP_HA_RECOVER_SESSIONS);
        try {
            if (this.serviceDiscovery) {
                this.serviceUri = this.getServerInstanceURI();
                this.addConfsToPublish(hiveConf, this.confsToPublish, this.serviceUri);
                if (this.activePassiveHA) {
                    hiveConf.set(INSTANCE_URI_CONFIG, this.serviceUri);
                    this.leaderLatchListener = new HS2LeaderLatchListener(this, SessionState.get());
                    this.leaderActionsExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Leader Actions Handler Thread").build());
                    this.hs2HARegistry = HS2ActivePassiveHARegistry.create((Configuration)hiveConf, false);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        try {
            this.logCompactionParameters(hiveConf);
            this.maybeStartCompactorThreads(hiveConf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            boolean uiDisabledInTest;
            int webUIPort = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT);
            String webHost = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_BIND_HOST);
            boolean bl = uiDisabledInTest = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && webUIPort == Integer.valueOf(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue());
            if (uiDisabledInTest) {
                LOG.info("Web UI is disabled in test mode since webui port was not specified");
            } else if (webUIPort <= 0) {
                LOG.info("Web UI is disabled since port is set to " + webUIPort);
            } else {
                LOG.info("Starting Web UI on port " + webUIPort);
                HttpServer.Builder builder = new HttpServer.Builder("hiveserver2");
                builder.setPort(webUIPort).setConf(hiveConf);
                builder.setHost(webHost);
                builder.setMaxThreads(hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_MAX_THREADS));
                builder.setAdmins(hiveConf.getVar(HiveConf.ConfVars.USERS_IN_ADMIN_ROLE));
                builder.setContextAttribute("hive.sm", (Object)this.cliService.getSessionManager());
                hiveConf.set("startcode", String.valueOf(System.currentTimeMillis()));
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL)) {
                    String keyStorePath = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH);
                    if (Strings.isBlank((String)keyStorePath)) {
                        throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                    }
                    builder.setKeyStorePassword(ShimLoader.getHadoopShims().getPassword((Configuration)hiveConf, HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PASSWORD.varname));
                    builder.setKeyStorePath(keyStorePath);
                    builder.setUseSSL(true);
                }
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SPNEGO)) {
                    String spnegoPrincipal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_PRINCIPAL);
                    String spnegoKeytab = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_KEYTAB);
                    if (Strings.isBlank((String)spnegoPrincipal) || Strings.isBlank((String)spnegoKeytab)) {
                        throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_PRINCIPAL.varname + "/" + HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SPNEGO_KEYTAB.varname + " Not configured for SPNEGO authentication");
                    }
                    builder.setSPNEGOPrincipal(spnegoPrincipal);
                    builder.setSPNEGOKeytab(spnegoKeytab);
                    builder.setUseSPNEGO(true);
                }
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_ENABLE_CORS)) {
                    builder.setEnableCORS(true);
                    String allowedOrigins = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_CORS_ALLOWED_ORIGINS);
                    String allowedMethods = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_CORS_ALLOWED_METHODS);
                    String allowedHeaders = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_CORS_ALLOWED_HEADERS);
                    if (Strings.isBlank((String)allowedOrigins) || Strings.isBlank((String)allowedMethods) || Strings.isBlank((String)allowedHeaders)) {
                        throw new IllegalArgumentException("CORS enabled. But " + HiveConf.ConfVars.HIVE_SERVER2_WEBUI_CORS_ALLOWED_ORIGINS.varname + "/" + HiveConf.ConfVars.HIVE_SERVER2_WEBUI_CORS_ALLOWED_METHODS.varname + "/" + HiveConf.ConfVars.HIVE_SERVER2_WEBUI_CORS_ALLOWED_HEADERS.varname + "/" + " is not configured");
                    }
                    builder.setAllowedOrigins(allowedOrigins);
                    builder.setAllowedMethods(allowedMethods);
                    builder.setAllowedHeaders(allowedHeaders);
                    LOG.info("CORS enabled - allowed-origins: {} allowed-methods: {} allowed-headers: {}", new Object[]{allowedOrigins, allowedMethods, allowedHeaders});
                }
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_XFRAME_ENABLED)) {
                    builder.configureXFrame(true).setXFrameOption(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_XFRAME_VALUE));
                }
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_PAM)) {
                    if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL)) {
                        String hiveServer2PamServices = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES);
                        if (hiveServer2PamServices == null || hiveServer2PamServices.isEmpty()) {
                            throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES.varname + " are not configured.");
                        }
                        builder.setPAMAuthenticator(this.pamAuthenticator == null ? new PamAuthenticator(hiveConf) : this.pamAuthenticator);
                        builder.setUsePAM(true);
                    } else if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                        builder.setPAMAuthenticator(this.pamAuthenticator == null ? new PamAuthenticator(hiveConf) : this.pamAuthenticator);
                        builder.setUsePAM(true);
                    } else {
                        throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL.varname + " has false value. It is recommended to set to true when PAM is used.");
                    }
                }
                if (this.serviceDiscovery && this.activePassiveHA) {
                    builder.setContextAttribute("hs2.isLeader", (Object)this.isLeader);
                    builder.setContextAttribute("hs2.failover.callback", (Object)new FailoverHandlerCallback(this.hs2HARegistry));
                    builder.setContextAttribute("hiveconf", (Object)hiveConf);
                    builder.addServlet("leader", HS2LeadershipStatus.class);
                    builder.addServlet("peers", HS2Peers.class);
                }
                builder.addServlet("llap", LlapServlet.class);
                builder.addServlet("jdbcjar", JdbcJarDownloadServlet.class);
                builder.setContextRootRewriteTarget("/hiveserver2.jsp");
                this.webServer = builder.build();
                this.webServer.addServlet("query_page", "/query_page", QueryProfileServlet.class);
                this.webServer.addServlet("api", "/api/*", QueriesRESTfulAPIServlet.class);
            }
        }
        catch (IOException ie) {
            throw new ServiceException(ie);
        }
        ShutdownHookManager.addShutdownHook(() -> hiveServer2.stop());
    }

    private void logCompactionParameters(HiveConf hiveConf) {
        LOG.info("Compaction HS2 parameters:");
        String runWorkerIn = MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN);
        LOG.info("hive.metastore.runworker.in = {}", (Object)runWorkerIn);
        int numWorkers = MetastoreConf.getIntVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS);
        LOG.info("metastore.compactor.worker.threads = {}", (Object)numWorkers);
        if ("hs2".equals(runWorkerIn) && numWorkers < 1) {
            LOG.warn("Invalid number of Compactor Worker threads({}) on HS2", (Object)numWorkers);
        }
    }

    private WMFullResourcePlan createTestResourcePlan() {
        WMPool pool = new WMPool("testDefault", "llap");
        pool.setAllocFraction(1.0);
        pool.setQueryParallelism(1);
        WMFullResourcePlan resourcePlan = new WMFullResourcePlan(new WMResourcePlan("testDefault"), (List)Lists.newArrayList((Object[])new WMPool[]{pool}));
        resourcePlan.getPlan().setDefaultPoolPath("llap");
        return resourcePlan;
    }

    public static boolean isHttpTransportMode(HiveConf hiveConf) {
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        return transportMode != null && transportMode.equalsIgnoreCase(HiveServer2TransportMode.http.toString());
    }

    public static boolean isAllTransportMode(HiveConf hiveConf) {
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        return transportMode != null && transportMode.equalsIgnoreCase(HiveServer2TransportMode.all.toString());
    }

    public static boolean isKerberosAuthMode(Configuration hiveConf) {
        String authMode = hiveConf.get(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION.varname);
        return authMode != null && authMode.equalsIgnoreCase("KERBEROS");
    }

    private ACLProvider getACLProvider(HiveConf hiveConf) {
        final boolean isSecure = ZookeeperUtils.isKerberosEnabled((Configuration)hiveConf);
        return new ACLProvider(){

            public List<ACL> getDefaultAcl() {
                ArrayList<ACL> nodeAcls = new ArrayList<ACL>();
                if (isSecure) {
                    nodeAcls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
                    nodeAcls.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
                } else {
                    nodeAcls.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
                }
                return nodeAcls;
            }

            public List<ACL> getAclForPath(String path) {
                return this.getDefaultAcl();
            }
        };
    }

    private void addConfsToPublish(HiveConf hiveConf, Map<String, String> confsToPublish, String serviceUri) {
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST));
        confsToPublish.put(INSTANCE_URI_CONFIG, serviceUri);
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE));
        boolean isHttpTransportMode = HiveServer2.isHttpTransportMode(hiveConf);
        boolean isAllTransportMode = HiveServer2.isAllTransportMode(hiveConf);
        if (isHttpTransportMode || isAllTransportMode) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname, Integer.toString(hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT)));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
        }
        if (!isHttpTransportMode || isAllTransportMode) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, Integer.toString(hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT)));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION));
        if (HiveServer2.isKerberosAuthMode((Configuration)hiveConf)) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL.varname, Boolean.toString(hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)));
    }

    private void setUpZooKeeperAuth(HiveConf hiveConf) throws Exception {
        if (ZookeeperUtils.isKerberosEnabled((Configuration)hiveConf)) {
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
            if (principal.isEmpty()) {
                throw new IOException("HiveServer2 Kerberos principal is empty");
            }
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
            if (keyTabFile.isEmpty()) {
                throw new IOException("HiveServer2 Kerberos keytab is empty");
            }
            Utils.setZookeeperClientKerberosJaasConfig((String)principal, (String)keyTabFile);
        }
    }

    public boolean isLeader() {
        return this.isLeader.get();
    }

    public int getOpenSessionsCount() {
        return this.cliService != null ? this.cliService.getSessionManager().getOpenSessionCount() : 0;
    }

    public boolean isDeregisteredWithZooKeeper() {
        if (this.serviceDiscovery && !this.activePassiveHA && this.zooKeeperHelper != null) {
            return this.zooKeeperHelper.isDeregisteredWithZooKeeper();
        }
        return false;
    }

    private String getServerInstanceURI() throws Exception {
        if (this.thriftCLIService == null || this.thriftCLIService.getServerIPAddress() == null) {
            throw new Exception("Unable to get the server address; it hasn't been initialized yet.");
        }
        return this.thriftCLIService.getServerIPAddress().getHostName() + ":" + this.thriftCLIService.getPortNumber();
    }

    public String getServerHost() throws Exception {
        if (this.thriftCLIService == null || this.thriftCLIService.getServerIPAddress() == null) {
            throw new Exception("Unable to get the server address; it hasn't been initialized yet.");
        }
        return this.thriftCLIService.getServerIPAddress().getHostName();
    }

    @Override
    public synchronized void start() {
        super.start();
        HiveConf hiveConf = this.getHiveConf();
        if (!this.serviceDiscovery || !this.activePassiveHA) {
            this.allowClientSessions();
        }
        if (this.serviceDiscovery) {
            try {
                if (this.activePassiveHA) {
                    this.hs2HARegistry.registerLeaderLatchListener(this.leaderLatchListener, this.leaderActionsExecutorService);
                    this.hs2HARegistry.start();
                    LOG.info("HS2 HA registry started");
                } else {
                    String znodeData;
                    boolean publishConfigs = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_PUBLISH_CONFIGS);
                    String instanceURI = this.getServerInstanceURI();
                    if (publishConfigs) {
                        this.addConfsToPublish(hiveConf, this.confsToPublish, this.getServerInstanceURI());
                        znodeData = Joiner.on((char)';').withKeyValueSeparator("=").join(this.confsToPublish);
                    } else {
                        znodeData = instanceURI;
                    }
                    this.setUpZooKeeperAuth(hiveConf);
                    this.zooKeeperHelper = hiveConf.getZKConfig();
                    String znodePathPrefix = "serverUri=" + instanceURI + ";" + "version=" + HiveVersionInfo.getVersion() + ";" + "sequence=";
                    this.zooKeeperHelper.addServerInstanceToZooKeeper(znodePathPrefix, znodeData, this.zooKeeperAclProvider, (ZKDeRegisterWatcher)new DeRegisterWatcher(this.zooKeeperHelper));
                }
            }
            catch (Exception e) {
                LOG.error("Error adding this HiveServer2 instance to ZooKeeper: ", (Throwable)e);
                throw new ServiceException(e);
            }
        }
        try {
            this.startPrivilegeSynchronizer(hiveConf);
        }
        catch (Exception e) {
            LOG.error("Error starting priviledge synchronizer: ", (Throwable)e);
            throw new ServiceException(e);
        }
        if (this.webServer != null) {
            try {
                this.webServer.start();
                LOG.info("Web UI has started on port " + this.webServer.getPort());
            }
            catch (Exception e) {
                LOG.error("Error starting Web UI: ", (Throwable)e);
                throw new ServiceException(e);
            }
        }
        if (hiveConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            if (!this.activePassiveHA) {
                LOG.info("HS2 interactive HA not enabled. Starting tez sessions..");
                try {
                    this.startOrReconnectTezSessions();
                }
                catch (Exception e) {
                    LOG.error("Error starting  Tez sessions: ", (Throwable)e);
                    throw new ServiceException(e);
                }
            } else {
                LOG.info("HS2 interactive HA enabled. Tez sessions will be started/reconnected by the leader.");
            }
        }
    }

    private void startOrReconnectTezSessions() {
        WMFullResourcePlan resourcePlan;
        LOG.info("Starting/Reconnecting tez sessions..");
        try {
            resourcePlan = this.sessionHive.getActiveResourcePlan();
        }
        catch (HiveException e) {
            if (!HiveConf.getBoolVar((Configuration)this.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST_SSL)) {
                throw new RuntimeException(e);
            }
            resourcePlan = null;
        }
        if (resourcePlan == null && HiveConf.getBoolVar((Configuration)this.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST)) {
            LOG.info("Creating a default resource plan for test");
            resourcePlan = this.createTestResourcePlan();
        }
        this.initAndStartTezSessionPoolManager(resourcePlan);
        this.initAndStartWorkloadManager(resourcePlan);
    }

    private void allowClientSessions() {
        this.cliService.getSessionManager().allowSessions(true);
    }

    private void initAndStartTezSessionPoolManager(WMFullResourcePlan resourcePlan) {
        try {
            LOG.info("Initializing tez session pool manager. Active resource plan: {}", (Object)(resourcePlan == null || resourcePlan.getPlan() == null ? "null" : resourcePlan.getPlan().getName()));
            this.tezSessionPoolManager = TezSessionPoolManager.getInstance();
            HiveConf hiveConf = this.getHiveConf();
            if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) {
                if (this.recoverAms) {
                    LOG.warn("AM recovery for non-WM pool is not yet supported.");
                }
                this.tezSessionPoolManager.setupPool(hiveConf);
            } else {
                this.tezSessionPoolManager.setupNonPool(hiveConf);
            }
            this.tezSessionPoolManager.startPool(hiveConf, resourcePlan);
            LOG.info("Tez session pool manager initialized.");
        }
        catch (Exception e) {
            throw new ServiceException("Unable to setup tez session pool", e);
        }
    }

    private void initAndStartWorkloadManager(WMFullResourcePlan resourcePlan) {
        if (StringUtils.isEmpty((CharSequence)this.wmQueue)) {
            LOG.info("Workload management is not enabled as {} config is not set", (Object)HiveConf.ConfVars.HIVE_SERVER2_TEZ_INTERACTIVE_QUEUE.varname);
            return;
        }
        LOG.info("Initializing workload management. Active resource plan: {}", (Object)(resourcePlan == null || resourcePlan.getPlan() == null ? "null" : resourcePlan.getPlan().getName()));
        try {
            this.wm = WorkloadManager.create((String)this.wmQueue, (HiveConf)this.getHiveConf(), (WMFullResourcePlan)resourcePlan, (boolean)this.recoverAms);
            this.wm.start();
            LOG.info("Workload manager initialized.");
        }
        catch (Exception e) {
            throw new ServiceException("Unable to instantiate and start Workload Manager", e);
        }
    }

    private void closeAndDisallowHiveSessions() {
        LOG.info("Closing all open hive sessions.");
        if (this.cliService == null) {
            return;
        }
        this.cliService.getSessionManager().allowSessions(false);
        try {
            for (HiveSession session : this.cliService.getSessionManager().getSessions()) {
                this.cliService.getSessionManager().closeSession(session.getSessionHandle());
            }
            LOG.info("Closed all open hive sessions");
        }
        catch (HiveSQLException e) {
            LOG.error("Unable to close all open sessions.", (Throwable)e);
        }
    }

    private void stopOrDisconnectTezSessions(boolean isStop) {
        LOG.info("Stopping/Disconnecting tez sessions.");
        if (this.tezSessionPoolManager != null) {
            try {
                this.tezSessionPoolManager.stop();
                LOG.info("Stopped tez session pool manager.");
            }
            catch (Exception e) {
                LOG.error("Error while stopping tez session pool manager.", (Throwable)e);
            }
        }
        if (this.wm != null) {
            try {
                this.wm.stop(isStop);
                LOG.info("Stopped workload manager.");
            }
            catch (Exception e) {
                LOG.error("Error while stopping workload manager.", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void stop() {
        LOG.info("Shutting down HiveServer2");
        HiveConf hiveConf = this.getHiveConf();
        super.stop();
        if (this.scheduledQueryService != null) {
            try {
                this.scheduledQueryService.close();
            }
            catch (Exception e) {
                LOG.error("Error stopping schq", (Throwable)e);
            }
        }
        if (this.hs2HARegistry != null) {
            this.hs2HARegistry.stop();
            this.shutdownExecutor(this.leaderActionsExecutorService);
            LOG.info("HS2 HA registry stopped");
            this.hs2HARegistry = null;
        }
        if (this.webServer != null) {
            try {
                this.webServer.stop();
                LOG.info("Web UI has stopped");
            }
            catch (Exception e) {
                LOG.error("Error stopping Web UI: ", (Throwable)e);
            }
        }
        if (MetricsFactory.getInstance() != null) {
            try {
                MetricsFactory.close();
            }
            catch (Exception e) {
                LOG.error("error in Metrics deinit: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.serviceDiscovery && !this.activePassiveHA) {
            try {
                if (this.zooKeeperHelper != null) {
                    this.zooKeeperHelper.removeServerInstanceFromZooKeeper();
                }
            }
            catch (Exception e) {
                LOG.error("Error removing znode for this HiveServer2 instance from ZooKeeper.", (Throwable)e);
            }
        }
        this.stopOrDisconnectTezSessions(true);
        if (hiveConf != null && hiveConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
            try {
                SparkSessionManagerImpl.getInstance().shutdown();
            }
            catch (Exception ex) {
                LOG.error("Spark session pool manager failed to stop during HiveServer2 shutdown.", (Throwable)ex);
            }
        }
        if (this.zKClientForPrivSync != null) {
            this.zKClientForPrivSync.close();
        }
        if (this.privilegeSynchonizerLatch != null) {
            try {
                this.privilegeSynchonizerLatch.close();
            }
            catch (IOException e) {
                LOG.error("Error close privilegeSynchonizerLatch");
            }
        }
    }

    private void shutdownExecutor(ExecutorService leaderActionsExecutorService) {
        leaderActionsExecutorService.shutdown();
        try {
            if (!leaderActionsExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOG.warn("Executor service did not terminate in the specified time {} sec", (Object)60);
                List<Runnable> droppedTasks = leaderActionsExecutorService.shutdownNow();
                LOG.warn("Executor service was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Executor service did not terminate in the specified time {} sec. Exception: {}", (Object)60, (Object)e.getMessage());
            List<Runnable> droppedTasks = leaderActionsExecutorService.shutdownNow();
            LOG.warn("Executor service was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
        }
    }

    @VisibleForTesting
    public static void scheduleClearDanglingScratchDir(HiveConf hiveConf, int initialWaitInSec) {
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_CLEAR_DANGLING_SCRATCH_DIR)) {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("cleardanglingscratchdir-%d").daemon(true).build());
            executor.scheduleAtFixedRate((Runnable)new ClearDanglingScratchDir(false, false, false, HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIR), hiveConf), initialWaitInSec, HiveConf.getTimeVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_CLEAR_DANGLING_SCRATCH_DIR_INTERVAL, (TimeUnit)TimeUnit.SECONDS), TimeUnit.SECONDS);
        }
    }

    public void startPrivilegeSynchronizer(HiveConf hiveConf) throws Exception {
        if (!HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PRIVILEGE_SYNCHRONIZER)) {
            return;
        }
        PolicyProviderContainer policyContainer = new PolicyProviderContainer();
        HiveAuthorizer authorizer = SessionState.get().getAuthorizerV2();
        if (authorizer.getHivePolicyProvider() != null) {
            policyContainer.addAuthorizer(authorizer);
        }
        if (MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS) != null && MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS).contains("org.apache.hadoop.hive.ql.security.authorization.AuthorizationPreEventListener") && MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_AUTHORIZATION_MANAGER) != null) {
            List providers = HiveUtils.getMetaStoreAuthorizeProviderManagers((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, (HiveAuthenticationProvider)SessionState.get().getAuthenticator());
            for (HiveMetastoreAuthorizationProvider provider : providers) {
                if (provider.getHivePolicyProvider() == null) continue;
                policyContainer.addAuthorizationProvider(provider);
            }
        }
        if (policyContainer.size() > 0) {
            String rootNamespace;
            block8: {
                this.setUpZooKeeperAuth(hiveConf);
                this.zKClientForPrivSync = hiveConf.getZKConfig().startZookeeperClient(this.zooKeeperAclProvider, true);
                rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LEADER_ZOOKEEPER_NAMESPACE);
                try {
                    ((ACLBackgroundPathAndBytesable)this.zKClientForPrivSync.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/" + rootNamespace);
                    LOG.info("Created the root name space: " + rootNamespace + " on ZooKeeper for HiveServer2");
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NODEEXISTS) break block8;
                    LOG.error("Unable to create HiveServer2 namespace: " + rootNamespace + " on ZooKeeper", (Throwable)e);
                    throw e;
                }
            }
            String path = "/" + rootNamespace + "/" + "privilege_synchonizer";
            LeaderLatch privilegeSynchronizerLatch = new LeaderLatch(this.zKClientForPrivSync, path);
            privilegeSynchronizerLatch.start();
            LOG.info("Find " + policyContainer.size() + " policy to synchronize, start PrivilegeSynchronizer");
            Thread privilegeSynchronizerThread = new Thread((Runnable)new PrivilegeSynchronizer(privilegeSynchronizerLatch, policyContainer, hiveConf), "PrivilegeSynchronizer");
            privilegeSynchronizerThread.start();
        } else {
            LOG.warn("No policy provider found, skip creating PrivilegeSynchonizer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startHiveServer2() throws Throwable {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            LOG.info("Starting HiveServer2");
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            long retrySleepIntervalMs = hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_SLEEP_INTERVAL_BETWEEN_START_ATTEMPTS, TimeUnit.MILLISECONDS);
            HiveServer2 server = null;
            try {
                ServerUtils.cleanUpScratchDir((HiveConf)hiveConf);
                HiveServer2.scheduleClearDanglingScratchDir(hiveConf, new Random().nextInt(600));
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                try {
                    JvmPauseMonitor pauseMonitor = new JvmPauseMonitor((Configuration)hiveConf);
                    pauseMonitor.start();
                }
                catch (Throwable t) {
                    LOG.warn("Could not initiate the JvmPauseMonitor thread. GCs and Pauses may not be warned upon.", t);
                }
                if (!hiveConf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) break;
                SparkSessionManagerImpl.getInstance().setup(hiveConf);
            }
            catch (Throwable throwable) {
                if (server != null) {
                    try {
                        server.stop();
                    }
                    catch (Throwable t) {
                        LOG.info("Exception caught when calling stop of HiveServer2 before retrying start", t);
                    }
                    finally {
                        server = null;
                    }
                }
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn("Error starting HiveServer2 on attempt " + attempts + ", will retry in " + retrySleepIntervalMs + "ms", throwable);
                try {
                    Thread.sleep(retrySleepIntervalMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    private void maybeStartCompactorThreads(HiveConf hiveConf) throws Exception {
        if (MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN).equals("hs2")) {
            int numWorkers = MetastoreConf.getIntVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS);
            for (int i = 0; i < numWorkers; ++i) {
                Worker w = new Worker();
                CompactorThread.initializeAndStartThread((CompactorThread)w, (Configuration)hiveConf);
            }
            LOG.info("This HS2 instance will act as Compactor Worker with {} threads", (Object)numWorkers);
        }
    }

    static void deleteServerInstancesFromZooKeeper(String versionNumber) throws Exception {
        HiveConf hiveConf = new HiveConf();
        CuratorFramework zooKeeperClient = hiveConf.getZKConfig().getNewZookeeperClient();
        zooKeeperClient.start();
        String rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_NAMESPACE);
        List znodePaths = (List)zooKeeperClient.getChildren().forPath("/" + rootNamespace);
        for (int i = 0; i < znodePaths.size(); ++i) {
            String znodePath = (String)znodePaths.get(i);
            deleteSignal = new CountDownLatch(1);
            if (!znodePath.contains("version=" + versionNumber + ";")) continue;
            String fullZnodePath = "/" + rootNamespace + "/" + znodePath;
            LOG.warn("Will attempt to remove the znode: " + fullZnodePath + " from ZooKeeper");
            System.out.println("Will attempt to remove the znode: " + fullZnodePath + " from ZooKeeper");
            ((ErrorListenerPathable)((ChildrenDeletable)zooKeeperClient.delete().guaranteed()).inBackground((BackgroundCallback)new DeleteCallBack())).forPath(fullZnodePath);
            deleteSignal.await();
            List znodePathsUpdated = (List)zooKeeperClient.getChildren().forPath("/" + rootNamespace);
            znodePathsUpdated.removeAll(znodePaths);
            znodePaths.addAll(znodePathsUpdated);
        }
        zooKeeperClient.close();
    }

    public static void main(String[] args) {
        HiveConf.setLoadHiveServer2Config((boolean)true);
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            ServerOptionsProcessorResponse oprocResponse = oproc.parse(args);
            String initLog4jMessage = LogUtils.initHiveLog4j();
            LOG.debug(initLog4jMessage);
            HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Logger)LOG);
            LOG.debug(oproc.getDebugMessage().toString());
            oprocResponse.getServerOptionsExecutor().execute();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.error("Error initializing log: " + e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(HiveServer2.class);
    }

    static class ListHAPeersExecutor
    implements ServerOptionsExecutor {
        ListHAPeersExecutor() {
        }

        @Override
        public void execute() {
            try {
                HiveConf hiveConf = new HiveConf();
                HS2ActivePassiveHARegistry haRegistry = HS2ActivePassiveHARegistryClient.getClient((Configuration)hiveConf);
                HS2Peers.HS2Instances hs2Instances = new HS2Peers.HS2Instances(haRegistry.getAll());
                String jsonOut = hs2Instances.toJson();
                System.out.println(jsonOut);
            }
            catch (IOException e) {
                LOG.error("Error listing HiveServer2 HA instances from ZooKeeper", (Throwable)e);
                System.err.println("Error listing HiveServer2 HA instances from ZooKeeper" + e);
                System.exit(-1);
            }
            System.exit(0);
        }
    }

    static class FailoverHS2InstanceExecutor
    implements ServerOptionsExecutor {
        private final String workerIdentity;

        FailoverHS2InstanceExecutor(String workerIdentity) {
            this.workerIdentity = workerIdentity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            try {
                String webPort;
                HiveConf hiveConf = new HiveConf();
                HS2ActivePassiveHARegistry haRegistry = HS2ActivePassiveHARegistryClient.getClient((Configuration)hiveConf);
                Collection<HiveServer2Instance> hs2Instances = haRegistry.getAll();
                if (hs2Instances.isEmpty()) {
                    LOG.error("No HiveServer2 instances are running in HA mode");
                    System.err.println("No HiveServer2 instances are running in HA mode");
                    System.exit(-1);
                }
                HiveServer2Instance targetInstance = null;
                for (HiveServer2Instance instance : hs2Instances) {
                    if (!instance.getWorkerIdentity().equals(this.workerIdentity)) continue;
                    targetInstance = instance;
                    break;
                }
                if (targetInstance == null) {
                    LOG.error("Cannot find any HiveServer2 instance with workerIdentity: " + this.workerIdentity);
                    System.err.println("Cannot find any HiveServer2 instance with workerIdentity: " + this.workerIdentity);
                    System.exit(-1);
                }
                if (hs2Instances.size() == 1) {
                    LOG.error("Only one HiveServer2 instance running in thefail cluster. Cannot failover: " + this.workerIdentity);
                    System.err.println("Only one HiveServer2 instance running in the cluster. Cannot failover: " + this.workerIdentity);
                    System.exit(-1);
                }
                if (!targetInstance.isLeader()) {
                    LOG.error("HiveServer2 instance (workerIdentity: " + this.workerIdentity + ") is not a leader. Cannot failover");
                    System.err.println("HiveServer2 instance (workerIdentity: " + this.workerIdentity + ") is not a leader. Cannot failover");
                    System.exit(-1);
                }
                if (StringUtils.isEmpty((CharSequence)(webPort = (String)targetInstance.getProperties().get(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname)))) {
                    LOG.error("Unable to determine web port for instance: " + this.workerIdentity);
                    System.err.println("Unable to determine web port for instance: " + this.workerIdentity);
                    System.exit(-1);
                }
                String webEndpoint = "http://" + targetInstance.getHost() + ":" + webPort + "/leader";
                HttpDelete httpDelete = new HttpDelete(webEndpoint);
                try (CloseableHttpResponse httpResponse = null;
                     CloseableHttpClient client = HttpClients.createDefault();){
                    StatusLine statusLine;
                    int statusCode = -1;
                    String response = "Response unavailable";
                    httpResponse = client.execute((HttpUriRequest)httpDelete);
                    if (httpResponse != null && (statusLine = httpResponse.getStatusLine()) != null) {
                        response = httpResponse.getStatusLine().getReasonPhrase();
                        statusCode = httpResponse.getStatusLine().getStatusCode();
                        if (statusCode == 200) {
                            System.out.println(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                        }
                    }
                    if (statusCode != 200) {
                        LOG.error("Unable to failover HiveServer2 instance: " + this.workerIdentity + ". status code: " + statusCode + "error: " + response);
                        System.err.println("Unable to failover HiveServer2 instance: " + this.workerIdentity + ". status code: " + statusCode + " error: " + response);
                        System.exit(-1);
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Error listing HiveServer2 HA instances from ZooKeeper", (Throwable)e);
                System.err.println("Error listing HiveServer2 HA instances from ZooKeeper" + e);
                System.exit(-1);
            }
            System.exit(0);
        }
    }

    static class DeregisterOptionExecutor
    implements ServerOptionsExecutor {
        private final String versionNumber;

        DeregisterOptionExecutor(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public void execute() {
            try {
                HiveServer2.deleteServerInstancesFromZooKeeper(this.versionNumber);
            }
            catch (Exception e) {
                LOG.error("Error deregistering HiveServer2 instances for version: " + this.versionNumber + " from ZooKeeper", (Throwable)e);
                System.out.println("Error deregistering HiveServer2 instances for version: " + this.versionNumber + " from ZooKeeper." + e);
                System.exit(-1);
            }
            System.exit(0);
        }
    }

    static class StartOptionExecutor
    implements ServerOptionsExecutor {
        StartOptionExecutor() {
        }

        @Override
        public void execute() {
            try {
                HiveServer2.startHiveServer2();
            }
            catch (Throwable t) {
                LOG.error("Error starting HiveServer2", t);
                System.exit(-1);
            }
        }
    }

    static class HelpOptionExecutor
    implements ServerOptionsExecutor {
        private final Options options;
        private final String serverName;

        HelpOptionExecutor(String serverName, Options options) {
            this.options = options;
            this.serverName = serverName;
        }

        @Override
        public void execute() {
            new HelpFormatter().printHelp(this.serverName, this.options);
            System.exit(0);
        }
    }

    static interface ServerOptionsExecutor {
        public void execute();
    }

    static class ServerOptionsProcessorResponse {
        private final ServerOptionsExecutor serverOptionsExecutor;

        ServerOptionsProcessorResponse(ServerOptionsExecutor serverOptionsExecutor) {
            this.serverOptionsExecutor = serverOptionsExecutor;
        }

        ServerOptionsExecutor getServerOptionsExecutor() {
            return this.serverOptionsExecutor;
        }
    }

    static class ServerOptionsProcessor {
        private final Options options = new Options();
        private CommandLine commandLine;
        private final String serverName;
        private final StringBuilder debugMessage = new StringBuilder();

        ServerOptionsProcessor(String serverName) {
            this.serverName = serverName;
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs((int)2);
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.withLongOpt((String)"hiveconf");
            OptionBuilder.withDescription((String)"Use value for given property");
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.hasArgs((int)1);
            OptionBuilder.withArgName((String)"versionNumber");
            OptionBuilder.withLongOpt((String)"deregister");
            OptionBuilder.withDescription((String)"Deregister all instances of given version from dynamic service discovery");
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.hasArgs((int)0);
            OptionBuilder.withLongOpt((String)"listHAPeers");
            OptionBuilder.withDescription((String)"List all HS2 instances when running in Active Passive HA mode");
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.hasArgs((int)1);
            OptionBuilder.withArgName((String)"workerIdentity");
            OptionBuilder.withLongOpt((String)"failover");
            OptionBuilder.withDescription((String)"Manually failover Active HS2 instance to passive standby mode");
            this.options.addOption(OptionBuilder.create());
            this.options.addOption(new Option("H", "help", false, "Print help information"));
        }

        ServerOptionsProcessorResponse parse(String[] argv) {
            try {
                this.commandLine = new GnuParser().parse(this.options, argv);
                Properties confProps = this.commandLine.getOptionProperties("hiveconf");
                for (String propKey : confProps.stringPropertyNames()) {
                    this.debugMessage.append("Setting " + propKey + "=" + confProps.getProperty(propKey) + ";\n");
                    if (propKey.equalsIgnoreCase("hive.root.logger")) {
                        CommonCliOptions.splitAndSetLogger((String)propKey, (Properties)confProps);
                        continue;
                    }
                    System.setProperty(propKey, confProps.getProperty(propKey));
                }
                if (this.commandLine.hasOption('H')) {
                    return new ServerOptionsProcessorResponse(new HelpOptionExecutor(this.serverName, this.options));
                }
                if (this.commandLine.hasOption("deregister")) {
                    return new ServerOptionsProcessorResponse(new DeregisterOptionExecutor(this.commandLine.getOptionValue("deregister")));
                }
                if (this.commandLine.hasOption("listHAPeers")) {
                    return new ServerOptionsProcessorResponse(new ListHAPeersExecutor());
                }
                if (this.commandLine.hasOption("failover")) {
                    return new ServerOptionsProcessorResponse(new FailoverHS2InstanceExecutor(this.commandLine.getOptionValue("failover")));
                }
            }
            catch (ParseException e) {
                System.err.println("Error starting HiveServer2 with given arguments: ");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return new ServerOptionsProcessorResponse(new StartOptionExecutor());
        }

        StringBuilder getDebugMessage() {
            return this.debugMessage;
        }
    }

    private static class DeleteCallBack
    implements BackgroundCallback {
        private DeleteCallBack() {
        }

        public void processResult(CuratorFramework zooKeeperClient, CuratorEvent event) throws Exception {
            if (event.getType() == CuratorEventType.DELETE) {
                deleteSignal.countDown();
            }
        }
    }

    private static class HS2LeaderLatchListener
    implements LeaderLatchListener {
        private HiveServer2 hiveServer2;
        private SessionState parentSession;

        HS2LeaderLatchListener(HiveServer2 hs2, SessionState parentSession) {
            this.hiveServer2 = hs2;
            this.parentSession = parentSession;
        }

        public void isLeader() {
            LOG.info("HS2 instance {} became the LEADER. Starting/Reconnecting tez sessions..", (Object)this.hiveServer2.serviceUri);
            this.hiveServer2.isLeader.set(true);
            if (this.parentSession != null) {
                SessionState.setCurrentSessionState((SessionState)this.parentSession);
            }
            this.hiveServer2.startOrReconnectTezSessions();
            LOG.info("Started/Reconnected tez sessions.");
            this.hiveServer2.allowClientSessions();
            if (HiveConf.getBoolVar((Configuration)this.hiveServer2.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST)) {
                this.hiveServer2.isLeaderTestFuture.set((Object)true);
                this.hiveServer2.resetNotLeaderTestFuture();
            }
        }

        public void notLeader() {
            LOG.info("HS2 instance {} LOST LEADERSHIP. Stopping/Disconnecting tez sessions..", (Object)this.hiveServer2.serviceUri);
            this.hiveServer2.isLeader.set(false);
            this.hiveServer2.closeAndDisallowHiveSessions();
            this.hiveServer2.stopOrDisconnectTezSessions(false);
            LOG.info("Stopped/Disconnected tez sessions.");
            if (HiveConf.getBoolVar((Configuration)this.hiveServer2.getHiveConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST)) {
                this.hiveServer2.notLeaderTestFuture.set((Object)true);
                this.hiveServer2.resetIsLeaderTestFuture();
            }
        }
    }

    public class DeRegisterWatcher
    extends ZKDeRegisterWatcher {
        public DeRegisterWatcher(ZooKeeperHiveHelper zooKeeperHiveHelper) {
            super(zooKeeperHiveHelper);
        }

        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted) && HiveServer2.this.cliService.getSessionManager().getOpenSessionCount() == 0) {
                LOG.warn("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
                HiveServer2.this.stop();
            }
        }
    }

    public static class FailoverHandlerCallback
    implements FailoverHandler {
        private HS2ActivePassiveHARegistry hs2HARegistry;

        FailoverHandlerCallback(HS2ActivePassiveHARegistry hs2HARegistry) {
            this.hs2HARegistry = hs2HARegistry;
        }

        @Override
        public void failover() throws Exception {
            this.hs2HARegistry.failover();
        }
    }

    static interface FailoverHandler {
        public void failover() throws Exception;
    }
}

