/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class SQLOperation
extends ExecuteStatementOperation {
    private IDriver driver = null;
    private TableSchema resultSchema;
    private AbstractSerDe serde = null;
    private boolean fetchStarted = false;
    private volatile MetricsScope currentSQLStateScope;
    private QueryInfo queryInfo;
    private long queryTimeout;
    private ScheduledExecutorService timeoutExecutor;
    private final boolean runAsync;
    private final long operationLogCleanupDelayMs;
    private static Map<String, AtomicInteger> userQueries = new HashMap<String, AtomicInteger>();
    private static final String ACTIVE_SQL_USER = "hs2_sql_operation_active_user";
    private MetricsScope submittedQryScp;
    private final transient List<Object> convey = new ArrayList<Object>();

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout) {
        this(parentSession, statement, confOverlay, runInBackground, queryTimeout, false);
    }

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout, boolean embedded) {
        super(parentSession, statement, confOverlay, runInBackground, embedded);
        this.runAsync = runInBackground;
        this.queryTimeout = queryTimeout;
        long timeout = HiveConf.getTimeVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        if (timeout > 0L && (queryTimeout <= 0L || timeout < queryTimeout)) {
            this.queryTimeout = timeout;
        }
        this.operationLogCleanupDelayMs = HiveConf.getTimeVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_OPERATION_LOG_CLEANUP_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        this.setupSessionIO(parentSession.getSessionState());
        this.queryInfo = new QueryInfo(this.getState().toString(), this.getParentSession().getUserName(), this.getExecutionEngine(), this.getHandle().getHandleIdentifier().toString());
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            this.submittedQryScp = metrics.createScope("hs2_submitted_queries");
        }
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runAsync;
    }

    private void setupSessionIO(SessionState sessionState) {
        try {
            sessionState.in = null;
            sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            sessionState.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error creating PrintStream", (Throwable)e);
            e.printStackTrace();
            sessionState.out = null;
            sessionState.info = null;
            sessionState.err = null;
        }
    }

    public void prepare(final QueryState queryState) throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            this.driver = DriverFactory.newDriver((QueryState)queryState, (String)this.getParentSession().getUserName(), (QueryInfo)this.queryInfo);
            if (this.queryTimeout > 0L) {
                this.timeoutExecutor = new ScheduledThreadPoolExecutor(1);
                Runnable timeoutTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String queryId = queryState.getQueryId();
                            Operation.LOG.info("Query timed out after: " + SQLOperation.this.queryTimeout + " seconds. Cancelling the execution now: " + queryId);
                            SQLOperation.this.cancel(OperationState.TIMEDOUT);
                        }
                        catch (HiveSQLException e) {
                            Operation.LOG.error("Error cancelling the query after timeout: " + SQLOperation.this.queryTimeout + " seconds", (Throwable)e);
                        }
                        finally {
                            SQLOperation.this.timeoutExecutor.shutdown();
                        }
                    }
                };
                this.timeoutExecutor.schedule(timeoutTask, this.queryTimeout, TimeUnit.SECONDS);
            }
            this.queryInfo.setQueryDisplay(this.driver.getQueryDisplay());
            if (this.operationLog != null) {
                this.queryInfo.setOperationLogLocation(this.operationLog.toString());
            }
            String guid64 = Base64.encodeBase64URLSafeString((byte[])this.getHandle().getHandleIdentifier().toTHandleIdentifier().getGuid()).trim();
            this.driver.setOperationId(guid64);
            this.driver.compileAndRespond(this.statement);
            if (queryState.getQueryTag() != null && queryState.getQueryId() != null) {
                this.parentSession.updateQueryTag(queryState.getQueryId(), queryState.getQueryTag());
            }
            this.setHasResultSet(this.driver.hasResultSet());
        }
        catch (CommandProcessorException e) {
            this.setState(OperationState.ERROR);
            throw this.toSQLException("Error while compiling statement", e);
        }
        catch (Throwable e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
    }

    private void runQuery() throws HiveSQLException {
        try {
            OperationState opState = this.getStatus().getState();
            if (opState.isTerminal()) {
                LOG.info("Not running the query. Operation is already in terminal state: " + (Object)((Object)opState) + ", perhaps cancelled due to query timeout or by another thread.");
                return;
            }
            this.driver.run();
        }
        catch (Throwable e) {
            if (this.getStatus().getState() == OperationState.CANCELED || this.getStatus().getState() == OperationState.TIMEDOUT || this.getStatus().getState() == OperationState.CLOSED || this.getStatus().getState() == OperationState.FINISHED) {
                LOG.warn("Ignore exception in terminal state", e);
                return;
            }
            this.setState(OperationState.ERROR);
            if (e instanceof CommandProcessorException) {
                throw this.toSQLException("Error while compiling statement", (CommandProcessorException)e);
            }
            if (e instanceof HiveSQLException) {
                throw (HiveSQLException)e;
            }
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        boolean asyncPrepare;
        this.setState(OperationState.PENDING);
        boolean runAsync = this.shouldRunAsync();
        boolean bl = asyncPrepare = runAsync && HiveConf.getBoolVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_ASYNC_COMPILE);
        if (!asyncPrepare) {
            this.prepare(this.queryState);
        }
        if (!runAsync) {
            this.runQuery();
        } else {
            BackgroundWork work = new BackgroundWork(this.getCurrentUGI(), this.parentSession.getSessionHive(), SessionState.getPerfLogger(), SessionState.get(), asyncPrepare);
            try {
                Future<?> backgroundHandle = this.getParentSession().submitBackgroundOperation(work);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
            }
        }
    }

    private UserGroupInformation getCurrentUGI() throws HiveSQLException {
        try {
            return Utils.getUGI();
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get current user", e);
        }
    }

    private synchronized void cleanup(OperationState state) throws HiveSQLException {
        Future<?> backgroundHandle;
        this.setState(state);
        if (this.shouldRunAsync() && state != OperationState.CANCELED && state != OperationState.TIMEDOUT && (backgroundHandle = this.getBackgroundHandle()) != null) {
            boolean success = backgroundHandle.cancel(true);
            String queryId = this.queryState.getQueryId();
            if (success) {
                LOG.info("The running operation has been successfully interrupted: " + queryId);
            } else if (state == OperationState.CANCELED) {
                LOG.info("The running operation could not be cancelled, typically because it has already completed normally: " + queryId);
            }
        }
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        this.driver = null;
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.warn("Operation seems to be in invalid state, SessionState is null");
        } else {
            ss.deleteTmpOutputFile();
            ss.deleteTmpErrOutputFile();
        }
        if (this.timeoutExecutor != null && state != OperationState.TIMEDOUT && state.isTerminal()) {
            this.timeoutExecutor.shutdownNow();
        }
    }

    @Override
    public void cancel(OperationState stateAfterCancel) throws HiveSQLException {
        String queryId = null;
        if (stateAfterCancel == OperationState.CANCELED) {
            queryId = this.queryState.getQueryId();
            LOG.info("Cancelling the query execution: " + queryId);
        }
        this.cleanup(stateAfterCancel);
        this.cleanupOperationLog(this.operationLogCleanupDelayMs);
        if (stateAfterCancel == OperationState.CANCELED) {
            LOG.info("Successfully cancelled the query: " + queryId);
        }
    }

    @Override
    public void close() throws HiveSQLException {
        if (!this.embedded) {
            this.cleanup(OperationState.CLOSED);
            this.cleanupOperationLog(0L);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(Arrays.asList(OperationState.RUNNING, OperationState.FINISHED));
        if (this.resultSchema == null) {
            this.resultSchema = new TableSchema(this.driver.getSchema());
        }
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        this.assertState(new ArrayList<OperationState>(Arrays.asList(OperationState.FINISHED)));
        FetchTask fetchTask = this.driver.getFetchTask();
        boolean isBlobBased = false;
        if (fetchTask != null && ((FetchWork)fetchTask.getWork()).isUsingThriftJDBCBinarySerDe()) {
            maxRows = 1L;
            isBlobBased = true;
        }
        this.driver.setMaxRows((int)maxRows);
        RowSet rowSet = RowSetFactory.create(this.getResultSetSchema(), this.getProtocolVersion(), isBlobBased);
        try {
            if (orientation.equals((Object)FetchOrientation.FETCH_FIRST) && this.fetchStarted) {
                this.driver.resetFetch();
            }
            this.fetchStarted = true;
            this.driver.setMaxRows((int)maxRows);
            if (this.driver.getResults(this.convey)) {
                RowSet rowSet2 = this.decode(this.convey, rowSet);
                return rowSet2;
            }
            RowSet rowSet3 = rowSet;
            return rowSet3;
        }
        catch (IOException e) {
            throw new HiveSQLException(e);
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
        finally {
            this.convey.clear();
        }
    }

    @Override
    public String getTaskStatus() throws HiveSQLException {
        List statuses;
        if (this.driver != null && (statuses = this.driver.getQueryDisplay().getTaskDisplays()) != null) {
            ByteArrayOutputStream out = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                out = new ByteArrayOutputStream();
                mapper.writeValue((OutputStream)out, (Object)statuses);
                String string = out.toString("UTF-8");
                return string;
            }
            catch (JsonGenerationException e) {
                throw new HiveSQLException(e);
            }
            catch (JsonMappingException e) {
                throw new HiveSQLException(e);
            }
            catch (IOException e) {
                throw new HiveSQLException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new HiveSQLException(e);
                    }
                }
            }
        }
        return null;
    }

    private RowSet decode(List<Object> rows, RowSet rowSet) throws Exception {
        if (this.driver.isFetchingTable()) {
            return this.prepareFromRow(rows, rowSet);
        }
        return this.decodeFromString(rows, rowSet);
    }

    private RowSet prepareFromRow(List<Object> rows, RowSet rowSet) throws Exception {
        for (Object row : rows) {
            rowSet.addRow((Object[])row);
        }
        return rowSet;
    }

    private RowSet decodeFromString(List<Object> rows, RowSet rowSet) throws SQLException, SerDeException {
        this.getSerDe();
        StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object[] deserializedFields = new Object[fieldRefs.size()];
        int protocol = this.getProtocolVersion().getValue();
        for (Object rowString : rows) {
            Object rowObj;
            try {
                rowObj = this.serde.deserialize((Writable)new BytesWritable(((String)rowString).getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new SerDeException((Throwable)e);
            }
            for (int i = 0; i < fieldRefs.size(); ++i) {
                StructField fieldRef = (StructField)fieldRefs.get(i);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                Object fieldData = soi.getStructFieldData(rowObj, fieldRef);
                deserializedFields[i] = SerDeUtils.toThriftPayload((Object)fieldData, (ObjectInspector)fieldOI, (int)protocol);
            }
            rowSet.addRow(deserializedFields);
        }
        return rowSet;
    }

    private AbstractSerDe getSerDe() throws SQLException {
        if (this.serde != null) {
            return this.serde;
        }
        try {
            Schema mResultSchema = this.driver.getSchema();
            List fieldSchemas = mResultSchema.getFieldSchemas();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    namesSb.append(((FieldSchema)fieldSchemas.get(pos)).getName());
                    typesSb.append(((FieldSchema)fieldSchemas.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.debug("Column names: " + names);
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.debug("Column types: " + types);
                props.setProperty("columns.types", types);
            }
            SerDeUtils.initializeSerDe((Deserializer)this.serde, (Configuration)this.queryState.getConf(), (Properties)props, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
        return this.serde;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    protected void onNewState(OperationState state, OperationState prevState) {
        super.onNewState(state, prevState);
        this.currentSQLStateScope = this.updateOperationStateMetrics(this.currentSQLStateScope, "hs2_sql_operation_", "hs2_completed_sql_operation_", state);
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            if (state == OperationState.RUNNING && prevState != state) {
                this.incrementUserQueries(metrics);
            }
            if (prevState == OperationState.RUNNING && prevState != state) {
                this.decrementUserQueries(metrics);
            }
        }
        if (state == OperationState.FINISHED || state == OperationState.CANCELED || state == OperationState.ERROR) {
            this.queryInfo.setRuntime(this.getOperationComplete() - this.getOperationStart());
            if (metrics != null && this.submittedQryScp != null) {
                metrics.endScope(this.submittedQryScp);
            }
        }
        if (state == OperationState.CLOSED) {
            this.queryInfo.setEndTime();
        } else {
            this.queryInfo.updateState(state.toString());
        }
        if (state == OperationState.ERROR) {
            this.markQueryMetric(MetricsFactory.getInstance(), "hs2_failed_queries");
        }
        if (state == OperationState.FINISHED) {
            this.markQueryMetric(MetricsFactory.getInstance(), "hs2_succeeded_queries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementUserQueries(Metrics metrics) {
        String username = this.parentSession.getUserName();
        if (username != null) {
            Map<String, AtomicInteger> map = userQueries;
            synchronized (map) {
                AtomicInteger count = userQueries.get(username);
                if (count == null) {
                    count = new AtomicInteger(0);
                    AtomicInteger prev = userQueries.put(username, count);
                    if (prev == null) {
                        metrics.incrementCounter(ACTIVE_SQL_USER);
                    } else {
                        count = prev;
                    }
                }
                count.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementUserQueries(Metrics metrics) {
        String username = this.parentSession.getUserName();
        if (username != null) {
            Map<String, AtomicInteger> map = userQueries;
            synchronized (map) {
                AtomicInteger count = userQueries.get(username);
                if (count != null && count.decrementAndGet() <= 0) {
                    metrics.decrementCounter(ACTIVE_SQL_USER);
                    userQueries.remove(username);
                }
            }
        }
    }

    private void markQueryMetric(Metrics metric, String name) {
        if (metric != null) {
            metric.markMeter(name);
        }
    }

    public String getExecutionEngine() {
        return this.queryState.getConf().getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
    }

    private final class BackgroundWork
    implements Runnable {
        private final UserGroupInformation currentUGI;
        private final Hive parentHive;
        private final PerfLogger parentPerfLogger;
        private final SessionState parentSessionState;
        private final boolean asyncPrepare;

        private BackgroundWork(UserGroupInformation currentUGI, Hive parentHive, PerfLogger parentPerfLogger, SessionState parentSessionState, boolean asyncPrepare) {
            this.currentUGI = currentUGI;
            this.parentHive = parentHive;
            this.parentPerfLogger = parentPerfLogger;
            this.parentSessionState = parentSessionState;
            this.asyncPrepare = asyncPrepare;
        }

        @Override
        public void run() {
            PrivilegedExceptionAction<Object> doAsAction = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws HiveSQLException {
                    assert (!BackgroundWork.this.parentHive.allowClose());
                    Hive.set((Hive)BackgroundWork.this.parentHive);
                    SessionState.setCurrentSessionState((SessionState)BackgroundWork.this.parentSessionState);
                    PerfLogger.setPerfLogger((PerfLogger)BackgroundWork.this.parentPerfLogger);
                    if (!SQLOperation.this.embedded) {
                        LogUtils.registerLoggingContext((Configuration)SQLOperation.this.queryState.getConf());
                    }
                    try {
                        if (BackgroundWork.this.asyncPrepare) {
                            SQLOperation.this.prepare(SQLOperation.this.queryState);
                        }
                        SQLOperation.this.runQuery();
                    }
                    catch (HiveSQLException e) {
                        SQLOperation.this.setOperationException(e);
                        Operation.LOG.error("Error running hive query: ", (Throwable)e);
                    }
                    finally {
                        if (!SQLOperation.this.embedded) {
                            LogUtils.unregisterLoggingContext();
                        }
                        Hive.closeCurrent();
                    }
                    return null;
                }
            };
            try {
                this.currentUGI.doAs((PrivilegedExceptionAction)doAsAction);
            }
            catch (Exception e) {
                SQLOperation.this.setOperationException(new HiveSQLException(e));
                Operation.LOG.error("Error running hive query as user : " + this.currentUGI.getShortUserName(), (Throwable)e);
            }
            finally {
                if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
                    ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
                    currentThread.cacheThreadLocalRawStore();
                }
            }
        }
    }
}

