/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationMetricsMaintTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationMetricsMaintTask.class);
    private Configuration conf;

    @Override
    public long initialDelay(TimeUnit unit) {
        return 0L;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.REPL_METRICS_CLEANUP_FREQUENCY, unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void run() {
        try {
            if (!MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED)) {
                return;
            }
            RawStore ms = HiveMetaStore.HMSHandler.getMSForConf(this.conf);
            int maxRetainSecs = (int)MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.REPL_METRICS_MAX_AGE, TimeUnit.SECONDS);
            LOG.info("Cleaning up Metrics older than {} ", (Object)maxRetainSecs);
            int deleteCnt = ms.deleteReplicationMetrics(maxRetainSecs);
            if ((long)deleteCnt > 0L) {
                LOG.info("Number of deleted entries: {}" + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to delete: " + e.getMessage(), (Throwable)e);
        }
    }
}

