/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.json.gzip.GzipJSONMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)MessageFactory.class.getName());
    protected static final Configuration conf = MetastoreConf.newMetastoreConf();
    private static final Map<String, Method> registry = new HashMap<String, Method>();

    public static void register(String messageFormat, Class clazz) {
        Method method = MessageFactory.requiredMethod(clazz);
        registry.put(messageFormat, method);
    }

    private static Method requiredMethod(Class clazz) {
        if (MessageEncoder.class.isAssignableFrom(clazz)) {
            try {
                Method methodInstance = clazz.getMethod("getInstance", new Class[0]);
                if (MessageEncoder.class.isAssignableFrom(methodInstance.getReturnType())) {
                    int modifiers = methodInstance.getModifiers();
                    if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
                        return methodInstance;
                    }
                    throw new NoSuchMethodException("modifier for getInstance() method is not 'public static' in " + clazz.getCanonicalName());
                }
                throw new NoSuchMethodException("return type is not assignable to " + MessageEncoder.class.getCanonicalName());
            }
            catch (NoSuchMethodException e) {
                String message = clazz.getCanonicalName() + " does not implement the required 'public static MessageEncoder getInstance()' method ";
                LOG.error(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
        }
        String message = clazz.getCanonicalName() + " is not assignable to " + MessageEncoder.class.getCanonicalName();
        LOG.error(message);
        throw new IllegalArgumentException(message);
    }

    public static MessageEncoder getInstance(String messageFormat) throws InvocationTargetException, IllegalAccessException {
        Method methodInstance = registry.get(messageFormat);
        if (methodInstance == null) {
            LOG.error("received incorrect MessageFormat " + messageFormat);
            throw new RuntimeException("messageFormat: " + messageFormat + " is not supported ");
        }
        return (MessageEncoder)methodInstance.invoke(null, new Object[0]);
    }

    public static MessageEncoder getDefaultInstance(Configuration conf) {
        String clazz = MetastoreConf.get(conf, MetastoreConf.ConfVars.EVENT_MESSAGE_FACTORY.getVarname());
        try {
            Class<?> clazzObject = MessageFactory.class.getClassLoader().loadClass(clazz);
            return (MessageEncoder)MessageFactory.requiredMethod(clazzObject).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            String message = "could not load the configured class " + clazz;
            LOG.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    static {
        MessageFactory.register("gzip(json-2.0)", GzipJSONMessageEncoder.class);
        MessageFactory.register("json-0.2", JSONMessageEncoder.class);
    }
}

