/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenSecretManager;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ReflectionUtils;

public class MetastoreDelegationTokenManager {
    public static final String DELEGATION_TOKEN_STORE_ZK_CONNECT_STR = "hive.cluster.delegation.token.store.zookeeper.connectString";
    protected DelegationTokenSecretManager secretManager;
    public static final String DELEGATION_TOKEN_STORE_ZK_CONNECT_STR_ALTERNATE = "hive.zookeeper.quorum";
    public static final String DELEGATION_TOKEN_STORE_ZK_CONNECT_TIMEOUTMILLIS = "hive.cluster.delegation.token.store.zookeeper.connectTimeoutMillis";
    public static final String DELEGATION_TOKEN_STORE_ZK_ZNODE = "hive.cluster.delegation.token.store.zookeeper.znode";
    public static final String DELEGATION_TOKEN_STORE_ZK_ACL = "hive.cluster.delegation.token.store.zookeeper.acl";
    public static final String DELEGATION_TOKEN_STORE_ZK_ZNODE_DEFAULT = "/hivedelegation";
    public static final String DELEGATION_TOKEN_STORE_ZK_SSL_ENABLE = "hive.cluster.delegation.token.store.zookeeper.ssl.client.enable";
    public static final String DELEGATION_TOKEN_STORE_ZK_KEYSTORE_LOCATION = "hive.cluster.delegation.token.store.zookeeper.keystore.location";
    public static final String DELEGATION_TOKEN_STORE_ZK_KEYSTORE_PASSWORD = "hive.cluster.delegation.token.store.zookeeper.keystore.password";
    public static final String DELEGATION_TOKEN_STORE_ZK_TRUSTSTORE_LOCATION = "hive.cluster.delegation.token.store.zookeeper.truststore.location";
    public static final String DELEGATION_TOKEN_STORE_ZK_TRUSTSTORE_PASSWORD = "hive.cluster.delegation.token.store.zookeeper.truststore.password";

    public DelegationTokenSecretManager getSecretManager() {
        return this.secretManager;
    }

    public void startDelegationTokenSecretManager(Configuration conf, Object hms) throws IOException {
        this.startDelegationTokenSecretManager(conf, hms, HadoopThriftAuthBridge.Server.ServerMode.METASTORE);
    }

    public void startDelegationTokenSecretManager(Configuration conf, Object hms, HadoopThriftAuthBridge.Server.ServerMode smode) throws IOException {
        long secretKeyInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.DELEGATION_KEY_UPDATE_INTERVAL, TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.DELEGATION_TOKEN_MAX_LIFETIME, TimeUnit.MILLISECONDS);
        long tokenRenewInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.DELEGATION_TOKEN_RENEW_INTERVAL, TimeUnit.MILLISECONDS);
        long tokenGcInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.DELEGATION_TOKEN_GC_INTERVAL, TimeUnit.MILLISECONDS);
        DelegationTokenStore dts = this.getTokenStore(conf);
        dts.setConf(conf);
        dts.init(hms, smode);
        this.secretManager = new TokenStoreDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, tokenGcInterval, dts);
        this.secretManager.startThreads();
    }

    public String getDelegationToken(String owner, String renewer, String remoteAddr) throws IOException, InterruptedException {
        UserGroupInformation currUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation ownerUgi = UserGroupInformation.createRemoteUser((String)owner);
        if (!ownerUgi.getShortUserName().equals(currUser.getShortUserName())) {
            ownerUgi = UserGroupInformation.createProxyUser((String)owner, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            ProxyUsers.authorize((UserGroupInformation)ownerUgi, (String)remoteAddr, null);
        }
        return this.secretManager.getDelegationToken(owner, renewer);
    }

    public String getDelegationTokenWithService(String owner, String renewer, String service, String remoteAddr) throws IOException, InterruptedException {
        String token = this.getDelegationToken(owner, renewer, remoteAddr);
        return MetastoreDelegationTokenManager.addServiceToToken(token, service);
    }

    public long renewDelegationToken(String tokenStrForm) throws IOException {
        return this.secretManager.renewDelegationToken(tokenStrForm);
    }

    public String getUserFromToken(String tokenStr) throws IOException {
        return this.secretManager.getUserFromToken(tokenStr);
    }

    public void cancelDelegationToken(String tokenStrForm) throws IOException {
        this.secretManager.cancelDelegationToken(tokenStrForm);
    }

    public String verifyDelegationToken(String tokenStrForm) throws IOException {
        return this.secretManager.verifyDelegationToken(tokenStrForm);
    }

    private DelegationTokenStore getTokenStore(Configuration conf) throws IOException {
        String tokenStoreClassName = SecurityUtils.getTokenStoreClassName(conf);
        try {
            Class<DelegationTokenStore> storeClass = Class.forName(tokenStoreClassName).asSubclass(DelegationTokenStore.class);
            return (DelegationTokenStore)ReflectionUtils.newInstance(storeClass, (Configuration)conf);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error initializing delegation token store: " + tokenStoreClassName, e);
        }
    }

    public static String addServiceToToken(String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = MetastoreDelegationTokenManager.createToken(tokenStr, tokenService);
        return delegationToken.encodeToUrlString();
    }

    private static Token<DelegationTokenIdentifier> createToken(String tokenStr, String tokenService) throws IOException {
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }
}

