/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Functions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidHouseKeeperService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidHouseKeeperService.class);
    private Configuration conf;
    private boolean isCompactorEnabled;
    private TxnStore txnHandler;

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.isCompactorEnabled = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON);
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.ACID_HOUSEKEEPER_SERVICE_INTERVAL, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.HouseKeeper.name());
            LOG.info("Starting to run AcidHouseKeeperService.");
            long start = System.currentTimeMillis();
            this.cleanTheHouse();
            LOG.debug("Total time AcidHouseKeeperService took: {} seconds.", (Object)this.elapsedSince(start));
        }
        catch (Throwable t) {
            LOG.error("Unexpected error in thread: {}, message: {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }

    private void cleanTheHouse() {
        this.performTask((Functions.FailableRunnable<MetaException>)((Functions.FailableRunnable)this.txnHandler::performTimeOuts), "Cleaning timed out txns and locks");
        this.performTask((Functions.FailableRunnable<MetaException>)((Functions.FailableRunnable)this.txnHandler::performWriteSetGC), "Cleaning obsolete write set entries");
        this.performTask((Functions.FailableRunnable<MetaException>)((Functions.FailableRunnable)this.txnHandler::cleanTxnToWriteIdTable), "Cleaning obsolete TXN_TO_WRITE_ID entries");
        this.performTask((Functions.FailableRunnable<MetaException>)((Functions.FailableRunnable)this.txnHandler::removeDuplicateCompletedTxnComponents), "Cleaning duplicate COMPLETED_TXN_COMPONENTS entries");
        if (this.isCompactorEnabled) {
            this.performTask((Functions.FailableRunnable<MetaException>)((Functions.FailableRunnable)this.txnHandler::purgeCompactionHistory), "Cleaning obsolete compaction history entries");
        }
    }

    private void performTask(Functions.FailableRunnable<MetaException> task, String description) {
        long start = System.currentTimeMillis();
        Functions.run(task);
        LOG.debug("{} took {} seconds.", (Object)description, (Object)this.elapsedSince(start));
    }

    private long elapsedSince(long start) {
        return (System.currentTimeMillis() - start) / 1000L;
    }
}

