/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.AuthConstants;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.MetaStorePlainSaslHelper;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.MetastoreDelegationTokenManager;
import org.apache.hadoop.hive.metastore.security.TUGIContainingTransport;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFactory.class);
    private HadoopThriftAuthBridge.Server saslServer;
    private String authTypeStr;
    private final String transportMode;
    private String hadoopAuth;
    private MetastoreDelegationTokenManager delegationTokenManager = null;
    private boolean useFramedTransport;
    private boolean executeSetUGI;
    private Configuration conf;

    public AuthFactory(HadoopThriftAuthBridge bridge, Configuration conf, Object baseHandler) throws HiveMetaException, TTransportException {
        this.conf = conf;
        this.transportMode = "binary";
        this.authTypeStr = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION);
        this.useFramedTransport = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
        this.executeSetUGI = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.EXECUTE_SET_UGI);
        if (StringUtils.isBlank((String)this.authTypeStr)) {
            this.authTypeStr = AuthConstants.AuthTypes.NOSASL.getAuthName();
        }
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.USE_THRIFT_SASL)) {
            this.hadoopAuth = "kerberos";
            if (this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.NOSASL.getAuthName())) {
                this.authTypeStr = AuthConstants.AuthTypes.KERBEROS.getAuthName();
            }
        } else {
            this.hadoopAuth = "simple";
        }
        LOG.info("Using authentication " + this.authTypeStr + " with kerberos authentication " + (this.isSASLWithKerberizedHadoop() ? "enabled." : "disabled"));
        if (this.isSASLWithKerberizedHadoop()) {
            if (this.useFramedTransport) {
                throw new HiveMetaException("Framed transport is not supported with SASL enabled.");
            }
            this.saslServer = bridge.createServer(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_KEYTAB_FILE), MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL), MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CLIENT_KERBEROS_PRINCIPAL));
            this.delegationTokenManager = new MetastoreDelegationTokenManager();
            try {
                this.delegationTokenManager.startDelegationTokenSecretManager(conf, baseHandler, HadoopThriftAuthBridge.Server.ServerMode.METASTORE);
                this.saslServer.setSecretManager(this.delegationTokenManager.getSecretManager());
            }
            catch (IOException e) {
                throw new TTransportException("Failed to start token manager", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TTransportFactory getAuthTransFactory(boolean useSSL, Configuration conf) throws LoginException {
        if (this.isSASLWithKerberizedHadoop()) {
            TTransportFactory transportFactory;
            TSaslServerTransport.Factory serverTransportFactory;
            try {
                if (this.useFramedTransport) {
                    throw new LoginException("Framed transport is not supported with SASL enabled.");
                }
                serverTransportFactory = this.saslServer.createSaslServerTransportFactory(MetaStoreUtils.getMetaStoreSaslProperties(conf, useSSL));
                transportFactory = this.saslServer.wrapTransportFactoryInClientUGI((TTransportFactory)serverTransportFactory);
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
            if (this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.KERBEROS.getAuthName())) return transportFactory;
            if (!(this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.NONE.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.LDAP.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.PAM.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.CUSTOM.getAuthName()))) {
                if (!this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.CONFIG.getAuthName())) throw new LoginException("Unsupported authentication type " + this.authTypeStr);
            }
            try {
                MetaStorePlainSaslHelper.init();
                LOG.debug("Adding server definition for PLAIN SaSL with authentication " + this.authTypeStr + " to transport factory " + serverTransportFactory);
                serverTransportFactory.addServerDefinition("PLAIN", this.authTypeStr, null, new HashMap(), (CallbackHandler)new MetaStorePlainSaslHelper.PlainServerCallbackHandler(this.authTypeStr, conf));
                return transportFactory;
            }
            catch (AuthenticationException e) {
                throw new LoginException("Error setting callback handler" + e);
            }
        }
        if (this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.NONE.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.LDAP.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.PAM.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.CUSTOM.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.CONFIG.getAuthName())) {
            if (this.useFramedTransport) {
                throw new LoginException("Framed transport is not supported with password based authentication enabled.");
            }
            if (this.executeSetUGI) {
                throw new LoginException("Setting " + (Object)((Object)MetastoreConf.ConfVars.EXECUTE_SET_UGI) + " is not supported with password based authentication enabled.");
            }
            LOG.info("Using plain SASL transport factory with " + this.authTypeStr + " authentication");
            return MetaStorePlainSaslHelper.getPlainTransportFactory(this.authTypeStr, conf);
        }
        if (!this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.NOSASL.getAuthName())) throw new LoginException("Unsupported authentication type " + this.authTypeStr);
        if (!this.executeSetUGI) return this.useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
        return this.useFramedTransport ? new ChainedTTransportFactory((TTransportFactory)new TFramedTransport.Factory(), new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
    }

    public HadoopThriftAuthBridge.Server getSaslServer() throws IllegalStateException {
        if (!this.isSASLWithKerberizedHadoop() || null == this.saslServer) {
            throw new IllegalStateException("SASL server is not setup");
        }
        return this.saslServer;
    }

    public MetastoreDelegationTokenManager getDelegationTokenManager() throws IllegalStateException {
        if (!this.isSASLWithKerberizedHadoop() || null == this.saslServer) {
            throw new IllegalStateException("SASL server is not setup");
        }
        return this.delegationTokenManager;
    }

    public boolean isSASLWithKerberizedHadoop() {
        return "kerberos".equalsIgnoreCase(this.hadoopAuth) && !this.authTypeStr.equalsIgnoreCase(AuthConstants.AuthTypes.NOSASL.getAuthName());
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        public TTransport getTransport(TTransport trans) {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

