/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.util.Collection;
import java.util.Collections;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;

public final class UserSearchFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(Configuration conf) {
        Collection<String> groupFilter = MetastoreConf.getStringCollection(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER);
        Collection<String> userFilter = MetastoreConf.getStringCollection(conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER);
        if (groupFilter.size() == 1 && groupFilter.contains("")) {
            groupFilter = Collections.emptySet();
        }
        if (userFilter.size() == 1 && userFilter.contains("")) {
            userFilter = Collections.emptySet();
        }
        if (groupFilter.isEmpty() && userFilter.isEmpty()) {
            return null;
        }
        return new UserSearchFilter();
    }

    private static final class UserSearchFilter
    implements Filter {
        private UserSearchFilter() {
        }

        @Override
        public void apply(DirSearch client, String user) throws AuthenticationException {
            try {
                String userDn = client.findUserDn(user);
                if (userDn == null) {
                    throw new AuthenticationException("Authentication failed: User search failed");
                }
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
        }
    }
}

