/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaToolTaskListExtTblLocs
extends MetaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger(MetaToolTaskListExtTblLocs.class);
    private static Configuration conf;
    private final Map<String, HashSet<String>> coverageList = new HashMap<String, HashSet<String>>();
    private final Map<String, DataLocation> inputLocations = new HashMap<String, DataLocation>();
    @VisibleForTesting
    static Configuration msConf;
    @VisibleForTesting
    Map<String, Long> testDatasizes = null;

    @Override
    void execute() {
        String[] loc = this.getCl().getListExtTblLocsParams();
        try {
            this.generateExternalTableInfo(loc[0], loc[1]);
        }
        catch (IOException | TException | JSONException e) {
            System.out.println("Generating external table locations failed: \n" + e.getMessage());
        }
    }

    private void generateExternalTableInfo(String dbPattern, String outputDir) throws TException, IOException, JSONException {
        ObjectStore objectStore = this.getObjectStore();
        conf = msConf != null ? msConf : objectStore.getConf();
        Warehouse wh = new Warehouse(conf);
        String defaultCatalog = MetaStoreUtils.getDefaultCatalog(conf);
        List<String> databases = objectStore.getDatabases(defaultCatalog, dbPattern);
        System.out.println("Number of databases found for given pattern: " + databases.size());
        TreeSet<String> leafLocations = new TreeSet<String>();
        for (String db : databases) {
            List<String> tables = objectStore.getAllTables(defaultCatalog, db);
            Path defaultDbExtPath = wh.getDefaultExternalDatabasePath(db);
            String defaultDbExtLocation = defaultDbExtPath.toString();
            boolean isDefaultPathEmpty = true;
            for (String tblName : tables) {
                Table t = objectStore.getTable(defaultCatalog, db, tblName);
                if (!TableType.EXTERNAL_TABLE.name().equalsIgnoreCase(t.getTableType())) continue;
                String tblLocation = t.getSd().getLocation();
                Path tblPath = new Path(tblLocation);
                if (this.isPathWithinSubtree(tblPath, defaultDbExtPath)) {
                    if (isDefaultPathEmpty) {
                        isDefaultPathEmpty = false;
                        this.addDefaultPath(defaultDbExtLocation, db);
                        leafLocations.add(defaultDbExtLocation);
                    }
                    HashSet<String> coveredByDefault = this.coverageList.get(defaultDbExtLocation);
                    coveredByDefault.add(tblLocation);
                } else if (!this.isCovered(leafLocations, tblPath)) {
                    leafLocations.add(tblLocation);
                }
                DataLocation dataLocation = new DataLocation(db, tblName, 0, 0, null);
                this.inputLocations.put(tblLocation, dataLocation);
                dataLocation.setSizeExtTblData(this.getDataSize(tblPath, MetaToolTaskListExtTblLocs.conf));
                Map<String, String> partitionLocations = objectStore.getPartitionLocations(defaultCatalog, db, tblName, tblLocation, -1);
                dataLocation.setTotalPartitions(partitionLocations.size());
                for (String partitionName : partitionLocations.keySet()) {
                    DataLocation partObj;
                    String partLocation = partitionLocations.get(partitionName);
                    if (partLocation == null) {
                        dataLocation.incrementNumPartsInTblLoc();
                        continue;
                    }
                    partLocation = partLocation + "/" + Warehouse.makePartName(Warehouse.makeSpecFromName(partitionName), false);
                    Path partPath = new Path(partLocation);
                    long partDataSize = this.getDataSize(partPath, conf);
                    if (this.isPathWithinSubtree(partPath, defaultDbExtPath)) {
                        if (isDefaultPathEmpty) {
                            isDefaultPathEmpty = false;
                            this.addDefaultPath(defaultDbExtLocation, db);
                            leafLocations.add(defaultDbExtLocation);
                        }
                        if (this.isPathWithinSubtree(partPath, tblPath)) {
                            dataLocation.incrementNumPartsInTblLoc();
                            continue;
                        }
                        partObj = new DataLocation(db, tblName, 0, 0, partitionName);
                        partObj.setSizeExtTblData(partDataSize);
                        this.inputLocations.put(partLocation, partObj);
                        this.coverageList.get(defaultDbExtLocation).add(partLocation);
                        continue;
                    }
                    if (this.isPathWithinSubtree(partPath, tblPath)) {
                        dataLocation.incrementNumPartsInTblLoc();
                        continue;
                    }
                    partObj = new DataLocation(db, tblName, 0, 0, partitionName);
                    partObj.setSizeExtTblData(partDataSize);
                    this.inputLocations.put(partLocation, partObj);
                    if (this.isCovered(leafLocations, partPath)) continue;
                    leafLocations.add(partLocation);
                }
            }
        }
        if (!leafLocations.isEmpty()) {
            this.removeNestedStructure(leafLocations);
            this.createOutputList(leafLocations, outputDir, dbPattern);
        } else {
            System.out.println("No external tables found to process.");
        }
    }

    private void addDefaultPath(String defaultDbExtLocation, String dbName) {
        this.coverageList.put(defaultDbExtLocation, new HashSet());
        DataLocation defaultDatalocation = new DataLocation(dbName, null, 0, 0, null);
        defaultDatalocation.setIncludeByDefault(true);
        this.inputLocations.put(defaultDbExtLocation, defaultDatalocation);
    }

    private long getDataSize(Path location, Configuration conf) throws IOException {
        if (location == null) {
            return 0L;
        }
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_IN_TEST)) {
            return this.testDatasizes == null ? 0L : (this.testDatasizes.containsKey(location.toString()) ? this.testDatasizes.get(location.toString()) : 0L);
        }
        FileSystem fs = location.getFileSystem(conf);
        if (fs != null && fs.getUri().getScheme().equals("hdfs")) {
            try {
                ContentSummary cs = fs.getContentSummary(location);
                return cs.getLength();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private boolean isPathWithinSubtree(Path path, Path subtree) {
        int subtreeDepth = subtree.depth();
        while (path != null) {
            if (subtreeDepth > path.depth()) {
                return false;
            }
            if (subtree.equals((Object)path)) {
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    private boolean isCovered(Set<String> locations, Path path) {
        Path originalPath = new Path(path.toString());
        while (path != null) {
            if (locations.contains(path.toString())) {
                this.addCoverage(path, originalPath, true);
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    private void addCoverage(Path parentPath, Path childPath, boolean addChild) {
        String childLoc = childPath.toString();
        String parentLoc = parentPath.toString();
        if (this.inputLocations.containsKey(childLoc) && this.inputLocations.get(childLoc).shouldIncludeByDefault()) {
            return;
        }
        HashSet<String> pathsUnderChild = this.coverageList.get(childLoc);
        this.coverageList.remove(childLoc);
        if (this.coverageList.get(parentLoc) == null) {
            this.coverageList.put(parentLoc, new HashSet());
        }
        HashSet<String> pathsUnderParent = this.coverageList.get(parentLoc);
        if (addChild) {
            pathsUnderParent.add(childPath.toString());
        }
        if (pathsUnderChild != null) {
            pathsUnderParent.addAll(pathsUnderChild);
        }
    }

    private void removeNestedStructure(Set<String> locations) {
        ArrayList<String> locationList = new ArrayList<String>();
        locationList.addAll(locations);
        block0: for (int i = 0; i < locationList.size(); ++i) {
            String currLoc = (String)locationList.get(i);
            Path currPath = new Path(currLoc);
            int j = i + 1;
            while (j < locationList.size()) {
                String nextLoc = (String)locationList.get(j);
                Path nextPath = new Path(nextLoc);
                if (!this.isPathWithinSubtree(nextPath, currPath)) {
                    i = j - 1;
                    continue block0;
                }
                this.addCoverage(currPath, nextPath, true);
                locations.remove(nextLoc);
                i = j++;
            }
        }
    }

    private void createOutputList(Set<String> locations, String outputDir, String dbPattern) throws IOException, JSONException {
        ExternalTableGraphNode rootNode = this.constructTree(locations);
        LinkedList<ExternalTableGraphNode> queue = new LinkedList<ExternalTableGraphNode>();
        queue.add(rootNode);
        while (!queue.isEmpty()) {
            ExternalTableGraphNode current = (ExternalTableGraphNode)queue.remove();
            if (current.isLeaf()) continue;
            int nonTrivialCoverage = 0;
            List childNodes = current.getChildNodes();
            boolean processChildrenByDefault = false;
            for (ExternalTableGraphNode child : childNodes) {
                if (child.getNumLeavesCovered() > 1) {
                    nonTrivialCoverage += child.getNumLeavesCovered();
                }
                if (!child.shouldIncludeByDefault()) continue;
                processChildrenByDefault = true;
                break;
            }
            boolean addCurrToSolution = false;
            if (!processChildrenByDefault) {
                addCurrToSolution = true;
                if (!current.shouldIncludeByDefault()) {
                    long currDataSize = this.getDataSize(new Path(current.getLocation()), conf);
                    int numLeavesCovered = current.getNumLeavesCovered();
                    addCurrToSolution &= currDataSize == current.getChildDataSizes() && nonTrivialCoverage < (numLeavesCovered + 1) / 2 && numLeavesCovered != 1;
                }
            }
            if (processChildrenByDefault) {
                queue.addAll(childNodes);
                continue;
            }
            if (addCurrToSolution) {
                this.addToSolution(current);
                continue;
            }
            queue.addAll(childNodes);
        }
        String outFileName = "externalTableLocations_" + dbPattern + "_" + System.currentTimeMillis() + ".txt";
        System.out.println("Writing output to " + outFileName);
        FileWriter fw = new FileWriter(outputDir + "/" + outFileName);
        PrintWriter pw = new PrintWriter(fw);
        JSONObject jsonObject = new JSONObject();
        for (String outputLocation : this.coverageList.keySet()) {
            HashSet<String> coveredLocations = this.coverageList.get(outputLocation);
            JSONArray outputEntities = this.listOutputEntities(coveredLocations);
            jsonObject.put(outputLocation, (Object)outputEntities);
        }
        String result = jsonObject.toString(4).replace("\\", "");
        pw.println(result);
        pw.close();
    }

    private JSONArray listOutputEntities(HashSet<String> locations) {
        ArrayList<String> listEntities = new ArrayList<String>();
        for (String loc : locations) {
            DataLocation data = this.inputLocations.get(loc);
            String tblName = data.getTblName();
            if (tblName == null) continue;
            String out = data.getDbName() + "." + tblName;
            String partName = data.getPartName();
            if (partName == null) {
                int numPartInTblLoc = data.getNumPartitionsInTblLoc();
                int totPartitions = data.getTotalPartitions();
                if (totPartitions > 0 && numPartInTblLoc == totPartitions) {
                    out = out + ".*";
                } else if (totPartitions > 0) {
                    out = out + " p(" + numPartInTblLoc + "/" + totPartitions + ")";
                }
            } else {
                out = out + "." + partName;
            }
            listEntities.add(out);
        }
        Collections.sort(listEntities);
        return new JSONArray(listEntities);
    }

    private ExternalTableGraphNode constructTree(Set<String> locations) {
        ExternalTableGraphNode rootNode = null;
        HashMap<String, ExternalTableGraphNode> locationGraph = new HashMap<String, ExternalTableGraphNode>();
        for (String leaf : locations) {
            Path parent;
            ExternalTableGraphNode currNode = new ExternalTableGraphNode(leaf, new ArrayList(), true, 0L);
            if (this.inputLocations.containsKey(leaf)) {
                if (this.inputLocations.get(leaf).shouldIncludeByDefault()) {
                    currNode.setIncludeByDefault(true);
                }
                currNode.setDataSize(this.inputLocations.get(leaf).getSizeExtTblData());
            }
            locationGraph.put(leaf, currNode);
            if (this.coverageList.get(leaf) == null) {
                this.coverageList.put(leaf, new HashSet());
            }
            HashSet<String> currCoverage = this.coverageList.get(leaf);
            currCoverage.add(leaf);
            currNode.setNumLeavesCovered(currCoverage.size());
            for (parent = new Path(leaf).getParent(); parent != null; parent = parent.getParent()) {
                ExternalTableGraphNode parNode;
                String parentLoc = parent.toString();
                if (!locationGraph.containsKey(parentLoc)) {
                    parNode = new ExternalTableGraphNode(parentLoc, new ArrayList(), false, 0L);
                    locationGraph.put(parentLoc, parNode);
                } else {
                    parNode = (ExternalTableGraphNode)locationGraph.get(parentLoc);
                    parNode.setIsLeaf(false);
                }
                if (currNode.getParent() != null) break;
                parNode.addChild(currNode);
                currNode.setParent(parNode);
                currNode = parNode;
            }
            if (parent != null || rootNode != null) continue;
            rootNode = currNode;
            rootNode.setParent(rootNode);
        }
        rootNode.updateNumLeavesCovered();
        rootNode.updateIncludeByDefault();
        rootNode.updateDataSize();
        return rootNode;
    }

    private void addToSolution(ExternalTableGraphNode node) {
        if (!node.isLeaf()) {
            this.addCoverageRecursive(node);
        }
    }

    private void addCoverageRecursive(ExternalTableGraphNode node) {
        for (ExternalTableGraphNode child : node.getChildNodes()) {
            if (child.isLeaf()) {
                this.addCoverage(new Path(node.getLocation()), new Path(child.getLocation()), true);
                continue;
            }
            this.addCoverageRecursive(child);
            this.addCoverage(new Path(node.getLocation()), new Path(child.getLocation()), false);
        }
    }

    @VisibleForTesting
    public Map<String, HashSet<String>> runTest(Set<String> inputList, Map<String, Long> sizes) {
        try {
            conf = msConf;
            this.testDatasizes = sizes;
            this.coverageList.clear();
            this.removeNestedStructure(inputList);
            this.createOutputList(inputList, "test", "test");
        }
        catch (Exception e) {
            LOG.error("MetaToolTask failed on ListExtTblLocs test: ", (Throwable)e);
        }
        return this.coverageList;
    }

    static {
        msConf = null;
    }

    private class ExternalTableGraphNode {
        private String location;
        private List<ExternalTableGraphNode> childNodes;
        private ExternalTableGraphNode parent;
        private boolean isLeaf;
        private boolean includeByDefault;
        private int numLeavesCovered;
        private long dataSize;

        private ExternalTableGraphNode(String location, List<ExternalTableGraphNode> childNodes, boolean isLeaf, long dataSize) {
            this.location = location;
            this.childNodes = childNodes;
            this.isLeaf = isLeaf;
            this.parent = null;
            this.includeByDefault = false;
            this.dataSize = dataSize;
        }

        private void addChild(ExternalTableGraphNode child) {
            this.childNodes.add(child);
        }

        private List<ExternalTableGraphNode> getChildNodes() {
            return this.childNodes;
        }

        private boolean isLeaf() {
            return this.isLeaf;
        }

        public void setIsLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        private void setNumLeavesCovered(int numLeavesCovered) {
            this.numLeavesCovered = numLeavesCovered;
        }

        private int getNumLeavesCovered() {
            return this.numLeavesCovered;
        }

        private String getLocation() {
            return this.location;
        }

        private void setParent(ExternalTableGraphNode node) {
            this.parent = node;
        }

        private ExternalTableGraphNode getParent() {
            return this.parent;
        }

        private boolean shouldIncludeByDefault() {
            return this.includeByDefault;
        }

        private void setIncludeByDefault(boolean includeByDefault) {
            this.includeByDefault = includeByDefault;
        }

        private void setDataSize(long dataSize) {
            this.dataSize = dataSize;
        }

        private long getDataSize() {
            return this.dataSize;
        }

        private void updateNumLeavesCovered() {
            if (this.isLeaf) {
                return;
            }
            this.numLeavesCovered = 0;
            for (ExternalTableGraphNode currChild : this.childNodes) {
                currChild.updateNumLeavesCovered();
                this.numLeavesCovered += currChild.getNumLeavesCovered();
            }
        }

        private void updateIncludeByDefault() {
            if (this.isLeaf) {
                return;
            }
            for (ExternalTableGraphNode currChild : this.childNodes) {
                currChild.updateIncludeByDefault();
            }
            for (ExternalTableGraphNode currChild : this.childNodes) {
                if (!currChild.shouldIncludeByDefault()) continue;
                this.includeByDefault = true;
                break;
            }
        }

        private void updateDataSize() {
            if (this.isLeaf) {
                return;
            }
            for (ExternalTableGraphNode currChild : this.childNodes) {
                currChild.updateDataSize();
            }
            this.dataSize += this.getChildDataSizes();
        }

        private long getChildDataSizes() {
            long sumChildDataSizes = 0L;
            for (ExternalTableGraphNode currChild : this.childNodes) {
                sumChildDataSizes += currChild.getDataSize();
            }
            return sumChildDataSizes;
        }
    }

    private class DataLocation {
        private String dbName;
        private String tblName;
        private int numPartitionsInTblLoc;
        private String partName;
        private int totalPartitions;
        long sizeExtTblData;
        boolean includeByDefault;

        private DataLocation(String dbName, String tblName, int totalPartitions, int numPartitionsInTblLoc, String partName) {
            this.dbName = dbName;
            this.tblName = tblName;
            this.totalPartitions = totalPartitions;
            this.numPartitionsInTblLoc = numPartitionsInTblLoc;
            this.partName = partName;
            this.sizeExtTblData = 0L;
        }

        private void incrementNumPartsInTblLoc() {
            ++this.numPartitionsInTblLoc;
        }

        private String getPartName() {
            return this.partName;
        }

        private String getDbName() {
            return this.dbName;
        }

        private String getTblName() {
            return this.tblName;
        }

        private int getNumPartitionsInTblLoc() {
            return this.numPartitionsInTblLoc;
        }

        private int getTotalPartitions() {
            return this.totalPartitions;
        }

        private long getSizeExtTblData() {
            return this.sizeExtTblData;
        }

        private boolean shouldIncludeByDefault() {
            return this.includeByDefault;
        }

        private void setTotalPartitions(int totalPartitions) {
            this.totalPartitions = totalPartitions;
        }

        private void setSizeExtTblData(long sizeExtTblData) {
            this.sizeExtTblData = sizeExtTblData;
        }

        private void setIncludeByDefault(boolean includeByDefault) {
            this.includeByDefault = includeByDefault;
        }
    }
}

