/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidTxnCleanerService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidTxnCleanerService.class);
    private Configuration conf;
    private TxnStore txnHandler;

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.ACID_TXN_CLEANER_INTERVAL, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.TxnCleaner.name());
            long start = System.currentTimeMillis();
            this.txnHandler.cleanEmptyAbortedTxns();
            LOG.debug("Txn cleaner service took: {} seconds.", (Object)this.elapsedSince(start));
        }
        catch (Throwable t) {
            LOG.error("Unexpected error in thread: {}, message: {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }

    private long elapsedSince(long start) {
        return (System.currentTimeMillis() - start) / 1000L;
    }
}

