/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnStatus;

public class OpenTxn {
    public static final String OPEN_TXNS_QUERY = "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_ID\" <= %s ORDER BY \"TXN_ID\"";
    public static final String OPEN_TXNS_INFO_QUERY = "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\", \"TXN_USER\", \"TXN_HOST\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\" FROM \"TXNS\" WHERE \"TXN_ID\" <= %s ORDER BY \"TXN_ID\"";
    private long txnId;
    private TxnStatus status;
    private TxnType type;
    private long startedTime;
    private long lastHeartBeatTime;
    private String user;
    private String host;

    public OpenTxn(long txnId, TxnStatus status, TxnType type) {
        this.txnId = txnId;
        this.status = status;
        this.type = type;
    }

    public TxnInfo toTxnInfo() {
        TxnInfo info = new TxnInfo(this.getTxnId(), this.getStatus().toTxnState(), this.getUser(), this.getHost());
        info.setStartedTime(this.getStartedTime());
        info.setLastHeartbeatTime(this.getLastHeartBeatTime());
        return info;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    public TxnStatus getStatus() {
        return this.status;
    }

    public void setStatus(TxnStatus status) {
        this.status = status;
    }

    public TxnType getType() {
        return this.type;
    }

    public void setType(TxnType type) {
        this.type = type;
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public void setStartedTime(long startedTime) {
        this.startedTime = startedTime;
    }

    public long getLastHeartBeatTime() {
        return this.lastHeartBeatTime;
    }

    public void setLastHeartBeatTime(long lastHeartBeatTime) {
        this.lastHeartBeatTime = lastHeartBeatTime;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

