/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DefaultIncompatibleTableChangeHandler;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAlterHandler
implements AlterHandler {
    protected Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveAlterHandler.class.getName());

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void alterTable(RawStore msdb, Warehouse wh, String catName, String dbname, String name, Table newt, EnvironmentContext environmentContext, IHMSHandler handler, String writeIdList) throws InvalidOperationException, MetaException {
        boolean isReplicated;
        Map<String, String> txnAlterTableEventResponses;
        List<MetaStoreEventListener> listeners;
        Table oldt;
        boolean success;
        block68: {
            boolean dataWasMoved;
            FileSystem destFs;
            Path destPath;
            Path srcPath;
            boolean replDataLocationChanged;
            block67: {
                Database olddb;
                block69: {
                    boolean cascade;
                    catName = StringUtils.normalizeIdentifier(catName);
                    name = name.toLowerCase();
                    dbname = dbname.toLowerCase();
                    if (environmentContext != null && environmentContext.isSetProperties()) {
                        cascade = "true".equals(environmentContext.getProperties().get("CASCADE"));
                        replDataLocationChanged = "true".equals(environmentContext.getProperties().get("REPL_DATA_LOCATION_CHANGED"));
                    } else {
                        cascade = false;
                        replDataLocationChanged = false;
                    }
                    if (newt == null) {
                        throw new InvalidOperationException("New table is null");
                    }
                    String newTblName = newt.getTableName().toLowerCase();
                    String newDbName = newt.getDbName().toLowerCase();
                    if (!MetaStoreUtils.validateName(newTblName, handler.getConf())) {
                        throw new InvalidOperationException(newTblName + " is not a valid object name");
                    }
                    String validate = MetaStoreUtils.validateTblColumns(newt.getSd().getCols());
                    if (validate != null) {
                        throw new InvalidOperationException("Invalid column " + validate);
                    }
                    srcPath = null;
                    destPath = null;
                    destFs = null;
                    success = false;
                    dataWasMoved = false;
                    boolean isPartitionedTable = false;
                    olddb = null;
                    oldt = null;
                    List<TransactionalMetaStoreEventListener> transactionalListeners = handler.getTransactionalListeners();
                    listeners = handler.getListeners();
                    txnAlterTableEventResponses = Collections.emptyMap();
                    try {
                        List<Partition> parts;
                        boolean rename = false;
                        if (!catName.equalsIgnoreCase(newt.getCatName())) {
                            throw new InvalidOperationException("Tables cannot be moved between catalogs, old catalog" + catName + ", new catalog " + newt.getCatName());
                        }
                        if (!newTblName.equals(name) || !newDbName.equals(dbname)) {
                            if (msdb.getTable(catName, newDbName, newTblName, null) != null) {
                                throw new InvalidOperationException("new table " + newDbName + "." + newTblName + " already exists");
                            }
                            rename = true;
                        }
                        msdb.openTransaction();
                        olddb = msdb.getDatabase(catName, dbname);
                        oldt = msdb.getTable(catName, dbname, name, null);
                        if (oldt == null) {
                            throw new InvalidOperationException("table " + TableName.getQualified((String)catName, (String)dbname, (String)name) + " doesn't exist");
                        }
                        this.validateTableChangesOnReplSource(olddb, oldt, newt, environmentContext);
                        isReplicated = HiveMetaStore.HMSHandler.isDbReplicationTarget(olddb);
                        if (oldt.getPartitionKeysSize() != 0) {
                            isPartitionedTable = true;
                        }
                        DefaultIncompatibleTableChangeHandler.get().allowChange(handler.getConf(), oldt, newt);
                        boolean partKeysPartiallyEqual = this.checkPartialPartKeysEqual(oldt.getPartitionKeys(), newt.getPartitionKeys());
                        if (!oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && !partKeysPartiallyEqual) {
                            throw new InvalidOperationException("partition keys can not be changed.");
                        }
                        boolean renamedManagedTable = rename && !oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && (oldt.getSd().getLocation().compareTo(newt.getSd().getLocation()) == 0 || org.apache.commons.lang.StringUtils.isEmpty((String)newt.getSd().getLocation())) && !MetaStoreUtils.isExternalTable(oldt);
                        Database db = msdb.getDatabase(catName, newDbName);
                        boolean renamedTranslatedToExternalTable = rename && MetaStoreUtils.isTranslatedToExternalTable(oldt) && MetaStoreUtils.isTranslatedToExternalTable(newt);
                        List<ColumnStatistics> columnStatistics = HiveAlterHandler.getColumnStats(msdb, oldt);
                        columnStatistics = HiveAlterHandler.deleteTableColumnStats(msdb, oldt, newt, columnStatistics);
                        if (replDataLocationChanged || renamedManagedTable || renamedTranslatedToExternalTable) {
                            srcPath = new Path(oldt.getSd().getLocation());
                            if (replDataLocationChanged) {
                                destPath = new Path(newt.getSd().getLocation());
                                dataWasMoved = true;
                            } else {
                                boolean tableInSpecifiedLoc;
                                String oldtRelativePath = wh.getDatabaseManagedPath(olddb).toUri().relativize(srcPath.toUri()).toString();
                                boolean bl = tableInSpecifiedLoc = !oldtRelativePath.equalsIgnoreCase(name) && !oldtRelativePath.equalsIgnoreCase(name + "/");
                                if (renamedTranslatedToExternalTable || !tableInSpecifiedLoc) {
                                    FileSystem srcFs = wh.getFs(srcPath);
                                    assert (isReplicated == HiveMetaStore.HMSHandler.isDbReplicationTarget(db));
                                    if (renamedTranslatedToExternalTable) {
                                        destPath = new Path(newt.getSd().getLocation());
                                    } else {
                                        Path databasePath = this.constructRenamedPath(wh.getDatabaseManagedPath(db), srcPath);
                                        destPath = new Path(databasePath, newTblName);
                                        newt.getSd().setLocation(destPath.toString());
                                    }
                                    destFs = wh.getFs(destPath);
                                    if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                                        throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                                    }
                                    try {
                                        if (destFs.exists(destPath)) {
                                            throw new InvalidOperationException("New location for this table " + TableName.getQualified((String)catName, (String)newDbName, (String)newTblName) + " already exists : " + destPath);
                                        }
                                        if (srcFs.exists(srcPath) && wh.renameDir(srcPath, destPath, ReplChangeManager.shouldEnableCm(olddb, oldt))) {
                                            dataWasMoved = true;
                                        }
                                    }
                                    catch (IOException | MetaException e) {
                                        LOG.error("Alter Table operation for " + dbname + "." + name + " failed.", (Throwable)e);
                                        throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage((Exception)e) + "' See hive log file for details.");
                                    }
                                    if (!HiveMetaStore.isRenameAllowed(olddb, db)) {
                                        LOG.error("Alter Table operation for " + TableName.getQualified((String)catName, (String)dbname, (String)name) + "to new table = " + TableName.getQualified((String)catName, (String)newDbName, (String)newTblName) + " failed ");
                                        throw new MetaException("Alter table not allowed for table " + TableName.getQualified((String)catName, (String)dbname, (String)name) + "to new table = " + TableName.getQualified((String)catName, (String)newDbName, (String)newTblName));
                                    }
                                }
                            }
                            if (isPartitionedTable) {
                                String oldTblLocPath = srcPath.toUri().getPath();
                                String newTblLocPath = dataWasMoved ? destPath.toUri().getPath() : null;
                                parts = msdb.getPartitions(catName, dbname, name, -1);
                                ArrayListMultimap columnStatsNeedUpdated222 = ArrayListMultimap.create();
                                for (Partition part : parts) {
                                    String oldPartLoc = part.getSd().getLocation();
                                    if (dataWasMoved && oldPartLoc.contains(oldTblLocPath)) {
                                        URI oldUri = new Path(oldPartLoc).toUri();
                                        String newPath = oldUri.getPath().replace(oldTblLocPath, newTblLocPath);
                                        Path newPartLocPath = new Path(oldUri.getScheme(), oldUri.getAuthority(), newPath);
                                        part.getSd().setLocation(newPartLocPath.toString());
                                    }
                                    part.setDbName(newDbName);
                                    part.setTableName(newTblName);
                                    List<ColumnStatistics> multiColStats = HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, part.getValues(), part.getSd().getCols(), oldt, part, null, null);
                                    for (ColumnStatistics colStats : multiColStats) {
                                        columnStatsNeedUpdated222.put((Object)part, (Object)colStats);
                                    }
                                }
                                msdb.alterTable(catName, dbname, name, newt, null);
                                if (dataWasMoved) {
                                    int partsToProcess = parts.size();
                                    int partitionBatchSize = MetastoreConf.getIntVar(handler.getConf(), MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                                    int batchStart = 0;
                                    while (partsToProcess > 0) {
                                        int batchEnd = Math.min(batchStart + partitionBatchSize, parts.size());
                                        List<Partition> partBatch = parts.subList(batchStart, batchEnd);
                                        int partBatchSize = partBatch.size();
                                        partsToProcess -= partBatchSize;
                                        batchStart += partBatchSize;
                                        ArrayList<List<String>> partValues = new ArrayList<List<String>>(partBatchSize);
                                        for (Partition part : partBatch) {
                                            partValues.add(part.getValues());
                                        }
                                        msdb.alterPartitions(catName, newDbName, newTblName, partValues, partBatch, newt.getWriteId(), writeIdList);
                                    }
                                }
                                Deadline.checkTimeout();
                                for (Map.Entry partColStats : columnStatsNeedUpdated222.entries()) {
                                    ColumnStatistics newPartColStats = (ColumnStatistics)partColStats.getValue();
                                    newPartColStats.getStatsDesc().setDbName(newDbName);
                                    newPartColStats.getStatsDesc().setTableName(newTblName);
                                    msdb.updatePartitionColumnStatistics(newPartColStats, ((Partition)partColStats.getKey()).getValues(), writeIdList, newt.getWriteId());
                                }
                            } else {
                                msdb.alterTable(catName, dbname, name, newt, writeIdList);
                            }
                        } else {
                            if (MetaStoreUtils.requireCalStats(null, null, newt, environmentContext) && !isPartitionedTable) {
                                assert (isReplicated == HiveMetaStore.HMSHandler.isDbReplicationTarget(db));
                                MetaStoreUtils.updateTableStatsSlow(db, newt, wh, false, true, environmentContext);
                            }
                            if (isPartitionedTable) {
                                boolean runPartitionMetadataUpdate = cascade && !MetaStoreUtils.areSameColumns(oldt.getSd().getCols(), newt.getSd().getCols());
                                boolean bl = !cascade && !MetaStoreUtils.arePrefixColumns(oldt.getSd().getCols(), newt.getSd().getCols());
                                boolean retainOnColRemoval = MetastoreConf.getBoolVar(handler.getConf(), MetastoreConf.ConfVars.COLSTATS_RETAIN_ON_COLUMN_REMOVAL);
                                if (runPartitionMetadataUpdate |= bl) {
                                    if (cascade || retainOnColRemoval) {
                                        parts = msdb.getPartitions(catName, dbname, name, -1);
                                        for (Partition part : parts) {
                                            Partition oldPart = new Partition(part);
                                            List<FieldSchema> oldCols = part.getSd().getCols();
                                            part.getSd().setCols(newt.getSd().getCols());
                                            List<ColumnStatistics> colStats = HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, part.getValues(), oldCols, oldt, part, null, null);
                                            assert (colStats.isEmpty());
                                            Deadline.checkTimeout();
                                            if (cascade) {
                                                msdb.alterPartition(catName, dbname, name, part.getValues(), part, writeIdList);
                                                continue;
                                            }
                                            oldPart.setParameters(part.getParameters());
                                            msdb.alterPartition(catName, dbname, name, part.getValues(), oldPart, writeIdList);
                                        }
                                    } else {
                                        TableName tableName = new TableName(catName, dbname, name);
                                        msdb.deleteAllPartitionColumnStatistics(tableName, writeIdList);
                                    }
                                    msdb.alterTable(catName, dbname, name, newt, null);
                                } else {
                                    LOG.warn("Alter table not cascaded to partitions.");
                                    msdb.alterTable(catName, dbname, name, newt, writeIdList);
                                }
                            } else {
                                msdb.alterTable(catName, dbname, name, newt, writeIdList);
                            }
                        }
                        this.updateTableColumnStats(msdb, newt, writeIdList, columnStatistics);
                        if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                            txnAlterTableEventResponses = MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(oldt, newt, false, true, newt.getWriteId(), handler, isReplicated), environmentContext);
                        }
                        if (!(success = msdb.commitTransaction())) break block67;
                        if (!replDataLocationChanged) break block68;
                        if ($assertionsDisabled || olddb != null) break block69;
                        throw new AssertionError();
                    }
                    catch (InvalidObjectException e) {
                        try {
                            LOG.debug("Failed to get object from Metastore ", (Throwable)((Object)e));
                            throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e.getMessage());
                            catch (InvalidInputException e2) {
                                LOG.debug("Accessing Metastore failed due to invalid input ", (Throwable)((Object)e2));
                                throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e2.getMessage());
                            }
                            catch (NoSuchObjectException e3) {
                                LOG.debug("Object not found in metastore ", (Throwable)((Object)e3));
                                throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist Check metastore logs for detailed stack." + e3.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                if (!replDataLocationChanged) throw throwable;
                                assert (olddb != null);
                                assert (oldt != null);
                                Path deleteOldDataLoc = new Path(oldt.getSd().getLocation());
                                boolean isAutoPurge = "true".equalsIgnoreCase(oldt.getParameters().get("auto.purge"));
                                try {
                                    wh.deleteDir(deleteOldDataLoc, true, isAutoPurge, ReplChangeManager.shouldEnableCm(olddb, oldt));
                                    LOG.info("Deleted the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(dbname + "." + name));
                                    throw throwable;
                                }
                                catch (MetaException ex) {
                                    LOG.warn("Unable to delete the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(dbname + "." + name));
                                    throw throwable;
                                }
                            }
                            LOG.error("Failed to alter table " + TableName.getQualified((String)catName, (String)dbname, (String)name));
                            msdb.rollbackTransaction();
                            if (replDataLocationChanged) throw throwable;
                            if (!dataWasMoved) throw throwable;
                            try {
                                if (!destFs.exists(destPath)) throw throwable;
                                if (destFs.rename(destPath, srcPath)) throw throwable;
                                LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                                throw throwable;
                            }
                            catch (IOException e4) {
                                LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                            }
                            throw throwable;
                        }
                    }
                }
                assert (oldt != null);
                Path deleteOldDataLoc = new Path(oldt.getSd().getLocation());
                boolean isAutoPurge = "true".equalsIgnoreCase(oldt.getParameters().get("auto.purge"));
                try {
                    wh.deleteDir(deleteOldDataLoc, true, isAutoPurge, ReplChangeManager.shouldEnableCm(olddb, oldt));
                    LOG.info("Deleted the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(dbname + "." + name));
                }
                catch (MetaException ex) {
                    LOG.warn("Unable to delete the old data location: {} for the table: {}", (Object)deleteOldDataLoc, (Object)(dbname + "." + name));
                }
                break block68;
            }
            LOG.error("Failed to alter table " + TableName.getQualified((String)catName, (String)dbname, (String)name));
            msdb.rollbackTransaction();
            if (!replDataLocationChanged && dataWasMoved) {
                try {
                    if (destFs.exists(destPath) && !destFs.rename(destPath, srcPath)) {
                        LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to restore data from " + destPath + " to " + srcPath + " in alter table failure. Manual restore is needed.");
                }
            }
        }
        if (listeners.isEmpty()) return;
        MetaStoreListenerNotifier.notifyEvent(listeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(oldt, newt, false, success, newt.getWriteId(), handler, isReplicated), environmentContext, txnAlterTableEventResponses, msdb);
    }

    String getSimpleMessage(Exception ex) {
        if (ex instanceof MetaException) {
            String msg = ex.getMessage();
            if (msg == null || !msg.contains("\n")) {
                return msg;
            }
            return msg.substring(0, msg.indexOf(10));
        }
        return ex.getMessage();
    }

    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String dbname, String name, List<String> part_vals, Partition new_part, EnvironmentContext environmentContext) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        return this.alterPartition(msdb, wh, "hive", dbname, name, part_vals, new_part, environmentContext, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String catName, String dbname, String name, List<String> part_vals, Partition new_part, EnvironmentContext environmentContext, IHMSHandler handler, String validWriteIds) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        Partition oldPart;
        block55: {
            boolean success = false;
            List<TransactionalMetaStoreEventListener> transactionalListeners = null;
            if (handler != null) {
                transactionalListeners = handler.getTransactionalListeners();
            }
            if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(new_part.getParameters().get("transient_lastDdlTime")) == 0) {
                new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            if (part_vals == null || part_vals.size() == 0) {
                Partition oldPart2;
                try {
                    msdb.openTransaction();
                    Table tbl = msdb.getTable(catName, dbname, name, null);
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to alter partition because table or database does not exist.");
                    }
                    oldPart2 = msdb.getPartition(catName, dbname, name, new_part.getValues());
                    if (MetaStoreUtils.requireCalStats(oldPart2, new_part, tbl, environmentContext)) {
                        if (MetaStoreUtils.isFastStatsSame(oldPart2, new_part)) {
                            MetaStoreUtils.updateBasicState(environmentContext, new_part.getParameters());
                        } else {
                            MetaStoreUtils.updatePartitionStatsFast(new_part, tbl, wh, false, true, environmentContext, false);
                        }
                    }
                    if (oldPart2.getSd() != null) {
                        HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, new_part.getValues(), oldPart2.getSd().getCols(), tbl, new_part, null, null);
                    }
                    Deadline.checkTimeout();
                    msdb.alterPartition(catName, dbname, name, new_part.getValues(), new_part, validWriteIds);
                    if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart2, new_part, tbl, false, true, new_part.getWriteId(), handler), environmentContext);
                    }
                    success = msdb.commitTransaction();
                }
                catch (InvalidObjectException e) {
                    LOG.warn("Alter failed", (Throwable)((Object)e));
                    throw new InvalidOperationException("alter is not possible: " + e.getMessage());
                }
                catch (NoSuchObjectException e) {
                    throw new InvalidOperationException("alter is not possible: " + e.getMessage());
                }
                finally {
                    if (!success) {
                        msdb.rollbackTransaction();
                    }
                }
                return oldPart2;
            }
            Path srcPath = null;
            Path destPath = null;
            FileSystem destFs = null;
            boolean dataWasMoved = false;
            try {
                Partition check_part;
                msdb.openTransaction();
                Table tbl = msdb.getTable("hive", dbname, name, null);
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to alter partition because table or database does not exist.");
                }
                try {
                    oldPart = msdb.getPartition(catName, dbname, name, part_vals);
                }
                catch (NoSuchObjectException e) {
                    throw new InvalidObjectException("Unable to rename partition because old partition does not exist");
                }
                try {
                    check_part = msdb.getPartition(catName, dbname, name, new_part.getValues());
                }
                catch (NoSuchObjectException e) {
                    check_part = null;
                }
                if (check_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + dbname + "." + name + "." + new_part.getValues());
                }
                if (!tbl.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                    Database db;
                    try {
                        db = msdb.getDatabase(catName, dbname);
                        destPath = wh.getPartitionPath(db, tbl, new_part.getValues());
                        destPath = this.constructRenamedPath(destPath, new Path(new_part.getSd().getLocation()));
                    }
                    catch (NoSuchObjectException e) {
                        LOG.debug("Didn't find object in metastore ", (Throwable)((Object)e));
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist Check metastore logs for detailed stack." + e.getMessage());
                    }
                    if (destPath != null) {
                        String newPartLoc = destPath.toString();
                        String oldPartLoc = oldPart.getSd().getLocation();
                        LOG.info("srcPath:" + oldPartLoc);
                        LOG.info("descPath:" + newPartLoc);
                        srcPath = new Path(oldPartLoc);
                        FileSystem srcFs = wh.getFs(srcPath);
                        destFs = wh.getFs(destPath);
                        if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                            throw new InvalidOperationException("New table location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported.");
                        }
                        try {
                            if (srcFs.exists(srcPath)) {
                                if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                                    throw new InvalidOperationException("New location for this table " + tbl.getDbName() + "." + tbl.getTableName() + " already exists : " + destPath);
                                }
                                Path destParentPath = destPath.getParent();
                                if (!wh.mkdirs(destParentPath)) {
                                    throw new MetaException("Unable to create path " + destParentPath);
                                }
                                wh.renameDir(srcPath, destPath, ReplChangeManager.shouldEnableCm(db, tbl));
                                LOG.info("Partition directory rename from " + srcPath + " to " + destPath + " done.");
                                dataWasMoved = true;
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Cannot rename partition directory from " + srcPath + " to " + destPath, (Throwable)e);
                            throw new InvalidOperationException("Unable to access src or dest location for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + new_part.getValues());
                        }
                        catch (MetaException me) {
                            LOG.error("Cannot rename partition directory from " + srcPath + " to " + destPath, (Throwable)((Object)me));
                            throw me;
                        }
                        new_part.getSd().setLocation(newPartLoc);
                    }
                } else {
                    new_part.getSd().setLocation(oldPart.getSd().getLocation());
                }
                if (MetaStoreUtils.requireCalStats(oldPart, new_part, tbl, environmentContext)) {
                    MetaStoreUtils.updatePartitionStatsFast(new_part, tbl, wh, false, true, environmentContext, false);
                }
                String newPartName = Warehouse.makePartName(tbl.getPartitionKeys(), new_part.getValues());
                List<ColumnStatistics> multiColumnStats = HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, oldPart.getValues(), oldPart.getSd().getCols(), tbl, new_part, null, null);
                msdb.alterPartition(catName, dbname, name, part_vals, new_part, validWriteIds);
                if (!multiColumnStats.isEmpty()) {
                    for (ColumnStatistics cs : multiColumnStats) {
                        cs.getStatsDesc().setPartName(newPartName);
                        try {
                            msdb.updatePartitionColumnStatistics(cs, new_part.getValues(), validWriteIds, new_part.getWriteId());
                        }
                        catch (InvalidInputException iie) {
                            throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                        }
                        catch (NoSuchObjectException noSuchObjectException) {
                        }
                    }
                }
                if (transactionalListeners != null && !transactionalListeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, new_part, tbl, false, true, new_part.getWriteId(), handler), environmentContext);
                }
                if (success = msdb.commitTransaction()) break block55;
            }
            catch (Throwable throwable) {
                if (!success) {
                    LOG.error("Failed to rename a partition. Rollback transaction");
                    msdb.rollbackTransaction();
                    if (dataWasMoved) {
                        LOG.error("Revert the data move in renaming a partition.");
                        try {
                            if (destFs.exists(destPath)) {
                                wh.renameDir(destPath, srcPath, false);
                            }
                        }
                        catch (MetaException me) {
                            LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                        }
                        catch (IOException ioe) {
                            LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                        }
                    }
                }
                throw throwable;
            }
            LOG.error("Failed to rename a partition. Rollback transaction");
            msdb.rollbackTransaction();
            if (dataWasMoved) {
                LOG.error("Revert the data move in renaming a partition.");
                try {
                    if (destFs.exists(destPath)) {
                        wh.renameDir(destPath, srcPath, false);
                    }
                }
                catch (MetaException me) {
                    LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                }
                catch (IOException ioe) {
                    LOG.error("Failed to restore partition data from " + destPath + " to " + srcPath + " in alter partition failure. Manual restore is needed.");
                }
            }
        }
        return oldPart;
    }

    @Override
    @Deprecated
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String dbname, String name, List<Partition> new_parts, EnvironmentContext environmentContext) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        return this.alterPartitions(msdb, wh, "hive", dbname, name, new_parts, environmentContext, null, -1L, null);
    }

    @Override
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String catName, String dbname, String name, List<Partition> new_parts, EnvironmentContext environmentContext, String writeIdList, long writeId, IHMSHandler handler) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        ArrayList<Partition> oldParts = new ArrayList<Partition>();
        ArrayList<List<String>> partValsList = new ArrayList<List<String>>();
        List<TransactionalMetaStoreEventListener> transactionalListeners = null;
        if (handler != null) {
            transactionalListeners = handler.getTransactionalListeners();
        }
        boolean success = false;
        try {
            msdb.openTransaction();
            Table tbl = msdb.getTable(catName, dbname, name, null);
            if (tbl == null) {
                throw new InvalidObjectException("Unable to alter partitions because table or database does not exist.");
            }
            this.blockPartitionLocationChangesOnReplSource(msdb.getDatabase(catName, dbname), tbl, environmentContext);
            for (Partition tmpPart : new_parts) {
                if (tmpPart.getParameters() == null || tmpPart.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(tmpPart.getParameters().get("transient_lastDdlTime")) == 0) {
                    tmpPart.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                Partition oldTmpPart = msdb.getPartition(catName, dbname, name, tmpPart.getValues());
                oldParts.add(oldTmpPart);
                partValsList.add(tmpPart.getValues());
                if (MetaStoreUtils.requireCalStats(oldTmpPart, tmpPart, tbl, environmentContext)) {
                    if (MetaStoreUtils.isFastStatsSame(oldTmpPart, tmpPart)) {
                        MetaStoreUtils.updateBasicState(environmentContext, tmpPart.getParameters());
                    } else {
                        MetaStoreUtils.updatePartitionStatsFast(tmpPart, tbl, wh, false, true, environmentContext, false);
                    }
                }
                if (oldTmpPart.getSd() == null) continue;
                HiveAlterHandler.updateOrGetPartitionColumnStats(msdb, catName, dbname, name, oldTmpPart.getValues(), oldTmpPart.getSd().getCols(), tbl, tmpPart, null, null);
            }
            msdb.alterPartitions(catName, dbname, name, partValsList, new_parts, writeId, writeIdList);
            Iterator oldPartsIt = oldParts.iterator();
            for (Partition newPart : new_parts) {
                if (!oldPartsIt.hasNext()) {
                    throw new InvalidOperationException("Missing old partition corresponding to new partition when invoking MetaStoreEventListener for alterPartitions event.");
                }
                Partition oldPart = (Partition)oldPartsIt.next();
                if (transactionalListeners == null || transactionalListeners.isEmpty()) continue;
                MetaStoreListenerNotifier.notifyEvent(transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, newPart, tbl, false, true, newPart.getWriteId(), handler), environmentContext);
            }
            success = msdb.commitTransaction();
        }
        catch (InvalidObjectException | NoSuchObjectException e) {
            throw new InvalidOperationException("Alter partition operation failed: " + (Object)((Object)e));
        }
        finally {
            if (!success) {
                msdb.rollbackTransaction();
            }
        }
        return oldParts;
    }

    private void blockPartitionLocationChangesOnReplSource(Database db, Table tbl, EnvironmentContext ec) throws InvalidOperationException {
        String alterType;
        if (!ReplChangeManager.isSourceOfReplication(db)) {
            return;
        }
        if (ec != null && ec.isSetProperties() && (alterType = ec.getProperties().get("alterTableOpType")) != null && alterType.equalsIgnoreCase("ALTERLOCATION") && tbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.name())) {
            throw new InvalidOperationException("Cannot change location of a managed table " + TableName.getQualified((String)tbl.getCatName(), (String)tbl.getDbName(), (String)tbl.getTableName()) + " as it is enabled for replication.");
        }
    }

    private void validateTableChangesOnReplSource(Database db, Table oldTbl, Table newTbl, EnvironmentContext ec) throws InvalidOperationException {
        String alterType;
        if (!ReplChangeManager.isSourceOfReplication(db)) {
            return;
        }
        if (ec != null && ec.isSetProperties() && (alterType = ec.getProperties().get("alterTableOpType")) != null && alterType.equalsIgnoreCase("ALTERLOCATION") && oldTbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.name())) {
            throw new InvalidOperationException("Cannot change location of a managed table " + TableName.getQualified((String)oldTbl.getCatName(), (String)oldTbl.getDbName(), (String)oldTbl.getTableName()) + " as it is enabled for replication.");
        }
        if (this.conf.getBoolean(MetastoreConf.ConfVars.STRICT_MANAGED_TABLES.getHiveName(), false)) {
            return;
        }
        if (!oldTbl.getTableType().equalsIgnoreCase(newTbl.getTableType())) {
            throw new InvalidOperationException("Table type cannot be changed from " + oldTbl.getTableType() + " to " + newTbl.getTableType() + " for the table " + TableName.getQualified((String)oldTbl.getCatName(), (String)oldTbl.getDbName(), (String)oldTbl.getTableName()) + " as it is enabled for replication.");
        }
        if (!TxnUtils.isTransactionalTable(oldTbl) && TxnUtils.isTransactionalTable(newTbl)) {
            throw new InvalidOperationException("A non-Acid table cannot be converted to an Acid table for the table " + TableName.getQualified((String)oldTbl.getCatName(), (String)oldTbl.getDbName(), (String)oldTbl.getTableName()) + " as it is enabled for replication.");
        }
    }

    private boolean checkPartialPartKeysEqual(List<FieldSchema> oldPartKeys, List<FieldSchema> newPartKeys) {
        if (newPartKeys == null || oldPartKeys == null) {
            return oldPartKeys == newPartKeys;
        }
        if (oldPartKeys.size() != newPartKeys.size()) {
            return false;
        }
        Iterator<FieldSchema> oldPartKeysIter = oldPartKeys.iterator();
        Iterator<FieldSchema> newPartKeysIter = newPartKeys.iterator();
        while (oldPartKeysIter.hasNext()) {
            FieldSchema oldFs = oldPartKeysIter.next();
            FieldSchema newFs = newPartKeysIter.next();
            if (oldFs.getName().equals(newFs.getName())) continue;
            return false;
        }
        return true;
    }

    private Path constructRenamedPath(Path defaultNewPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), defaultNewPath.toUri().getPath());
    }

    public static List<ColumnStatistics> getColumnStats(RawStore msdb, Table oldTable) throws NoSuchObjectException, MetaException {
        String catName = StringUtils.normalizeIdentifier(oldTable.isSetCatName() ? oldTable.getCatName() : MetaStoreUtils.getDefaultCatalog(msdb.getConf()));
        String dbName = oldTable.getDbName().toLowerCase();
        String tableName = StringUtils.normalizeIdentifier(oldTable.getTableName());
        List<String> columnNames = oldTable.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
        return msdb.getTableColumnStatistics(catName, dbName, tableName, columnNames);
    }

    @VisibleForTesting
    public static List<ColumnStatistics> deleteTableColumnStats(RawStore msdb, Table oldTable, Table newTable, List<ColumnStatistics> multiColStats) throws InvalidObjectException, MetaException {
        ArrayList<ColumnStatistics> newMultiColStats = new ArrayList<ColumnStatistics>();
        try {
            boolean nameChanged;
            String catName = StringUtils.normalizeIdentifier(oldTable.isSetCatName() ? oldTable.getCatName() : MetaStoreUtils.getDefaultCatalog(msdb.getConf()));
            String dbName = oldTable.getDbName().toLowerCase();
            String tableName = StringUtils.normalizeIdentifier(oldTable.getTableName());
            String newDbName = newTable.getDbName().toLowerCase();
            String newTableName = StringUtils.normalizeIdentifier(newTable.getTableName());
            List<FieldSchema> oldTableCols = oldTable.getSd().getCols();
            List<FieldSchema> newTableCols = newTable.getSd().getCols();
            boolean bl = nameChanged = !newDbName.equals(dbName) || !newTableName.equals(tableName);
            if ((nameChanged || !MetaStoreUtils.columnsIncludedByNameType(oldTableCols, newTableCols)) && TxnUtils.isAcidTable(oldTable) == TxnUtils.isAcidTable(newTable)) {
                for (ColumnStatistics colStats : multiColStats) {
                    List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
                    ArrayList<ColumnStatisticsObj> newStatsObjs = new ArrayList<ColumnStatisticsObj>();
                    if (statsObjs != null) {
                        for (ColumnStatisticsObj statsObj : statsObjs) {
                            boolean found = newTableCols.stream().anyMatch(c -> statsObj.getColName().equalsIgnoreCase(c.getName()) && statsObj.getColType().equalsIgnoreCase(c.getType()));
                            if (nameChanged || !found) {
                                msdb.deleteTableColumnStatistics(catName, oldTable.getDbName().toLowerCase(), StringUtils.normalizeIdentifier(oldTable.getTableName()), statsObj.getColName(), colStats.getEngine());
                            }
                            if (!found) continue;
                            newStatsObjs.add(statsObj);
                        }
                        StatsSetupConst.removeColumnStatsState(newTable.getParameters(), statsObjs.stream().map(ColumnStatisticsObj::getColName).collect(Collectors.toList()));
                    }
                    ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
                    statsDesc.setDbName(newDbName);
                    statsDesc.setTableName(newTableName);
                    colStats.setStatsObj(newStatsObjs);
                    newMultiColStats.add(colStats);
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug("Could not find db entry." + nsoe);
        }
        catch (InvalidInputException e) {
            throw new InvalidObjectException("Invalid inputs to update table column stats: " + e);
        }
        return newMultiColStats;
    }

    @VisibleForTesting
    public void updateTableColumnStats(RawStore msdb, Table newTable, String validWriteIds, List<ColumnStatistics> columnStatistics) throws MetaException, InvalidObjectException {
        Deadline.checkTimeout();
        for (ColumnStatistics colStats : columnStatistics) {
            try {
                msdb.updateTableColumnStatistics(colStats, validWriteIds, newTable.getWriteId());
            }
            catch (NoSuchObjectException nsoe) {
                LOG.debug("Could not find db entry." + nsoe);
            }
            catch (InvalidInputException e) {
                throw new InvalidObjectException("Invalid inputs to update table column stats: " + e);
            }
        }
    }

    public static List<ColumnStatisticsObj> filterColumnStatsForTableColumns(List<FieldSchema> columns, ColumnStatistics colStats) {
        return colStats.getStatsObj().stream().filter(o -> columns.stream().anyMatch(column -> o.getColName().equalsIgnoreCase(column.getName()) && o.getColType().equalsIgnoreCase(column.getType()))).collect(Collectors.toList());
    }

    public static List<ColumnStatistics> updateOrGetPartitionColumnStats(RawStore msdb, String catName, String dbname, String tblname, List<String> partVals, List<FieldSchema> oldCols, Table table, Partition part, List<FieldSchema> newCols, List<String> deletedCols) throws MetaException, InvalidObjectException {
        ArrayList<ColumnStatistics> newPartsColStats = new ArrayList<ColumnStatistics>();
        boolean updateColumnStats = true;
        try {
            boolean rename;
            if (newCols == null) {
                newCols = part.getSd() == null ? new ArrayList() : part.getSd().getCols();
            }
            String oldPartName = Warehouse.makePartName(table.getPartitionKeys(), partVals);
            String newPartName = Warehouse.makePartName(table.getPartitionKeys(), part.getValues());
            boolean bl = rename = !part.getDbName().equals(dbname) || !part.getTableName().equals(tblname) || !oldPartName.equals(newPartName);
            if (!rename && MetaStoreUtils.columnsIncludedByNameType(oldCols, newCols)) {
                return newPartsColStats;
            }
            ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
            for (FieldSchema oldCol : oldCols) {
                oldColNames.add(oldCol.getName());
            }
            ArrayList oldPartNames = Lists.newArrayList((Object[])new String[]{oldPartName});
            List<List<ColumnStatistics>> multiPartsColStats = msdb.getPartitionColumnStatistics(catName, dbname, tblname, oldPartNames, oldColNames);
            for (List<ColumnStatistics> partsColStats : multiPartsColStats) {
                assert (partsColStats.size() <= 1);
                if (deletedCols == null) {
                    deletedCols = new ArrayList<String>();
                } else {
                    updateColumnStats = false;
                }
                for (ColumnStatistics partColStats : partsColStats) {
                    ArrayList<ColumnStatisticsObj> newStatsObjs = new ArrayList<ColumnStatisticsObj>();
                    List<ColumnStatisticsObj> statsObjs = partColStats.getStatsObj();
                    for (ColumnStatisticsObj statsObj : statsObjs) {
                        boolean found = false;
                        for (FieldSchema newCol : newCols) {
                            if (!statsObj.getColName().equalsIgnoreCase(newCol.getName()) || !statsObj.getColType().equalsIgnoreCase(newCol.getType())) continue;
                            found = true;
                            break;
                        }
                        Deadline.checkTimeout();
                        if (found) {
                            if (!rename) continue;
                            if (updateColumnStats) {
                                msdb.deletePartitionColumnStatistics(catName, dbname, tblname, partColStats.getStatsDesc().getPartName(), partVals, statsObj.getColName(), partColStats.getEngine());
                            } else {
                                deletedCols.add(statsObj.getColName());
                            }
                            newStatsObjs.add(statsObj);
                            continue;
                        }
                        if (updateColumnStats) {
                            msdb.deletePartitionColumnStatistics(catName, dbname, tblname, partColStats.getStatsDesc().getPartName(), partVals, statsObj.getColName(), partColStats.getEngine());
                        }
                        deletedCols.add(statsObj.getColName());
                    }
                    if (updateColumnStats) {
                        StatsSetupConst.removeColumnStatsState(part.getParameters(), deletedCols);
                    }
                    if (newStatsObjs.isEmpty()) continue;
                    partColStats.setStatsObj(newStatsObjs);
                    newPartsColStats.add(partColStats);
                }
            }
        }
        catch (NoSuchObjectException oldPartName) {
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to delete partition column stats." + iie);
        }
        return newPartsColStats;
    }
}

