/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.NoReconnect;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.ExtendedTableInfo;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface IMetaStoreClient {
    public boolean isCompatibleWith(Configuration var1);

    public void setHiveAddedJars(String var1);

    public boolean isLocalMetaStore();

    public void reconnect() throws MetaException;

    @NoReconnect
    public void close();

    public void setMetaConf(String var1, String var2) throws MetaException, TException;

    public String getMetaConf(String var1) throws MetaException, TException;

    public String getHMSAPIVersion() throws MetaException, TException;

    public void createCatalog(Catalog var1) throws AlreadyExistsException, InvalidObjectException, MetaException, TException;

    public void alterCatalog(String var1, Catalog var2) throws NoSuchObjectException, InvalidObjectException, MetaException, TException;

    public Catalog getCatalog(String var1) throws NoSuchObjectException, MetaException, TException;

    public List<String> getCatalogs() throws MetaException, TException;

    public void dropCatalog(String var1) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public List<String> getDatabases(String var1) throws MetaException, TException;

    public List<String> getDatabases(String var1, String var2) throws MetaException, TException;

    public List<String> getAllDatabases() throws MetaException, TException;

    public List<String> getAllDatabases(String var1) throws MetaException, TException;

    public List<String> getTables(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public List<String> getTables(String var1, String var2, String var3) throws MetaException, TException, UnknownDBException;

    public List<String> getTables(String var1, String var2, TableType var3) throws MetaException, TException, UnknownDBException;

    public List<String> getTables(String var1, String var2, String var3, TableType var4) throws MetaException, TException, UnknownDBException;

    public List<Table> getAllMaterializedViewObjectsForRewriting() throws MetaException, TException, UnknownDBException;

    public List<ExtendedTableInfo> getTablesExt(String var1, String var2, String var3, int var4, int var5) throws MetaException, TException;

    public List<String> getMaterializedViewsForRewriting(String var1) throws MetaException, TException, UnknownDBException;

    public List<String> getMaterializedViewsForRewriting(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public List<TableMeta> getTableMeta(String var1, String var2, List<String> var3) throws MetaException, TException, UnknownDBException;

    public List<TableMeta> getTableMeta(String var1, String var2, String var3, List<String> var4) throws MetaException, TException, UnknownDBException;

    public List<String> getAllTables(String var1) throws MetaException, TException, UnknownDBException;

    public List<String> getAllTables(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public List<String> listTableNamesByFilter(String var1, String var2, short var3) throws TException, InvalidOperationException, UnknownDBException;

    public List<String> listTableNamesByFilter(String var1, String var2, String var3, int var4) throws TException, InvalidOperationException, UnknownDBException;

    public void dropTable(String var1, String var2, boolean var3, boolean var4) throws MetaException, TException, NoSuchObjectException;

    @Deprecated
    public void dropTable(String var1, String var2, boolean var3, boolean var4, boolean var5) throws MetaException, TException, NoSuchObjectException;

    public void dropTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public void dropTable(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6) throws MetaException, NoSuchObjectException, TException;

    default public void dropTable(String catName, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable) throws MetaException, NoSuchObjectException, TException {
        this.dropTable(catName, dbName, tableName, deleteData, ignoreUnknownTable, false);
    }

    default public void dropTable(String catName, String dbName, String tableName) throws MetaException, NoSuchObjectException, TException {
        this.dropTable(catName, dbName, tableName, true, true, false);
    }

    public void truncateTable(String var1, String var2, List<String> var3) throws MetaException, TException;

    public void truncateTable(String var1, String var2, List<String> var3, String var4, long var5) throws TException;

    public void truncateTable(String var1, String var2, String var3, List<String> var4) throws MetaException, TException;

    public CmRecycleResponse recycleDirToCmPath(CmRecycleRequest var1) throws MetaException, TException;

    public boolean tableExists(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public boolean tableExists(String var1, String var2, String var3) throws MetaException, TException, UnknownDBException;

    public Database getDatabase(String var1) throws NoSuchObjectException, MetaException, TException;

    public Database getDatabase(String var1, String var2) throws NoSuchObjectException, MetaException, TException;

    public Table getTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public Table getTable(String var1, String var2, boolean var3, String var4) throws MetaException, TException, NoSuchObjectException;

    public Table getTable(String var1, String var2, String var3) throws MetaException, TException;

    public Table getTable(String var1, String var2, String var3, String var4) throws TException;

    public Table getTable(String var1, String var2, String var3, String var4, boolean var5, String var6) throws TException;

    public List<Table> getTableObjectsByName(String var1, List<String> var2) throws MetaException, InvalidOperationException, UnknownDBException, TException;

    public List<Table> getTables(String var1, String var2, List<String> var3, GetProjectionsSpec var4) throws MetaException, InvalidOperationException, UnknownDBException, TException;

    public List<Table> getTableObjectsByName(String var1, String var2, List<String> var3) throws MetaException, InvalidOperationException, UnknownDBException, TException;

    public Materialization getMaterializationInvalidationInfo(CreationMetadata var1, String var2) throws MetaException, InvalidOperationException, UnknownDBException, TException;

    public void updateCreationMetadata(String var1, String var2, CreationMetadata var3) throws MetaException, TException;

    public void updateCreationMetadata(String var1, String var2, String var3, CreationMetadata var4) throws MetaException, TException;

    public Partition appendPartition(String var1, String var2, List<String> var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition appendPartition(String var1, String var2, String var3, List<String> var4) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition appendPartition(String var1, String var2, String var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition appendPartition(String var1, String var2, String var3, String var4) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition add_partition(Partition var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public int add_partitions(List<Partition> var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public int add_partitions_pspec(PartitionSpecProxy var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public List<Partition> add_partitions(List<Partition> var1, boolean var2, boolean var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition getPartition(String var1, String var2, List<String> var3) throws NoSuchObjectException, MetaException, TException;

    public Partition getPartition(String var1, String var2, String var3, List<String> var4) throws NoSuchObjectException, MetaException, TException;

    public Partition exchange_partition(Map<String, String> var1, String var2, String var3, String var4, String var5) throws MetaException, NoSuchObjectException, InvalidObjectException, TException;

    public Partition exchange_partition(Map<String, String> var1, String var2, String var3, String var4, String var5, String var6, String var7) throws MetaException, NoSuchObjectException, InvalidObjectException, TException;

    public List<Partition> exchange_partitions(Map<String, String> var1, String var2, String var3, String var4, String var5) throws MetaException, NoSuchObjectException, InvalidObjectException, TException;

    public List<Partition> exchange_partitions(Map<String, String> var1, String var2, String var3, String var4, String var5, String var6, String var7) throws MetaException, NoSuchObjectException, InvalidObjectException, TException;

    public Partition getPartition(String var1, String var2, String var3) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public Partition getPartition(String var1, String var2, String var3, String var4) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public Partition getPartitionWithAuthInfo(String var1, String var2, List<String> var3, String var4, List<String> var5) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public Partition getPartitionWithAuthInfo(String var1, String var2, String var3, List<String> var4, String var5, List<String> var6) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public List<Partition> listPartitions(String var1, String var2, short var3) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> listPartitions(String var1, String var2, String var3, int var4) throws NoSuchObjectException, MetaException, TException;

    public PartitionSpecProxy listPartitionSpecs(String var1, String var2, int var3) throws TException;

    public PartitionSpecProxy listPartitionSpecs(String var1, String var2, String var3, int var4) throws TException;

    public List<Partition> listPartitions(String var1, String var2, List<String> var3, short var4) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> listPartitions(String var1, String var2, String var3, List<String> var4, int var5) throws NoSuchObjectException, MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, short var3) throws NoSuchObjectException, MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, String var3, int var4) throws NoSuchObjectException, MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, List<String> var3, short var4) throws MetaException, TException, NoSuchObjectException;

    public List<String> listPartitionNames(String var1, String var2, String var3, List<String> var4, int var5) throws MetaException, TException, NoSuchObjectException;

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest var1) throws MetaException, TException, NoSuchObjectException;

    public int getNumPartitionsByFilter(String var1, String var2, String var3) throws MetaException, NoSuchObjectException, TException;

    public int getNumPartitionsByFilter(String var1, String var2, String var3, String var4) throws MetaException, NoSuchObjectException, TException;

    public List<Partition> listPartitionsByFilter(String var1, String var2, String var3, short var4) throws MetaException, NoSuchObjectException, TException;

    public List<Partition> listPartitionsByFilter(String var1, String var2, String var3, String var4, int var5) throws MetaException, NoSuchObjectException, TException;

    public PartitionSpecProxy listPartitionSpecsByFilter(String var1, String var2, String var3, int var4) throws MetaException, NoSuchObjectException, TException;

    public PartitionSpecProxy listPartitionSpecsByFilter(String var1, String var2, String var3, String var4, int var5) throws MetaException, NoSuchObjectException, TException;

    public boolean listPartitionsByExpr(String var1, String var2, byte[] var3, String var4, short var5, List<Partition> var6) throws TException;

    public boolean listPartitionsByExpr(String var1, String var2, String var3, byte[] var4, String var5, int var6, List<Partition> var7) throws TException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, short var3, String var4, List<String> var5) throws MetaException, TException, NoSuchObjectException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, String var3, int var4, String var5, List<String> var6) throws MetaException, TException, NoSuchObjectException;

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3, boolean var4, String var5) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> getPartitionsByNames(String var1, String var2, String var3, List<String> var4) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> getPartitionsByNames(String var1, String var2, String var3, List<String> var4, boolean var5, String var6) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, List<String> var3, short var4, String var5, List<String> var6) throws MetaException, TException, NoSuchObjectException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, String var3, List<String> var4, int var5, String var6, List<String> var7) throws MetaException, TException, NoSuchObjectException;

    public void markPartitionForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException;

    public void markPartitionForEvent(String var1, String var2, String var3, Map<String, String> var4, PartitionEventType var5) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException;

    public boolean isPartitionMarkedForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException;

    public boolean isPartitionMarkedForEvent(String var1, String var2, String var3, Map<String, String> var4, PartitionEventType var5) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException;

    public void validatePartitionNameCharacters(List<String> var1) throws TException, MetaException;

    public Table getTranslateTableDryrun(Table var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void createTable(Table var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void createTable(CreateTableRequest var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void alter_table(String var1, String var2, Table var3) throws InvalidOperationException, MetaException, TException;

    default public void alter_table(String catName, String dbName, String tblName, Table newTable) throws InvalidOperationException, MetaException, TException {
        this.alter_table(catName, dbName, tblName, newTable, null);
    }

    public void alter_table(String var1, String var2, String var3, Table var4, EnvironmentContext var5) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    public void alter_table(String var1, String var2, Table var3, boolean var4) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    public void alter_table_with_environmentContext(String var1, String var2, Table var3, EnvironmentContext var4) throws InvalidOperationException, MetaException, TException;

    public void alter_table(String var1, String var2, String var3, Table var4, EnvironmentContext var5, String var6) throws InvalidOperationException, MetaException, TException;

    public void createDatabase(Database var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public void dropDatabase(String var1) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3, boolean var4) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, String var2, boolean var3, boolean var4, boolean var5) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    default public void dropDatabase(String catName, String dbName, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(catName, dbName, deleteData, ignoreUnknownDb, false);
    }

    default public void dropDatabase(String catName, String dbName) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(catName, dbName, true, false, false);
    }

    public void alterDatabase(String var1, Database var2) throws NoSuchObjectException, MetaException, TException;

    public void alterDatabase(String var1, String var2, Database var3) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, List<String> var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, String var3, List<String> var4, boolean var5) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, List<String> var3, PartitionDropOptions var4) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, String var3, List<String> var4, PartitionDropOptions var5) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> dropPartitions(String var1, String var2, List<Pair<Integer, byte[]>> var3, boolean var4, boolean var5) throws NoSuchObjectException, MetaException, TException;

    default public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(catName, dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    @Deprecated
    public List<Partition> dropPartitions(String var1, String var2, List<Pair<Integer, byte[]>> var3, boolean var4, boolean var5, boolean var6) throws NoSuchObjectException, MetaException, TException;

    default public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(catName, dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists).returnResults(needResults));
    }

    public List<Partition> dropPartitions(String var1, String var2, List<Pair<Integer, byte[]>> var3, PartitionDropOptions var4) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> dropPartitions(String var1, String var2, String var3, List<Pair<Integer, byte[]>> var4, PartitionDropOptions var5) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, String var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, String var3, String var4, boolean var5) throws NoSuchObjectException, MetaException, TException;

    public void alter_partition(String var1, String var2, Partition var3) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    default public void alter_partition(String catName, String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.alter_partition(catName, dbName, tblName, newPart, null);
    }

    @Deprecated
    public void alter_partition(String var1, String var2, Partition var3, EnvironmentContext var4) throws InvalidOperationException, MetaException, TException;

    public void alter_partition(String var1, String var2, String var3, Partition var4, EnvironmentContext var5, String var6) throws InvalidOperationException, MetaException, TException;

    public void alter_partition(String var1, String var2, String var3, Partition var4, EnvironmentContext var5) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    public void alter_partitions(String var1, String var2, List<Partition> var3) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    public void alter_partitions(String var1, String var2, List<Partition> var3, EnvironmentContext var4) throws InvalidOperationException, MetaException, TException;

    public void alter_partitions(String var1, String var2, List<Partition> var3, EnvironmentContext var4, String var5, long var6) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    default public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts) throws InvalidOperationException, MetaException, TException {
        this.alter_partitions(catName, dbName, tblName, newParts, new EnvironmentContext(), null, -1L);
    }

    public void alter_partitions(String var1, String var2, String var3, List<Partition> var4, EnvironmentContext var5, String var6, long var7) throws InvalidOperationException, MetaException, TException;

    @Deprecated
    public void renamePartition(String var1, String var2, List<String> var3, Partition var4) throws InvalidOperationException, MetaException, TException;

    public void renamePartition(String var1, String var2, String var3, List<String> var4, Partition var5, String var6) throws InvalidOperationException, MetaException, TException;

    public List<FieldSchema> getFields(String var1, String var2) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public List<FieldSchema> getFields(String var1, String var2, String var3) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public List<FieldSchema> getSchema(String var1, String var2) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public List<FieldSchema> getSchema(String var1, String var2, String var3) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public String getConfigValue(String var1, String var2) throws TException, ConfigValSecurityException;

    public List<String> partitionNameToVals(String var1) throws MetaException, TException;

    public Map<String, String> partitionNameToSpec(String var1) throws MetaException, TException;

    public boolean updateTableColumnStatistics(ColumnStatistics var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException;

    public boolean updatePartitionColumnStatistics(ColumnStatistics var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, List<String> var3, String var4) throws NoSuchObjectException, MetaException, TException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, List<String> var3, String var4, String var5) throws NoSuchObjectException, MetaException, TException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, String var3, List<String> var4, String var5) throws NoSuchObjectException, MetaException, TException;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, String var3, List<String> var4, String var5, String var6) throws NoSuchObjectException, MetaException, TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4, String var5) throws NoSuchObjectException, MetaException, TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4, String var5, String var6) throws NoSuchObjectException, MetaException, TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, String var3, List<String> var4, List<String> var5, String var6) throws NoSuchObjectException, MetaException, TException;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, String var3, List<String> var4, List<String> var5, String var6, String var7) throws NoSuchObjectException, MetaException, TException;

    public boolean deletePartitionColumnStatistics(String var1, String var2, String var3, String var4, String var5) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException;

    public boolean deletePartitionColumnStatistics(String var1, String var2, String var3, String var4, String var5, String var6) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException;

    public boolean deleteTableColumnStatistics(String var1, String var2, String var3, String var4) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException;

    public boolean deleteTableColumnStatistics(String var1, String var2, String var3, String var4, String var5) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException;

    public boolean create_role(Role var1) throws MetaException, TException;

    public boolean drop_role(String var1) throws MetaException, TException;

    public List<String> listRoleNames() throws MetaException, TException;

    public boolean grant_role(String var1, String var2, PrincipalType var3, String var4, PrincipalType var5, boolean var6) throws MetaException, TException;

    public boolean revoke_role(String var1, String var2, PrincipalType var3, boolean var4) throws MetaException, TException;

    public List<Role> list_roles(String var1, PrincipalType var2) throws MetaException, TException;

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef var1, String var2, List<String> var3) throws MetaException, TException;

    public List<HiveObjectPrivilege> list_privileges(String var1, PrincipalType var2, HiveObjectRef var3) throws MetaException, TException;

    public boolean grant_privileges(PrivilegeBag var1) throws MetaException, TException;

    public boolean revoke_privileges(PrivilegeBag var1, boolean var2) throws MetaException, TException;

    public boolean refresh_privileges(HiveObjectRef var1, String var2, PrivilegeBag var3) throws MetaException, TException;

    public String getDelegationToken(String var1, String var2) throws MetaException, TException;

    public long renewDelegationToken(String var1) throws MetaException, TException;

    public void cancelDelegationToken(String var1) throws MetaException, TException;

    public String getTokenStrForm() throws IOException;

    public boolean addToken(String var1, String var2) throws TException;

    public boolean removeToken(String var1) throws TException;

    public String getToken(String var1) throws TException;

    public List<String> getAllTokenIdentifiers() throws TException;

    public int addMasterKey(String var1) throws MetaException, TException;

    public void updateMasterKey(Integer var1, String var2) throws NoSuchObjectException, MetaException, TException;

    public boolean removeMasterKey(Integer var1) throws TException;

    public String[] getMasterKeys() throws TException;

    public void createFunction(Function var1) throws InvalidObjectException, MetaException, TException;

    public void alterFunction(String var1, String var2, Function var3) throws InvalidObjectException, MetaException, TException;

    public void alterFunction(String var1, String var2, String var3, Function var4) throws InvalidObjectException, MetaException, TException;

    public void dropFunction(String var1, String var2) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException;

    public void dropFunction(String var1, String var2, String var3) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException;

    public Function getFunction(String var1, String var2) throws MetaException, TException;

    public Function getFunction(String var1, String var2, String var3) throws MetaException, TException;

    public List<String> getFunctions(String var1, String var2) throws MetaException, TException;

    public List<String> getFunctions(String var1, String var2, String var3) throws MetaException, TException;

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException;

    public GetOpenTxnsResponse getOpenTxns() throws TException;

    public ValidTxnList getValidTxns() throws TException;

    public ValidTxnList getValidTxns(long var1) throws TException;

    public ValidTxnList getValidTxns(long var1, List<TxnType> var3) throws TException;

    public ValidWriteIdList getValidWriteIds(String var1) throws TException;

    public ValidWriteIdList getValidWriteIds(String var1, Long var2) throws TException;

    public List<TableValidWriteIds> getValidWriteIds(List<String> var1, String var2) throws TException;

    public long openTxn(String var1) throws TException;

    public long openTxn(String var1, TxnType var2) throws TException;

    public List<Long> replOpenTxn(String var1, List<Long> var2, String var3, TxnType var4) throws TException;

    public OpenTxnsResponse openTxns(String var1, int var2) throws TException;

    public void rollbackTxn(long var1) throws NoSuchTxnException, TException;

    public void replRollbackTxn(long var1, String var3, TxnType var4) throws NoSuchTxnException, TException;

    public void commitTxn(long var1) throws NoSuchTxnException, TxnAbortedException, TException;

    public void commitTxnWithKeyValue(long var1, long var3, String var5, String var6) throws NoSuchTxnException, TxnAbortedException, TException;

    public void commitTxn(CommitTxnRequest var1) throws NoSuchTxnException, TxnAbortedException, TException;

    public void abortTxns(List<Long> var1) throws TException;

    public long allocateTableWriteId(long var1, String var3, String var4) throws TException;

    public long allocateTableWriteId(long var1, String var3, String var4, boolean var5) throws TException;

    public void replTableWriteIdState(String var1, String var2, String var3, List<String> var4) throws TException;

    public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> var1, String var2, String var3) throws TException;

    public List<TxnToWriteId> replAllocateTableWriteIdsBatch(String var1, String var2, String var3, List<TxnToWriteId> var4) throws TException;

    public GetOpenTxnsInfoResponse showTxns() throws TException;

    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest var1) throws NoSuchTxnException, TxnAbortedException, TException;

    public LockResponse checkLock(long var1) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException;

    public void unlock(long var1) throws NoSuchLockException, TxnOpenException, TException;

    @Deprecated
    public ShowLocksResponse showLocks() throws TException;

    public ShowLocksResponse showLocks(ShowLocksRequest var1) throws TException;

    public void heartbeat(long var1, long var3) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException;

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long var1, long var3) throws TException;

    @Deprecated
    public void compact(String var1, String var2, String var3, CompactionType var4) throws TException;

    @Deprecated
    public void compact(String var1, String var2, String var3, CompactionType var4, Map<String, String> var5) throws TException;

    public CompactionResponse compact2(String var1, String var2, String var3, CompactionType var4, Map<String, String> var5) throws TException;

    public ShowCompactResponse showCompactions() throws TException;

    public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest var1) throws TException;

    @Deprecated
    public void addDynamicPartitions(long var1, long var3, String var5, String var6, List<String> var7) throws TException;

    public void addDynamicPartitions(long var1, long var3, String var5, String var6, List<String> var7, DataOperationType var8) throws TException;

    public void insertTable(Table var1, boolean var2) throws MetaException;

    public long getLatestTxnInConflict(long var1) throws TException;

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventResponse getNextNotification(long var1, int var3, NotificationFilter var4) throws TException;

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventResponse getNextNotification(NotificationEventRequest var1, boolean var2, NotificationFilter var3) throws TException;

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException;

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest var1) throws TException;

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public FireEventResponse fireListenerEvent(FireEventRequest var1) throws TException;

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public void addWriteNotificationLog(WriteNotificationLogRequest var1) throws TException;

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest var1) throws MetaException, TException;

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest var1) throws MetaException, TException;

    public AggrStats getAggrColStatsFor(String var1, String var2, List<String> var3, List<String> var4, String var5) throws NoSuchObjectException, MetaException, TException;

    public AggrStats getAggrColStatsFor(String var1, String var2, List<String> var3, List<String> var4, String var5, String var6) throws NoSuchObjectException, MetaException, TException;

    public AggrStats getAggrColStatsFor(String var1, String var2, String var3, List<String> var4, List<String> var5, String var6) throws NoSuchObjectException, MetaException, TException;

    public AggrStats getAggrColStatsFor(String var1, String var2, String var3, List<String> var4, List<String> var5, String var6, String var7) throws NoSuchObjectException, MetaException, TException;

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException;

    public void flushCache();

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> var1) throws TException;

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> var1, ByteBuffer var2, boolean var3) throws TException;

    public void clearFileMetadata(List<Long> var1) throws TException;

    public void putFileMetadata(List<Long> var1, List<ByteBuffer> var2) throws TException;

    public boolean isSameConfObj(Configuration var1);

    public boolean cacheFileMetadata(String var1, String var2, String var3, boolean var4) throws TException;

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest var1) throws MetaException, NoSuchObjectException, TException;

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest var1) throws MetaException, NoSuchObjectException, TException;

    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest var1) throws MetaException, NoSuchObjectException, TException;

    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest var1) throws MetaException, NoSuchObjectException, TException;

    public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest var1) throws MetaException, NoSuchObjectException, TException;

    public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest var1) throws MetaException, NoSuchObjectException, TException;

    public void createTableWithConstraints(Table var1, List<SQLPrimaryKey> var2, List<SQLForeignKey> var3, List<SQLUniqueConstraint> var4, List<SQLNotNullConstraint> var5, List<SQLDefaultConstraint> var6, List<SQLCheckConstraint> var7) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void dropConstraint(String var1, String var2, String var3) throws MetaException, NoSuchObjectException, TException;

    public void dropConstraint(String var1, String var2, String var3, String var4) throws MetaException, NoSuchObjectException, TException;

    public void addPrimaryKey(List<SQLPrimaryKey> var1) throws MetaException, NoSuchObjectException, TException;

    public void addForeignKey(List<SQLForeignKey> var1) throws MetaException, NoSuchObjectException, TException;

    public void addUniqueConstraint(List<SQLUniqueConstraint> var1) throws MetaException, NoSuchObjectException, TException;

    public void addNotNullConstraint(List<SQLNotNullConstraint> var1) throws MetaException, NoSuchObjectException, TException;

    public void addDefaultConstraint(List<SQLDefaultConstraint> var1) throws MetaException, NoSuchObjectException, TException;

    public void addCheckConstraint(List<SQLCheckConstraint> var1) throws MetaException, NoSuchObjectException, TException;

    public String getMetastoreDbUuid() throws MetaException, TException;

    public void createResourcePlan(WMResourcePlan var1, String var2) throws InvalidObjectException, MetaException, TException;

    public WMFullResourcePlan getResourcePlan(String var1) throws NoSuchObjectException, MetaException, TException;

    public List<WMResourcePlan> getAllResourcePlans() throws NoSuchObjectException, MetaException, TException;

    public void dropResourcePlan(String var1) throws NoSuchObjectException, MetaException, TException;

    public WMFullResourcePlan alterResourcePlan(String var1, WMNullableResourcePlan var2, boolean var3, boolean var4, boolean var5) throws NoSuchObjectException, InvalidObjectException, MetaException, TException;

    public WMFullResourcePlan getActiveResourcePlan() throws MetaException, TException;

    public WMValidateResourcePlanResponse validateResourcePlan(String var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException;

    public void createWMTrigger(WMTrigger var1) throws InvalidObjectException, MetaException, TException;

    public void alterWMTrigger(WMTrigger var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException;

    public void dropWMTrigger(String var1, String var2) throws NoSuchObjectException, MetaException, TException;

    public List<WMTrigger> getTriggersForResourcePlan(String var1) throws NoSuchObjectException, MetaException, TException;

    public void createWMPool(WMPool var1) throws NoSuchObjectException, InvalidObjectException, MetaException, TException;

    public void alterWMPool(WMNullablePool var1, String var2) throws NoSuchObjectException, InvalidObjectException, TException;

    public void dropWMPool(String var1, String var2) throws TException;

    public void createOrUpdateWMMapping(WMMapping var1, boolean var2) throws TException;

    public void dropWMMapping(WMMapping var1) throws TException;

    public void createOrDropTriggerToPoolMapping(String var1, String var2, String var3, boolean var4) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException;

    public void createISchema(ISchema var1) throws TException;

    public void alterISchema(String var1, String var2, String var3, ISchema var4) throws TException;

    public ISchema getISchema(String var1, String var2, String var3) throws TException;

    public void dropISchema(String var1, String var2, String var3) throws TException;

    public void addSchemaVersion(SchemaVersion var1) throws TException;

    public SchemaVersion getSchemaVersion(String var1, String var2, String var3, int var4) throws TException;

    public SchemaVersion getSchemaLatestVersion(String var1, String var2, String var3) throws TException;

    public List<SchemaVersion> getSchemaAllVersions(String var1, String var2, String var3) throws TException;

    public void dropSchemaVersion(String var1, String var2, String var3, int var4) throws TException;

    public FindSchemasByColsResp getSchemaByCols(FindSchemasByColsRqst var1) throws TException;

    public void mapSchemaVersionToSerde(String var1, String var2, String var3, int var4, String var5) throws TException;

    public void setSchemaVersionState(String var1, String var2, String var3, int var4, SchemaVersionState var5) throws TException;

    public void addSerDe(SerDeInfo var1) throws TException;

    public SerDeInfo getSerDe(String var1) throws TException;

    public LockResponse lockMaterializationRebuild(String var1, String var2, long var3) throws TException;

    public boolean heartbeatLockMaterializationRebuild(String var1, String var2, long var3) throws TException;

    public void addRuntimeStat(RuntimeStat var1) throws TException;

    public List<RuntimeStat> getRuntimeStats(int var1, int var2) throws TException;

    @Deprecated
    public OptionalCompactionInfoStruct findNextCompact(String var1) throws MetaException, TException;

    public OptionalCompactionInfoStruct findNextCompact(FindNextCompactRequest var1) throws MetaException, TException;

    public void updateCompactorState(CompactionInfoStruct var1, long var2) throws TException;

    public List<String> findColumnsWithStats(CompactionInfoStruct var1) throws TException;

    public void markCleaned(CompactionInfoStruct var1) throws MetaException, TException;

    public void markCompacted(CompactionInfoStruct var1) throws MetaException, TException;

    public void markFailed(CompactionInfoStruct var1) throws MetaException, TException;

    public void setHadoopJobid(String var1, long var2) throws MetaException, TException;

    public String getServerVersion() throws TException;

    public ScheduledQuery getScheduledQuery(ScheduledQueryKey var1) throws TException;

    public void scheduledQueryMaintenance(ScheduledQueryMaintenanceRequest var1) throws MetaException, TException;

    public ScheduledQueryPollResponse scheduledQueryPoll(ScheduledQueryPollRequest var1) throws MetaException, TException;

    public void scheduledQueryProgress(ScheduledQueryProgressInfo var1) throws TException;

    public void addReplicationMetrics(ReplicationMetricList var1) throws MetaException, TException;

    public ReplicationMetricList getReplicationMetrics(GetReplicationMetricsRequest var1) throws MetaException, TException;

    public GetPartitionsResponse getPartitionsWithSpecs(GetPartitionsRequest var1) throws TException;

    public List<WriteEventInfo> getAllWriteEventInfo(GetAllWriteEventInfoRequest var1) throws TException;

    public ThriftHiveMetastore.Client getThriftClient() throws MetaException;

    public static class IncompatibleMetastoreException
    extends MetaException {
        IncompatibleMetastoreException(String message) {
            super(message);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public static interface NotificationFilter {
        public boolean accept(NotificationEvent var1);
    }
}

