/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.aggr.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.DateColumnStatsMerger;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateColumnStatsAggregator
extends ColumnStatsAggregator
implements IExtrapolatePartStatus {
    private static final Logger LOG = LoggerFactory.getLogger(DateColumnStatsAggregator.class);

    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        String colType = null;
        String colName = null;
        boolean doAllPartitionContainStats = partNames.size() == colStatsWithSourceInfo.size();
        NumDistinctValueEstimator ndvEstimator = null;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            DateColumnStatsDataInspector dateColumnStats;
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
                LOG.trace("doAllPartitionContainStats for column: {} is: {}", (Object)colName, (Object)doAllPartitionContainStats);
            }
            if ((dateColumnStats = ColumnsStatsUtils.dateInspectorFromStats(cso)).getNdvEstimator() == null) {
                ndvEstimator = null;
                break;
            }
            NumDistinctValueEstimator estimator = dateColumnStats.getNdvEstimator();
            if (ndvEstimator == null) {
                ndvEstimator = estimator;
                continue;
            }
            if (ndvEstimator.canMerge(estimator)) continue;
            ndvEstimator = null;
            break;
        }
        if (ndvEstimator != null) {
            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
        }
        LOG.debug("all of the bit vectors can merge for " + colName + " is " + (ndvEstimator != null));
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (doAllPartitionContainStats || colStatsWithSourceInfo.size() < 2) {
            DateColumnStatsData aggregateData = null;
            long lowerBound = 0L;
            long higherBound = 0L;
            double densityAvgSum = 0.0;
            for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                ColumnStatisticsObj cso = csp.getColStatsObj();
                DateColumnStatsDataInspector newData = ColumnsStatsUtils.dateInspectorFromStats(cso);
                higherBound += newData.getNumDVs();
                if (newData.isSetLowValue() && newData.isSetHighValue()) {
                    densityAvgSum += (double)(this.diff(newData.getHighValue(), newData.getLowValue()) / newData.getNumDVs());
                }
                if (ndvEstimator != null) {
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                DateColumnStatsMerger merger = new DateColumnStatsMerger();
                merger.setLowValue((DateColumnStatsDataInspector)aggregateData, newData);
                merger.setHighValue((DateColumnStatsDataInspector)aggregateData, newData);
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            if (ndvEstimator != null) {
                aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            } else {
                long estimation;
                if (this.useDensityFunctionForNDVEstimation) {
                    double densityAvg = densityAvgSum / (double)partNames.size();
                    estimation = (long)((double)this.diff(aggregateData.getHighValue(), aggregateData.getLowValue()) / densityAvg);
                    if (estimation < lowerBound) {
                        estimation = lowerBound;
                    } else if (estimation > higherBound) {
                        estimation = higherBound;
                    }
                } else {
                    estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * this.ndvTuner);
                }
                aggregateData.setNumDVs(estimation);
            }
            columnStatisticsData.setDateStats(aggregateData);
        } else {
            LOG.debug("start extrapolation for " + colName);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap<String, Double> adjustedIndexMap = new HashMap<String, Double>();
            HashMap<String, ColumnStatisticsData> adjustedStatsMap = new HashMap<String, ColumnStatisticsData>();
            double densityAvgSum = 0.0;
            if (ndvEstimator == null) {
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    DateColumnStatsData newData = cso.getStatsData().getDateStats();
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)(this.diff(newData.getHighValue(), newData.getLowValue()) / newData.getNumDVs());
                    }
                    adjustedIndexMap.put(partName, (double)((Integer)indexMap.get(partName)));
                    adjustedStatsMap.put(partName, cso.getStatsData());
                }
            } else {
                StringBuilder pseudoPartName = new StringBuilder();
                double pseudoIndexSum = 0.0;
                int length = 0;
                int curIndex = -1;
                DateColumnStatsData aggregateData = null;
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    DateColumnStatsDataInspector newData = ColumnsStatsUtils.dateInspectorFromStats(cso);
                    if ((Integer)indexMap.get(partName) != curIndex) {
                        if (length > 0) {
                            adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                            ColumnStatisticsData csd = new ColumnStatisticsData();
                            csd.setDateStats(aggregateData);
                            adjustedStatsMap.put(pseudoPartName.toString(), csd);
                            if (this.useDensityFunctionForNDVEstimation) {
                                densityAvgSum += (double)(this.diff(aggregateData.getHighValue(), aggregateData.getLowValue()) / aggregateData.getNumDVs());
                            }
                            pseudoPartName = new StringBuilder();
                            pseudoIndexSum = 0.0;
                            length = 0;
                            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
                        }
                        aggregateData = null;
                    }
                    curIndex = (Integer)indexMap.get(partName);
                    pseudoPartName.append(partName);
                    pseudoIndexSum += (double)curIndex;
                    ++length;
                    ++curIndex;
                    if (aggregateData == null) {
                        aggregateData = newData.deepCopy();
                    } else {
                        aggregateData.setLowValue(this.min(aggregateData.getLowValue(), newData.getLowValue()));
                        aggregateData.setHighValue(this.max(aggregateData.getHighValue(), newData.getHighValue()));
                        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                    }
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (length > 0) {
                    adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                    aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                    ColumnStatisticsData csd = new ColumnStatisticsData();
                    csd.setDateStats(aggregateData);
                    adjustedStatsMap.put(pseudoPartName.toString(), csd);
                    if (this.useDensityFunctionForNDVEstimation) {
                        densityAvgSum += (double)(this.diff(aggregateData.getHighValue(), aggregateData.getLowValue()) / aggregateData.getNumDVs());
                    }
                }
            }
            this.extrapolate(columnStatisticsData, partNames.size(), colStatsWithSourceInfo.size(), adjustedIndexMap, adjustedStatsMap, densityAvgSum / (double)adjustedStatsMap.size());
        }
        LOG.debug("Ndv estimatation for {} is {} # of partitions requested: {} # of partitions found: {}", new Object[]{colName, columnStatisticsData.getDateStats().getNumDVs(), partNames.size(), colStatsWithSourceInfo.size()});
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    private long diff(Date d1, Date d2) {
        return d1.getDaysSinceEpoch() - d2.getDaysSinceEpoch();
    }

    private Date min(Date d1, Date d2) {
        return d1.compareTo(d2) < 0 ? d1 : d2;
    }

    private Date max(Date d1, Date d2) {
        return d1.compareTo(d2) < 0 ? d2 : d1;
    }

    @Override
    public void extrapolate(ColumnStatisticsData extrapolateData, int numParts, int numPartsWithStats, Map<String, Double> adjustedIndexMap, Map<String, ColumnStatisticsData> adjustedStatsMap, double densityAvg) {
        int rightBorderInd = numParts;
        DateColumnStatsDataInspector extrapolateDateData = new DateColumnStatsDataInspector();
        HashMap<String, DateColumnStatsData> extractedAdjustedStatsMap = new HashMap<String, DateColumnStatsData>();
        for (Map.Entry<String, ColumnStatisticsData> entry : adjustedStatsMap.entrySet()) {
            extractedAdjustedStatsMap.put(entry.getKey(), entry.getValue().getDateStats());
        }
        LinkedList list = new LinkedList(extractedAdjustedStatsMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, DateColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, DateColumnStatsData> o1, Map.Entry<String, DateColumnStatsData> o2) {
                return o1.getValue().getLowValue().compareTo(o2.getValue().getLowValue());
            }
        });
        double minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        double maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long lowValue = 0L;
        long min = ((DateColumnStatsData)((Map.Entry)list.get(0)).getValue()).getLowValue().getDaysSinceEpoch();
        long max = ((DateColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getLowValue().getDaysSinceEpoch();
        lowValue = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)max - (double)(max - min) * maxInd / (maxInd - minInd)) : (long)((double)max - (double)(max - min) * ((double)rightBorderInd - maxInd) / (minInd - maxInd)));
        Collections.sort(list, new Comparator<Map.Entry<String, DateColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, DateColumnStatsData> o1, Map.Entry<String, DateColumnStatsData> o2) {
                return o1.getValue().getHighValue().compareTo(o2.getValue().getHighValue());
            }
        });
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        long highValue = 0L;
        min = ((DateColumnStatsData)((Map.Entry)list.get(0)).getValue()).getHighValue().getDaysSinceEpoch();
        max = ((DateColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getHighValue().getDaysSinceEpoch();
        highValue = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)min + (double)(max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min + (double)(max - min) * minInd / (minInd - maxInd)));
        long numNulls = 0L;
        for (Map.Entry entry : extractedAdjustedStatsMap.entrySet()) {
            numNulls += ((DateColumnStatsData)entry.getValue()).getNumNulls();
        }
        numNulls = numNulls * (long)numParts / (long)numPartsWithStats;
        long ndv = 0L;
        Collections.sort(list, new Comparator<Map.Entry<String, DateColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, DateColumnStatsData> o1, Map.Entry<String, DateColumnStatsData> o2) {
                return Long.compare(o1.getValue().getNumDVs(), o2.getValue().getNumDVs());
            }
        });
        long lowerBound = ((DateColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
        long higherBound = 0L;
        for (Map.Entry entry : list) {
            higherBound += ((DateColumnStatsData)entry.getValue()).getNumDVs();
        }
        if (this.useDensityFunctionForNDVEstimation && densityAvg != 0.0) {
            ndv = (long)((double)(highValue - lowValue) / densityAvg);
            if (ndv < lowerBound) {
                ndv = lowerBound;
            } else if (ndv > higherBound) {
                ndv = higherBound;
            }
        } else {
            minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
            maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
            min = ((DateColumnStatsData)((Map.Entry)list.get(0)).getValue()).getNumDVs();
            max = ((DateColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
            ndv = minInd == maxInd ? min : (minInd < maxInd ? (long)((double)min + (double)(max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)((double)min + (double)(max - min) * minInd / (minInd - maxInd)));
        }
        extrapolateDateData.setLowValue(new Date(lowValue));
        extrapolateDateData.setHighValue(new Date(highValue));
        extrapolateDateData.setNumNulls(numNulls);
        extrapolateDateData.setNumDVs(ndv);
        extrapolateData.setDateStats(extrapolateDateData);
    }
}

