/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.github.joshelser.dropwizard.metrics.hadoop.HadoopMetrics2Reporter;
import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.JsonReporter;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private static Metrics self;
    private static final AtomicInteger singletonAtomicInteger;
    private static final Counter dummyCounter;
    private static final Pair<AtomicInteger, AtomicInteger> dummyRatio;
    private final MetricRegistry registry = new MetricRegistry();
    private List<Reporter> reporters;
    private List<ScheduledReporter> scheduledReporters;
    private Map<String, AtomicInteger> gaugeAtomics;
    private Map<String, Pair<AtomicInteger, AtomicInteger>> gaugeRatio;
    private boolean hadoopMetricsStarted;

    public static synchronized Metrics initialize(Configuration conf) {
        if (self == null && MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.METRICS_ENABLED)) {
            self = new Metrics(conf);
        }
        return self;
    }

    public static MetricRegistry getRegistry() {
        if (self == null) {
            return null;
        }
        return Metrics.self.registry;
    }

    public static void shutdown() {
        if (self != null) {
            for (ScheduledReporter reporter : Metrics.self.scheduledReporters) {
                reporter.stop();
                reporter.close();
            }
            if (Metrics.self.hadoopMetricsStarted) {
                DefaultMetricsSystem.shutdown();
            }
            self = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getOrCreateCounter(String name) {
        if (self == null) {
            return dummyCounter;
        }
        SortedMap counters = Metrics.self.registry.getCounters();
        Counter counter = (Counter)counters.get(name);
        if (counter != null) {
            return counter;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            counters = Metrics.self.registry.getCounters();
            counter = (Counter)counters.get(name);
            if (counter != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return counter;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Metrics.self.registry.counter(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getOrCreateTimer(String name) {
        if (self == null) {
            return null;
        }
        SortedMap timers = Metrics.self.registry.getTimers();
        Timer timer = (Timer)timers.get(name);
        if (timer != null) {
            return timer;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            timers = Metrics.self.registry.getTimers();
            timer = (Timer)timers.get(name);
            if (timer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return timer;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Metrics.self.registry.timer(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomicInteger getOrCreateGauge(String name) {
        if (self == null) {
            return singletonAtomicInteger;
        }
        AtomicInteger ai = Metrics.self.gaugeAtomics.get(name);
        if (ai != null) {
            return ai;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            ai = Metrics.self.gaugeAtomics.get(name);
            if (ai != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ai;
            }
            final AtomicInteger forGauge = ai = new AtomicInteger();
            Metrics.self.gaugeAtomics.put(name, ai);
            Metrics.self.registry.register(name, (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    return forGauge.get();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ai;
        }
    }

    public static Counter getOpenConnectionsCounter() {
        return Metrics.getOrCreateCounter("open_connections");
    }

    @VisibleForTesting
    static List<Reporter> getReporters() {
        return Metrics.self.reporters;
    }

    private Metrics(Configuration conf) {
        this.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        this.registerAll("buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        this.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        this.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
        String reportersToStart = conf.get(MetastoreConf.ConfVars.METRICS_REPORTERS.getVarname());
        if (reportersToStart == null && (reportersToStart = conf.get(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName())) == null && (reportersToStart = conf.get(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName())) == null) {
            reportersToStart = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_REPORTERS);
        }
        this.reporters = new ArrayList<Reporter>();
        this.scheduledReporters = new ArrayList<ScheduledReporter>();
        if (reportersToStart != null && reportersToStart.length() > 0) {
            String[] reporterNames;
            for (String reporterName : reporterNames = reportersToStart.toLowerCase().split(",")) {
                HadoopMetrics2Reporter reporter;
                Object reporter2;
                if (reporterName.equals("console") || reporterName.endsWith("consolemetricsreporter")) {
                    reporter2 = ConsoleReporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    reporter2.start(15L, TimeUnit.SECONDS);
                    this.reporters.add((Reporter)reporter2);
                    this.scheduledReporters.add((ScheduledReporter)reporter2);
                    continue;
                }
                if (reporterName.equals("jmx") || reporterName.endsWith("jmxmetricsreporter")) {
                    reporter2 = JmxReporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    reporter2.start();
                    this.reporters.add((Reporter)reporter2);
                    continue;
                }
                if (reporterName.startsWith("json") || reporterName.endsWith("jsonfilemetricsreporter")) {
                    reporter2 = JsonReporter.forRegistry(this.registry, conf).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    ((JsonReporter)((Object)reporter2)).start(MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL, TimeUnit.SECONDS), TimeUnit.SECONDS);
                    this.reporters.add((Reporter)reporter2);
                    this.scheduledReporters.add((ScheduledReporter)reporter2);
                    continue;
                }
                if (reporterName.startsWith("hadoop") || reporterName.endsWith("metrics2reporter")) {
                    String applicationName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_HADOOP2_COMPONENT_NAME);
                    reporter = HadoopMetrics2Reporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(DefaultMetricsSystem.initialize((String)applicationName), applicationName, "Runtime metadata catalog", "General");
                    reporter.start(1L, TimeUnit.MINUTES);
                    this.reporters.add((Reporter)reporter);
                    this.scheduledReporters.add((ScheduledReporter)reporter);
                    this.hadoopMetricsStarted = true;
                    continue;
                }
                if (reporterName.startsWith("slf4j")) {
                    String level = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METRICS_SLF4J_LOG_LEVEL);
                    reporter = Slf4jReporter.forRegistry((MetricRegistry)this.registry).outputTo(LOGGER).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).withLoggingLevel(Slf4jReporter.LoggingLevel.valueOf((String)level)).build();
                    reporter.start(MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.METRICS_SLF4J_LOG_FREQUENCY_MINS, TimeUnit.SECONDS), TimeUnit.SECONDS);
                    this.reporters.add((Reporter)reporter);
                    this.scheduledReporters.add((ScheduledReporter)reporter);
                    continue;
                }
                throw new RuntimeException("Unknown metric type " + reporterName);
            }
        } else {
            LOGGER.warn("No metrics reporters configured.");
        }
        this.gaugeAtomics = new HashMap<String, AtomicInteger>();
        this.gaugeRatio = new HashMap<String, Pair<AtomicInteger, AtomicInteger>>();
    }

    private void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.registry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    static {
        singletonAtomicInteger = new AtomicInteger();
        dummyCounter = new Counter();
        dummyRatio = Pair.of((Object)singletonAtomicInteger, (Object)singletonAtomicInteger);
    }
}

