/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaToolTaskAlterCatalog
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaToolTaskAlterCatalog.class.getName());
    private String catName;
    private String location;
    private String description;
    private static final String UPDATE_CATALOG_STMT = "update <q>CTLGS<q>    set <q>LOCATION_URI<q> = %s,        <qa>DESC<qa> = %s  where <q>NAME<q> = '%s'";

    SchemaToolTaskAlterCatalog() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.catName = StringUtils.normalizeIdentifier(cl.getOptionValue("alterCatalog"));
        this.location = cl.getOptionValue("catalogLocation");
        this.description = cl.getOptionValue("catalogDescription");
    }

    @Override
    void execute() throws HiveMetaException {
        if (this.location == null && this.description == null) {
            throw new HiveMetaException("Asked to update catalog " + this.catName + " but not given any changes to update");
        }
        System.out.println("Updating catalog " + this.catName);
        Connection conn = this.schemaTool.getConnectionToMetastore(true);
        boolean success = false;
        try {
            conn.setAutoCommit(false);
            try (Statement stmt = conn.createStatement();){
                String updateLocation = this.location == null ? this.schemaTool.quote("<q>LOCATION_URI<q>") : "'" + this.location + "'";
                String updateDescription = this.description == null ? this.schemaTool.quote("<qa>DESC<qa>") : "'" + this.description + "'";
                String update = String.format(this.schemaTool.quote(UPDATE_CATALOG_STMT), updateLocation, updateDescription, this.catName);
                LOG.debug("Going to run " + update);
                int count = stmt.executeUpdate(update);
                if (count != 1) {
                    throw new HiveMetaException("Failed to find catalog " + this.catName + " to update");
                }
                conn.commit();
                success = true;
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to update catalog", e);
        }
        finally {
            try {
                if (!success) {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                LOG.error("Failed to rollback, everything will probably go bad from here.", (Throwable)e);
            }
        }
    }
}

