/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TxnDbUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)TxnDbUtil.class.getName());
    private static final String TXN_MANAGER = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
    private static final EnumMap<DatabaseProduct, String> DB_EPOCH_FN = new EnumMap<DatabaseProduct, String>(DatabaseProduct.class){
        {
            this.put(DatabaseProduct.DERBY, "{ fn timestampdiff(sql_tsi_frac_second, timestamp('" + new Timestamp(0L) + "'), current_timestamp) } / 1000000");
            this.put(DatabaseProduct.MYSQL, "round(unix_timestamp(now(3)) * 1000)");
            this.put(DatabaseProduct.POSTGRES, "round(extract(epoch from current_timestamp) * 1000)");
            this.put(DatabaseProduct.ORACLE, "(cast(systimestamp at time zone 'UTC' as date) - date '1970-01-01')*24*60*60*1000 + cast(mod( extract( second from systimestamp ), 1 ) * 1000 as int)");
            this.put(DatabaseProduct.SQLSERVER, "datediff_big(millisecond, '19700101', sysutcdatetime())");
        }
    };
    private static int deadlockCnt = 0;

    private TxnDbUtil() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static void setConfValues(Configuration conf) {
        MetastoreConf.setVar(conf, MetastoreConf.ConfVars.HIVE_TXN_MANAGER, TXN_MANAGER);
        MetastoreConf.setBoolVar(conf, MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void prepDb(Configuration conf) throws Exception {
        block40: {
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = TxnDbUtil.getConnection(conf);
                stmt = conn.createStatement();
                stmt.execute("CREATE TABLE TXNS (  TXN_ID bigint PRIMARY KEY,  TXN_STATE char(1) NOT NULL,  TXN_STARTED bigint NOT NULL,  TXN_LAST_HEARTBEAT bigint NOT NULL,  TXN_USER varchar(128) NOT NULL,  TXN_HOST varchar(128) NOT NULL,  TXN_TYPE integer)");
                stmt.execute("CREATE TABLE TXN_COMPONENTS (  TC_TXNID bigint NOT NULL REFERENCES TXNS (TXN_ID),  TC_DATABASE varchar(128) NOT NULL,  TC_TABLE varchar(128),  TC_PARTITION varchar(767),  TC_OPERATION_TYPE char(1) NOT NULL,  TC_WRITEID bigint)");
                stmt.execute("CREATE TABLE COMPLETED_TXN_COMPONENTS (  CTC_TXNID bigint NOT NULL,  CTC_DATABASE varchar(128) NOT NULL,  CTC_TABLE varchar(128),  CTC_PARTITION varchar(767),  CTC_TIMESTAMP timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL,  CTC_WRITEID bigint,  CTC_UPDATE_DELETE char(1) NOT NULL)");
                stmt.execute("CREATE TABLE NEXT_TXN_ID (  NTXN_NEXT bigint NOT NULL)");
                stmt.execute("INSERT INTO NEXT_TXN_ID VALUES(1)");
                stmt.execute("CREATE TABLE TXN_TO_WRITE_ID ( T2W_TXNID bigint NOT NULL, T2W_DATABASE varchar(128) NOT NULL, T2W_TABLE varchar(256) NOT NULL, T2W_WRITEID bigint NOT NULL)");
                stmt.execute("CREATE TABLE NEXT_WRITE_ID ( NWI_DATABASE varchar(128) NOT NULL, NWI_TABLE varchar(256) NOT NULL, NWI_NEXT bigint NOT NULL)");
                stmt.execute("CREATE TABLE MIN_HISTORY_LEVEL ( MHL_TXNID bigint NOT NULL, MHL_MIN_OPEN_TXNID bigint NOT NULL, PRIMARY KEY(MHL_TXNID))");
                stmt.execute("CREATE TABLE HIVE_LOCKS ( HL_LOCK_EXT_ID bigint NOT NULL, HL_LOCK_INT_ID bigint NOT NULL, HL_TXNID bigint NOT NULL, HL_DB varchar(128) NOT NULL, HL_TABLE varchar(128), HL_PARTITION varchar(767), HL_LOCK_STATE char(1) NOT NULL, HL_LOCK_TYPE char(1) NOT NULL, HL_LAST_HEARTBEAT bigint NOT NULL, HL_ACQUIRED_AT bigint, HL_USER varchar(128) NOT NULL, HL_HOST varchar(128) NOT NULL, HL_HEARTBEAT_COUNT integer, HL_AGENT_INFO varchar(128), HL_BLOCKEDBY_EXT_ID bigint, HL_BLOCKEDBY_INT_ID bigint, PRIMARY KEY(HL_LOCK_EXT_ID, HL_LOCK_INT_ID))");
                stmt.execute("CREATE INDEX HL_TXNID_INDEX ON HIVE_LOCKS (HL_TXNID)");
                stmt.execute("CREATE TABLE NEXT_LOCK_ID ( NL_NEXT bigint NOT NULL)");
                stmt.execute("INSERT INTO NEXT_LOCK_ID VALUES(1)");
                stmt.execute("CREATE TABLE COMPACTION_QUEUE ( CQ_ID bigint PRIMARY KEY, CQ_DATABASE varchar(128) NOT NULL, CQ_TABLE varchar(128) NOT NULL, CQ_PARTITION varchar(767), CQ_STATE char(1) NOT NULL, CQ_TYPE char(1) NOT NULL, CQ_TBLPROPERTIES varchar(2048), CQ_WORKER_ID varchar(128), CQ_ENQUEUE_TIME bigint,  CQ_START bigint, CQ_RUN_AS varchar(128), CQ_HIGHEST_WRITE_ID bigint, CQ_META_INFO varchar(2048) for bit data, CQ_HADOOP_JOB_ID varchar(32), CQ_ERROR_MESSAGE clob, CQ_NEXT_TXN_ID bigint, CQ_TXN_ID bigint, CQ_COMMIT_TIME bigint, CQ_INITIATOR_ID varchar(128), CQ_INITIATOR_VERSION varchar(128), CQ_WORKER_VERSION varchar(128))");
                stmt.execute("CREATE TABLE NEXT_COMPACTION_QUEUE_ID (NCQ_NEXT bigint NOT NULL)");
                stmt.execute("INSERT INTO NEXT_COMPACTION_QUEUE_ID VALUES(1)");
                stmt.execute("CREATE TABLE COMPLETED_COMPACTIONS ( CC_ID bigint PRIMARY KEY, CC_DATABASE varchar(128) NOT NULL, CC_TABLE varchar(128) NOT NULL, CC_PARTITION varchar(767), CC_STATE char(1) NOT NULL, CC_TYPE char(1) NOT NULL, CC_TBLPROPERTIES varchar(2048), CC_WORKER_ID varchar(128), CC_ENQUEUE_TIME bigint, CC_START bigint, CC_END bigint, CC_RUN_AS varchar(128), CC_HIGHEST_WRITE_ID bigint, CC_META_INFO varchar(2048) for bit data, CC_HADOOP_JOB_ID varchar(32), CC_ERROR_MESSAGE clob, CC_INITIATOR_ID varchar(128), CC_INITIATOR_VERSION varchar(128), CC_WORKER_VERSION varchar(128))");
                stmt.execute("CREATE INDEX COMPLETED_COMPACTIONS_RES ON COMPLETED_COMPACTIONS (CC_DATABASE,CC_TABLE,CC_PARTITION)");
                stmt.execute("CREATE TABLE AUX_TABLE ( MT_KEY1 varchar(128) NOT NULL, MT_KEY2 bigint NOT NULL, MT_COMMENT varchar(255), PRIMARY KEY(MT_KEY1, MT_KEY2))");
                stmt.execute("CREATE TABLE WRITE_SET ( WS_DATABASE varchar(128) NOT NULL, WS_TABLE varchar(128) NOT NULL, WS_PARTITION varchar(767), WS_TXNID bigint NOT NULL, WS_COMMIT_ID bigint NOT NULL, WS_OPERATION_TYPE char(1) NOT NULL)");
                stmt.execute("CREATE TABLE REPL_TXN_MAP ( RTM_REPL_POLICY varchar(256) NOT NULL,  RTM_SRC_TXN_ID bigint NOT NULL,  RTM_TARGET_TXN_ID bigint NOT NULL,  PRIMARY KEY (RTM_REPL_POLICY, RTM_SRC_TXN_ID))");
                stmt.execute("CREATE TABLE MATERIALIZATION_REBUILD_LOCKS (  MRL_TXN_ID BIGINT NOT NULL,   MRL_DB_NAME VARCHAR(128) NOT NULL,   MRL_TBL_NAME VARCHAR(256) NOT NULL,   MRL_LAST_HEARTBEAT BIGINT NOT NULL,   PRIMARY KEY(MRL_TXN_ID))");
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"TBLS\" (\"TBL_ID\" BIGINT NOT NULL,  \"CREATE_TIME\" INTEGER NOT NULL, \"DB_ID\" BIGINT, \"LAST_ACCESS_TIME\" INTEGER NOT NULL,  \"OWNER\" VARCHAR(767), \"OWNER_TYPE\" VARCHAR(10), \"RETENTION\" INTEGER NOT NULL,  \"SD_ID\" BIGINT, \"TBL_NAME\" VARCHAR(256), \"TBL_TYPE\" VARCHAR(128),  \"VIEW_EXPANDED_TEXT\" LONG VARCHAR, \"VIEW_ORIGINAL_TEXT\" LONG VARCHAR,  \"IS_REWRITE_ENABLED\" CHAR(1) NOT NULL DEFAULT 'N',  \"WRITE_ID\" BIGINT DEFAULT 0,  PRIMARY KEY (TBL_ID))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("TBLS table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"DBS\" (\"DB_ID\" BIGINT NOT NULL, \"DESC\" VARCHAR(4000), \"DB_LOCATION_URI\" VARCHAR(4000) NOT NULL, \"NAME\" VARCHAR(128), \"OWNER_NAME\" VARCHAR(128), \"OWNER_TYPE\" VARCHAR(10), \"CTLG_NAME\" VARCHAR(256) NOT NULL, PRIMARY KEY (DB_ID))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("TBLS table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"PARTITIONS\" ( \"PART_ID\" BIGINT NOT NULL, \"CREATE_TIME\" INTEGER NOT NULL,  \"LAST_ACCESS_TIME\" INTEGER NOT NULL, \"PART_NAME\" VARCHAR(767),  \"SD_ID\" BIGINT, \"TBL_ID\" BIGINT,  \"WRITE_ID\" BIGINT DEFAULT 0,  PRIMARY KEY (PART_ID))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("PARTITIONS table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"TABLE_PARAMS\" ( \"TBL_ID\" BIGINT NOT NULL, \"PARAM_KEY\" VARCHAR(256) NOT NULL,  \"PARAM_VALUE\" CLOB,  PRIMARY KEY (TBL_ID, PARAM_KEY))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("TABLE_PARAMS table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"DATABASE_PARAMS\" (\"DB_ID\" BIGINT NOT NULL,\"PARAM_KEY\" VARCHAR(180) NOT NULL, \"PARAM_VALUE\" VARCHAR(4000), PRIMARY KEY (DB_ID,PARAM_KEY))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("DATABASE_PARAMS table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"PARTITION_PARAMS\" ( \"PART_ID\" BIGINT NOT NULL, \"PARAM_KEY\" VARCHAR(256) NOT NULL,  \"PARAM_VALUE\" VARCHAR(4000),  PRIMARY KEY (PART_ID, PARAM_KEY))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("PARTITION_PARAMS table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"SEQUENCE_TABLE\" (\"SEQUENCE_NAME\" VARCHAR(256) NOT NULL, \"NEXT_VAL\" BIGINT NOT NULL)");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("SEQUENCE_TABLE table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"NOTIFICATION_SEQUENCE\" (\"NNI_ID\" BIGINT NOT NULL, \"NEXT_EVENT_ID\" BIGINT NOT NULL)");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("NOTIFICATION_SEQUENCE table already exist, ignoring");
                    }
                    throw e;
                }
                try {
                    stmt.execute("CREATE TABLE \"APP\".\"NOTIFICATION_LOG\" (\"NL_ID\" BIGINT NOT NULL, \"DB_NAME\" VARCHAR(128), \"EVENT_ID\" BIGINT NOT NULL, \"EVENT_TIME\" INTEGER NOT NULL, \"EVENT_TYPE\" VARCHAR(32) NOT NULL, \"MESSAGE\" CLOB, \"TBL_NAME\" VARCHAR(256), \"MESSAGE_FORMAT\" VARCHAR(16))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("NOTIFICATION_LOG table already exist, ignoring");
                    }
                    throw e;
                }
                stmt.execute("INSERT INTO \"APP\".\"SEQUENCE_TABLE\" (\"SEQUENCE_NAME\", \"NEXT_VAL\") SELECT * FROM (VALUES ('org.apache.hadoop.hive.metastore.model.MNotificationLog', 1)) tmp_table WHERE NOT EXISTS ( SELECT \"NEXT_VAL\" FROM \"APP\".\"SEQUENCE_TABLE\" WHERE \"SEQUENCE_NAME\" = 'org.apache.hadoop.hive.metastore.model.MNotificationLog')");
                stmt.execute("INSERT INTO \"APP\".\"NOTIFICATION_SEQUENCE\" (\"NNI_ID\", \"NEXT_EVENT_ID\") SELECT * FROM (VALUES (1,1)) tmp_table WHERE NOT EXISTS ( SELECT \"NEXT_EVENT_ID\" FROM \"APP\".\"NOTIFICATION_SEQUENCE\")");
                try {
                    stmt.execute("CREATE TABLE TXN_WRITE_NOTIFICATION_LOG (WNL_ID bigint NOT NULL,WNL_TXNID bigint NOT NULL,WNL_WRITEID bigint NOT NULL,WNL_DATABASE varchar(128) NOT NULL,WNL_TABLE varchar(128) NOT NULL,WNL_PARTITION varchar(1024) NOT NULL,WNL_TABLE_OBJ clob NOT NULL,WNL_PARTITION_OBJ clob,WNL_FILES clob,WNL_EVENT_TIME integer NOT NULL,PRIMARY KEY (WNL_TXNID, WNL_DATABASE, WNL_TABLE, WNL_PARTITION))");
                }
                catch (SQLException e) {
                    if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                        LOG.info("TXN_WRITE_NOTIFICATION_LOG table already exist, ignoring");
                    }
                    throw e;
                }
                stmt.execute("INSERT INTO \"APP\".\"SEQUENCE_TABLE\" (\"SEQUENCE_NAME\", \"NEXT_VAL\") SELECT * FROM (VALUES ('org.apache.hadoop.hive.metastore.model.MTxnWriteNotificationLog', 1)) tmp_table WHERE NOT EXISTS ( SELECT \"NEXT_VAL\" FROM \"APP\".\"SEQUENCE_TABLE\" WHERE \"SEQUENCE_NAME\" = 'org.apache.hadoop.hive.metastore.model.MTxnWriteNotificationLog')");
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException re) {
                    LOG.error("Error rolling back: " + re.getMessage());
                }
                if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                    LOG.info("Txn tables already exist, returning");
                    return;
                }
                if (e instanceof SQLTransactionRollbackException && deadlockCnt++ < 5) {
                    LOG.warn("Caught deadlock, retrying db creation");
                    TxnDbUtil.prepDb(conf);
                    break block40;
                }
                throw e;
            }
            finally {
                deadlockCnt = 0;
                TxnDbUtil.closeResources(conn, stmt, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanDb(Configuration conf) throws Exception {
        int retryCount = 0;
        while (++retryCount <= 3) {
            boolean success = true;
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = TxnDbUtil.getConnection(conf);
                stmt = conn.createStatement();
                success &= TxnDbUtil.dropIndex(stmt, "HL_TXNID_INDEX", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "TXN_COMPONENTS", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "COMPLETED_TXN_COMPONENTS", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "TXNS", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "NEXT_TXN_ID", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "TXN_TO_WRITE_ID", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "NEXT_WRITE_ID", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "MIN_HISTORY_LEVEL", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "HIVE_LOCKS", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "NEXT_LOCK_ID", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "COMPACTION_QUEUE", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "NEXT_COMPACTION_QUEUE_ID", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "COMPLETED_COMPACTIONS", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "AUX_TABLE", retryCount);
                success &= TxnDbUtil.dropTable(stmt, "WRITE_SET", retryCount);
            }
            finally {
                TxnDbUtil.closeResources(conn, stmt, null);
            }
            if (!(success &= TxnDbUtil.dropTable(stmt, "REPL_TXN_MAP", retryCount))) continue;
            return;
        }
        throw new RuntimeException("Failed to clean up txn tables");
    }

    private static boolean dropIndex(Statement stmt, String index, int retryCount) {
        block2: {
            try {
                stmt.execute("DROP INDEX " + index);
            }
            catch (SQLException e) {
                if ("42X65".equals(e.getSQLState()) && 30000 == e.getErrorCode()) break block2;
                LOG.error("Unable to drop index {} {} State={} code={} retryCount={}", new Object[]{index, e.getMessage(), e.getSQLState(), e.getErrorCode(), retryCount});
                return false;
            }
        }
        return true;
    }

    private static boolean dropTable(Statement stmt, String name, int retryCount) throws SQLException {
        for (int i = 0; i < 3; ++i) {
            try {
                stmt.execute("DROP TABLE " + name);
                LOG.debug("Successfully dropped table " + name);
                return true;
            }
            catch (SQLException e) {
                if ("42Y55".equals(e.getSQLState()) && 30000 == e.getErrorCode()) {
                    LOG.debug("Not dropping " + name + " because it doesn't exist");
                    return true;
                }
                if ("X0Y25".equals(e.getSQLState()) && 30000 == e.getErrorCode()) {
                    LOG.warn("Intermittent drop failure, retrying, try number " + i);
                    continue;
                }
                LOG.error("Unable to drop table " + name + ": " + e.getMessage() + " State=" + e.getSQLState() + " code=" + e.getErrorCode() + " retryCount=" + retryCount);
                continue;
            }
        }
        LOG.error("Failed to drop table, don't know why");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLockComponents(Configuration conf, long lockId) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = TxnDbUtil.getConnection(conf);
                stmt = conn.prepareStatement("SELECT count(*) FROM hive_locks WHERE hl_lock_ext_id = ?");
                stmt.setLong(1, lockId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                TxnDbUtil.closeResources(conn, stmt, rs);
                throw throwable;
            }
            TxnDbUtil.closeResources(conn, stmt, rs);
            return n;
        }
        int n = rs.getInt(1);
        TxnDbUtil.closeResources(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countQueryAgent(Configuration conf, String countQuery) throws Exception {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = TxnDbUtil.getConnection(conf);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(countQuery);
                if (rs.next()) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                TxnDbUtil.closeResources(conn, stmt, rs);
                throw throwable;
            }
            TxnDbUtil.closeResources(conn, stmt, rs);
            return n;
        }
        int n = rs.getInt(1);
        TxnDbUtil.closeResources(conn, stmt, rs);
        return n;
    }

    @VisibleForTesting
    public static String queryToString(Configuration conf, String query) throws Exception {
        return TxnDbUtil.queryToString(conf, query, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryToString(Configuration conf, String query, boolean includeHeader) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder();
        try {
            int colPos;
            conn = TxnDbUtil.getConnection(conf);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            if (includeHeader) {
                for (colPos = 1; colPos <= rsmd.getColumnCount(); ++colPos) {
                    sb.append(rsmd.getColumnName(colPos)).append("   ");
                }
                sb.append('\n');
            }
            while (rs.next()) {
                for (colPos = 1; colPos <= rsmd.getColumnCount(); ++colPos) {
                    sb.append(rs.getObject(colPos)).append("   ");
                }
                sb.append('\n');
            }
        }
        catch (Throwable throwable) {
            TxnDbUtil.closeResources(conn, stmt, rs);
            throw throwable;
        }
        TxnDbUtil.closeResources(conn, stmt, rs);
        return sb.toString();
    }

    static Connection getConnection(Configuration conf) throws Exception {
        String jdbcDriver = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECTION_DRIVER);
        Driver driver = (Driver)Class.forName(jdbcDriver).newInstance();
        Properties prop = new Properties();
        String driverUrl = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECT_URL_KEY);
        String user = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECTION_USER_NAME);
        String passwd = MetastoreConf.getPassword(conf, MetastoreConf.ConfVars.PWD);
        prop.setProperty("user", user);
        prop.setProperty("password", passwd);
        Connection conn = driver.connect(driverUrl, prop);
        conn.setAutoCommit(true);
        return conn;
    }

    static void closeResources(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.error("Error closing ResultSet: " + e.getMessage());
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing Statement: " + e.getMessage());
            }
        }
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                System.err.println("Error rolling back: " + e.getMessage());
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing Connection: " + e.getMessage());
            }
        }
    }

    static String getEpochFn(DatabaseProduct dbProduct) throws MetaException {
        String epochFn = DB_EPOCH_FN.get((Object)dbProduct);
        if (epochFn != null) {
            return epochFn;
        }
        String msg = "Unknown database product: " + dbProduct.toString();
        LOG.error(msg);
        throw new MetaException(msg);
    }

    static List<Integer> executeQueriesInBatch(Statement stmt, List<String> queries, Configuration conf) throws SQLException {
        ArrayList<Integer> affectedRowsByQuery = new ArrayList<Integer>();
        int queryCounter = 0;
        int batchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE);
        for (String query : queries) {
            LOG.debug("Adding query to batch: <" + query + ">");
            stmt.addBatch(query);
            if (++queryCounter % batchSize != 0) continue;
            LOG.debug("Going to execute queries in batch. Batch size: " + batchSize);
            int[] affectedRecordsByQuery = stmt.executeBatch();
            Arrays.stream(affectedRecordsByQuery).forEach(affectedRowsByQuery::add);
        }
        if (queryCounter % batchSize != 0) {
            LOG.debug("Going to execute queries in batch. Batch size: " + queryCounter % batchSize);
            int[] affectedRecordsByQuery = stmt.executeBatch();
            Arrays.stream(affectedRecordsByQuery).forEach(affectedRowsByQuery::add);
        }
        return affectedRowsByQuery;
    }
}

