/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStorePasswdAuthenticationProvider;
import org.apache.hadoop.hive.metastore.ServiceUtils;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.ChainFilterFactory;
import org.apache.hadoop.hive.metastore.ldap.CustomQueryFilterFactory;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.DirSearchFactory;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.apache.hadoop.hive.metastore.ldap.GroupFilterFactory;
import org.apache.hadoop.hive.metastore.ldap.LdapSearchFactory;
import org.apache.hadoop.hive.metastore.ldap.LdapUtils;
import org.apache.hadoop.hive.metastore.ldap.UserFilterFactory;
import org.apache.hadoop.hive.metastore.ldap.UserSearchFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreLdapAuthenticationProviderImpl
implements MetaStorePasswdAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreLdapAuthenticationProviderImpl.class);
    private static final List<FilterFactory> FILTER_FACTORIES = ImmutableList.of((Object)new CustomQueryFilterFactory(), (Object)new ChainFilterFactory(new UserSearchFilterFactory(), new UserFilterFactory(), new GroupFilterFactory()));
    private final Configuration conf;
    private final Filter filter;
    private final DirSearchFactory searchFactory;

    public MetaStoreLdapAuthenticationProviderImpl(Configuration conf) {
        this(conf, new LdapSearchFactory());
    }

    @VisibleForTesting
    MetaStoreLdapAuthenticationProviderImpl(Configuration conf, DirSearchFactory searchFactory) {
        this.conf = conf;
        this.searchFactory = searchFactory;
        this.filter = MetaStoreLdapAuthenticationProviderImpl.resolveFilter(conf);
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        boolean usedBind;
        String bindPassword;
        DirSearch search = null;
        String bindUser = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_BIND_USER);
        if (StringUtils.isBlank((String)bindUser)) {
            bindUser = null;
        }
        try {
            bindPassword = MetastoreConf.getPassword(this.conf, MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_BIND_PASSWORD);
            if (StringUtils.isBlank((String)bindPassword)) {
                bindPassword = null;
            }
        }
        catch (IOException e) {
            bindPassword = null;
        }
        boolean bl = usedBind = bindUser != null && bindPassword != null;
        if (!usedBind) {
            bindUser = user;
            bindPassword = password;
        }
        try {
            search = this.createDirSearch(bindUser, bindPassword);
            this.applyFilter(search, user);
            if (usedBind) {
                this.createDirSearch(search.findUserDn(user), password);
            }
        }
        catch (NamingException e) {
            try {
                throw new AuthenticationException("Unable to find the user in the LDAP tree. " + e.getMessage());
            }
            catch (Throwable throwable) {
                ServiceUtils.cleanup(LOG, search);
                throw throwable;
            }
        }
        ServiceUtils.cleanup(LOG, search);
    }

    private DirSearch createDirSearch(String user, String password) throws AuthenticationException {
        if (StringUtils.isBlank((String)user)) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank user name has been provided");
        }
        if (StringUtils.isBlank((String)password) || password.getBytes()[0] == 0) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        List<String> principals = LdapUtils.createCandidatePrincipals(this.conf, user);
        Iterator<String> iterator = principals.iterator();
        while (iterator.hasNext()) {
            String principal = iterator.next();
            try {
                return this.searchFactory.getInstance(this.conf, principal, password);
            }
            catch (AuthenticationException ex) {
                if (iterator.hasNext()) continue;
                throw ex;
            }
        }
        throw new AuthenticationException(String.format("No candidate principals for %s was found.", user));
    }

    private static Filter resolveFilter(Configuration conf) {
        for (FilterFactory filterProvider : FILTER_FACTORIES) {
            Filter filter = filterProvider.getInstance(conf);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    private void applyFilter(DirSearch client, String user) throws AuthenticationException {
        if (this.filter != null) {
            if (LdapUtils.hasDomain(user)) {
                this.filter.apply(client, LdapUtils.extractUserName(user));
            } else {
                this.filter.apply(client, user);
            }
        }
    }
}

