/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.jdo.JDOCanRetryException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.datastore.DataStoreCache;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MFieldSchema;
import org.apache.hadoop.hive.metastore.model.MOrder;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MSerDeInfo;
import org.apache.hadoop.hive.metastore.model.MStorageDescriptor;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MType;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.datanucleus.AbstractNucleusContext;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassLoaderResolverImpl;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextThreadedImpl;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PersistenceNucleusContextImpl;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.plugin.NonManagedPluginRegistry;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.TypeManagerImpl;
import org.datanucleus.util.WeakValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManagerProvider {
    private static PersistenceManagerFactory pmf;
    private static Properties prop;
    private static final ReentrantReadWriteLock pmfLock;
    private static final Lock pmfReadLock;
    private static final Lock pmfWriteLock;
    private static final Logger LOG;
    private static final Map<String, Class<?>> PINCLASSMAP;
    private static boolean forTwoMetastoreTesting;
    private static int retryLimit;
    private static long retryInterval;
    private static final Set<Class<? extends Throwable>> retriableExceptionClasses;

    private PersistenceManagerProvider() {
    }

    private static boolean isRetriableException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (retriableExceptionClasses.contains(e.getClass())) {
            return true;
        }
        for (Class<? extends Throwable> c : retriableExceptionClasses) {
            if (!c.isInstance(e)) continue;
            return true;
        }
        if (e.getCause() == null) {
            return false;
        }
        return PersistenceManagerProvider.isRetriableException(e.getCause());
    }

    @VisibleForTesting
    public static void closePmfInternal(PersistenceManagerFactory pmf) {
        if (pmf != null) {
            Throwable throwable;
            AutoCloseable closeable;
            LOG.debug("Closing PersistenceManagerFactory");
            pmf.close();
            if (pmf.getConnectionFactory() instanceof AutoCloseable) {
                try {
                    closeable = (AutoCloseable)pmf.getConnectionFactory();
                    throwable = null;
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            closeable.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to close connection factory of PersistenceManagerFactory: " + pmf, (Throwable)e);
                }
            }
            if (pmf.getConnectionFactory2() instanceof AutoCloseable) {
                try {
                    closeable = (AutoCloseable)pmf.getConnectionFactory2();
                    throwable = null;
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            closeable.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to close connection factory2 of PersistenceManagerFactory: " + pmf, (Throwable)e);
                }
            }
            LOG.debug("PersistenceManagerFactory closed");
        }
    }

    private static void logPropChanges(Properties newProps) {
        if (prop == null) {
            LOG.info("Current pmf properties are uninitialized");
            return;
        }
        LOG.info("Updating the pmf due to property change");
        if (LOG.isDebugEnabled() && !newProps.equals(prop)) {
            for (String key : prop.stringPropertyNames()) {
                if (key.equals(newProps.get(key))) continue;
                if (LOG.isDebugEnabled() && MetastoreConf.isPrintable(key)) {
                    String oldVal = prop.getProperty(key);
                    String newVal = newProps.getProperty(key);
                    if (key.equals(MetastoreConf.ConfVars.CONNECT_URL_KEY.getVarname())) {
                        oldVal = MetaStoreUtils.anonymizeConnectionURL(oldVal);
                        newVal = MetaStoreUtils.anonymizeConnectionURL(newVal);
                    }
                    LOG.debug("Found {} to be different. Old val : {} : New Val : {}", new Object[]{key, oldVal, newVal});
                    continue;
                }
                LOG.debug("Found masked property {} to be different", (Object)key);
            }
        }
    }

    public static void closePmfIfNeeded() {
        pmfWriteLock.lock();
        try {
            PersistenceManagerFactory factory = pmf;
            if (factory != null) {
                PersistenceManagerProvider.clearOutPmfClassLoaderCache();
                if (!forTwoMetastoreTesting) {
                    PersistenceManagerProvider.closePmfInternal(factory);
                }
                pmf = null;
            }
        }
        finally {
            pmfWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePmfProperties(Configuration conf) {
        block8: {
            Properties propsFromConf = PersistenceManagerProvider.getDataSourceProps(conf);
            pmfReadLock.lock();
            boolean readLockAcquired = true;
            try {
                if (prop != null && pmf != null && propsFromConf.equals(prop)) break block8;
                pmfReadLock.unlock();
                readLockAcquired = false;
                pmfWriteLock.lock();
                try {
                    if (prop == null || pmf == null || !propsFromConf.equals(prop)) {
                        PersistenceManagerProvider.logPropChanges(propsFromConf);
                        PersistenceManagerProvider.closePmfIfNeeded();
                        prop = propsFromConf;
                        retryLimit = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
                        retryInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, TimeUnit.MILLISECONDS);
                        PersistenceManagerProvider.retry(() -> {
                            PersistenceManagerProvider.initPMF(conf);
                            return null;
                        });
                    }
                    pmfReadLock.lock();
                    readLockAcquired = true;
                }
                finally {
                    pmfWriteLock.unlock();
                }
            }
            finally {
                if (readLockAcquired) {
                    pmfReadLock.unlock();
                }
            }
        }
    }

    private static void initPMF(Configuration conf) {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull(conf);
        if (dsp == null) {
            pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
        } else {
            try (DataSourceProvider.DataSourceNameConfigurator configurator = new DataSourceProvider.DataSourceNameConfigurator(conf, "objectstore");){
                DataSource ds = dsp.create(conf);
                configurator.resetName("objectstore-secondary");
                Configuration newConf = new Configuration(conf);
                MetastoreConf.setLongVar(newConf, MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS, 2L);
                DataSource ds2 = dsp.create(newConf);
                HashMap<Object, Object> dsProperties = new HashMap<Object, Object>();
                dsProperties.putAll(prop);
                dsProperties.put("datanucleus.ConnectionFactory", ds);
                dsProperties.put("datanucleus.ConnectionFactory2", ds2);
                dsProperties.put(MetastoreConf.ConfVars.MANAGER_FACTORY_CLASS.getVarname(), "org.datanucleus.api.jdo.JDOPersistenceManagerFactory");
                pmf = JDOHelper.getPersistenceManagerFactory(dsProperties);
            }
            catch (SQLException e) {
                LOG.warn("Could not create PersistenceManagerFactory using connection pool properties, will fall back", (Throwable)e);
                pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
            }
        }
        DataStoreCache dsc = pmf.getDataStoreCache();
        if (dsc != null) {
            String objTypes = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CACHE_PINOBJTYPES);
            LOG.info("Setting MetaStore object pin classes with hive.metastore.cache.pinobjtypes=\"{}\"", (Object)objTypes);
            if (StringUtils.isNotEmpty((String)objTypes)) {
                String[] typeTokens;
                for (String type : typeTokens = objTypes.toLowerCase().split(",")) {
                    if (PINCLASSMAP.containsKey(type = type.trim())) {
                        dsc.pinAll(true, PINCLASSMAP.get(type));
                        continue;
                    }
                    LOG.warn("{} is not one of the pinnable object types: {}", (Object)type, (Object)StringUtils.join(PINCLASSMAP.keySet(), (String)" "));
                }
            }
        } else {
            LOG.warn("PersistenceManagerFactory returned null DataStoreCache object. Unable to initialize object pin types defined by hive.metastore.cache.pinobjtypes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOutPmfClassLoaderCache() {
        pmfWriteLock.lock();
        try {
            if (pmf == null || !(pmf instanceof JDOPersistenceManagerFactory)) {
                return;
            }
            JDOPersistenceManagerFactory jdoPmf = (JDOPersistenceManagerFactory)pmf;
            PersistenceNucleusContext nc = jdoPmf.getNucleusContext();
            try {
                Field pmCache = pmf.getClass().getDeclaredField("pmCache");
                pmCache.setAccessible(true);
                Set pmSet = (Set)pmCache.get(pmf);
                for (JDOPersistenceManager pm : pmSet) {
                    ExecutionContext ec = pm.getExecutionContext();
                    if (!(ec instanceof ExecutionContextThreadedImpl)) continue;
                    ClassLoaderResolver clr = ((ExecutionContextThreadedImpl)ec).getClassLoaderResolver();
                    PersistenceManagerProvider.clearClr(clr);
                }
                PluginManager pluginManager = jdoPmf.getNucleusContext().getPluginManager();
                Field registryField = pluginManager.getClass().getDeclaredField("registry");
                registryField.setAccessible(true);
                PluginRegistry registry = (PluginRegistry)registryField.get(pluginManager);
                if (registry instanceof NonManagedPluginRegistry) {
                    NonManagedPluginRegistry nRegistry = (NonManagedPluginRegistry)registry;
                    Field clrField = nRegistry.getClass().getDeclaredField("clr");
                    clrField.setAccessible(true);
                    ClassLoaderResolver clr = (ClassLoaderResolver)clrField.get(nRegistry);
                    PersistenceManagerProvider.clearClr(clr);
                }
                if (nc instanceof PersistenceNucleusContextImpl) {
                    PersistenceNucleusContextImpl pnc = (PersistenceNucleusContextImpl)nc;
                    TypeManagerImpl tm = (TypeManagerImpl)pnc.getTypeManager();
                    Field clrField = tm.getClass().getDeclaredField("clr");
                    clrField.setAccessible(true);
                    ClassLoaderResolver clr = (ClassLoaderResolver)clrField.get(tm);
                    PersistenceManagerProvider.clearClr(clr);
                    Field storeMgrField = pnc.getClass().getDeclaredField("storeMgr");
                    storeMgrField.setAccessible(true);
                    RDBMSStoreManager storeMgr = (RDBMSStoreManager)storeMgrField.get(pnc);
                    Field backingStoreField = storeMgr.getClass().getDeclaredField("backingStoreByMemberName");
                    backingStoreField.setAccessible(true);
                    Map backingStoreByMemberName = (Map)backingStoreField.get(storeMgr);
                    for (Store store : backingStoreByMemberName.values()) {
                        BaseContainerStore baseStore = (BaseContainerStore)store;
                        clrField = BaseContainerStore.class.getDeclaredField("clr");
                        clrField.setAccessible(true);
                        clr = (ClassLoaderResolver)clrField.get(baseStore);
                        PersistenceManagerProvider.clearClr(clr);
                    }
                }
                Field classLoaderResolverMap = AbstractNucleusContext.class.getDeclaredField("classLoaderResolverMap");
                classLoaderResolverMap.setAccessible(true);
                Map loaderMap = (Map)classLoaderResolverMap.get(nc);
                for (ClassLoaderResolver clr : loaderMap.values()) {
                    PersistenceManagerProvider.clearClr(clr);
                }
                classLoaderResolverMap.set(nc, new HashMap());
                LOG.debug("Removed cached classloaders from DataNucleus NucleusContext");
            }
            catch (Exception e) {
                LOG.warn("Failed to remove cached classloaders from DataNucleus NucleusContext", (Throwable)e);
            }
        }
        finally {
            pmfWriteLock.unlock();
        }
    }

    private static void clearClr(ClassLoaderResolver clr) throws Exception {
        if (clr != null && clr instanceof ClassLoaderResolverImpl) {
            ClassLoaderResolverImpl clri = (ClassLoaderResolverImpl)clr;
            long resourcesCleared = PersistenceManagerProvider.clearFieldMap(clri, "resources");
            long loadedClassesCleared = PersistenceManagerProvider.clearFieldMap(clri, "loadedClasses");
            long unloadedClassesCleared = PersistenceManagerProvider.clearFieldMap(clri, "unloadedClasses");
            LOG.debug("Cleared ClassLoaderResolverImpl: {}, {}, {}", new Object[]{resourcesCleared, loadedClassesCleared, unloadedClassesCleared});
        }
    }

    private static long clearFieldMap(ClassLoaderResolverImpl clri, String mapFieldName) throws Exception {
        Field mapField = ClassLoaderResolverImpl.class.getDeclaredField(mapFieldName);
        mapField.setAccessible(true);
        Map map = (Map)mapField.get(clri);
        long sz = map.size();
        mapField.set(clri, Collections.synchronizedMap(new WeakValueMap()));
        return sz;
    }

    public static PersistenceManager getPersistenceManager() {
        pmfReadLock.lock();
        try {
            if (pmf == null) {
                throw new RuntimeException("Cannot create PersistenceManager. PersistenceManagerFactory is not yet initialized");
            }
            PersistenceManager persistenceManager = PersistenceManagerProvider.retry(() -> ((PersistenceManagerFactory)pmf).getPersistenceManager());
            return persistenceManager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            pmfReadLock.unlock();
        }
    }

    private static Properties getDataSourceProps(Configuration conf) {
        Properties prop = new Properties();
        PersistenceManagerProvider.correctAutoStartMechanism(conf);
        for (MetastoreConf.ConfVars var : MetastoreConf.dataNucleusAndJdoConfs) {
            String confVal = MetastoreConf.getAsString(conf, var);
            String varName = var.getVarname();
            Object prevVal = prop.setProperty(varName, confVal);
            if (!MetastoreConf.isPrintable(varName)) continue;
            LOG.debug("Overriding {} value {} from jpox.properties with {}", new Object[]{varName, prevVal, confVal});
        }
        try {
            String passwd = MetastoreConf.getPassword(conf, MetastoreConf.ConfVars.PWD);
            if (StringUtils.isNotEmpty((String)passwd)) {
                prop.setProperty(MetastoreConf.ConfVars.PWD.getVarname(), passwd);
            }
        }
        catch (IOException err) {
            throw new RuntimeException("Error getting metastore password: " + err.getMessage(), err);
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : prop.entrySet()) {
                if (!MetastoreConf.isPrintable(entry.getKey().toString())) continue;
                LOG.debug("{} = {}", entry.getKey(), entry.getValue());
            }
        }
        return prop;
    }

    private static void correctAutoStartMechanism(Configuration conf) {
        String autoStartKey = "datanucleus.autoStartMechanismMode";
        String autoStartIgnore = "ignored";
        String currentAutoStartVal = conf.get("datanucleus.autoStartMechanismMode");
        if (!"ignored".equalsIgnoreCase(currentAutoStartVal)) {
            LOG.warn("{} is set to unsupported value {} . Setting it to value: {}", new Object[]{"datanucleus.autoStartMechanismMode", conf.get("datanucleus.autoStartMechanismMode"), "ignored"});
        }
        conf.set("datanucleus.autoStartMechanismMode", "ignored");
    }

    @VisibleForTesting
    public static void setTwoMetastoreTesting(boolean twoMetastoreTesting) {
        forTwoMetastoreTesting = twoMetastoreTesting;
    }

    public static String getProperty(String key) {
        return prop == null ? null : prop.getProperty(key);
    }

    private static <T> T retry(Supplier<T> s) {
        Exception ex = null;
        int myRetryLimit = retryLimit;
        while (myRetryLimit > 0) {
            try {
                return s.get();
            }
            catch (Exception e) {
                boolean retriable = PersistenceManagerProvider.isRetriableException(e);
                if (--myRetryLimit > 0 && retriable) {
                    LOG.info("Retriable exception while invoking method, retrying. {} attempts left", (Object)myRetryLimit, (Object)e);
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Interrupted while sleeping before retrying.", (Throwable)ie);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (retriable) {
                    LOG.warn("Exception retry limit reached, not retrying any longer.", (Throwable)e);
                } else {
                    LOG.debug("Non-retriable exception.", (Throwable)e);
                }
                ex = e;
            }
        }
        throw new RuntimeException(ex);
    }

    static {
        pmfLock = new ReentrantReadWriteLock();
        pmfReadLock = pmfLock.readLock();
        pmfWriteLock = pmfLock.writeLock();
        LOG = LoggerFactory.getLogger(PersistenceManagerProvider.class);
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("table", MTable.class);
        map.put("storagedescriptor", MStorageDescriptor.class);
        map.put("serdeinfo", MSerDeInfo.class);
        map.put("partition", MPartition.class);
        map.put("database", MDatabase.class);
        map.put("type", MType.class);
        map.put("fieldschema", MFieldSchema.class);
        map.put("order", MOrder.class);
        PINCLASSMAP = Collections.unmodifiableMap(map);
        retriableExceptionClasses = new HashSet<Class>(Arrays.asList(JDOCanRetryException.class));
    }
}

