/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AddDynamicPartitions
implements TBase<AddDynamicPartitions, _Fields>,
Serializable,
Cloneable,
Comparable<AddDynamicPartitions> {
    private static final TStruct STRUCT_DESC = new TStruct("AddDynamicPartitions");
    private static final TField TXNID_FIELD_DESC = new TField("txnid", 10, 1);
    private static final TField WRITEID_FIELD_DESC = new TField("writeid", 10, 2);
    private static final TField DBNAME_FIELD_DESC = new TField("dbname", 11, 3);
    private static final TField TABLENAME_FIELD_DESC = new TField("tablename", 11, 4);
    private static final TField PARTITIONNAMES_FIELD_DESC = new TField("partitionnames", 15, 5);
    private static final TField OPERATION_TYPE_FIELD_DESC = new TField("operationType", 8, 6);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new AddDynamicPartitionsStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new AddDynamicPartitionsTupleSchemeFactory();
    private long txnid;
    private long writeid;
    @Nullable
    private String dbname;
    @Nullable
    private String tablename;
    @Nullable
    private List<String> partitionnames;
    @Nullable
    private DataOperationType operationType;
    private static final int __TXNID_ISSET_ID = 0;
    private static final int __WRITEID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.OPERATION_TYPE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public AddDynamicPartitions() {
        this.operationType = DataOperationType.UNSET;
    }

    public AddDynamicPartitions(long txnid, long writeid, String dbname, String tablename, List<String> partitionnames) {
        this();
        this.txnid = txnid;
        this.setTxnidIsSet(true);
        this.writeid = writeid;
        this.setWriteidIsSet(true);
        this.dbname = dbname;
        this.tablename = tablename;
        this.partitionnames = partitionnames;
    }

    public AddDynamicPartitions(AddDynamicPartitions other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.txnid = other.txnid;
        this.writeid = other.writeid;
        if (other.isSetDbname()) {
            this.dbname = other.dbname;
        }
        if (other.isSetTablename()) {
            this.tablename = other.tablename;
        }
        if (other.isSetPartitionnames()) {
            ArrayList<String> __this__partitionnames = new ArrayList<String>(other.partitionnames);
            this.partitionnames = __this__partitionnames;
        }
        if (other.isSetOperationType()) {
            this.operationType = other.operationType;
        }
    }

    public AddDynamicPartitions deepCopy() {
        return new AddDynamicPartitions(this);
    }

    public void clear() {
        this.setTxnidIsSet(false);
        this.txnid = 0L;
        this.setWriteidIsSet(false);
        this.writeid = 0L;
        this.dbname = null;
        this.tablename = null;
        this.partitionnames = null;
        this.operationType = DataOperationType.UNSET;
    }

    public long getTxnid() {
        return this.txnid;
    }

    public void setTxnid(long txnid) {
        this.txnid = txnid;
        this.setTxnidIsSet(true);
    }

    public void unsetTxnid() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTxnid() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setTxnidIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getWriteid() {
        return this.writeid;
    }

    public void setWriteid(long writeid) {
        this.writeid = writeid;
        this.setWriteidIsSet(true);
    }

    public void unsetWriteid() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetWriteid() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setWriteidIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    @Nullable
    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(@Nullable String dbname) {
        this.dbname = dbname;
    }

    public void unsetDbname() {
        this.dbname = null;
    }

    public boolean isSetDbname() {
        return this.dbname != null;
    }

    public void setDbnameIsSet(boolean value) {
        if (!value) {
            this.dbname = null;
        }
    }

    @Nullable
    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(@Nullable String tablename) {
        this.tablename = tablename;
    }

    public void unsetTablename() {
        this.tablename = null;
    }

    public boolean isSetTablename() {
        return this.tablename != null;
    }

    public void setTablenameIsSet(boolean value) {
        if (!value) {
            this.tablename = null;
        }
    }

    public int getPartitionnamesSize() {
        return this.partitionnames == null ? 0 : this.partitionnames.size();
    }

    @Nullable
    public Iterator<String> getPartitionnamesIterator() {
        return this.partitionnames == null ? null : this.partitionnames.iterator();
    }

    public void addToPartitionnames(String elem) {
        if (this.partitionnames == null) {
            this.partitionnames = new ArrayList<String>();
        }
        this.partitionnames.add(elem);
    }

    @Nullable
    public List<String> getPartitionnames() {
        return this.partitionnames;
    }

    public void setPartitionnames(@Nullable List<String> partitionnames) {
        this.partitionnames = partitionnames;
    }

    public void unsetPartitionnames() {
        this.partitionnames = null;
    }

    public boolean isSetPartitionnames() {
        return this.partitionnames != null;
    }

    public void setPartitionnamesIsSet(boolean value) {
        if (!value) {
            this.partitionnames = null;
        }
    }

    @Nullable
    public DataOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(@Nullable DataOperationType operationType) {
        this.operationType = operationType;
    }

    public void unsetOperationType() {
        this.operationType = null;
    }

    public boolean isSetOperationType() {
        return this.operationType != null;
    }

    public void setOperationTypeIsSet(boolean value) {
        if (!value) {
            this.operationType = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TXNID: {
                if (value == null) {
                    this.unsetTxnid();
                    break;
                }
                this.setTxnid((Long)value);
                break;
            }
            case WRITEID: {
                if (value == null) {
                    this.unsetWriteid();
                    break;
                }
                this.setWriteid((Long)value);
                break;
            }
            case DBNAME: {
                if (value == null) {
                    this.unsetDbname();
                    break;
                }
                this.setDbname((String)value);
                break;
            }
            case TABLENAME: {
                if (value == null) {
                    this.unsetTablename();
                    break;
                }
                this.setTablename((String)value);
                break;
            }
            case PARTITIONNAMES: {
                if (value == null) {
                    this.unsetPartitionnames();
                    break;
                }
                this.setPartitionnames((List)value);
                break;
            }
            case OPERATION_TYPE: {
                if (value == null) {
                    this.unsetOperationType();
                    break;
                }
                this.setOperationType((DataOperationType)((Object)value));
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TXNID: {
                return this.getTxnid();
            }
            case WRITEID: {
                return this.getWriteid();
            }
            case DBNAME: {
                return this.getDbname();
            }
            case TABLENAME: {
                return this.getTablename();
            }
            case PARTITIONNAMES: {
                return this.getPartitionnames();
            }
            case OPERATION_TYPE: {
                return this.getOperationType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TXNID: {
                return this.isSetTxnid();
            }
            case WRITEID: {
                return this.isSetWriteid();
            }
            case DBNAME: {
                return this.isSetDbname();
            }
            case TABLENAME: {
                return this.isSetTablename();
            }
            case PARTITIONNAMES: {
                return this.isSetPartitionnames();
            }
            case OPERATION_TYPE: {
                return this.isSetOperationType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof AddDynamicPartitions) {
            return this.equals((AddDynamicPartitions)that);
        }
        return false;
    }

    public boolean equals(AddDynamicPartitions that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_txnid = true;
        boolean that_present_txnid = true;
        if (this_present_txnid || that_present_txnid) {
            if (!this_present_txnid || !that_present_txnid) {
                return false;
            }
            if (this.txnid != that.txnid) {
                return false;
            }
        }
        boolean this_present_writeid = true;
        boolean that_present_writeid = true;
        if (this_present_writeid || that_present_writeid) {
            if (!this_present_writeid || !that_present_writeid) {
                return false;
            }
            if (this.writeid != that.writeid) {
                return false;
            }
        }
        boolean this_present_dbname = this.isSetDbname();
        boolean that_present_dbname = that.isSetDbname();
        if (this_present_dbname || that_present_dbname) {
            if (!this_present_dbname || !that_present_dbname) {
                return false;
            }
            if (!this.dbname.equals(that.dbname)) {
                return false;
            }
        }
        boolean this_present_tablename = this.isSetTablename();
        boolean that_present_tablename = that.isSetTablename();
        if (this_present_tablename || that_present_tablename) {
            if (!this_present_tablename || !that_present_tablename) {
                return false;
            }
            if (!this.tablename.equals(that.tablename)) {
                return false;
            }
        }
        boolean this_present_partitionnames = this.isSetPartitionnames();
        boolean that_present_partitionnames = that.isSetPartitionnames();
        if (this_present_partitionnames || that_present_partitionnames) {
            if (!this_present_partitionnames || !that_present_partitionnames) {
                return false;
            }
            if (!this.partitionnames.equals(that.partitionnames)) {
                return false;
            }
        }
        boolean this_present_operationType = this.isSetOperationType();
        boolean that_present_operationType = that.isSetOperationType();
        if (this_present_operationType || that_present_operationType) {
            if (!this_present_operationType || !that_present_operationType) {
                return false;
            }
            if (!this.operationType.equals((Object)that.operationType)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.txnid);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.writeid);
        hashCode = hashCode * 8191 + (this.isSetDbname() ? 131071 : 524287);
        if (this.isSetDbname()) {
            hashCode = hashCode * 8191 + this.dbname.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTablename() ? 131071 : 524287);
        if (this.isSetTablename()) {
            hashCode = hashCode * 8191 + this.tablename.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionnames() ? 131071 : 524287);
        if (this.isSetPartitionnames()) {
            hashCode = hashCode * 8191 + this.partitionnames.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOperationType() ? 131071 : 524287);
        if (this.isSetOperationType()) {
            hashCode = hashCode * 8191 + this.operationType.getValue();
        }
        return hashCode;
    }

    @Override
    public int compareTo(AddDynamicPartitions other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTxnid(), other.isSetTxnid());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTxnid() && (lastComparison = TBaseHelper.compareTo((long)this.txnid, (long)other.txnid)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetWriteid(), other.isSetWriteid());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWriteid() && (lastComparison = TBaseHelper.compareTo((long)this.writeid, (long)other.writeid)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbname(), other.isSetDbname());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbname() && (lastComparison = TBaseHelper.compareTo((String)this.dbname, (String)other.dbname)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTablename(), other.isSetTablename());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTablename() && (lastComparison = TBaseHelper.compareTo((String)this.tablename, (String)other.tablename)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionnames(), other.isSetPartitionnames());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionnames() && (lastComparison = TBaseHelper.compareTo(this.partitionnames, other.partitionnames)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOperationType(), other.isSetOperationType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOperationType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.operationType), (Comparable)((Object)other.operationType))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        AddDynamicPartitions.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        AddDynamicPartitions.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AddDynamicPartitions(");
        boolean first = true;
        sb.append("txnid:");
        sb.append(this.txnid);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("writeid:");
        sb.append(this.writeid);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbname:");
        if (this.dbname == null) {
            sb.append("null");
        } else {
            sb.append(this.dbname);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tablename:");
        if (this.tablename == null) {
            sb.append("null");
        } else {
            sb.append(this.tablename);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partitionnames:");
        if (this.partitionnames == null) {
            sb.append("null");
        } else {
            sb.append(this.partitionnames);
        }
        first = false;
        if (this.isSetOperationType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("operationType:");
            if (this.operationType == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.operationType);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetTxnid()) {
            throw new TProtocolException("Required field 'txnid' is unset! Struct:" + this.toString());
        }
        if (!this.isSetWriteid()) {
            throw new TProtocolException("Required field 'writeid' is unset! Struct:" + this.toString());
        }
        if (!this.isSetDbname()) {
            throw new TProtocolException("Required field 'dbname' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTablename()) {
            throw new TProtocolException("Required field 'tablename' is unset! Struct:" + this.toString());
        }
        if (!this.isSetPartitionnames()) {
            throw new TProtocolException("Required field 'partitionnames' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TXNID, new FieldMetaData("txnid", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.WRITEID, new FieldMetaData("writeid", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DBNAME, new FieldMetaData("dbname", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLENAME, new FieldMetaData("tablename", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARTITIONNAMES, new FieldMetaData("partitionnames", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.OPERATION_TYPE, new FieldMetaData("operationType", 2, (FieldValueMetaData)new EnumMetaData(16, DataOperationType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(AddDynamicPartitions.class, metaDataMap);
    }

    private static class AddDynamicPartitionsTupleScheme
    extends TupleScheme<AddDynamicPartitions> {
        private AddDynamicPartitionsTupleScheme() {
        }

        public void write(TProtocol prot, AddDynamicPartitions struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.txnid);
            oprot.writeI64(struct.writeid);
            oprot.writeString(struct.dbname);
            oprot.writeString(struct.tablename);
            oprot.writeI32(struct.partitionnames.size());
            for (String _iter808 : struct.partitionnames) {
                oprot.writeString(_iter808);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetOperationType()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetOperationType()) {
                oprot.writeI32(struct.operationType.getValue());
            }
        }

        public void read(TProtocol prot, AddDynamicPartitions struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.txnid = iprot.readI64();
            struct.setTxnidIsSet(true);
            struct.writeid = iprot.readI64();
            struct.setWriteidIsSet(true);
            struct.dbname = iprot.readString();
            struct.setDbnameIsSet(true);
            struct.tablename = iprot.readString();
            struct.setTablenameIsSet(true);
            TList _list809 = iprot.readListBegin((byte)11);
            struct.partitionnames = new ArrayList(_list809.size);
            for (int _i811 = 0; _i811 < _list809.size; ++_i811) {
                String _elem810 = iprot.readString();
                struct.partitionnames.add(_elem810);
            }
            struct.setPartitionnamesIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.operationType = DataOperationType.findByValue(iprot.readI32());
                struct.setOperationTypeIsSet(true);
            }
        }
    }

    private static class AddDynamicPartitionsTupleSchemeFactory
    implements SchemeFactory {
        private AddDynamicPartitionsTupleSchemeFactory() {
        }

        public AddDynamicPartitionsTupleScheme getScheme() {
            return new AddDynamicPartitionsTupleScheme();
        }
    }

    private static class AddDynamicPartitionsStandardScheme
    extends StandardScheme<AddDynamicPartitions> {
        private AddDynamicPartitionsStandardScheme() {
        }

        public void read(TProtocol iprot, AddDynamicPartitions struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.txnid = iprot.readI64();
                            struct.setTxnidIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.writeid = iprot.readI64();
                            struct.setWriteidIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.dbname = iprot.readString();
                            struct.setDbnameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.tablename = iprot.readString();
                            struct.setTablenameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list804 = iprot.readListBegin();
                            struct.partitionnames = new ArrayList(_list804.size);
                            for (int _i806 = 0; _i806 < _list804.size; ++_i806) {
                                String _elem805 = iprot.readString();
                                struct.partitionnames.add(_elem805);
                            }
                            iprot.readListEnd();
                            struct.setPartitionnamesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.operationType = DataOperationType.findByValue(iprot.readI32());
                            struct.setOperationTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, AddDynamicPartitions struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TXNID_FIELD_DESC);
            oprot.writeI64(struct.txnid);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(WRITEID_FIELD_DESC);
            oprot.writeI64(struct.writeid);
            oprot.writeFieldEnd();
            if (struct.dbname != null) {
                oprot.writeFieldBegin(DBNAME_FIELD_DESC);
                oprot.writeString(struct.dbname);
                oprot.writeFieldEnd();
            }
            if (struct.tablename != null) {
                oprot.writeFieldBegin(TABLENAME_FIELD_DESC);
                oprot.writeString(struct.tablename);
                oprot.writeFieldEnd();
            }
            if (struct.partitionnames != null) {
                oprot.writeFieldBegin(PARTITIONNAMES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.partitionnames.size()));
                for (String _iter807 : struct.partitionnames) {
                    oprot.writeString(_iter807);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.operationType != null && struct.isSetOperationType()) {
                oprot.writeFieldBegin(OPERATION_TYPE_FIELD_DESC);
                oprot.writeI32(struct.operationType.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class AddDynamicPartitionsStandardSchemeFactory
    implements SchemeFactory {
        private AddDynamicPartitionsStandardSchemeFactory() {
        }

        public AddDynamicPartitionsStandardScheme getScheme() {
            return new AddDynamicPartitionsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TXNID(1, "txnid"),
        WRITEID(2, "writeid"),
        DBNAME(3, "dbname"),
        TABLENAME(4, "tablename"),
        PARTITIONNAMES(5, "partitionnames"),
        OPERATION_TYPE(6, "operationType");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TXNID;
                }
                case 2: {
                    return WRITEID;
                }
                case 3: {
                    return DBNAME;
                }
                case 4: {
                    return TABLENAME;
                }
                case 5: {
                    return PARTITIONNAMES;
                }
                case 6: {
                    return OPERATION_TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

