/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DoubleColumnStatsData
implements TBase<DoubleColumnStatsData, _Fields>,
Serializable,
Cloneable,
Comparable<DoubleColumnStatsData> {
    private static final TStruct STRUCT_DESC = new TStruct("DoubleColumnStatsData");
    private static final TField LOW_VALUE_FIELD_DESC = new TField("lowValue", 4, 1);
    private static final TField HIGH_VALUE_FIELD_DESC = new TField("highValue", 4, 2);
    private static final TField NUM_NULLS_FIELD_DESC = new TField("numNulls", 10, 3);
    private static final TField NUM_DVS_FIELD_DESC = new TField("numDVs", 10, 4);
    private static final TField BIT_VECTORS_FIELD_DESC = new TField("bitVectors", 11, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new DoubleColumnStatsDataStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new DoubleColumnStatsDataTupleSchemeFactory();
    private double lowValue;
    private double highValue;
    private long numNulls;
    private long numDVs;
    @Nullable
    private ByteBuffer bitVectors;
    private static final int __LOWVALUE_ISSET_ID = 0;
    private static final int __HIGHVALUE_ISSET_ID = 1;
    private static final int __NUMNULLS_ISSET_ID = 2;
    private static final int __NUMDVS_ISSET_ID = 3;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.LOW_VALUE, _Fields.HIGH_VALUE, _Fields.BIT_VECTORS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DoubleColumnStatsData() {
    }

    public DoubleColumnStatsData(long numNulls, long numDVs) {
        this();
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
        this.numDVs = numDVs;
        this.setNumDVsIsSet(true);
    }

    public DoubleColumnStatsData(DoubleColumnStatsData other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.lowValue = other.lowValue;
        this.highValue = other.highValue;
        this.numNulls = other.numNulls;
        this.numDVs = other.numDVs;
        if (other.isSetBitVectors()) {
            this.bitVectors = TBaseHelper.copyBinary((ByteBuffer)other.bitVectors);
        }
    }

    public DoubleColumnStatsData deepCopy() {
        return new DoubleColumnStatsData(this);
    }

    public void clear() {
        this.setLowValueIsSet(false);
        this.lowValue = 0.0;
        this.setHighValueIsSet(false);
        this.highValue = 0.0;
        this.setNumNullsIsSet(false);
        this.numNulls = 0L;
        this.setNumDVsIsSet(false);
        this.numDVs = 0L;
        this.bitVectors = null;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(double lowValue) {
        this.lowValue = lowValue;
        this.setLowValueIsSet(true);
    }

    public void unsetLowValue() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetLowValue() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setLowValueIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public double getHighValue() {
        return this.highValue;
    }

    public void setHighValue(double highValue) {
        this.highValue = highValue;
        this.setHighValueIsSet(true);
    }

    public void unsetHighValue() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetHighValue() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setHighValueIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
        this.setNumNullsIsSet(true);
    }

    public void unsetNumNulls() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetNumNulls() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setNumNullsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getNumDVs() {
        return this.numDVs;
    }

    public void setNumDVs(long numDVs) {
        this.numDVs = numDVs;
        this.setNumDVsIsSet(true);
    }

    public void unsetNumDVs() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetNumDVs() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setNumDVsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public byte[] getBitVectors() {
        this.setBitVectors(TBaseHelper.rightSize((ByteBuffer)this.bitVectors));
        return this.bitVectors == null ? null : this.bitVectors.array();
    }

    public ByteBuffer bufferForBitVectors() {
        return TBaseHelper.copyBinary((ByteBuffer)this.bitVectors);
    }

    public void setBitVectors(byte[] bitVectors) {
        this.bitVectors = bitVectors == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])bitVectors.clone());
    }

    public void setBitVectors(@Nullable ByteBuffer bitVectors) {
        this.bitVectors = TBaseHelper.copyBinary((ByteBuffer)bitVectors);
    }

    public void unsetBitVectors() {
        this.bitVectors = null;
    }

    public boolean isSetBitVectors() {
        return this.bitVectors != null;
    }

    public void setBitVectorsIsSet(boolean value) {
        if (!value) {
            this.bitVectors = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case LOW_VALUE: {
                if (value == null) {
                    this.unsetLowValue();
                    break;
                }
                this.setLowValue((Double)value);
                break;
            }
            case HIGH_VALUE: {
                if (value == null) {
                    this.unsetHighValue();
                    break;
                }
                this.setHighValue((Double)value);
                break;
            }
            case NUM_NULLS: {
                if (value == null) {
                    this.unsetNumNulls();
                    break;
                }
                this.setNumNulls((Long)value);
                break;
            }
            case NUM_DVS: {
                if (value == null) {
                    this.unsetNumDVs();
                    break;
                }
                this.setNumDVs((Long)value);
                break;
            }
            case BIT_VECTORS: {
                if (value == null) {
                    this.unsetBitVectors();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setBitVectors((byte[])value);
                    break;
                }
                this.setBitVectors((ByteBuffer)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case LOW_VALUE: {
                return this.getLowValue();
            }
            case HIGH_VALUE: {
                return this.getHighValue();
            }
            case NUM_NULLS: {
                return this.getNumNulls();
            }
            case NUM_DVS: {
                return this.getNumDVs();
            }
            case BIT_VECTORS: {
                return this.getBitVectors();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case LOW_VALUE: {
                return this.isSetLowValue();
            }
            case HIGH_VALUE: {
                return this.isSetHighValue();
            }
            case NUM_NULLS: {
                return this.isSetNumNulls();
            }
            case NUM_DVS: {
                return this.isSetNumDVs();
            }
            case BIT_VECTORS: {
                return this.isSetBitVectors();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof DoubleColumnStatsData) {
            return this.equals((DoubleColumnStatsData)that);
        }
        return false;
    }

    public boolean equals(DoubleColumnStatsData that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_lowValue = this.isSetLowValue();
        boolean that_present_lowValue = that.isSetLowValue();
        if (this_present_lowValue || that_present_lowValue) {
            if (!this_present_lowValue || !that_present_lowValue) {
                return false;
            }
            if (this.lowValue != that.lowValue) {
                return false;
            }
        }
        boolean this_present_highValue = this.isSetHighValue();
        boolean that_present_highValue = that.isSetHighValue();
        if (this_present_highValue || that_present_highValue) {
            if (!this_present_highValue || !that_present_highValue) {
                return false;
            }
            if (this.highValue != that.highValue) {
                return false;
            }
        }
        boolean this_present_numNulls = true;
        boolean that_present_numNulls = true;
        if (this_present_numNulls || that_present_numNulls) {
            if (!this_present_numNulls || !that_present_numNulls) {
                return false;
            }
            if (this.numNulls != that.numNulls) {
                return false;
            }
        }
        boolean this_present_numDVs = true;
        boolean that_present_numDVs = true;
        if (this_present_numDVs || that_present_numDVs) {
            if (!this_present_numDVs || !that_present_numDVs) {
                return false;
            }
            if (this.numDVs != that.numDVs) {
                return false;
            }
        }
        boolean this_present_bitVectors = this.isSetBitVectors();
        boolean that_present_bitVectors = that.isSetBitVectors();
        if (this_present_bitVectors || that_present_bitVectors) {
            if (!this_present_bitVectors || !that_present_bitVectors) {
                return false;
            }
            if (!this.bitVectors.equals(that.bitVectors)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetLowValue() ? 131071 : 524287);
        if (this.isSetLowValue()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.lowValue);
        }
        hashCode = hashCode * 8191 + (this.isSetHighValue() ? 131071 : 524287);
        if (this.isSetHighValue()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.highValue);
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.numNulls);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.numDVs);
        hashCode = hashCode * 8191 + (this.isSetBitVectors() ? 131071 : 524287);
        if (this.isSetBitVectors()) {
            hashCode = hashCode * 8191 + this.bitVectors.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(DoubleColumnStatsData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetLowValue(), other.isSetLowValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLowValue() && (lastComparison = TBaseHelper.compareTo((double)this.lowValue, (double)other.lowValue)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetHighValue(), other.isSetHighValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHighValue() && (lastComparison = TBaseHelper.compareTo((double)this.highValue, (double)other.highValue)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumNulls(), other.isSetNumNulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumNulls() && (lastComparison = TBaseHelper.compareTo((long)this.numNulls, (long)other.numNulls)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumDVs(), other.isSetNumDVs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumDVs() && (lastComparison = TBaseHelper.compareTo((long)this.numDVs, (long)other.numDVs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBitVectors(), other.isSetBitVectors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBitVectors() && (lastComparison = TBaseHelper.compareTo((Comparable)this.bitVectors, (Comparable)other.bitVectors)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        DoubleColumnStatsData.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        DoubleColumnStatsData.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DoubleColumnStatsData(");
        boolean first = true;
        if (this.isSetLowValue()) {
            sb.append("lowValue:");
            sb.append(this.lowValue);
            first = false;
        }
        if (this.isSetHighValue()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("highValue:");
            sb.append(this.highValue);
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("numNulls:");
        sb.append(this.numNulls);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numDVs:");
        sb.append(this.numDVs);
        first = false;
        if (this.isSetBitVectors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bitVectors:");
            if (this.bitVectors == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.bitVectors, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetNumNulls()) {
            throw new TProtocolException("Required field 'numNulls' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNumDVs()) {
            throw new TProtocolException("Required field 'numDVs' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.LOW_VALUE, new FieldMetaData("lowValue", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.HIGH_VALUE, new FieldMetaData("highValue", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.NUM_NULLS, new FieldMetaData("numNulls", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NUM_DVS, new FieldMetaData("numDVs", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BIT_VECTORS, new FieldMetaData("bitVectors", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DoubleColumnStatsData.class, metaDataMap);
    }

    private static class DoubleColumnStatsDataTupleScheme
    extends TupleScheme<DoubleColumnStatsData> {
        private DoubleColumnStatsDataTupleScheme() {
        }

        public void write(TProtocol prot, DoubleColumnStatsData struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.numNulls);
            oprot.writeI64(struct.numDVs);
            BitSet optionals = new BitSet();
            if (struct.isSetLowValue()) {
                optionals.set(0);
            }
            if (struct.isSetHighValue()) {
                optionals.set(1);
            }
            if (struct.isSetBitVectors()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetLowValue()) {
                oprot.writeDouble(struct.lowValue);
            }
            if (struct.isSetHighValue()) {
                oprot.writeDouble(struct.highValue);
            }
            if (struct.isSetBitVectors()) {
                oprot.writeBinary(struct.bitVectors);
            }
        }

        public void read(TProtocol prot, DoubleColumnStatsData struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.numNulls = iprot.readI64();
            struct.setNumNullsIsSet(true);
            struct.numDVs = iprot.readI64();
            struct.setNumDVsIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.lowValue = iprot.readDouble();
                struct.setLowValueIsSet(true);
            }
            if (incoming.get(1)) {
                struct.highValue = iprot.readDouble();
                struct.setHighValueIsSet(true);
            }
            if (incoming.get(2)) {
                struct.bitVectors = iprot.readBinary();
                struct.setBitVectorsIsSet(true);
            }
        }
    }

    private static class DoubleColumnStatsDataTupleSchemeFactory
    implements SchemeFactory {
        private DoubleColumnStatsDataTupleSchemeFactory() {
        }

        public DoubleColumnStatsDataTupleScheme getScheme() {
            return new DoubleColumnStatsDataTupleScheme();
        }
    }

    private static class DoubleColumnStatsDataStandardScheme
    extends StandardScheme<DoubleColumnStatsData> {
        private DoubleColumnStatsDataStandardScheme() {
        }

        public void read(TProtocol iprot, DoubleColumnStatsData struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 4) {
                            struct.lowValue = iprot.readDouble();
                            struct.setLowValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 4) {
                            struct.highValue = iprot.readDouble();
                            struct.setHighValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.numNulls = iprot.readI64();
                            struct.setNumNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.numDVs = iprot.readI64();
                            struct.setNumDVsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.bitVectors = iprot.readBinary();
                            struct.setBitVectorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, DoubleColumnStatsData struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.isSetLowValue()) {
                oprot.writeFieldBegin(LOW_VALUE_FIELD_DESC);
                oprot.writeDouble(struct.lowValue);
                oprot.writeFieldEnd();
            }
            if (struct.isSetHighValue()) {
                oprot.writeFieldBegin(HIGH_VALUE_FIELD_DESC);
                oprot.writeDouble(struct.highValue);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(NUM_NULLS_FIELD_DESC);
            oprot.writeI64(struct.numNulls);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_DVS_FIELD_DESC);
            oprot.writeI64(struct.numDVs);
            oprot.writeFieldEnd();
            if (struct.bitVectors != null && struct.isSetBitVectors()) {
                oprot.writeFieldBegin(BIT_VECTORS_FIELD_DESC);
                oprot.writeBinary(struct.bitVectors);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DoubleColumnStatsDataStandardSchemeFactory
    implements SchemeFactory {
        private DoubleColumnStatsDataStandardSchemeFactory() {
        }

        public DoubleColumnStatsDataStandardScheme getScheme() {
            return new DoubleColumnStatsDataStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        LOW_VALUE(1, "lowValue"),
        HIGH_VALUE(2, "highValue"),
        NUM_NULLS(3, "numNulls"),
        NUM_DVS(4, "numDVs"),
        BIT_VECTORS(5, "bitVectors");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return LOW_VALUE;
                }
                case 2: {
                    return HIGH_VALUE;
                }
                case 3: {
                    return NUM_NULLS;
                }
                case 4: {
                    return NUM_DVS;
                }
                case 5: {
                    return BIT_VECTORS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

