/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GetPartitionsRequest
implements TBase<GetPartitionsRequest, _Fields>,
Serializable,
Cloneable,
Comparable<GetPartitionsRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("GetPartitionsRequest");
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField TBL_NAME_FIELD_DESC = new TField("tblName", 11, 3);
    private static final TField WITH_AUTH_FIELD_DESC = new TField("withAuth", 2, 4);
    private static final TField USER_FIELD_DESC = new TField("user", 11, 5);
    private static final TField GROUP_NAMES_FIELD_DESC = new TField("groupNames", 15, 6);
    private static final TField PROJECTION_SPEC_FIELD_DESC = new TField("projectionSpec", 12, 7);
    private static final TField FILTER_SPEC_FIELD_DESC = new TField("filterSpec", 12, 8);
    private static final TField PROCESSOR_CAPABILITIES_FIELD_DESC = new TField("processorCapabilities", 15, 9);
    private static final TField PROCESSOR_IDENTIFIER_FIELD_DESC = new TField("processorIdentifier", 11, 10);
    private static final TField VALID_WRITE_ID_LIST_FIELD_DESC = new TField("validWriteIdList", 11, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new GetPartitionsRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new GetPartitionsRequestTupleSchemeFactory();
    @Nullable
    private String catName;
    @Nullable
    private String dbName;
    @Nullable
    private String tblName;
    private boolean withAuth;
    @Nullable
    private String user;
    @Nullable
    private List<String> groupNames;
    @Nullable
    private GetProjectionsSpec projectionSpec;
    @Nullable
    private GetPartitionsFilterSpec filterSpec;
    @Nullable
    private List<String> processorCapabilities;
    @Nullable
    private String processorIdentifier;
    @Nullable
    private String validWriteIdList;
    private static final int __WITHAUTH_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CAT_NAME, _Fields.WITH_AUTH, _Fields.USER, _Fields.GROUP_NAMES, _Fields.PROCESSOR_CAPABILITIES, _Fields.PROCESSOR_IDENTIFIER, _Fields.VALID_WRITE_ID_LIST};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public GetPartitionsRequest() {
    }

    public GetPartitionsRequest(String dbName, String tblName, GetProjectionsSpec projectionSpec, GetPartitionsFilterSpec filterSpec) {
        this();
        this.dbName = dbName;
        this.tblName = tblName;
        this.projectionSpec = projectionSpec;
        this.filterSpec = filterSpec;
    }

    public GetPartitionsRequest(GetPartitionsRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTblName()) {
            this.tblName = other.tblName;
        }
        this.withAuth = other.withAuth;
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetGroupNames()) {
            ArrayList<String> __this__groupNames = new ArrayList<String>(other.groupNames);
            this.groupNames = __this__groupNames;
        }
        if (other.isSetProjectionSpec()) {
            this.projectionSpec = new GetProjectionsSpec(other.projectionSpec);
        }
        if (other.isSetFilterSpec()) {
            this.filterSpec = new GetPartitionsFilterSpec(other.filterSpec);
        }
        if (other.isSetProcessorCapabilities()) {
            ArrayList<String> __this__processorCapabilities = new ArrayList<String>(other.processorCapabilities);
            this.processorCapabilities = __this__processorCapabilities;
        }
        if (other.isSetProcessorIdentifier()) {
            this.processorIdentifier = other.processorIdentifier;
        }
        if (other.isSetValidWriteIdList()) {
            this.validWriteIdList = other.validWriteIdList;
        }
    }

    public GetPartitionsRequest deepCopy() {
        return new GetPartitionsRequest(this);
    }

    public void clear() {
        this.catName = null;
        this.dbName = null;
        this.tblName = null;
        this.setWithAuthIsSet(false);
        this.withAuth = false;
        this.user = null;
        this.groupNames = null;
        this.projectionSpec = null;
        this.filterSpec = null;
        this.processorCapabilities = null;
        this.processorIdentifier = null;
        this.validWriteIdList = null;
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(@Nullable String tblName) {
        this.tblName = tblName;
    }

    public void unsetTblName() {
        this.tblName = null;
    }

    public boolean isSetTblName() {
        return this.tblName != null;
    }

    public void setTblNameIsSet(boolean value) {
        if (!value) {
            this.tblName = null;
        }
    }

    public boolean isWithAuth() {
        return this.withAuth;
    }

    public void setWithAuth(boolean withAuth) {
        this.withAuth = withAuth;
        this.setWithAuthIsSet(true);
    }

    public void unsetWithAuth() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetWithAuth() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setWithAuthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    public int getGroupNamesSize() {
        return this.groupNames == null ? 0 : this.groupNames.size();
    }

    @Nullable
    public Iterator<String> getGroupNamesIterator() {
        return this.groupNames == null ? null : this.groupNames.iterator();
    }

    public void addToGroupNames(String elem) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.add(elem);
    }

    @Nullable
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public void setGroupNames(@Nullable List<String> groupNames) {
        this.groupNames = groupNames;
    }

    public void unsetGroupNames() {
        this.groupNames = null;
    }

    public boolean isSetGroupNames() {
        return this.groupNames != null;
    }

    public void setGroupNamesIsSet(boolean value) {
        if (!value) {
            this.groupNames = null;
        }
    }

    @Nullable
    public GetProjectionsSpec getProjectionSpec() {
        return this.projectionSpec;
    }

    public void setProjectionSpec(@Nullable GetProjectionsSpec projectionSpec) {
        this.projectionSpec = projectionSpec;
    }

    public void unsetProjectionSpec() {
        this.projectionSpec = null;
    }

    public boolean isSetProjectionSpec() {
        return this.projectionSpec != null;
    }

    public void setProjectionSpecIsSet(boolean value) {
        if (!value) {
            this.projectionSpec = null;
        }
    }

    @Nullable
    public GetPartitionsFilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    public void setFilterSpec(@Nullable GetPartitionsFilterSpec filterSpec) {
        this.filterSpec = filterSpec;
    }

    public void unsetFilterSpec() {
        this.filterSpec = null;
    }

    public boolean isSetFilterSpec() {
        return this.filterSpec != null;
    }

    public void setFilterSpecIsSet(boolean value) {
        if (!value) {
            this.filterSpec = null;
        }
    }

    public int getProcessorCapabilitiesSize() {
        return this.processorCapabilities == null ? 0 : this.processorCapabilities.size();
    }

    @Nullable
    public Iterator<String> getProcessorCapabilitiesIterator() {
        return this.processorCapabilities == null ? null : this.processorCapabilities.iterator();
    }

    public void addToProcessorCapabilities(String elem) {
        if (this.processorCapabilities == null) {
            this.processorCapabilities = new ArrayList<String>();
        }
        this.processorCapabilities.add(elem);
    }

    @Nullable
    public List<String> getProcessorCapabilities() {
        return this.processorCapabilities;
    }

    public void setProcessorCapabilities(@Nullable List<String> processorCapabilities) {
        this.processorCapabilities = processorCapabilities;
    }

    public void unsetProcessorCapabilities() {
        this.processorCapabilities = null;
    }

    public boolean isSetProcessorCapabilities() {
        return this.processorCapabilities != null;
    }

    public void setProcessorCapabilitiesIsSet(boolean value) {
        if (!value) {
            this.processorCapabilities = null;
        }
    }

    @Nullable
    public String getProcessorIdentifier() {
        return this.processorIdentifier;
    }

    public void setProcessorIdentifier(@Nullable String processorIdentifier) {
        this.processorIdentifier = processorIdentifier;
    }

    public void unsetProcessorIdentifier() {
        this.processorIdentifier = null;
    }

    public boolean isSetProcessorIdentifier() {
        return this.processorIdentifier != null;
    }

    public void setProcessorIdentifierIsSet(boolean value) {
        if (!value) {
            this.processorIdentifier = null;
        }
    }

    @Nullable
    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public void setValidWriteIdList(@Nullable String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
    }

    public void unsetValidWriteIdList() {
        this.validWriteIdList = null;
    }

    public boolean isSetValidWriteIdList() {
        return this.validWriteIdList != null;
    }

    public void setValidWriteIdListIsSet(boolean value) {
        if (!value) {
            this.validWriteIdList = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case CAT_NAME: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TBL_NAME: {
                if (value == null) {
                    this.unsetTblName();
                    break;
                }
                this.setTblName((String)value);
                break;
            }
            case WITH_AUTH: {
                if (value == null) {
                    this.unsetWithAuth();
                    break;
                }
                this.setWithAuth((Boolean)value);
                break;
            }
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case GROUP_NAMES: {
                if (value == null) {
                    this.unsetGroupNames();
                    break;
                }
                this.setGroupNames((List)value);
                break;
            }
            case PROJECTION_SPEC: {
                if (value == null) {
                    this.unsetProjectionSpec();
                    break;
                }
                this.setProjectionSpec((GetProjectionsSpec)value);
                break;
            }
            case FILTER_SPEC: {
                if (value == null) {
                    this.unsetFilterSpec();
                    break;
                }
                this.setFilterSpec((GetPartitionsFilterSpec)value);
                break;
            }
            case PROCESSOR_CAPABILITIES: {
                if (value == null) {
                    this.unsetProcessorCapabilities();
                    break;
                }
                this.setProcessorCapabilities((List)value);
                break;
            }
            case PROCESSOR_IDENTIFIER: {
                if (value == null) {
                    this.unsetProcessorIdentifier();
                    break;
                }
                this.setProcessorIdentifier((String)value);
                break;
            }
            case VALID_WRITE_ID_LIST: {
                if (value == null) {
                    this.unsetValidWriteIdList();
                    break;
                }
                this.setValidWriteIdList((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CAT_NAME: {
                return this.getCatName();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case TBL_NAME: {
                return this.getTblName();
            }
            case WITH_AUTH: {
                return this.isWithAuth();
            }
            case USER: {
                return this.getUser();
            }
            case GROUP_NAMES: {
                return this.getGroupNames();
            }
            case PROJECTION_SPEC: {
                return this.getProjectionSpec();
            }
            case FILTER_SPEC: {
                return this.getFilterSpec();
            }
            case PROCESSOR_CAPABILITIES: {
                return this.getProcessorCapabilities();
            }
            case PROCESSOR_IDENTIFIER: {
                return this.getProcessorIdentifier();
            }
            case VALID_WRITE_ID_LIST: {
                return this.getValidWriteIdList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CAT_NAME: {
                return this.isSetCatName();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TBL_NAME: {
                return this.isSetTblName();
            }
            case WITH_AUTH: {
                return this.isSetWithAuth();
            }
            case USER: {
                return this.isSetUser();
            }
            case GROUP_NAMES: {
                return this.isSetGroupNames();
            }
            case PROJECTION_SPEC: {
                return this.isSetProjectionSpec();
            }
            case FILTER_SPEC: {
                return this.isSetFilterSpec();
            }
            case PROCESSOR_CAPABILITIES: {
                return this.isSetProcessorCapabilities();
            }
            case PROCESSOR_IDENTIFIER: {
                return this.isSetProcessorIdentifier();
            }
            case VALID_WRITE_ID_LIST: {
                return this.isSetValidWriteIdList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof GetPartitionsRequest) {
            return this.equals((GetPartitionsRequest)that);
        }
        return false;
    }

    public boolean equals(GetPartitionsRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tblName = this.isSetTblName();
        boolean that_present_tblName = that.isSetTblName();
        if (this_present_tblName || that_present_tblName) {
            if (!this_present_tblName || !that_present_tblName) {
                return false;
            }
            if (!this.tblName.equals(that.tblName)) {
                return false;
            }
        }
        boolean this_present_withAuth = this.isSetWithAuth();
        boolean that_present_withAuth = that.isSetWithAuth();
        if (this_present_withAuth || that_present_withAuth) {
            if (!this_present_withAuth || !that_present_withAuth) {
                return false;
            }
            if (this.withAuth != that.withAuth) {
                return false;
            }
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_groupNames = this.isSetGroupNames();
        boolean that_present_groupNames = that.isSetGroupNames();
        if (this_present_groupNames || that_present_groupNames) {
            if (!this_present_groupNames || !that_present_groupNames) {
                return false;
            }
            if (!this.groupNames.equals(that.groupNames)) {
                return false;
            }
        }
        boolean this_present_projectionSpec = this.isSetProjectionSpec();
        boolean that_present_projectionSpec = that.isSetProjectionSpec();
        if (this_present_projectionSpec || that_present_projectionSpec) {
            if (!this_present_projectionSpec || !that_present_projectionSpec) {
                return false;
            }
            if (!this.projectionSpec.equals(that.projectionSpec)) {
                return false;
            }
        }
        boolean this_present_filterSpec = this.isSetFilterSpec();
        boolean that_present_filterSpec = that.isSetFilterSpec();
        if (this_present_filterSpec || that_present_filterSpec) {
            if (!this_present_filterSpec || !that_present_filterSpec) {
                return false;
            }
            if (!this.filterSpec.equals(that.filterSpec)) {
                return false;
            }
        }
        boolean this_present_processorCapabilities = this.isSetProcessorCapabilities();
        boolean that_present_processorCapabilities = that.isSetProcessorCapabilities();
        if (this_present_processorCapabilities || that_present_processorCapabilities) {
            if (!this_present_processorCapabilities || !that_present_processorCapabilities) {
                return false;
            }
            if (!this.processorCapabilities.equals(that.processorCapabilities)) {
                return false;
            }
        }
        boolean this_present_processorIdentifier = this.isSetProcessorIdentifier();
        boolean that_present_processorIdentifier = that.isSetProcessorIdentifier();
        if (this_present_processorIdentifier || that_present_processorIdentifier) {
            if (!this_present_processorIdentifier || !that_present_processorIdentifier) {
                return false;
            }
            if (!this.processorIdentifier.equals(that.processorIdentifier)) {
                return false;
            }
        }
        boolean this_present_validWriteIdList = this.isSetValidWriteIdList();
        boolean that_present_validWriteIdList = that.isSetValidWriteIdList();
        if (this_present_validWriteIdList || that_present_validWriteIdList) {
            if (!this_present_validWriteIdList || !that_present_validWriteIdList) {
                return false;
            }
            if (!this.validWriteIdList.equals(that.validWriteIdList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTblName() ? 131071 : 524287);
        if (this.isSetTblName()) {
            hashCode = hashCode * 8191 + this.tblName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetWithAuth() ? 131071 : 524287);
        if (this.isSetWithAuth()) {
            hashCode = hashCode * 8191 + (this.withAuth ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetUser() ? 131071 : 524287);
        if (this.isSetUser()) {
            hashCode = hashCode * 8191 + this.user.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetGroupNames() ? 131071 : 524287);
        if (this.isSetGroupNames()) {
            hashCode = hashCode * 8191 + this.groupNames.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProjectionSpec() ? 131071 : 524287);
        if (this.isSetProjectionSpec()) {
            hashCode = hashCode * 8191 + this.projectionSpec.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFilterSpec() ? 131071 : 524287);
        if (this.isSetFilterSpec()) {
            hashCode = hashCode * 8191 + this.filterSpec.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProcessorCapabilities() ? 131071 : 524287);
        if (this.isSetProcessorCapabilities()) {
            hashCode = hashCode * 8191 + this.processorCapabilities.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProcessorIdentifier() ? 131071 : 524287);
        if (this.isSetProcessorIdentifier()) {
            hashCode = hashCode * 8191 + this.processorIdentifier.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetValidWriteIdList() ? 131071 : 524287);
        if (this.isSetValidWriteIdList()) {
            hashCode = hashCode * 8191 + this.validWriteIdList.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(GetPartitionsRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo((String)this.catName, (String)other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTblName(), other.isSetTblName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTblName() && (lastComparison = TBaseHelper.compareTo((String)this.tblName, (String)other.tblName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetWithAuth(), other.isSetWithAuth());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWithAuth() && (lastComparison = TBaseHelper.compareTo((boolean)this.withAuth, (boolean)other.withAuth)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetUser(), other.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)other.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetGroupNames(), other.isSetGroupNames());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGroupNames() && (lastComparison = TBaseHelper.compareTo(this.groupNames, other.groupNames)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProjectionSpec(), other.isSetProjectionSpec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProjectionSpec() && (lastComparison = TBaseHelper.compareTo((Comparable)this.projectionSpec, (Comparable)other.projectionSpec)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFilterSpec(), other.isSetFilterSpec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFilterSpec() && (lastComparison = TBaseHelper.compareTo((Comparable)this.filterSpec, (Comparable)other.filterSpec)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProcessorCapabilities(), other.isSetProcessorCapabilities());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessorCapabilities() && (lastComparison = TBaseHelper.compareTo(this.processorCapabilities, other.processorCapabilities)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProcessorIdentifier(), other.isSetProcessorIdentifier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcessorIdentifier() && (lastComparison = TBaseHelper.compareTo((String)this.processorIdentifier, (String)other.processorIdentifier)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetValidWriteIdList(), other.isSetValidWriteIdList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValidWriteIdList() && (lastComparison = TBaseHelper.compareTo((String)this.validWriteIdList, (String)other.validWriteIdList)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        GetPartitionsRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        GetPartitionsRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetPartitionsRequest(");
        boolean first = true;
        if (this.isSetCatName()) {
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tblName:");
        if (this.tblName == null) {
            sb.append("null");
        } else {
            sb.append(this.tblName);
        }
        first = false;
        if (this.isSetWithAuth()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("withAuth:");
            sb.append(this.withAuth);
            first = false;
        }
        if (this.isSetUser()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("user:");
            if (this.user == null) {
                sb.append("null");
            } else {
                sb.append(this.user);
            }
            first = false;
        }
        if (this.isSetGroupNames()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("groupNames:");
            if (this.groupNames == null) {
                sb.append("null");
            } else {
                sb.append(this.groupNames);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("projectionSpec:");
        if (this.projectionSpec == null) {
            sb.append("null");
        } else {
            sb.append(this.projectionSpec);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("filterSpec:");
        if (this.filterSpec == null) {
            sb.append("null");
        } else {
            sb.append(this.filterSpec);
        }
        first = false;
        if (this.isSetProcessorCapabilities()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processorCapabilities:");
            if (this.processorCapabilities == null) {
                sb.append("null");
            } else {
                sb.append(this.processorCapabilities);
            }
            first = false;
        }
        if (this.isSetProcessorIdentifier()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("processorIdentifier:");
            if (this.processorIdentifier == null) {
                sb.append("null");
            } else {
                sb.append(this.processorIdentifier);
            }
            first = false;
        }
        if (this.isSetValidWriteIdList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("validWriteIdList:");
            if (this.validWriteIdList == null) {
                sb.append("null");
            } else {
                sb.append(this.validWriteIdList);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.projectionSpec != null) {
            this.projectionSpec.validate();
        }
        if (this.filterSpec != null) {
            this.filterSpec.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL_NAME, new FieldMetaData("tblName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.WITH_AUTH, new FieldMetaData("withAuth", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GROUP_NAMES, new FieldMetaData("groupNames", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PROJECTION_SPEC, new FieldMetaData("projectionSpec", 3, (FieldValueMetaData)new StructMetaData(12, GetProjectionsSpec.class)));
        tmpMap.put(_Fields.FILTER_SPEC, new FieldMetaData("filterSpec", 3, (FieldValueMetaData)new StructMetaData(12, GetPartitionsFilterSpec.class)));
        tmpMap.put(_Fields.PROCESSOR_CAPABILITIES, new FieldMetaData("processorCapabilities", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PROCESSOR_IDENTIFIER, new FieldMetaData("processorIdentifier", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VALID_WRITE_ID_LIST, new FieldMetaData("validWriteIdList", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(GetPartitionsRequest.class, metaDataMap);
    }

    private static class GetPartitionsRequestTupleScheme
    extends TupleScheme<GetPartitionsRequest> {
        private GetPartitionsRequestTupleScheme() {
        }

        public void write(TProtocol prot, GetPartitionsRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetCatName()) {
                optionals.set(0);
            }
            if (struct.isSetDbName()) {
                optionals.set(1);
            }
            if (struct.isSetTblName()) {
                optionals.set(2);
            }
            if (struct.isSetWithAuth()) {
                optionals.set(3);
            }
            if (struct.isSetUser()) {
                optionals.set(4);
            }
            if (struct.isSetGroupNames()) {
                optionals.set(5);
            }
            if (struct.isSetProjectionSpec()) {
                optionals.set(6);
            }
            if (struct.isSetFilterSpec()) {
                optionals.set(7);
            }
            if (struct.isSetProcessorCapabilities()) {
                optionals.set(8);
            }
            if (struct.isSetProcessorIdentifier()) {
                optionals.set(9);
            }
            if (struct.isSetValidWriteIdList()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetDbName()) {
                oprot.writeString(struct.dbName);
            }
            if (struct.isSetTblName()) {
                oprot.writeString(struct.tblName);
            }
            if (struct.isSetWithAuth()) {
                oprot.writeBool(struct.withAuth);
            }
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetGroupNames()) {
                oprot.writeI32(struct.groupNames.size());
                for (String _iter1232 : struct.groupNames) {
                    oprot.writeString(_iter1232);
                }
            }
            if (struct.isSetProjectionSpec()) {
                struct.projectionSpec.write((TProtocol)oprot);
            }
            if (struct.isSetFilterSpec()) {
                struct.filterSpec.write((TProtocol)oprot);
            }
            if (struct.isSetProcessorCapabilities()) {
                oprot.writeI32(struct.processorCapabilities.size());
                for (String _iter1233 : struct.processorCapabilities) {
                    oprot.writeString(_iter1233);
                }
            }
            if (struct.isSetProcessorIdentifier()) {
                oprot.writeString(struct.processorIdentifier);
            }
            if (struct.isSetValidWriteIdList()) {
                oprot.writeString(struct.validWriteIdList);
            }
        }

        public void read(TProtocol prot, GetPartitionsRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.dbName = iprot.readString();
                struct.setDbNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.tblName = iprot.readString();
                struct.setTblNameIsSet(true);
            }
            if (incoming.get(3)) {
                struct.withAuth = iprot.readBool();
                struct.setWithAuthIsSet(true);
            }
            if (incoming.get(4)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list1234 = iprot.readListBegin((byte)11);
                struct.groupNames = new ArrayList(_list1234.size);
                for (int _i1236 = 0; _i1236 < _list1234.size; ++_i1236) {
                    String _elem1235 = iprot.readString();
                    struct.groupNames.add(_elem1235);
                }
                struct.setGroupNamesIsSet(true);
            }
            if (incoming.get(6)) {
                struct.projectionSpec = new GetProjectionsSpec();
                struct.projectionSpec.read((TProtocol)iprot);
                struct.setProjectionSpecIsSet(true);
            }
            if (incoming.get(7)) {
                struct.filterSpec = new GetPartitionsFilterSpec();
                struct.filterSpec.read((TProtocol)iprot);
                struct.setFilterSpecIsSet(true);
            }
            if (incoming.get(8)) {
                TList _list1237 = iprot.readListBegin((byte)11);
                struct.processorCapabilities = new ArrayList(_list1237.size);
                for (int _i1239 = 0; _i1239 < _list1237.size; ++_i1239) {
                    String _elem1238 = iprot.readString();
                    struct.processorCapabilities.add(_elem1238);
                }
                struct.setProcessorCapabilitiesIsSet(true);
            }
            if (incoming.get(9)) {
                struct.processorIdentifier = iprot.readString();
                struct.setProcessorIdentifierIsSet(true);
            }
            if (incoming.get(10)) {
                struct.validWriteIdList = iprot.readString();
                struct.setValidWriteIdListIsSet(true);
            }
        }
    }

    private static class GetPartitionsRequestTupleSchemeFactory
    implements SchemeFactory {
        private GetPartitionsRequestTupleSchemeFactory() {
        }

        public GetPartitionsRequestTupleScheme getScheme() {
            return new GetPartitionsRequestTupleScheme();
        }
    }

    private static class GetPartitionsRequestStandardScheme
    extends StandardScheme<GetPartitionsRequest> {
        private GetPartitionsRequestStandardScheme() {
        }

        public void read(TProtocol iprot, GetPartitionsRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.tblName = iprot.readString();
                            struct.setTblNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 2) {
                            struct.withAuth = iprot.readBool();
                            struct.setWithAuthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list1224 = iprot.readListBegin();
                            struct.groupNames = new ArrayList(_list1224.size);
                            for (int _i1226 = 0; _i1226 < _list1224.size; ++_i1226) {
                                String _elem1225 = iprot.readString();
                                struct.groupNames.add(_elem1225);
                            }
                            iprot.readListEnd();
                            struct.setGroupNamesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.projectionSpec = new GetProjectionsSpec();
                            struct.projectionSpec.read(iprot);
                            struct.setProjectionSpecIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.filterSpec = new GetPartitionsFilterSpec();
                            struct.filterSpec.read(iprot);
                            struct.setFilterSpecIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list1227 = iprot.readListBegin();
                            struct.processorCapabilities = new ArrayList(_list1227.size);
                            for (int _i1229 = 0; _i1229 < _list1227.size; ++_i1229) {
                                String _elem1228 = iprot.readString();
                                struct.processorCapabilities.add(_elem1228);
                            }
                            iprot.readListEnd();
                            struct.setProcessorCapabilitiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.processorIdentifier = iprot.readString();
                            struct.setProcessorIdentifierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.validWriteIdList = iprot.readString();
                            struct.setValidWriteIdListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, GetPartitionsRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tblName != null) {
                oprot.writeFieldBegin(TBL_NAME_FIELD_DESC);
                oprot.writeString(struct.tblName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetWithAuth()) {
                oprot.writeFieldBegin(WITH_AUTH_FIELD_DESC);
                oprot.writeBool(struct.withAuth);
                oprot.writeFieldEnd();
            }
            if (struct.user != null && struct.isSetUser()) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.groupNames != null && struct.isSetGroupNames()) {
                oprot.writeFieldBegin(GROUP_NAMES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.groupNames.size()));
                for (String _iter1230 : struct.groupNames) {
                    oprot.writeString(_iter1230);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.projectionSpec != null) {
                oprot.writeFieldBegin(PROJECTION_SPEC_FIELD_DESC);
                struct.projectionSpec.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.filterSpec != null) {
                oprot.writeFieldBegin(FILTER_SPEC_FIELD_DESC);
                struct.filterSpec.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.processorCapabilities != null && struct.isSetProcessorCapabilities()) {
                oprot.writeFieldBegin(PROCESSOR_CAPABILITIES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.processorCapabilities.size()));
                for (String _iter1231 : struct.processorCapabilities) {
                    oprot.writeString(_iter1231);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.processorIdentifier != null && struct.isSetProcessorIdentifier()) {
                oprot.writeFieldBegin(PROCESSOR_IDENTIFIER_FIELD_DESC);
                oprot.writeString(struct.processorIdentifier);
                oprot.writeFieldEnd();
            }
            if (struct.validWriteIdList != null && struct.isSetValidWriteIdList()) {
                oprot.writeFieldBegin(VALID_WRITE_ID_LIST_FIELD_DESC);
                oprot.writeString(struct.validWriteIdList);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class GetPartitionsRequestStandardSchemeFactory
    implements SchemeFactory {
        private GetPartitionsRequestStandardSchemeFactory() {
        }

        public GetPartitionsRequestStandardScheme getScheme() {
            return new GetPartitionsRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CAT_NAME(1, "catName"),
        DB_NAME(2, "dbName"),
        TBL_NAME(3, "tblName"),
        WITH_AUTH(4, "withAuth"),
        USER(5, "user"),
        GROUP_NAMES(6, "groupNames"),
        PROJECTION_SPEC(7, "projectionSpec"),
        FILTER_SPEC(8, "filterSpec"),
        PROCESSOR_CAPABILITIES(9, "processorCapabilities"),
        PROCESSOR_IDENTIFIER(10, "processorIdentifier"),
        VALID_WRITE_ID_LIST(11, "validWriteIdList");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CAT_NAME;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return TBL_NAME;
                }
                case 4: {
                    return WITH_AUTH;
                }
                case 5: {
                    return USER;
                }
                case 6: {
                    return GROUP_NAMES;
                }
                case 7: {
                    return PROJECTION_SPEC;
                }
                case 8: {
                    return FILTER_SPEC;
                }
                case 9: {
                    return PROCESSOR_CAPABILITIES;
                }
                case 10: {
                    return PROCESSOR_IDENTIFIER;
                }
                case 11: {
                    return VALID_WRITE_ID_LIST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

