/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;

public class AuditLeaderListener
implements LeaderElection.LeadershipStateListener {
    private final Configuration configuration;
    private final Path tableLocation;
    private static final String SERDE = "org.apache.hadoop.hive.serde2.JsonSerDe";
    private static final String INPUTFORMAT = "org.apache.hadoop.mapred.TextInputFormat";
    private static final String OUTPUTFORMAT = "org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat";

    public AuditLeaderListener(TableName tableName, IHMSHandler handler) throws Exception {
        Table table;
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(handler, "handler is null");
        this.configuration = handler.getConf();
        try {
            table = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setCatName(tableName.getCat()).setDbName(tableName.getDb()).setTableName(tableName.getTable()).addCol("leader_host", "string")).addCol("leader_type", "string")).addCol("elected_time", "string")).setOwner(SecurityUtils.getUser()).setSerdeLib(SERDE)).setInputFormat(INPUTFORMAT)).setOutputFormat(OUTPUTFORMAT)).addTableParam("EXTERNAL", "TRUE").addTableParam("external.table.purge", "TRUE").build(handler.getConf());
            table.setOwnerType(PrincipalType.USER);
            table.setTableType(TableType.EXTERNAL_TABLE.toString());
            handler.create_table(table);
        }
        catch (AlreadyExistsException table2) {
            // empty catch block
        }
        table = handler.getMS().getTable(tableName.getCat(), tableName.getDb(), tableName.getTable());
        this.tableLocation = new Path(table.getSd().getLocation());
        String serde = table.getSd().getSerdeInfo().getSerializationLib();
        String input = table.getSd().getInputFormat();
        String output = table.getSd().getOutputFormat();
        if (!(SERDE.equals(serde) && INPUTFORMAT.equals(input) && OUTPUTFORMAT.equals(output))) {
            throw new RuntimeException(tableName + " should be a plain json table");
        }
    }

    @VisibleForTesting
    public AuditLeaderListener(Path tableLocation, Configuration configuration) {
        this.tableLocation = tableLocation;
        this.configuration = configuration;
    }

    @Override
    public void takeLeadership(LeaderElection election) throws Exception {
        HiveMetaStore.LOG.info("Became the LEADER for {}", (Object)election.getName());
        String hostName = AuditLeaderListener.getHostname();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String message = "{\"leader_host\": \"" + hostName + "\", \"leader_type\": \"" + election.getName() + "\", \"elected_time\": \"" + LocalDateTime.now().format(formatter) + "\"} \n";
        Path path = null;
        try {
            FileSystem fs = Warehouse.getFs(this.tableLocation, this.configuration);
            boolean createNewFile = FileUtils.isS3a(fs) || MetastoreConf.getBoolVar(this.configuration, MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_NEW_AUDIT_FILE);
            String prefix = "leader_" + election.getName();
            String fileName = createNewFile ? prefix + "_" + System.currentTimeMillis() + ".json" : prefix + ".json";
            path = new Path(this.tableLocation, fileName);
            try (FSDataOutputStream outputStream = createNewFile ? fs.create(path, false) : (fs.exists(path) ? fs.append(path) : fs.create(path, false));){
                outputStream.write(message.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            int limit = MetastoreConf.getIntVar(this.configuration, MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_AUDIT_FILE_LIMIT);
            if (createNewFile && limit > 0) {
                List<FileStatus> allFileStatuses = FileUtils.getFileStatusRecurse(this.tableLocation, fs);
                ArrayList<FileStatus> thisLeaderFiles = new ArrayList<FileStatus>();
                allFileStatuses.stream().forEach(f -> {
                    if (f.getPath().getName().startsWith(prefix)) {
                        thisLeaderFiles.add((FileStatus)f);
                    }
                });
                if (thisLeaderFiles.size() > limit) {
                    thisLeaderFiles.sort(Comparator.comparing(o -> o.getPath().getName()));
                    for (int i = 0; i < thisLeaderFiles.size() - limit; ++i) {
                        FileUtils.moveToTrash(fs, ((FileStatus)thisLeaderFiles.get(i)).getPath(), this.configuration, true);
                    }
                }
            }
        }
        catch (Exception e) {
            HiveMetaStore.LOG.error("Error while writing the leader info into file: " + path, (Throwable)e);
        }
    }

    private static String getHostname() {
        try {
            return "" + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    @Override
    public void lossLeadership(LeaderElection election) throws Exception {
        HiveMetaStore.LOG.info("Lost leadership for {}", (Object)election.getName());
    }
}

