/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.AcidWriteMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAcidWriteMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDeletePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDeleteTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONInsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONOpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONUpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONUpdateTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBuilder.class);
    public static final String ADD_PARTITION_EVENT = "ADD_PARTITION";
    public static final String ALTER_PARTITION_EVENT = "ALTER_PARTITION";
    public static final String DROP_PARTITION_EVENT = "DROP_PARTITION";
    public static final String CREATE_TABLE_EVENT = "CREATE_TABLE";
    public static final String ALTER_TABLE_EVENT = "ALTER_TABLE";
    public static final String DROP_TABLE_EVENT = "DROP_TABLE";
    public static final String CREATE_DATABASE_EVENT = "CREATE_DATABASE";
    public static final String ALTER_DATABASE_EVENT = "ALTER_DATABASE";
    public static final String DROP_DATABASE_EVENT = "DROP_DATABASE";
    public static final String INSERT_EVENT = "INSERT";
    public static final String CREATE_FUNCTION_EVENT = "CREATE_FUNCTION";
    public static final String DROP_FUNCTION_EVENT = "DROP_FUNCTION";
    public static final String ADD_PRIMARYKEY_EVENT = "ADD_PRIMARYKEY";
    public static final String ADD_FOREIGNKEY_EVENT = "ADD_FOREIGNKEY";
    public static final String ADD_UNIQUECONSTRAINT_EVENT = "ADD_UNIQUECONSTRAINT";
    public static final String ADD_NOTNULLCONSTRAINT_EVENT = "ADD_NOTNULLCONSTRAINT";
    public static final String DROP_CONSTRAINT_EVENT = "DROP_CONSTRAINT";
    public static final String CREATE_ISCHEMA_EVENT = "CREATE_ISCHEMA";
    public static final String ALTER_ISCHEMA_EVENT = "ALTER_ISCHEMA";
    public static final String DROP_ISCHEMA_EVENT = "DROP_ISCHEMA";
    public static final String ADD_SCHEMA_VERSION_EVENT = "ADD_SCHEMA_VERSION";
    public static final String ALTER_SCHEMA_VERSION_EVENT = "ALTER_SCHEMA_VERSION";
    public static final String DROP_SCHEMA_VERSION_EVENT = "DROP_SCHEMA_VERSION";
    public static final String CREATE_CATALOG_EVENT = "CREATE_CATALOG";
    public static final String DROP_CATALOG_EVENT = "DROP_CATALOG";
    public static final String OPEN_TXN_EVENT = "OPEN_TXN";
    public static final String COMMIT_TXN_EVENT = "COMMIT_TXN";
    public static final String ABORT_TXN_EVENT = "ABORT_TXN";
    public static final String ALLOC_WRITE_ID_EVENT = "ALLOC_WRITE_ID_EVENT";
    public static final String ALTER_CATALOG_EVENT = "ALTER_CATALOG";
    public static final String ACID_WRITE_EVENT = "ACID_WRITE_EVENT";
    public static final String UPDATE_TBL_COL_STAT_EVENT = "UPDATE_TBL_COL_STAT_EVENT";
    public static final String DELETE_TBL_COL_STAT_EVENT = "DELETE_TBL_COL_STAT_EVENT";
    public static final String UPDATE_PART_COL_STAT_EVENT = "UPDATE_PART_COL_STAT_EVENT";
    public static final String DELETE_PART_COL_STAT_EVENT = "DELETE_PART_COL_STAT_EVENT";
    protected static final Configuration conf = MetastoreConf.newMetastoreConf();
    private static final String MS_SERVER_URL = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_URIS, "");
    private static final String MS_SERVICE_PRINCIPAL = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL, "");
    private static volatile MessageBuilder instance;
    private static final Object lock;
    private static List<Predicate<String>> paramsFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageBuilder getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    MessageBuilder newInstance = new MessageBuilder();
                    newInstance.init();
                    instance = newInstance;
                }
            }
        }
        return instance;
    }

    public void init() {
        List<String> excludePatterns = Arrays.asList(MetastoreConf.getTrimmedStringsVar(conf, MetastoreConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS));
        try {
            paramsFilter = MetaStoreUtils.compilePatternsToPredicates(excludePatterns);
        }
        catch (PatternSyntaxException e) {
            LOG.error("Regex pattern compilation failed. Verify that metastore.notification.parameters.exclude.patterns has valid patterns.");
            throw new IllegalStateException("Regex pattern compilation failed. " + e.getMessage());
        }
    }

    public CreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new JSONCreateDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, this.now());
    }

    public AlterDatabaseMessage buildAlterDatabaseMessage(Database beforeDb, Database afterDb) {
        return new JSONAlterDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, beforeDb, afterDb, this.now());
    }

    public DropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new JSONDropDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, this.now());
    }

    public CreateTableMessage buildCreateTableMessage(Table table, Iterator<String> fileIter) {
        return new JSONCreateTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, fileIter, (Long)this.now());
    }

    public AlterTableMessage buildAlterTableMessage(Table before, Table after, boolean isTruncateOp, Long writeId) {
        return new JSONAlterTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, isTruncateOp, writeId, this.now());
    }

    public DropTableMessage buildDropTableMessage(Table table) {
        return new JSONDropTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, this.now());
    }

    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator, Iterator<PartitionFiles> partitionFileIter) {
        return new JSONAddPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, partitionsIterator, partitionFileIter, this.now());
    }

    public AlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after, boolean isTruncateOp, Long writeId) {
        return new JSONAlterPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, before, after, isTruncateOp, writeId, this.now());
    }

    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        return new JSONDropPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, MessageBuilder.getPartitionKeyValues(table, partitionsIterator), this.now());
    }

    public CreateFunctionMessage buildCreateFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONCreateFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    public DropFunctionMessage buildDropFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONDropFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    public InsertMessage buildInsertMessage(Table tableObj, Partition partObj, boolean replace, Iterator<String> fileIter) {
        return new JSONInsertMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, tableObj, partObj, replace, fileIter, this.now());
    }

    public AddPrimaryKeyMessage buildAddPrimaryKeyMessage(List<SQLPrimaryKey> pks) {
        return new JSONAddPrimaryKeyMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, pks, this.now());
    }

    public AddForeignKeyMessage buildAddForeignKeyMessage(List<SQLForeignKey> fks) {
        return new JSONAddForeignKeyMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fks, this.now());
    }

    public AddUniqueConstraintMessage buildAddUniqueConstraintMessage(List<SQLUniqueConstraint> uks) {
        return new JSONAddUniqueConstraintMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, uks, this.now());
    }

    public AddNotNullConstraintMessage buildAddNotNullConstraintMessage(List<SQLNotNullConstraint> nns) {
        return new JSONAddNotNullConstraintMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, nns, this.now());
    }

    public DropConstraintMessage buildDropConstraintMessage(String dbName, String tableName, String constraintName) {
        return new JSONDropConstraintMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, dbName, tableName, constraintName, this.now());
    }

    public CreateCatalogMessage buildCreateCatalogMessage(Catalog catalog) {
        return new JSONCreateCatalogMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, catalog.getName(), this.now());
    }

    public AlterCatalogMessage buildAlterCatalogMessage(Catalog beforeCat, Catalog afterCat) {
        return new JSONAlterCatalogMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, beforeCat, afterCat, this.now());
    }

    public DropCatalogMessage buildDropCatalogMessage(Catalog catalog) {
        return new JSONDropCatalogMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, catalog.getName(), this.now());
    }

    public OpenTxnMessage buildOpenTxnMessage(Long fromTxnId, Long toTxnId) {
        return new JSONOpenTxnMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fromTxnId, toTxnId, this.now());
    }

    public CommitTxnMessage buildCommitTxnMessage(Long txnId) {
        return new JSONCommitTxnMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, txnId, this.now());
    }

    public AbortTxnMessage buildAbortTxnMessage(Long txnId, List<String> dbsUpdated) {
        return new JSONAbortTxnMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, txnId, this.now(), dbsUpdated);
    }

    public AllocWriteIdMessage buildAllocWriteIdMessage(List<TxnToWriteId> txnToWriteIdList, String dbName, String tableName) {
        return new JSONAllocWriteIdMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, txnToWriteIdList, dbName, tableName, this.now());
    }

    public AcidWriteMessage buildAcidWriteMessage(AcidWriteEvent acidWriteEvent, Iterator<String> files) {
        return new JSONAcidWriteMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), acidWriteEvent, files);
    }

    public JSONUpdateTableColumnStatMessage buildUpdateTableColumnStatMessage(ColumnStatistics colStats, Table tableObj, Map<String, String> parameters, long writeId) {
        return new JSONUpdateTableColumnStatMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), colStats, tableObj, parameters, writeId);
    }

    public JSONDeleteTableColumnStatMessage buildDeleteTableColumnStatMessage(String dbName, String colName) {
        return new JSONDeleteTableColumnStatMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), dbName, colName);
    }

    public JSONUpdatePartitionColumnStatMessage buildUpdatePartitionColumnStatMessage(ColumnStatistics colStats, List<String> partVals, Map<String, String> parameters, Table tableObj, long writeId) {
        return new JSONUpdatePartitionColumnStatMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), colStats, partVals, parameters, tableObj, writeId);
    }

    public JSONDeletePartitionColumnStatMessage buildDeletePartitionColumnStatMessage(String dbName, String colName, String partName, List<String> partValues) {
        return new JSONDeletePartitionColumnStatMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), dbName, colName, partName, partValues);
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String createPrimaryKeyObjJson(SQLPrimaryKey primaryKeyObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)primaryKeyObj);
    }

    public static String createForeignKeyObjJson(SQLForeignKey foreignKeyObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)foreignKeyObj);
    }

    public static String createUniqueConstraintObjJson(SQLUniqueConstraint uniqueConstraintObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)uniqueConstraintObj);
    }

    public static String createNotNullConstraintObjJson(SQLNotNullConstraint notNullConstaintObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)notNullConstaintObj);
    }

    public static String createDatabaseObjJson(Database dbObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)dbObj);
    }

    public static String createCatalogObjJson(Catalog catObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)catObj);
    }

    public static String createTableObjJson(Table tableObj) throws TException {
        MetaStoreUtils.filterMapkeys(tableObj.getParameters(), paramsFilter);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)tableObj);
    }

    public static String createPartitionObjJson(Partition partitionObj) throws TException {
        MetaStoreUtils.filterMapkeys(partitionObj.getParameters(), paramsFilter);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)partitionObj);
    }

    public static String createFunctionObjJson(org.apache.hadoop.hive.metastore.api.Function functionObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)functionObj);
    }

    public static Table getTableObj(ObjectNode jsonTree) throws Exception {
        TDeserializer deSerializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
        Table tableObj = new Table();
        String tableJson = jsonTree.get("tableObjJson").asText();
        deSerializer.deserialize((TBase)tableObj, tableJson, "UTF-8");
        return tableObj;
    }

    public static String createTableColumnStatJson(ColumnStatistics tableColumnStat) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)tableColumnStat);
    }

    public static TBase getTObj(String tSerialized, Class<? extends TBase> objClass) throws Exception {
        TDeserializer thriftDeSerializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
        TBase obj = objClass.newInstance();
        thriftDeSerializer.deserialize(obj, tSerialized, "UTF-8");
        return obj;
    }

    public static Iterable<? extends TBase> getTObjs(Iterable<String> objRefStrs, final Class<? extends TBase> objClass) throws Exception {
        try {
            return Iterables.transform(objRefStrs, (Function)new Function<String, TBase>(){

                public TBase apply(@Nullable String objStr) {
                    try {
                        return MessageBuilder.getTObj(objStr, objClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable t = re.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw re;
        }
    }

    public static Iterable<? extends TBase> getTObjs(ObjectNode jsonTree, String objRefListName, Class<? extends TBase> objClass) throws Exception {
        JsonNode jsonArrayIterator = jsonTree.get(objRefListName);
        return MessageBuilder.getTObjs(Iterables.transform((Iterable)jsonArrayIterator, JsonNode::asText), objClass);
    }

    public static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(table.getPartitionKeys().get(i).getName(), partition.getValues().get(i));
        }
        return partitionKeys;
    }

    public static List<Map<String, String>> getPartitionKeyValues(Table table, Iterator<Partition> iterator) {
        return Lists.newArrayList((Iterator)Iterators.transform(iterator, partition -> MessageBuilder.getPartitionKeyValues(table, partition)));
    }

    static {
        lock = new Object();
    }
}

