/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public final class SQLGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)SQLGenerator.class.getName());
    private final DatabaseProduct dbProduct;
    private final Configuration conf;
    private static final String CREATE_METADATASUMMARY_ORACLE = "CREATE OR REPLACE VIEW METADATASUMMARYALL AS SELECT a.TBL_ID, a.TBL_NAME, a.OWNER as \"CTLG\", a.TBL_TYPE, a.CREATE_TIME, a.DB_ID, a.SD_ID, b.NAME, c.INPUT_FORMAT, c.IS_COMPRESSED, c.LOCATION, c.OUTPUT_FORMAT,c.SERDE_ID, d.SLIB, TO_CHAR(e.PARAM_VALUE) as \"PARAM_VAL\", count(j.COLUMN_NAME) as \"TOTAL_COLUMN_COUNT\", jj.ARRAY_COLUMN_COUNT, jj.STRUCT_COLUMN_COUNT, jj.MAP_COLUMN_COUNT, k.PARTITION_KEY_NAME as \"PARTITION_COLUMN\", m.PARTITION_CNT, CAST(CAST(q.NUM_FILES AS VARCHAR2(200)) AS NUMBER) as \"num_files\", CAST(q.TOTAL_SIZE AS NUMBER) as \"total_size\", CAST(q.NUM_ROWS AS NUMBER) as \"num_rows\" FROM TBLS a left JOIN DBS b on a.DB_ID = b.DB_ID left JOIN SDS c on a.SD_ID = c.SD_ID LEFT JOIN SERDES d on c.SERDE_ID = d.SERDE_ID left JOIN (select SERDE_ID,PARAM_KEY,PARAM_VALUE from SERDE_PARAMS where PARAM_KEY = 'field.delim') e on c.SERDE_ID = e.SERDE_ID left join COLUMNS_V2 j on c.CD_ID = j.CD_ID LEFT JOIN (SELECT CD_ID, sum(CASE WHEN TYPE_NAME like 'array%' THEN 1 ELSE 0 END) AS \"ARRAY_COLUMN_COUNT\", sum(CASE WHEN TYPE_NAME like 'struct%' THEN 1 ELSE 0 END) AS \"STRUCT_COLUMN_COUNT\", sum(CASE WHEN TYPE_NAME like 'map%' THEN 1 ELSE 0 END) AS \"MAP_COLUMN_COUNT\" from COLUMNS_V2 group by CD_ID) jj on jj.CD_ID=c.CD_ID left JOIN(select TBL_ID, LISTAGG(PKEY_NAME, ',') as PARTITION_KEY_NAME from PARTITION_KEYS group by TBL_ID) k on a.TBL_ID = k.TBL_ID left JOIN (select SERDE_ID,PARAM_KEY,PARAM_VALUE from SERDE_PARAMS where PARAM_KEY = 'serialization.format') f on c.SERDE_ID = f.SERDE_ID left join (select TBL_ID,PARAM_KEY,PARAM_VALUE from TABLE_PARAMS where PARAM_KEY = 'comment') g on a.TBL_ID = g.TBL_ID left JOIN (select TBL_ID, PARAM_KEY,PARAM_VALUE from TABLE_PARAMS where PARAM_KEY = 'transient_lastDdlTime') h on a.TBL_ID = h.TBL_ID left join (select TBL_ID,COUNT(PART_ID) as PARTITION_CNT from PARTITIONS group by TBL_ID) m on a.TBL_ID = m.TBL_ID Left join (SELECT aa.TBL_ID, aa.NUM_FILES + case when bb.NUM_FILES is not null then bb.NUM_FILES else 0 end AS \"NUM_FILES\", aa.NUM_ROWS + case when bb.NUM_ROWS is not null then bb.NUM_ROWS else 0 end AS \"NUM_ROWS\", aa.TOTAL_SIZE + case when bb.TOTAL_SIZE is not null then bb.TOTAL_SIZE else 0 end  AS \"TOTAL_SIZE\" from (select TBL_ID, max(CASE PARAM_KEY WHEN 'numFiles' THEN CAST(CAST(PARAM_VALUE AS VARCHAR2(200)) AS NUMBER) ELSE 0 END) AS \"NUM_FILES\", max(CASE PARAM_KEY WHEN 'numRows' THEN CAST(CAST(PARAM_VALUE AS VARCHAR2(200)) AS NUMBER) ELSE 0 END) AS \"NUM_ROWS\", max(CASE PARAM_KEY WHEN 'totalSize' THEN CAST(CAST(PARAM_VALUE AS VARCHAR2(200)) AS NUMBER) ELSE 0 END) AS \"TOTAL_SIZE\" from TABLE_PARAMS group by TBL_ID) aa left join (SELECT y.TBL_ID, SUM(x.NUM_FILES) AS \"NUM_FILES\", SUM(x.NUM_ROWS) AS \"NUM_ROWS\", SUM(x.TOTAL_SIZE) AS \"TOTAL_SIZE\" FROM PARTITIONS y left JOIN (SELECT PART_ID, max(CASE PARAM_KEY WHEN 'numFiles' THEN CAST(CAST(PARAM_VALUE AS VARCHAR2(200)) AS NUMBER) ELSE 0 END) AS \"NUM_FILES\", max(CASE PARAM_KEY WHEN 'numRows' THEN CAST(CAST(PARAM_VALUE AS VARCHAR2(200)) AS NUMBER) ELSE 0 END) AS \"NUM_ROWS\", max(CASE PARAM_KEY WHEN 'totalSize' THEN CAST(CAST(PARAM_VALUE AS VARCHAR2(200)) AS NUMBER) ELSE 0 END) AS \"TOTAL_SIZE\" FROM PARTITION_PARAMS group by PART_ID)x ON y.PART_ID=x.PART_ID group by y.TBL_ID) bb on aa.TBL_ID = bb.TBL_ID) q on a.TBL_ID = q.TBL_ID group by a.TBL_ID, a.TBL_NAME, a.OWNER, a.TBL_TYPE, a.CREATE_TIME, a.DB_ID, a.SD_ID, b.NAME, c.INPUT_FORMAT, c.IS_COMPRESSED, c.LOCATION, c.OUTPUT_FORMAT,c.SERDE_ID, d.SLIB, TO_CHAR(e.PARAM_VALUE), jj.ARRAY_COLUMN_COUNT, jj.STRUCT_COLUMN_COUNT,jj.MAP_COLUMN_COUNT, k.PARTITION_KEY_NAME, m.PARTITION_CNT,q.NUM_FILES, q.TOTAL_SIZE, q.NUM_ROWS";
    private static final String CREATE_METADATASUMMARY_MYSQL = "CREATE OR REPLACE VIEW METADATASUMMARYALL AS SELECT a.TBL_ID, a.TBL_NAME, a.OWNER as \"CTLG\", a.TBL_TYPE, a.CREATE_TIME, a.DB_ID, a.SD_ID, b.NAME, c.INPUT_FORMAT, c.IS_COMPRESSED, c.LOCATION, c.OUTPUT_FORMAT,c.SERDE_ID, d.SLIB, e.PARAM_VALUE, count(j.COLUMN_NAME) as \"TOTAL_COLUMN_COUNT\", jj.ARRAY_COLUMN_COUNT as \"ARRAY_COLUMN_COUNT\", jj.STRUCT_COLUMN_COUNT as \"STRUCT_COLUMN_COUNT\", jj.MAP_COLUMN_COUNT as \"MAP_COLUMN_COUNT\", k.PARTITION_KEY_NAME as \"PARTITION_COLUMN\", m.PARTITION_CNT, CAST(CAST(q.NUM_FILES AS CHAR(200)) AS SIGNED) as NUM_FILES, CAST(q.TOTAL_SIZE AS SIGNED) as TOTAL_SIZE, CAST(q.NUM_ROWS AS SIGNED) as NUM_ROWS FROM TBLS a left JOIN DBS b on a.DB_ID = b.DB_ID left JOIN SDS c on a.SD_ID = c.SD_ID LEFT JOIN SERDES d on c.SERDE_ID = d.SERDE_ID left JOIN (select SERDE_ID,PARAM_KEY,PARAM_VALUE from SERDE_PARAMS where PARAM_KEY = 'field.delim') e on c.SERDE_ID = e.SERDE_ID left join COLUMNS_V2 j on c.CD_ID = j.CD_ID LEFT JOIN (SELECT CD_ID, sum(CASE WHEN TYPE_NAME like 'array%' THEN 1 ELSE 0 END) AS \"ARRAY_COLUMN_COUNT\", sum(CASE WHEN TYPE_NAME like 'struct%' THEN 1 ELSE 0 END) AS \"STRUCT_COLUMN_COUNT\", sum(CASE WHEN TYPE_NAME like 'map%' THEN 1 ELSE 0 END) AS \"MAP_COLUMN_COUNT\" from COLUMNS_V2 group by CD_ID) jj on jj.CD_ID=c.CD_ID left JOIN(select TBL_ID, GROUP_CONCAT(PKEY_NAME, ',') as PARTITION_KEY_NAME from PARTITION_KEYS group by TBL_ID) k on a.TBL_ID = k.TBL_ID left JOIN (select SERDE_ID,PARAM_KEY,PARAM_VALUE from SERDE_PARAMS where PARAM_KEY = 'serialization.format') f on c.SERDE_ID = f.SERDE_ID left join (select TBL_ID,PARAM_KEY,PARAM_VALUE from TABLE_PARAMS where PARAM_KEY = 'comment') g on a.TBL_ID = g.TBL_ID left JOIN (select TBL_ID, PARAM_KEY,PARAM_VALUE from TABLE_PARAMS where PARAM_KEY = 'transient_lastDdlTime') h on a.TBL_ID = h.TBL_ID left join (select TBL_ID,COUNT(PART_ID) as PARTITION_CNT from PARTITIONS group by TBL_ID) m on a.TBL_ID = m.TBL_ID Left join (SELECT aa.TBL_ID, aa.NUM_FILES + case when bb.NUM_FILES is not null then bb.NUM_FILES else 0 end AS \"NUM_FILES\", aa.NUM_ROWS + case when bb.NUM_ROWS is not null then bb.NUM_ROWS else 0 end AS \"NUM_ROWS\", aa.TOTAL_SIZE + case when bb.TOTAL_SIZE is not null then bb.TOTAL_SIZE else 0 end  AS \"TOTAL_SIZE\" from (select TBL_ID, max(CASE PARAM_KEY WHEN 'numFiles' THEN CAST(CAST(PARAM_VALUE AS CHAR(200)) AS SIGNED) ELSE 0 END) AS \"NUM_FILES\", max(CASE PARAM_KEY WHEN 'numRows' THEN CAST(CAST(PARAM_VALUE AS CHAR(200)) AS SIGNED) ELSE 0 END) AS \"NUM_ROWS\", max(CASE PARAM_KEY WHEN 'totalSize' THEN CAST(CAST(PARAM_VALUE AS CHAR(200)) AS SIGNED) ELSE 0 END) AS \"TOTAL_SIZE\" from TABLE_PARAMS group by TBL_ID) aa left join (SELECT y.TBL_ID, SUM(x.NUM_FILES) AS \"NUM_FILES\", SUM(x.NUM_ROWS) AS \"NUM_ROWS\", SUM(x.TOTAL_SIZE) AS \"TOTAL_SIZE\" FROM PARTITIONS y left JOIN (SELECT PART_ID, max(CASE PARAM_KEY WHEN 'numFiles' THEN CAST(CAST(PARAM_VALUE AS CHAR(200)) AS SIGNED) ELSE 0 END) AS \"NUM_FILES\", max(CASE PARAM_KEY WHEN 'numRows' THEN CAST(CAST(PARAM_VALUE AS CHAR(200)) AS SIGNED) ELSE 0 END) AS \"NUM_ROWS\", max(CASE PARAM_KEY WHEN 'totalSize' THEN CAST(CAST(PARAM_VALUE AS CHAR(200)) AS SIGNED) ELSE 0 END) AS \"TOTAL_SIZE\" FROM PARTITION_PARAMS group by PART_ID)x ON y.PART_ID=x.PART_ID group by y.TBL_ID) bb on aa.TBL_ID = bb.TBL_ID) q on a.TBL_ID = q.TBL_ID group by a.TBL_ID, a.TBL_NAME, a.OWNER, a.TBL_TYPE, a.CREATE_TIME, a.DB_ID, a.SD_ID, b.NAME, c.INPUT_FORMAT, c.IS_COMPRESSED, c.LOCATION, c.OUTPUT_FORMAT,c.SERDE_ID, d.SLIB, e.PARAM_VALUE, jj.ARRAY_COLUMN_COUNT, jj.STRUCT_COLUMN_COUNT,jj.MAP_COLUMN_COUNT, k.PARTITION_KEY_NAME, m.PARTITION_CNT,q.NUM_FILES, q.TOTAL_SIZE, q.NUM_ROWS;";
    private static final String CREATE_METADATASUMMARY_POSTGRES = "CREATE OR REPLACE VIEW \"METADATASUMMARYALL\" AS \nSELECT a.\"TBL_ID\", a.\"TBL_NAME\", a.\"OWNER\" as \"CTLG\", a.\"TBL_TYPE\", a.\"CREATE_TIME\", a.\"DB_ID\", a.\"SD_ID\", \nb.\"NAME\", c.\"INPUT_FORMAT\", c.\"IS_COMPRESSED\", c.\"LOCATION\", c.\"OUTPUT_FORMAT\",c.\"SERDE_ID\", d.\"SLIB\", e.\"PARAM_VALUE\", \ncount(j.\"COLUMN_NAME\") as \"TOTAL_COLUMN_COUNT\", jj.\"ARRAY_COLUMN_COUNT\", jj.\"STRUCT_COLUMN_COUNT\", jj.\"MAP_COLUMN_COUNT\", \nk.\"PARTITION_KEY_NAME\" as \"PARTITION_COLUMN\", m.\"PARTITION_CNT\", CAST(CAST(q.\"NUM_FILES\" AS CHAR(200)) AS BIGINT), CAST(q.\"TOTAL_SIZE\" AS BIGINT), \nCAST(q.\"NUM_ROWS\" AS BIGINT) \nFROM \"TBLS\" a left JOIN \"DBS\" b on a.\"DB_ID\" = b.\"DB_ID\" \nleft JOIN \"SDS\" c on a.\"SD_ID\" = c.\"SD_ID\" \nLEFT JOIN \"SERDES\" d on c.\"SERDE_ID\" = d.\"SERDE_ID\" \nleft JOIN (select \"SERDE_ID\",\"PARAM_KEY\",\"PARAM_VALUE\" from \"SERDE_PARAMS\" where \"PARAM_KEY\" = 'field.delim') e on c.\"SERDE_ID\" = e.\"SERDE_ID\" \nleft join \"COLUMNS_V2\" j on c.\"CD_ID\" = j.\"CD_ID\" \nLEFT JOIN (SELECT \"CD_ID\", sum(CASE WHEN \"TYPE_NAME\" like 'array%' THEN 1 ELSE 0 END) AS \"ARRAY_COLUMN_COUNT\", sum(CASE WHEN \"TYPE_NAME\" like 'struct%' THEN 1 ELSE 0 END) AS \"STRUCT_COLUMN_COUNT\", sum(CASE WHEN \"TYPE_NAME\" like 'map%' THEN 1 ELSE 0 END) AS \"MAP_COLUMN_COUNT\" from \"COLUMNS_V2\" group by \"CD_ID\") jj on jj.\"CD_ID\"=c.\"CD_ID\" \nleft JOIN(select \"TBL_ID\", string_agg(\"PKEY_NAME\", ',') as \"PARTITION_KEY_NAME\" from \"PARTITION_KEYS\" group by \"TBL_ID\") k on a.\"TBL_ID\" = k.\"TBL_ID\" \nleft JOIN (select \"SERDE_ID\",\"PARAM_KEY\",\"PARAM_VALUE\" from \"SERDE_PARAMS\" where \"PARAM_KEY\" = 'serialization.format') f on c.\"SERDE_ID\" = f.\"SERDE_ID\" \nleft join (select \"TBL_ID\",\"PARAM_KEY\",\"PARAM_VALUE\" from \"TABLE_PARAMS\" where \"PARAM_KEY\" = 'comment') g on a.\"TBL_ID\" = g.\"TBL_ID\" \nleft JOIN (select \"TBL_ID\", \"PARAM_KEY\",\"PARAM_VALUE\" from \"TABLE_PARAMS\" where \"PARAM_KEY\" = 'transient_lastDdlTime') h on a.\"TBL_ID\" = h.\"TBL_ID\" \nleft join (select \"TBL_ID\",COUNT(\"PART_ID\") as \"PARTITION_CNT\" from \"PARTITIONS\" group by \"TBL_ID\") m on a.\"TBL_ID\" = m.\"TBL_ID\" \nLeft join (SELECT aa.\"TBL_ID\", aa.\"NUM_FILES\" + case when bb.\"NUM_FILES\" is not null then bb.\"NUM_FILES\" else 0 end AS \"NUM_FILES\", aa.\"NUM_ROWS\" + case when bb.\"NUM_ROWS\" is not null then bb.\"NUM_ROWS\" else 0 end AS \"NUM_ROWS\", aa.\"TOTAL_SIZE\" + case when bb.\"TOTAL_SIZE\" is not null then bb.\"TOTAL_SIZE\" else 0 end  AS \"TOTAL_SIZE\" from (select \"TBL_ID\", max(CASE \"PARAM_KEY\" WHEN 'numFiles' THEN CAST(CAST(\"PARAM_VALUE\" AS CHAR(200)) AS BIGINT) ELSE 0 END) AS \"NUM_FILES\", max(CASE \"PARAM_KEY\" WHEN 'numRows' THEN CAST(CAST(\"PARAM_VALUE\" AS CHAR(200)) AS BIGINT) ELSE 0 END) AS \"NUM_ROWS\", max(CASE \"PARAM_KEY\" WHEN 'totalSize' THEN CAST(CAST(\"PARAM_VALUE\" AS CHAR(200)) AS BIGINT) ELSE 0 END) AS \"TOTAL_SIZE\" from \"TABLE_PARAMS\" group by \"TBL_ID\") aa \nleft join (SELECT y.\"TBL_ID\", SUM(x.\"NUM_FILES\") AS \"NUM_FILES\", SUM(x.\"NUM_ROWS\") AS \"NUM_ROWS\", SUM(x.\"TOTAL_SIZE\") AS \"TOTAL_SIZE\" FROM \"PARTITIONS\" y \nleft JOIN (SELECT \"PART_ID\", max(CASE \"PARAM_KEY\" WHEN 'numFiles' THEN CAST(CAST(\"PARAM_VALUE\" AS CHAR(200)) AS BIGINT) ELSE 0 END) AS \"NUM_FILES\", max(CASE \"PARAM_KEY\" WHEN 'numRows' THEN CAST(CAST(\"PARAM_VALUE\" AS CHAR(200)) AS BIGINT) ELSE 0 END) AS \"NUM_ROWS\", max(CASE \"PARAM_KEY\" WHEN 'totalSize' THEN CAST(CAST(\"PARAM_VALUE\" AS CHAR(200)) AS BIGINT) ELSE 0 END) AS \"TOTAL_SIZE\" FROM \"PARTITION_PARAMS\" group by \"PART_ID\")x ON y.\"PART_ID\"=x.\"PART_ID\" group by y.\"TBL_ID\") bb on aa.\"TBL_ID\" = bb.\"TBL_ID\") q on a.\"TBL_ID\" = q.\"TBL_ID\" group by a.\"TBL_ID\", a.\"TBL_NAME\", a.\"OWNER\", a.\"TBL_TYPE\", a.\"CREATE_TIME\", a.\"DB_ID\", a.\"SD_ID\", b.\"NAME\", c.\"INPUT_FORMAT\", c.\"IS_COMPRESSED\", c.\"LOCATION\", c.\"OUTPUT_FORMAT\",c.\"SERDE_ID\", d.\"SLIB\", e.\"PARAM_VALUE\", jj.\"ARRAY_COLUMN_COUNT\", jj.\"STRUCT_COLUMN_COUNT\",jj.\"MAP_COLUMN_COUNT\", k.\"PARTITION_KEY_NAME\", m.\"PARTITION_CNT\",q.\"NUM_FILES\", q.\"TOTAL_SIZE\", q.\"NUM_ROWS\";";

    public SQLGenerator(DatabaseProduct dbProduct, Configuration conf) {
        this.dbProduct = dbProduct;
        this.conf = conf;
    }

    public List<PreparedStatement> createInsertValuesPreparedStmt(Connection dbConn, String tblColumns, List<String> rows, List<List<String>> paramsList) throws SQLException {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        assert (paramsList == null || rows.size() == paramsList.size());
        ArrayList<Integer> rowsCountInStmts = new ArrayList<Integer>();
        List<String> insertStmts = this.createInsertValuesStmt(tblColumns, rows, rowsCountInStmts);
        assert (insertStmts.size() == rowsCountInStmts.size());
        ArrayList<PreparedStatement> preparedStmts = new ArrayList<PreparedStatement>();
        int paramsListFromIdx = 0;
        try {
            for (int stmtIdx = 0; stmtIdx < insertStmts.size(); ++stmtIdx) {
                String sql = insertStmts.get(stmtIdx);
                PreparedStatement pStmt = this.prepareStmtWithParameters(dbConn, sql, null);
                if (paramsList != null) {
                    int paramIdx = 1;
                    int paramsListToIdx = paramsListFromIdx + (Integer)rowsCountInStmts.get(stmtIdx);
                    for (int paramsListIdx = paramsListFromIdx; paramsListIdx < paramsListToIdx; ++paramsListIdx) {
                        List<String> params = paramsList.get(paramsListIdx);
                        int i = 0;
                        while (i < params.size()) {
                            pStmt.setString(paramIdx, params.get(i));
                            ++i;
                            ++paramIdx;
                        }
                    }
                    paramsListFromIdx = paramsListToIdx;
                }
                preparedStmts.add(pStmt);
            }
        }
        catch (SQLException e) {
            for (PreparedStatement pst : preparedStmts) {
                pst.close();
            }
            throw e;
        }
        return preparedStmts;
    }

    public List<String> createInsertValuesStmt(String tblColumns, List<String> rows) {
        return this.createInsertValuesStmt(tblColumns, rows, null);
    }

    private List<String> createInsertValuesStmt(String tblColumns, List<String> rows, List<Integer> rowsCountInStmts) {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> insertStmts = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int numRowsInCurrentStmt = 0;
        switch (this.dbProduct) {
            case ORACLE: {
                if (rows.size() > 1) {
                    for (int numRows = 0; numRows < rows.size(); ++numRows) {
                        if (numRows % MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                            if (numRows > 0) {
                                sb.append(" select * from dual");
                                insertStmts.add(sb.toString());
                                if (rowsCountInStmts != null) {
                                    rowsCountInStmts.add(numRowsInCurrentStmt);
                                }
                                numRowsInCurrentStmt = 0;
                            }
                            sb.setLength(0);
                            sb.append("insert all ");
                        }
                        sb.append("into ").append(tblColumns).append(" values(").append(rows.get(numRows)).append(") ");
                        ++numRowsInCurrentStmt;
                    }
                    sb.append("select * from dual");
                    insertStmts.add(sb.toString());
                    if (rowsCountInStmts != null) {
                        rowsCountInStmts.add(numRowsInCurrentStmt);
                    }
                    return insertStmts;
                }
            }
            case DERBY: 
            case MYSQL: 
            case POSTGRES: 
            case SQLSERVER: {
                for (int numRows = 0; numRows < rows.size(); ++numRows) {
                    if (numRows % MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                        if (numRows > 0) {
                            insertStmts.add(sb.substring(0, sb.length() - 1));
                            if (rowsCountInStmts != null) {
                                rowsCountInStmts.add(numRowsInCurrentStmt);
                            }
                            numRowsInCurrentStmt = 0;
                        }
                        sb.setLength(0);
                        sb.append("insert into ").append(tblColumns).append(" values");
                    }
                    sb.append('(').append(rows.get(numRows)).append("),");
                    ++numRowsInCurrentStmt;
                }
                insertStmts.add(sb.substring(0, sb.length() - 1));
                if (rowsCountInStmts != null) {
                    rowsCountInStmts.add(numRowsInCurrentStmt);
                }
                return insertStmts;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    public String addForUpdateClause(String selectStatement) throws MetaException {
        switch (this.dbProduct) {
            case DERBY: {
                return selectStatement;
            }
            case ORACLE: 
            case MYSQL: 
            case POSTGRES: {
                return selectStatement + " for update";
            }
            case SQLSERVER: {
                String modifier = " with (updlock)";
                int wherePos = selectStatement.toUpperCase().indexOf(" WHERE ");
                if (wherePos < 0) {
                    return selectStatement + modifier;
                }
                return selectStatement.substring(0, wherePos) + modifier + selectStatement.substring(wherePos, selectStatement.length());
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public String addLimitClause(int numRows, String noSelectsqlQuery) throws MetaException {
        switch (this.dbProduct) {
            case DERBY: {
                return "select " + noSelectsqlQuery + " fetch first " + numRows + " rows only";
            }
            case MYSQL: 
            case POSTGRES: {
                return "select " + noSelectsqlQuery + " limit " + numRows;
            }
            case ORACLE: {
                return "select * from (select " + noSelectsqlQuery + ") where rownum <= " + numRows;
            }
            case SQLSERVER: {
                return "select TOP(" + numRows + ") " + noSelectsqlQuery;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public PreparedStatement prepareStmtWithParameters(Connection dbConn, String sql, List<String> parameters) throws SQLException {
        PreparedStatement pst = dbConn.prepareStatement(this.addEscapeCharacters(sql));
        if (parameters == null || parameters.isEmpty()) {
            return pst;
        }
        try {
            for (int i = 1; i <= parameters.size(); ++i) {
                pst.setString(i, parameters.get(i - 1));
            }
        }
        catch (SQLException e) {
            pst.close();
            throw e;
        }
        return pst;
    }

    public List<String> getCreateQueriesForMetastoreSummary() {
        ArrayList<String> queries = new ArrayList<String>();
        switch (this.dbProduct) {
            case MYSQL: {
                queries.add(CREATE_METADATASUMMARY_MYSQL);
                break;
            }
            case DERBY: {
                return null;
            }
            case SQLSERVER: {
                return null;
            }
            case ORACLE: {
                queries.add(CREATE_METADATASUMMARY_ORACLE);
                break;
            }
            case POSTGRES: {
                queries.add(CREATE_METADATASUMMARY_POSTGRES);
            }
        }
        return queries;
    }

    public String getSelectQueryForMetastoreSummary() {
        if (this.dbProduct == DatabaseProduct.DERBY || this.dbProduct == DatabaseProduct.MYSQL || this.dbProduct == DatabaseProduct.ORACLE) {
            return "select * from METADATASUMMARYALL";
        }
        if (this.dbProduct == DatabaseProduct.POSTGRES) {
            return "select * from \"METADATASUMMARYALL\"";
        }
        return null;
    }

    public DatabaseProduct getDbProduct() {
        return this.dbProduct;
    }

    public String addEscapeCharacters(String s) {
        if (this.dbProduct == DatabaseProduct.MYSQL) {
            return s.replaceAll("\\\\", "\\\\\\\\");
        }
        return s;
    }

    public String getBatchInsertQuery(String tableName, String columns, String rowFormat, int batchCount) {
        String row;
        StringBuilder sb = new StringBuilder();
        String fixedPart = tableName + " " + columns + " values ";
        if (this.dbProduct == DatabaseProduct.ORACLE) {
            sb.append("insert all ");
            row = "into " + fixedPart + rowFormat + " ";
        } else {
            sb.append("insert into " + fixedPart);
            row = rowFormat + ',';
        }
        for (int i = 0; i < batchCount; ++i) {
            sb.append(row);
        }
        if (this.dbProduct == DatabaseProduct.ORACLE) {
            sb.append("select * from dual ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public Object getBoolean(boolean val) {
        if (this.dbProduct == DatabaseProduct.DERBY) {
            return val ? "Y" : "N";
        }
        return val;
    }
}

