/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.IllegalFormatException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSchemaHelper.class);
    public static final String DB_DERBY = "derby";
    public static final String DB_HIVE = "hive";
    public static final String DB_MSSQL = "mssql";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_POSTGRACE = "postgres";
    public static final String DB_ORACLE = "oracle";
    public static final String EMBEDDED_HS2_URL = "jdbc:hive2://?hive.conf.restricted.list=;hive.security.authorization.sqlstd.confwhitelist=.*;hive.security.authorization.sqlstd.confwhitelist.append=.*;hive.security.authorization.enabled=false;hive.metastore.uris=;hive.security.authorization.manager=org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdConfOnlyAuthorizerFactory;hive.support.concurrency=false;hive.txn.manager=org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;hive.metastore.rawstore.impl=org.apache.hadoop.hive.metastore.ObjectStore";
    public static final String HIVE_JDBC_DRIVER = "org.apache.hive.jdbc.HiveDriver";

    public static Connection getConnectionToMetastore(String userName, String password, String url, String driver, boolean printInfo, Configuration conf, String schema) throws HiveMetaException {
        try {
            url = url == null ? HiveSchemaHelper.getValidConfVar(MetastoreConf.ConfVars.CONNECT_URL_KEY, conf) : url;
            String string = driver = driver == null ? HiveSchemaHelper.getValidConfVar(MetastoreConf.ConfVars.CONNECTION_DRIVER, conf) : driver;
            if (printInfo) {
                HiveSchemaHelper.logAndPrintToStdout("Metastore connection URL:\t " + url);
                HiveSchemaHelper.logAndPrintToStdout("Metastore connection Driver :\t " + driver);
                HiveSchemaHelper.logAndPrintToStdout("Metastore connection User:\t " + userName);
                if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_IN_TEST)) {
                    HiveSchemaHelper.logAndPrintToStdout("Metastore connection Password:\t " + password);
                }
            }
            if (userName == null || userName.isEmpty()) {
                throw new HiveMetaException("UserName empty ");
            }
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, userName, password);
            if (schema != null) {
                conn.setSchema(schema);
            }
            return conn;
        }
        catch (IOException | SQLException e) {
            throw new HiveMetaException("Failed to get schema version.", e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to find driver class", (Throwable)e);
            throw new HiveMetaException("Failed to load driver", e);
        }
    }

    public static Connection getConnectionToMetastore(MetaStoreConnectionInfo info, String schema) throws HiveMetaException {
        return HiveSchemaHelper.getConnectionToMetastore(info.getUsername(), info.getPassword(), info.getUrl(), info.getDriver(), info.getPrintInfo(), info.getConf(), schema);
    }

    public static String getValidConfVar(MetastoreConf.ConfVars confVar, Configuration conf) throws IOException {
        String confVarStr = MetastoreConf.getAsString(conf, confVar);
        if (confVarStr == null || confVarStr.isEmpty()) {
            throw new IOException("Empty " + confVar.getVarname());
        }
        return confVarStr.trim();
    }

    private static void logAndPrintToStdout(String msg) {
        LOG.info(msg);
        System.out.println(msg);
    }

    public static NestedScriptParser getDbCommandParser(String dbName, boolean usingSqlLine) {
        return HiveSchemaHelper.getDbCommandParser(dbName, null, usingSqlLine);
    }

    public static NestedScriptParser getDbCommandParser(String dbName, String metaDbName, boolean usingSqlLine) {
        return HiveSchemaHelper.getDbCommandParser(dbName, null, null, null, null, metaDbName, usingSqlLine);
    }

    public static NestedScriptParser getDbCommandParser(String dbName, String dbOpts, String msUsername, String msPassword, Configuration conf, String metaDbType, boolean usingSqlLine) {
        if (dbName.equalsIgnoreCase(DB_DERBY)) {
            return new DerbyCommandParser(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }
        if (dbName.equalsIgnoreCase(DB_HIVE)) {
            return new HiveCommandParser(dbOpts, msUsername, msPassword, conf, metaDbType, usingSqlLine);
        }
        if (dbName.equalsIgnoreCase(DB_MSSQL)) {
            return new MSSQLCommandParser(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }
        if (dbName.equalsIgnoreCase(DB_MYSQL)) {
            return new MySqlCommandParser(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }
        if (dbName.equalsIgnoreCase(DB_POSTGRACE)) {
            return new PostgresCommandParser(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }
        if (dbName.equalsIgnoreCase(DB_ORACLE)) {
            return new OracleCommandParser(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }
        throw new IllegalArgumentException("Unknown dbType " + dbName);
    }

    public static class MetaStoreConnectionInfo {
        private final String userName;
        private final String password;
        private final String url;
        private final String driver;
        private final boolean printInfo;
        private final Configuration conf;
        private final String dbType;
        private final String metaDbType;

        public MetaStoreConnectionInfo(String userName, String password, String url, String driver, boolean printInfo, Configuration conf, String dbType, String metaDbType) {
            this.userName = userName;
            this.password = password;
            this.url = url;
            this.driver = driver;
            this.printInfo = printInfo;
            this.conf = conf;
            this.dbType = dbType;
            this.metaDbType = metaDbType;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDriver() {
            return this.driver;
        }

        public boolean isPrintInfo() {
            return this.printInfo;
        }

        public Configuration getConf() {
            return this.conf;
        }

        public String getUsername() {
            return this.userName;
        }

        public boolean getPrintInfo() {
            return this.printInfo;
        }

        public String getDbType() {
            return this.dbType;
        }

        public String getMetaDbType() {
            return this.metaDbType;
        }
    }

    public static class MSSQLCommandParser
    extends AbstractCommandParser {
        private static final String MSSQL_NESTING_TOKEN = ":r";

        public MSSQLCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, boolean usingSqlLine) {
            super(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1];
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(MSSQL_NESTING_TOKEN);
        }
    }

    public static class OracleCommandParser
    extends AbstractCommandParser {
        private static final String ORACLE_NESTING_TOKEN = "@";

        public OracleCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, boolean usingSqlLine) {
            super(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a nested script format " + dbCommand);
            }
            return dbCommand.replace(";", "").replace(ORACLE_NESTING_TOKEN, "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(ORACLE_NESTING_TOKEN);
        }
    }

    public static class PostgresCommandParser
    extends AbstractCommandParser {
        private static final String POSTGRES_NESTING_TOKEN = "\\i";
        @VisibleForTesting
        public static final String POSTGRES_STANDARD_STRINGS_OPT = "SET standard_conforming_strings";
        @VisibleForTesting
        public static final String POSTGRES_SKIP_STANDARD_STRINGS_DBOPT = "postgres.filter.81";

        public PostgresCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, boolean usingSqlLine) {
            super(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(POSTGRES_NESTING_TOKEN);
        }

        @Override
        public boolean needsQuotedIdentifier() {
            return true;
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            if (this.getDbOpts().contains(POSTGRES_SKIP_STANDARD_STRINGS_DBOPT) && dbCommand.startsWith(POSTGRES_STANDARD_STRINGS_OPT)) {
                return true;
            }
            return super.isNonExecCommand(dbCommand);
        }
    }

    public static class MySqlCommandParser
    extends AbstractCommandParser {
        private static final String MYSQL_NESTING_TOKEN = "SOURCE";
        private static final String DELIMITER_TOKEN = "DELIMITER";
        private String delimiter = ";";

        public MySqlCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, boolean usingSqlLine) {
            super(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }

        @Override
        public boolean isPartialCommand(String dbCommand) throws IllegalArgumentException {
            boolean isPartial = super.isPartialCommand(dbCommand);
            if (dbCommand.startsWith(DELIMITER_TOKEN)) {
                String[] tokens = dbCommand.split(" ");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
                }
                this.delimiter = tokens[1];
            }
            return isPartial;
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(MYSQL_NESTING_TOKEN);
        }

        @Override
        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public String getQuoteCharacter() {
            return "`";
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            return super.isNonExecCommand(dbCommand) || dbCommand.startsWith("/*") && dbCommand.endsWith("*/") || dbCommand.startsWith(DELIMITER_TOKEN);
        }

        @Override
        public String cleanseCommand(String dbCommand) {
            return super.cleanseCommand(dbCommand).replaceAll("/\\*.*?\\*/[^;]", "");
        }
    }

    public static class HiveCommandParser
    extends AbstractCommandParser {
        private static String HIVE_NESTING_TOKEN = "SOURCE";
        private final NestedScriptParser nestedDbCommandParser;

        public HiveCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, String metaDbType, boolean usingSqlLine) {
            super(dbOpts, msUsername, msPassword, conf, usingSqlLine);
            this.nestedDbCommandParser = HiveSchemaHelper.getDbCommandParser(metaDbType, usingSqlLine);
        }

        @Override
        public String getQuoteCharacter() {
            return this.nestedDbCommandParser.getQuoteCharacter();
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a script format " + dbCommand);
            }
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(HIVE_NESTING_TOKEN);
        }
    }

    public static class DerbyCommandParser
    extends AbstractCommandParser {
        private static final String DERBY_NESTING_TOKEN = "RUN";

        public DerbyCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, boolean usingSqlLine) {
            super(dbOpts, msUsername, msPassword, conf, usingSqlLine);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a script format " + dbCommand);
            }
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "").replaceAll("'", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(DERBY_NESTING_TOKEN);
        }
    }

    private static abstract class AbstractCommandParser
    implements NestedScriptParser {
        private List<String> dbOpts;
        private String msUsername;
        private String msPassword;
        private Configuration conf;
        private final boolean usingSqlLine;

        public AbstractCommandParser(String dbOpts, String msUsername, String msPassword, Configuration conf, boolean usingSqlLine) {
            this.setDbOpts(dbOpts);
            this.msUsername = msUsername;
            this.msPassword = msPassword;
            this.conf = conf;
            this.usingSqlLine = usingSqlLine;
        }

        @Override
        public boolean isPartialCommand(String dbCommand) throws IllegalArgumentException {
            if (dbCommand == null || dbCommand.isEmpty()) {
                throw new IllegalArgumentException("invalid command line " + dbCommand);
            }
            return !(dbCommand = dbCommand.trim()).endsWith(this.getDelimiter()) && !this.isNonExecCommand(dbCommand);
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            return dbCommand.startsWith("--") || dbCommand.startsWith("#");
        }

        @Override
        public String getDelimiter() {
            return ";";
        }

        @Override
        public String getQuoteCharacter() {
            return "\"";
        }

        @Override
        public String cleanseCommand(String dbCommand) {
            if (dbCommand.endsWith(this.getDelimiter())) {
                dbCommand = dbCommand.substring(0, dbCommand.length() - this.getDelimiter().length());
            }
            return dbCommand;
        }

        @Override
        public boolean needsQuotedIdentifier() {
            return false;
        }

        @Override
        public String buildCommand(String scriptDir, String scriptFile) throws IllegalFormatException, IOException {
            return this.buildCommand(scriptDir, scriptFile, false);
        }

        @Override
        public String buildCommand(String scriptDir, String scriptFile, boolean fixQuotes) throws IllegalFormatException, IOException {
            String currLine;
            BufferedReader bfReader = new BufferedReader(new FileReader(scriptDir + File.separatorChar + scriptFile));
            StringBuilder sb = new StringBuilder();
            String currentCommand = null;
            while ((currLine = bfReader.readLine()) != null) {
                currLine = currLine.trim();
                if (fixQuotes && !this.getQuoteCharacter().equals("\"")) {
                    currLine = currLine.replace("\\\"", this.getQuoteCharacter());
                }
                if (currLine.isEmpty()) continue;
                currentCommand = currentCommand == null ? currLine : currentCommand + " " + currLine;
                if (this.isPartialCommand(currLine)) continue;
                if (!this.isNonExecCommand(currentCommand)) {
                    if (this.isNestedScript(currentCommand = this.cleanseCommand(currentCommand))) {
                        String currScript = this.getScriptName(currentCommand);
                        sb.append(this.buildCommand(scriptDir, currScript));
                    } else {
                        sb.append(currentCommand);
                        if (this.usingSqlLine) {
                            sb.append(";");
                        }
                        sb.append(System.getProperty("line.separator"));
                    }
                }
                currentCommand = null;
            }
            bfReader.close();
            return sb.toString();
        }

        private void setDbOpts(String dbOpts) {
            this.dbOpts = dbOpts != null ? Lists.newArrayList((Object[])dbOpts.split(",")) : Lists.newArrayList();
        }

        protected List<String> getDbOpts() {
            return this.dbOpts;
        }

        protected String getMsUsername() {
            return this.msUsername;
        }

        protected String getMsPassword() {
            return this.msPassword;
        }

        protected Configuration getConf() {
            return this.conf;
        }
    }

    public static interface NestedScriptParser {
        public static final String DEFAULT_DELIMITER = ";";
        public static final String DEFAULT_QUOTE = "\"";

        public boolean isPartialCommand(String var1) throws IllegalArgumentException;

        public String getScriptName(String var1) throws IllegalArgumentException;

        public boolean isNestedScript(String var1);

        public boolean isNonExecCommand(String var1);

        public String getDelimiter();

        public String getQuoteCharacter();

        public String cleanseCommand(String var1);

        public boolean needsQuotedIdentifier();

        public String buildCommand(String var1, String var2) throws IllegalFormatException, IOException;

        public String buildCommand(String var1, String var2, boolean var3) throws IllegalFormatException, IOException;

        public static enum CommandType {
            PARTIAL_STATEMENT,
            TERMINATED_STATEMENT,
            COMMENT;

        }
    }
}

