/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;

public class SchemaToolTaskDrop
extends SchemaToolTask {
    @VisibleForTesting
    boolean yes = false;

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cmdLine) {
        if (cmdLine.hasOption("yes")) {
            this.yes = true;
        }
    }

    @Override
    void execute() throws HiveMetaException {
        boolean confirmed;
        if (!(this.schemaTool.isDryRun() || this.yes || (confirmed = this.promptToConfirm()))) {
            System.out.println("Operation cancelled, exiting.");
            return;
        }
        Connection conn = this.schemaTool.getConnectionToMetastore(true);
        try (Statement stmt = conn.createStatement();){
            String def = "default";
            ArrayList<String> databases = new ArrayList<String>();
            ResultSet rs = stmt.executeQuery("SHOW DATABASES");
            Object object = null;
            try {
                while (rs.next()) {
                    databases.add(rs.getString(1));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (object != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            for (String database : databases) {
                if ("default".equalsIgnoreCase(database)) continue;
                if (this.schemaTool.isDryRun()) {
                    System.out.println("would drop database " + database);
                    continue;
                }
                this.logIfVerbose("dropping database " + database);
                stmt.execute(String.format("DROP DATABASE `%s` CASCADE", database));
            }
            ArrayList<String> tables = new ArrayList<String>();
            try (ResultSet rs2 = stmt.executeQuery(String.format("SHOW TABLES IN `%s`", "default"));){
                while (rs2.next()) {
                    tables.add(rs2.getString(1));
                }
            }
            for (String table : tables) {
                if (this.schemaTool.isDryRun()) {
                    System.out.println("would drop table " + table);
                    continue;
                }
                this.logIfVerbose("dropping table " + table);
                stmt.execute(String.format("DROP TABLE `%s`.`%s`", "default", table));
            }
        }
        catch (SQLException se) {
            throw new HiveMetaException("Failed to drop databases.", se);
        }
    }

    private boolean promptToConfirm() {
        System.out.print("This operation will delete ALL managed data in Hive. Are you sure you want to continue (y/[n])?");
        Scanner scanner = new Scanner(System.in, "UTF-8");
        String input = scanner.nextLine();
        return "y".equalsIgnoreCase(input) || "yes".equalsIgnoreCase(input);
    }

    private void logIfVerbose(String msg) {
        if (this.schemaTool.isVerbose()) {
            System.out.println(msg);
        }
    }
}

