/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.DataOperationType;

public enum OperationType {
    SELECT('s', DataOperationType.SELECT),
    INSERT('i', DataOperationType.INSERT),
    UPDATE('u', DataOperationType.UPDATE),
    DELETE('d', DataOperationType.DELETE),
    COMPACT('c', null);

    private final char sqlConst;
    private final DataOperationType dataOperationType;
    private static final Map<DataOperationType, OperationType> DOT_LOOKUP;

    private OperationType(char sqlConst, DataOperationType dataOperationType) {
        this.sqlConst = sqlConst;
        this.dataOperationType = dataOperationType;
    }

    public String toString() {
        return "'" + this.getSqlConst() + "'";
    }

    public static OperationType fromDataOperationType(DataOperationType dop) {
        return Optional.of(DOT_LOOKUP.get((Object)dop)).orElseThrow(IllegalArgumentException::new);
    }

    public String getSqlConst() {
        return Character.toString(this.sqlConst);
    }

    public DataOperationType getDataOperationType() {
        return this.dataOperationType;
    }

    static {
        DOT_LOOKUP = Arrays.stream(OperationType.values()).collect(Collectors.toMap(OperationType::getDataOperationType, Function.identity()));
    }
}

