/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.LockType;

public class LockTypeUtil {
    private static final char UNKNOWN_LOCK_TYPE_ENCODING = 'z';
    private static final BiMap<LockType, Character> PERSISTENCE_ENCODINGS = EnumHashBiMap.create(LockType.class);

    public static char getEncoding(LockType lockType) {
        return ((Character)PERSISTENCE_ENCODINGS.getOrDefault((Object)lockType, (Object)Character.valueOf('z'))).charValue();
    }

    public static String getEncodingAsStr(LockType lockType) {
        return Character.toString(LockTypeUtil.getEncoding(lockType));
    }

    private static String getEncodingAsQuotedStr(LockType lockType) {
        return "'" + LockTypeUtil.getEncodingAsStr(lockType) + "'";
    }

    public static Optional<LockType> getLockTypeFromEncoding(char encoding) {
        return Optional.ofNullable(PERSISTENCE_ENCODINGS.inverse().get((Object)Character.valueOf(encoding)));
    }

    public static String exclusive() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.EXCLUSIVE);
    }

    public static String exclWrite() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.EXCL_WRITE);
    }

    public static String sharedWrite() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.SHARED_WRITE);
    }

    public static String sharedRead() {
        return LockTypeUtil.getEncodingAsQuotedStr(LockType.SHARED_READ);
    }

    static {
        PERSISTENCE_ENCODINGS.put((Object)LockType.SHARED_READ, (Object)Character.valueOf('r'));
        PERSISTENCE_ENCODINGS.put((Object)LockType.SHARED_WRITE, (Object)Character.valueOf('w'));
        PERSISTENCE_ENCODINGS.put((Object)LockType.EXCL_WRITE, (Object)Character.valueOf('x'));
        PERSISTENCE_ENCODINGS.put((Object)LockType.EXCLUSIVE, (Object)Character.valueOf('e'));
    }
}

