/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreAuthenticationProviderFactory;
import org.apache.hadoop.hive.metastore.MetaStorePasswdAuthenticationProvider;
import org.apache.hadoop.hive.metastore.MetaStorePlainSaslServer;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaStorePlainSaslHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStorePlainSaslHelper.class);

    public static void init() {
        LOG.info("init called to add SaslPlainProvider to Sasl providers.");
    }

    public static TTransportFactory getPlainTransportFactory(String authTypeStr, Configuration conf) throws LoginException {
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        try {
            saslFactory.addServerDefinition("PLAIN", authTypeStr, null, new HashMap(), (CallbackHandler)new PlainServerCallbackHandler(authTypeStr, conf));
        }
        catch (AuthenticationException e) {
            throw new LoginException("Error setting callback handler" + e);
        }
        return saslFactory;
    }

    public static TTransport getPlainTransport(String username, String password, TTransport underlyingTransport) throws SaslException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap(), (CallbackHandler)new PlainCallbackHandler(username, password), underlyingTransport);
    }

    private MetaStorePlainSaslHelper() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    static {
        Security.addProvider(new MetaStorePlainSaslServer.SaslPlainProvider());
    }

    public static class PlainCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public PlainCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callback;
                    passCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    public static final class PlainServerCallbackHandler
    implements CallbackHandler {
        private final MetaStoreAuthenticationProviderFactory.AuthMethods authMethod;
        private final Configuration conf;

        PlainServerCallbackHandler(String authMethodStr, Configuration conf) throws AuthenticationException {
            this.authMethod = MetaStoreAuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authMethodStr);
            this.conf = conf;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            String password = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    username = nc.getName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    password = new String(pc.getPassword());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            MetaStorePasswdAuthenticationProvider provider = MetaStoreAuthenticationProviderFactory.getAuthenticationProvider(this.conf, this.authMethod);
            provider.Authenticate(username, password);
            if (ac != null) {
                ac.setAuthorized(true);
            }
        }
    }
}

