/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompactionInfoStruct
implements TBase<CompactionInfoStruct, _Fields>,
Serializable,
Cloneable,
Comparable<CompactionInfoStruct> {
    private static final TStruct STRUCT_DESC = new TStruct("CompactionInfoStruct");
    private static final TField ID_FIELD_DESC = new TField("id", 10, 1);
    private static final TField DBNAME_FIELD_DESC = new TField("dbname", 11, 2);
    private static final TField TABLENAME_FIELD_DESC = new TField("tablename", 11, 3);
    private static final TField PARTITIONNAME_FIELD_DESC = new TField("partitionname", 11, 4);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 5);
    private static final TField RUNAS_FIELD_DESC = new TField("runas", 11, 6);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 11, 7);
    private static final TField TOOMANYABORTS_FIELD_DESC = new TField("toomanyaborts", 2, 8);
    private static final TField STATE_FIELD_DESC = new TField("state", 11, 9);
    private static final TField WORKER_ID_FIELD_DESC = new TField("workerId", 11, 10);
    private static final TField START_FIELD_DESC = new TField("start", 10, 11);
    private static final TField HIGHEST_WRITE_ID_FIELD_DESC = new TField("highestWriteId", 10, 12);
    private static final TField ERROR_MESSAGE_FIELD_DESC = new TField("errorMessage", 11, 13);
    private static final TField HASOLDABORT_FIELD_DESC = new TField("hasoldabort", 2, 14);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private long id;
    private String dbname;
    private String tablename;
    private String partitionname;
    private CompactionType type;
    private String runas;
    private String properties;
    private boolean toomanyaborts;
    private String state;
    private String workerId;
    private long start;
    private long highestWriteId;
    private String errorMessage;
    private boolean hasoldabort;
    private static final int __ID_ISSET_ID = 0;
    private static final int __TOOMANYABORTS_ISSET_ID = 1;
    private static final int __START_ISSET_ID = 2;
    private static final int __HIGHESTWRITEID_ISSET_ID = 3;
    private static final int __HASOLDABORT_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CompactionInfoStruct() {
    }

    public CompactionInfoStruct(long id, String dbname, String tablename, CompactionType type) {
        this();
        this.id = id;
        this.setIdIsSet(true);
        this.dbname = dbname;
        this.tablename = tablename;
        this.type = type;
    }

    public CompactionInfoStruct(CompactionInfoStruct other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.id = other.id;
        if (other.isSetDbname()) {
            this.dbname = other.dbname;
        }
        if (other.isSetTablename()) {
            this.tablename = other.tablename;
        }
        if (other.isSetPartitionname()) {
            this.partitionname = other.partitionname;
        }
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetRunas()) {
            this.runas = other.runas;
        }
        if (other.isSetProperties()) {
            this.properties = other.properties;
        }
        this.toomanyaborts = other.toomanyaborts;
        if (other.isSetState()) {
            this.state = other.state;
        }
        if (other.isSetWorkerId()) {
            this.workerId = other.workerId;
        }
        this.start = other.start;
        this.highestWriteId = other.highestWriteId;
        if (other.isSetErrorMessage()) {
            this.errorMessage = other.errorMessage;
        }
        this.hasoldabort = other.hasoldabort;
    }

    public CompactionInfoStruct deepCopy() {
        return new CompactionInfoStruct(this);
    }

    public void clear() {
        this.setIdIsSet(false);
        this.id = 0L;
        this.dbname = null;
        this.tablename = null;
        this.partitionname = null;
        this.type = null;
        this.runas = null;
        this.properties = null;
        this.setToomanyabortsIsSet(false);
        this.toomanyaborts = false;
        this.state = null;
        this.workerId = null;
        this.setStartIsSet(false);
        this.start = 0L;
        this.setHighestWriteIdIsSet(false);
        this.highestWriteId = 0L;
        this.errorMessage = null;
        this.setHasoldabortIsSet(false);
        this.hasoldabort = false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public void unsetDbname() {
        this.dbname = null;
    }

    public boolean isSetDbname() {
        return this.dbname != null;
    }

    public void setDbnameIsSet(boolean value) {
        if (!value) {
            this.dbname = null;
        }
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void unsetTablename() {
        this.tablename = null;
    }

    public boolean isSetTablename() {
        return this.tablename != null;
    }

    public void setTablenameIsSet(boolean value) {
        if (!value) {
            this.tablename = null;
        }
    }

    public String getPartitionname() {
        return this.partitionname;
    }

    public void setPartitionname(String partitionname) {
        this.partitionname = partitionname;
    }

    public void unsetPartitionname() {
        this.partitionname = null;
    }

    public boolean isSetPartitionname() {
        return this.partitionname != null;
    }

    public void setPartitionnameIsSet(boolean value) {
        if (!value) {
            this.partitionname = null;
        }
    }

    public CompactionType getType() {
        return this.type;
    }

    public void setType(CompactionType type) {
        this.type = type;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public String getRunas() {
        return this.runas;
    }

    public void setRunas(String runas) {
        this.runas = runas;
    }

    public void unsetRunas() {
        this.runas = null;
    }

    public boolean isSetRunas() {
        return this.runas != null;
    }

    public void setRunasIsSet(boolean value) {
        if (!value) {
            this.runas = null;
        }
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
        if (!value) {
            this.properties = null;
        }
    }

    public boolean isToomanyaborts() {
        return this.toomanyaborts;
    }

    public void setToomanyaborts(boolean toomanyaborts) {
        this.toomanyaborts = toomanyaborts;
        this.setToomanyabortsIsSet(true);
    }

    public void unsetToomanyaborts() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetToomanyaborts() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setToomanyabortsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void unsetState() {
        this.state = null;
    }

    public boolean isSetState() {
        return this.state != null;
    }

    public void setStateIsSet(boolean value) {
        if (!value) {
            this.state = null;
        }
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void unsetWorkerId() {
        this.workerId = null;
    }

    public boolean isSetWorkerId() {
        return this.workerId != null;
    }

    public void setWorkerIdIsSet(boolean value) {
        if (!value) {
            this.workerId = null;
        }
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
        this.setStartIsSet(true);
    }

    public void unsetStart() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetStart() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setStartIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getHighestWriteId() {
        return this.highestWriteId;
    }

    public void setHighestWriteId(long highestWriteId) {
        this.highestWriteId = highestWriteId;
        this.setHighestWriteIdIsSet(true);
    }

    public void unsetHighestWriteId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetHighestWriteId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setHighestWriteIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void unsetErrorMessage() {
        this.errorMessage = null;
    }

    public boolean isSetErrorMessage() {
        return this.errorMessage != null;
    }

    public void setErrorMessageIsSet(boolean value) {
        if (!value) {
            this.errorMessage = null;
        }
    }

    public boolean isHasoldabort() {
        return this.hasoldabort;
    }

    public void setHasoldabort(boolean hasoldabort) {
        this.hasoldabort = hasoldabort;
        this.setHasoldabortIsSet(true);
    }

    public void unsetHasoldabort() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetHasoldabort() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setHasoldabortIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
                break;
            }
            case DBNAME: {
                if (value == null) {
                    this.unsetDbname();
                    break;
                }
                this.setDbname((String)value);
                break;
            }
            case TABLENAME: {
                if (value == null) {
                    this.unsetTablename();
                    break;
                }
                this.setTablename((String)value);
                break;
            }
            case PARTITIONNAME: {
                if (value == null) {
                    this.unsetPartitionname();
                    break;
                }
                this.setPartitionname((String)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((CompactionType)((Object)value));
                break;
            }
            case RUNAS: {
                if (value == null) {
                    this.unsetRunas();
                    break;
                }
                this.setRunas((String)value);
                break;
            }
            case PROPERTIES: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((String)value);
                break;
            }
            case TOOMANYABORTS: {
                if (value == null) {
                    this.unsetToomanyaborts();
                    break;
                }
                this.setToomanyaborts((Boolean)value);
                break;
            }
            case STATE: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((String)value);
                break;
            }
            case WORKER_ID: {
                if (value == null) {
                    this.unsetWorkerId();
                    break;
                }
                this.setWorkerId((String)value);
                break;
            }
            case START: {
                if (value == null) {
                    this.unsetStart();
                    break;
                }
                this.setStart((Long)value);
                break;
            }
            case HIGHEST_WRITE_ID: {
                if (value == null) {
                    this.unsetHighestWriteId();
                    break;
                }
                this.setHighestWriteId((Long)value);
                break;
            }
            case ERROR_MESSAGE: {
                if (value == null) {
                    this.unsetErrorMessage();
                    break;
                }
                this.setErrorMessage((String)value);
                break;
            }
            case HASOLDABORT: {
                if (value == null) {
                    this.unsetHasoldabort();
                    break;
                }
                this.setHasoldabort((Boolean)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ID: {
                return this.getId();
            }
            case DBNAME: {
                return this.getDbname();
            }
            case TABLENAME: {
                return this.getTablename();
            }
            case PARTITIONNAME: {
                return this.getPartitionname();
            }
            case TYPE: {
                return this.getType();
            }
            case RUNAS: {
                return this.getRunas();
            }
            case PROPERTIES: {
                return this.getProperties();
            }
            case TOOMANYABORTS: {
                return this.isToomanyaborts();
            }
            case STATE: {
                return this.getState();
            }
            case WORKER_ID: {
                return this.getWorkerId();
            }
            case START: {
                return this.getStart();
            }
            case HIGHEST_WRITE_ID: {
                return this.getHighestWriteId();
            }
            case ERROR_MESSAGE: {
                return this.getErrorMessage();
            }
            case HASOLDABORT: {
                return this.isHasoldabort();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ID: {
                return this.isSetId();
            }
            case DBNAME: {
                return this.isSetDbname();
            }
            case TABLENAME: {
                return this.isSetTablename();
            }
            case PARTITIONNAME: {
                return this.isSetPartitionname();
            }
            case TYPE: {
                return this.isSetType();
            }
            case RUNAS: {
                return this.isSetRunas();
            }
            case PROPERTIES: {
                return this.isSetProperties();
            }
            case TOOMANYABORTS: {
                return this.isSetToomanyaborts();
            }
            case STATE: {
                return this.isSetState();
            }
            case WORKER_ID: {
                return this.isSetWorkerId();
            }
            case START: {
                return this.isSetStart();
            }
            case HIGHEST_WRITE_ID: {
                return this.isSetHighestWriteId();
            }
            case ERROR_MESSAGE: {
                return this.isSetErrorMessage();
            }
            case HASOLDABORT: {
                return this.isSetHasoldabort();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof CompactionInfoStruct) {
            return this.equals((CompactionInfoStruct)that);
        }
        return false;
    }

    public boolean equals(CompactionInfoStruct that) {
        if (that == null) {
            return false;
        }
        boolean this_present_id = true;
        boolean that_present_id = true;
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_dbname = this.isSetDbname();
        boolean that_present_dbname = that.isSetDbname();
        if (this_present_dbname || that_present_dbname) {
            if (!this_present_dbname || !that_present_dbname) {
                return false;
            }
            if (!this.dbname.equals(that.dbname)) {
                return false;
            }
        }
        boolean this_present_tablename = this.isSetTablename();
        boolean that_present_tablename = that.isSetTablename();
        if (this_present_tablename || that_present_tablename) {
            if (!this_present_tablename || !that_present_tablename) {
                return false;
            }
            if (!this.tablename.equals(that.tablename)) {
                return false;
            }
        }
        boolean this_present_partitionname = this.isSetPartitionname();
        boolean that_present_partitionname = that.isSetPartitionname();
        if (this_present_partitionname || that_present_partitionname) {
            if (!this_present_partitionname || !that_present_partitionname) {
                return false;
            }
            if (!this.partitionname.equals(that.partitionname)) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_runas = this.isSetRunas();
        boolean that_present_runas = that.isSetRunas();
        if (this_present_runas || that_present_runas) {
            if (!this_present_runas || !that_present_runas) {
                return false;
            }
            if (!this.runas.equals(that.runas)) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!this.properties.equals(that.properties)) {
                return false;
            }
        }
        boolean this_present_toomanyaborts = this.isSetToomanyaborts();
        boolean that_present_toomanyaborts = that.isSetToomanyaborts();
        if (this_present_toomanyaborts || that_present_toomanyaborts) {
            if (!this_present_toomanyaborts || !that_present_toomanyaborts) {
                return false;
            }
            if (this.toomanyaborts != that.toomanyaborts) {
                return false;
            }
        }
        boolean this_present_state = this.isSetState();
        boolean that_present_state = that.isSetState();
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (!this.state.equals(that.state)) {
                return false;
            }
        }
        boolean this_present_workerId = this.isSetWorkerId();
        boolean that_present_workerId = that.isSetWorkerId();
        if (this_present_workerId || that_present_workerId) {
            if (!this_present_workerId || !that_present_workerId) {
                return false;
            }
            if (!this.workerId.equals(that.workerId)) {
                return false;
            }
        }
        boolean this_present_start = this.isSetStart();
        boolean that_present_start = that.isSetStart();
        if (this_present_start || that_present_start) {
            if (!this_present_start || !that_present_start) {
                return false;
            }
            if (this.start != that.start) {
                return false;
            }
        }
        boolean this_present_highestWriteId = this.isSetHighestWriteId();
        boolean that_present_highestWriteId = that.isSetHighestWriteId();
        if (this_present_highestWriteId || that_present_highestWriteId) {
            if (!this_present_highestWriteId || !that_present_highestWriteId) {
                return false;
            }
            if (this.highestWriteId != that.highestWriteId) {
                return false;
            }
        }
        boolean this_present_errorMessage = this.isSetErrorMessage();
        boolean that_present_errorMessage = that.isSetErrorMessage();
        if (this_present_errorMessage || that_present_errorMessage) {
            if (!this_present_errorMessage || !that_present_errorMessage) {
                return false;
            }
            if (!this.errorMessage.equals(that.errorMessage)) {
                return false;
            }
        }
        boolean this_present_hasoldabort = this.isSetHasoldabort();
        boolean that_present_hasoldabort = that.isSetHasoldabort();
        if (this_present_hasoldabort || that_present_hasoldabort) {
            if (!this_present_hasoldabort || !that_present_hasoldabort) {
                return false;
            }
            if (this.hasoldabort != that.hasoldabort) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_id = true;
        list.add(present_id);
        if (present_id) {
            list.add(this.id);
        }
        boolean present_dbname = this.isSetDbname();
        list.add(present_dbname);
        if (present_dbname) {
            list.add(this.dbname);
        }
        boolean present_tablename = this.isSetTablename();
        list.add(present_tablename);
        if (present_tablename) {
            list.add(this.tablename);
        }
        boolean present_partitionname = this.isSetPartitionname();
        list.add(present_partitionname);
        if (present_partitionname) {
            list.add(this.partitionname);
        }
        boolean present_type = this.isSetType();
        list.add(present_type);
        if (present_type) {
            list.add(this.type.getValue());
        }
        boolean present_runas = this.isSetRunas();
        list.add(present_runas);
        if (present_runas) {
            list.add(this.runas);
        }
        boolean present_properties = this.isSetProperties();
        list.add(present_properties);
        if (present_properties) {
            list.add(this.properties);
        }
        boolean present_toomanyaborts = this.isSetToomanyaborts();
        list.add(present_toomanyaborts);
        if (present_toomanyaborts) {
            list.add(this.toomanyaborts);
        }
        boolean present_state = this.isSetState();
        list.add(present_state);
        if (present_state) {
            list.add(this.state);
        }
        boolean present_workerId = this.isSetWorkerId();
        list.add(present_workerId);
        if (present_workerId) {
            list.add(this.workerId);
        }
        boolean present_start = this.isSetStart();
        list.add(present_start);
        if (present_start) {
            list.add(this.start);
        }
        boolean present_highestWriteId = this.isSetHighestWriteId();
        list.add(present_highestWriteId);
        if (present_highestWriteId) {
            list.add(this.highestWriteId);
        }
        boolean present_errorMessage = this.isSetErrorMessage();
        list.add(present_errorMessage);
        if (present_errorMessage) {
            list.add(this.errorMessage);
        }
        boolean present_hasoldabort = this.isSetHasoldabort();
        list.add(present_hasoldabort);
        if (present_hasoldabort) {
            list.add(this.hasoldabort);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(CompactionInfoStruct other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetId()).compareTo(other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((long)this.id, (long)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDbname()).compareTo(other.isSetDbname());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbname() && (lastComparison = TBaseHelper.compareTo((String)this.dbname, (String)other.dbname)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTablename()).compareTo(other.isSetTablename());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTablename() && (lastComparison = TBaseHelper.compareTo((String)this.tablename, (String)other.tablename)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartitionname()).compareTo(other.isSetPartitionname());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionname() && (lastComparison = TBaseHelper.compareTo((String)this.partitionname, (String)other.partitionname)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRunas()).compareTo(other.isSetRunas());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRunas() && (lastComparison = TBaseHelper.compareTo((String)this.runas, (String)other.runas)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProperties()).compareTo(other.isSetProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProperties() && (lastComparison = TBaseHelper.compareTo((String)this.properties, (String)other.properties)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetToomanyaborts()).compareTo(other.isSetToomanyaborts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToomanyaborts() && (lastComparison = TBaseHelper.compareTo((boolean)this.toomanyaborts, (boolean)other.toomanyaborts)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetState()).compareTo(other.isSetState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((String)this.state, (String)other.state)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWorkerId()).compareTo(other.isSetWorkerId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWorkerId() && (lastComparison = TBaseHelper.compareTo((String)this.workerId, (String)other.workerId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStart()).compareTo(other.isSetStart());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStart() && (lastComparison = TBaseHelper.compareTo((long)this.start, (long)other.start)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHighestWriteId()).compareTo(other.isSetHighestWriteId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHighestWriteId() && (lastComparison = TBaseHelper.compareTo((long)this.highestWriteId, (long)other.highestWriteId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetErrorMessage()).compareTo(other.isSetErrorMessage());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetErrorMessage() && (lastComparison = TBaseHelper.compareTo((String)this.errorMessage, (String)other.errorMessage)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHasoldabort()).compareTo(other.isSetHasoldabort());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHasoldabort() && (lastComparison = TBaseHelper.compareTo((boolean)this.hasoldabort, (boolean)other.hasoldabort)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CompactionInfoStruct(");
        boolean first = true;
        sb.append("id:");
        sb.append(this.id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbname:");
        if (this.dbname == null) {
            sb.append("null");
        } else {
            sb.append(this.dbname);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tablename:");
        if (this.tablename == null) {
            sb.append("null");
        } else {
            sb.append(this.tablename);
        }
        first = false;
        if (this.isSetPartitionname()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partitionname:");
            if (this.partitionname == null) {
                sb.append("null");
            } else {
                sb.append(this.partitionname);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetRunas()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("runas:");
            if (this.runas == null) {
                sb.append("null");
            } else {
                sb.append(this.runas);
            }
            first = false;
        }
        if (this.isSetProperties()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("properties:");
            if (this.properties == null) {
                sb.append("null");
            } else {
                sb.append(this.properties);
            }
            first = false;
        }
        if (this.isSetToomanyaborts()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("toomanyaborts:");
            sb.append(this.toomanyaborts);
            first = false;
        }
        if (this.isSetState()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("state:");
            if (this.state == null) {
                sb.append("null");
            } else {
                sb.append(this.state);
            }
            first = false;
        }
        if (this.isSetWorkerId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("workerId:");
            if (this.workerId == null) {
                sb.append("null");
            } else {
                sb.append(this.workerId);
            }
            first = false;
        }
        if (this.isSetStart()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("start:");
            sb.append(this.start);
            first = false;
        }
        if (this.isSetHighestWriteId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("highestWriteId:");
            sb.append(this.highestWriteId);
            first = false;
        }
        if (this.isSetErrorMessage()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("errorMessage:");
            if (this.errorMessage == null) {
                sb.append("null");
            } else {
                sb.append(this.errorMessage);
            }
            first = false;
        }
        if (this.isSetHasoldabort()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("hasoldabort:");
            sb.append(this.hasoldabort);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetId()) {
            throw new TProtocolException("Required field 'id' is unset! Struct:" + this.toString());
        }
        if (!this.isSetDbname()) {
            throw new TProtocolException("Required field 'dbname' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTablename()) {
            throw new TProtocolException("Required field 'tablename' is unset! Struct:" + this.toString());
        }
        if (!this.isSetType()) {
            throw new TProtocolException("Required field 'type' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new CompactionInfoStructStandardSchemeFactory());
        schemes.put(TupleScheme.class, new CompactionInfoStructTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.PARTITIONNAME, _Fields.RUNAS, _Fields.PROPERTIES, _Fields.TOOMANYABORTS, _Fields.STATE, _Fields.WORKER_ID, _Fields.START, _Fields.HIGHEST_WRITE_ID, _Fields.ERROR_MESSAGE, _Fields.HASOLDABORT};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DBNAME, new FieldMetaData("dbname", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLENAME, new FieldMetaData("tablename", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARTITIONNAME, new FieldMetaData("partitionname", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, CompactionType.class)));
        tmpMap.put(_Fields.RUNAS, new FieldMetaData("runas", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROPERTIES, new FieldMetaData("properties", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TOOMANYABORTS, new FieldMetaData("toomanyaborts", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.STATE, new FieldMetaData("state", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.WORKER_ID, new FieldMetaData("workerId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.START, new FieldMetaData("start", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.HIGHEST_WRITE_ID, new FieldMetaData("highestWriteId", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ERROR_MESSAGE, new FieldMetaData("errorMessage", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.HASOLDABORT, new FieldMetaData("hasoldabort", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CompactionInfoStruct.class, metaDataMap);
    }

    private static class CompactionInfoStructTupleScheme
    extends TupleScheme<CompactionInfoStruct> {
        private CompactionInfoStructTupleScheme() {
        }

        public void write(TProtocol prot, CompactionInfoStruct struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.id);
            oprot.writeString(struct.dbname);
            oprot.writeString(struct.tablename);
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetPartitionname()) {
                optionals.set(0);
            }
            if (struct.isSetRunas()) {
                optionals.set(1);
            }
            if (struct.isSetProperties()) {
                optionals.set(2);
            }
            if (struct.isSetToomanyaborts()) {
                optionals.set(3);
            }
            if (struct.isSetState()) {
                optionals.set(4);
            }
            if (struct.isSetWorkerId()) {
                optionals.set(5);
            }
            if (struct.isSetStart()) {
                optionals.set(6);
            }
            if (struct.isSetHighestWriteId()) {
                optionals.set(7);
            }
            if (struct.isSetErrorMessage()) {
                optionals.set(8);
            }
            if (struct.isSetHasoldabort()) {
                optionals.set(9);
            }
            oprot.writeBitSet(optionals, 10);
            if (struct.isSetPartitionname()) {
                oprot.writeString(struct.partitionname);
            }
            if (struct.isSetRunas()) {
                oprot.writeString(struct.runas);
            }
            if (struct.isSetProperties()) {
                oprot.writeString(struct.properties);
            }
            if (struct.isSetToomanyaborts()) {
                oprot.writeBool(struct.toomanyaborts);
            }
            if (struct.isSetState()) {
                oprot.writeString(struct.state);
            }
            if (struct.isSetWorkerId()) {
                oprot.writeString(struct.workerId);
            }
            if (struct.isSetStart()) {
                oprot.writeI64(struct.start);
            }
            if (struct.isSetHighestWriteId()) {
                oprot.writeI64(struct.highestWriteId);
            }
            if (struct.isSetErrorMessage()) {
                oprot.writeString(struct.errorMessage);
            }
            if (struct.isSetHasoldabort()) {
                oprot.writeBool(struct.hasoldabort);
            }
        }

        public void read(TProtocol prot, CompactionInfoStruct struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.id = iprot.readI64();
            struct.setIdIsSet(true);
            struct.dbname = iprot.readString();
            struct.setDbnameIsSet(true);
            struct.tablename = iprot.readString();
            struct.setTablenameIsSet(true);
            struct.type = CompactionType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(10);
            if (incoming.get(0)) {
                struct.partitionname = iprot.readString();
                struct.setPartitionnameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.runas = iprot.readString();
                struct.setRunasIsSet(true);
            }
            if (incoming.get(2)) {
                struct.properties = iprot.readString();
                struct.setPropertiesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.toomanyaborts = iprot.readBool();
                struct.setToomanyabortsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.state = iprot.readString();
                struct.setStateIsSet(true);
            }
            if (incoming.get(5)) {
                struct.workerId = iprot.readString();
                struct.setWorkerIdIsSet(true);
            }
            if (incoming.get(6)) {
                struct.start = iprot.readI64();
                struct.setStartIsSet(true);
            }
            if (incoming.get(7)) {
                struct.highestWriteId = iprot.readI64();
                struct.setHighestWriteIdIsSet(true);
            }
            if (incoming.get(8)) {
                struct.errorMessage = iprot.readString();
                struct.setErrorMessageIsSet(true);
            }
            if (incoming.get(9)) {
                struct.hasoldabort = iprot.readBool();
                struct.setHasoldabortIsSet(true);
            }
        }
    }

    private static class CompactionInfoStructTupleSchemeFactory
    implements SchemeFactory {
        private CompactionInfoStructTupleSchemeFactory() {
        }

        public CompactionInfoStructTupleScheme getScheme() {
            return new CompactionInfoStructTupleScheme();
        }
    }

    private static class CompactionInfoStructStandardScheme
    extends StandardScheme<CompactionInfoStruct> {
        private CompactionInfoStructStandardScheme() {
        }

        public void read(TProtocol iprot, CompactionInfoStruct struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.id = iprot.readI64();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbname = iprot.readString();
                            struct.setDbnameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.tablename = iprot.readString();
                            struct.setTablenameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.partitionname = iprot.readString();
                            struct.setPartitionnameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.type = CompactionType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.runas = iprot.readString();
                            struct.setRunasIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.properties = iprot.readString();
                            struct.setPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 2) {
                            struct.toomanyaborts = iprot.readBool();
                            struct.setToomanyabortsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.state = iprot.readString();
                            struct.setStateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.workerId = iprot.readString();
                            struct.setWorkerIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.start = iprot.readI64();
                            struct.setStartIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 10) {
                            struct.highestWriteId = iprot.readI64();
                            struct.setHighestWriteIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 11) {
                            struct.errorMessage = iprot.readString();
                            struct.setErrorMessageIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 2) {
                            struct.hasoldabort = iprot.readBool();
                            struct.setHasoldabortIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, CompactionInfoStruct struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(ID_FIELD_DESC);
            oprot.writeI64(struct.id);
            oprot.writeFieldEnd();
            if (struct.dbname != null) {
                oprot.writeFieldBegin(DBNAME_FIELD_DESC);
                oprot.writeString(struct.dbname);
                oprot.writeFieldEnd();
            }
            if (struct.tablename != null) {
                oprot.writeFieldBegin(TABLENAME_FIELD_DESC);
                oprot.writeString(struct.tablename);
                oprot.writeFieldEnd();
            }
            if (struct.partitionname != null && struct.isSetPartitionname()) {
                oprot.writeFieldBegin(PARTITIONNAME_FIELD_DESC);
                oprot.writeString(struct.partitionname);
                oprot.writeFieldEnd();
            }
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.runas != null && struct.isSetRunas()) {
                oprot.writeFieldBegin(RUNAS_FIELD_DESC);
                oprot.writeString(struct.runas);
                oprot.writeFieldEnd();
            }
            if (struct.properties != null && struct.isSetProperties()) {
                oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
                oprot.writeString(struct.properties);
                oprot.writeFieldEnd();
            }
            if (struct.isSetToomanyaborts()) {
                oprot.writeFieldBegin(TOOMANYABORTS_FIELD_DESC);
                oprot.writeBool(struct.toomanyaborts);
                oprot.writeFieldEnd();
            }
            if (struct.state != null && struct.isSetState()) {
                oprot.writeFieldBegin(STATE_FIELD_DESC);
                oprot.writeString(struct.state);
                oprot.writeFieldEnd();
            }
            if (struct.workerId != null && struct.isSetWorkerId()) {
                oprot.writeFieldBegin(WORKER_ID_FIELD_DESC);
                oprot.writeString(struct.workerId);
                oprot.writeFieldEnd();
            }
            if (struct.isSetStart()) {
                oprot.writeFieldBegin(START_FIELD_DESC);
                oprot.writeI64(struct.start);
                oprot.writeFieldEnd();
            }
            if (struct.isSetHighestWriteId()) {
                oprot.writeFieldBegin(HIGHEST_WRITE_ID_FIELD_DESC);
                oprot.writeI64(struct.highestWriteId);
                oprot.writeFieldEnd();
            }
            if (struct.errorMessage != null && struct.isSetErrorMessage()) {
                oprot.writeFieldBegin(ERROR_MESSAGE_FIELD_DESC);
                oprot.writeString(struct.errorMessage);
                oprot.writeFieldEnd();
            }
            if (struct.isSetHasoldabort()) {
                oprot.writeFieldBegin(HASOLDABORT_FIELD_DESC);
                oprot.writeBool(struct.hasoldabort);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class CompactionInfoStructStandardSchemeFactory
    implements SchemeFactory {
        private CompactionInfoStructStandardSchemeFactory() {
        }

        public CompactionInfoStructStandardScheme getScheme() {
            return new CompactionInfoStructStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ID(1, "id"),
        DBNAME(2, "dbname"),
        TABLENAME(3, "tablename"),
        PARTITIONNAME(4, "partitionname"),
        TYPE(5, "type"),
        RUNAS(6, "runas"),
        PROPERTIES(7, "properties"),
        TOOMANYABORTS(8, "toomanyaborts"),
        STATE(9, "state"),
        WORKER_ID(10, "workerId"),
        START(11, "start"),
        HIGHEST_WRITE_ID(12, "highestWriteId"),
        ERROR_MESSAGE(13, "errorMessage"),
        HASOLDABORT(14, "hasoldabort");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ID;
                }
                case 2: {
                    return DBNAME;
                }
                case 3: {
                    return TABLENAME;
                }
                case 4: {
                    return PARTITIONNAME;
                }
                case 5: {
                    return TYPE;
                }
                case 6: {
                    return RUNAS;
                }
                case 7: {
                    return PROPERTIES;
                }
                case 8: {
                    return TOOMANYABORTS;
                }
                case 9: {
                    return STATE;
                }
                case 10: {
                    return WORKER_ID;
                }
                case 11: {
                    return START;
                }
                case 12: {
                    return HIGHEST_WRITE_ID;
                }
                case 13: {
                    return ERROR_MESSAGE;
                }
                case 14: {
                    return HASOLDABORT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

