/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AcidWriteEvent
extends ListenerEvent {
    private final WriteNotificationLogRequest writeNotificationLogRequest;
    private final String partition;
    private final Table tableObj;
    private final Partition partitionObj;

    public AcidWriteEvent(String partition, Table tableObj, Partition partitionObj, WriteNotificationLogRequest writeNotificationLogRequest) {
        super(true, null);
        this.writeNotificationLogRequest = writeNotificationLogRequest;
        this.partition = partition;
        this.tableObj = tableObj;
        this.partitionObj = partitionObj;
    }

    public Long getTxnId() {
        return this.writeNotificationLogRequest.getTxnId();
    }

    public List<String> getFiles() {
        return this.writeNotificationLogRequest.getFileInfo().getFilesAdded();
    }

    public List<String> getChecksums() {
        return this.writeNotificationLogRequest.getFileInfo().getFilesAddedChecksum();
    }

    public String getDatabase() {
        return StringUtils.normalizeIdentifier(this.writeNotificationLogRequest.getDb());
    }

    public String getTable() {
        return StringUtils.normalizeIdentifier(this.writeNotificationLogRequest.getTable());
    }

    public String getPartition() {
        return this.partition;
    }

    public Long getWriteId() {
        return this.writeNotificationLogRequest.getWriteId();
    }

    public Table getTableObj() {
        return this.tableObj;
    }

    public Partition getPartitionObj() {
        return this.partitionObj;
    }

    public List<String> getSubDirs() {
        return this.writeNotificationLogRequest.getFileInfo().getSubDirectoryList();
    }
}

