/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.util.Arrays;
import jline.TerminalFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveMetaToolCommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HiveMetaToolCommandLine.class.getName());
    private static final Option LIST_FS_ROOT;
    private static final Option EXECUTE_JDOQL;
    private static final Option UPDATE_LOCATION;
    private static final Option DRY_RUN;
    private static final Option SERDE_PROP_KEY;
    private static final Option TABLE_PROP_KEY;
    private static final Option HELP;
    private static final Options OPTIONS;
    private boolean listFSRoot;
    private String jdoqlQuery;
    private String[] updateLocationParams;
    private boolean dryRun;
    private String serdePropKey;
    private String tablePropKey;
    private boolean help;

    public static HiveMetaToolCommandLine parseArguments(String[] args) {
        HiveMetaToolCommandLine cl = null;
        try {
            cl = new HiveMetaToolCommandLine(args);
        }
        catch (Exception e) {
            LOGGER.error("Parsing the command line arguments failed", (Throwable)e);
            HiveMetaToolCommandLine.printUsage();
            System.exit(1);
        }
        if (cl.isHelp()) {
            HiveMetaToolCommandLine.printUsage();
            System.exit(0);
        }
        return cl;
    }

    HiveMetaToolCommandLine(String[] args) throws ParseException {
        LOGGER.info("Hive Meta Tool invoked with arguments = {}", (Object)Arrays.toString(args));
        this.parseCommandLine(args);
        this.printArguments();
    }

    private void parseCommandLine(String[] args) throws ParseException {
        CommandLine cl = new GnuParser().parse(OPTIONS, args);
        this.listFSRoot = cl.hasOption(LIST_FS_ROOT.getOpt());
        this.jdoqlQuery = cl.getOptionValue(EXECUTE_JDOQL.getOpt());
        this.updateLocationParams = cl.getOptionValues(UPDATE_LOCATION.getOpt());
        this.dryRun = cl.hasOption(DRY_RUN.getOpt());
        this.serdePropKey = cl.getOptionValue(SERDE_PROP_KEY.getOpt());
        this.tablePropKey = cl.getOptionValue(TABLE_PROP_KEY.getOpt());
        this.help = cl.hasOption(HELP.getOpt());
        int commandCount = (this.isListFSRoot() ? 1 : 0) + (this.isExecuteJDOQL() ? 1 : 0) + (this.isUpdateLocation() ? 1 : 0);
        if (commandCount != 1) {
            throw new IllegalArgumentException("exectly one of -listFSRoot, -executeJDOQL, -updateLocation must be set");
        }
        if (this.updateLocationParams != null && this.updateLocationParams.length != 2) {
            throw new IllegalArgumentException("HiveMetaTool:updateLocation takes in 2 arguments but was passed " + this.updateLocationParams.length + " arguments");
        }
        if ((this.dryRun || this.serdePropKey != null || this.tablePropKey != null) && !this.isUpdateLocation()) {
            throw new IllegalArgumentException("-dryRun, -serdePropKey, -tablePropKey may be used only for the -updateLocation command");
        }
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        try {
            int width = hf.getWidth();
            int jlineWidth = TerminalFactory.get().getWidth();
            width = Math.min(160, Math.max(jlineWidth, width));
            hf.setWidth(width);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hf.printHelp("metatool", OPTIONS);
    }

    private void printArguments() {
        LOGGER.info("Hive Meta Tool is running with the following parsed arguments: \n\tlistFSRoot    : " + this.listFSRoot + "\n" + "\tjdoqlQuery    : " + this.jdoqlQuery + "\n" + "\tupdateLocation: " + Arrays.toString(this.updateLocationParams) + "\n" + "\tdryRun        : " + this.dryRun + "\n" + "\tserdePropKey  : " + this.serdePropKey + "\n" + "\ttablePropKey  : " + this.tablePropKey);
    }

    boolean isListFSRoot() {
        return this.listFSRoot;
    }

    boolean isExecuteJDOQL() {
        return this.jdoqlQuery != null;
    }

    String getJDOQLQuery() {
        return this.jdoqlQuery;
    }

    boolean isUpdateLocation() {
        return this.updateLocationParams != null;
    }

    String[] getUpddateLocationParams() {
        return this.updateLocationParams;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    String getSerdePropKey() {
        return this.serdePropKey;
    }

    String getTablePropKey() {
        return this.tablePropKey;
    }

    private boolean isHelp() {
        return this.help;
    }

    static {
        OptionBuilder.withDescription((String)"print the current FS root locations");
        LIST_FS_ROOT = OptionBuilder.create((String)"listFSRoot");
        OptionBuilder.withArgName((String)"query-string");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"execute the given JDOQL query");
        EXECUTE_JDOQL = OptionBuilder.create((String)"executeJDOQL");
        OptionBuilder.withArgName((String)"new-loc> <old-loc");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withDescription((String)"Update FS root location in the metastore to new location.Both new-loc and old-loc should be valid URIs with valid host names and schemes. When run with the dryRun option changes are displayed but are not persisted. When run with the serdepropKey/tablePropKey option updateLocation looks for the serde-prop-key/table-prop-key that is specified and updates its value if found.");
        UPDATE_LOCATION = OptionBuilder.create((String)"updateLocation");
        OptionBuilder.withDescription((String)"Perform a dry run of updateLocation changes.When run with the dryRun option updateLocation changes are displayed but not persisted. dryRun is valid only with the updateLocation option.");
        DRY_RUN = OptionBuilder.create((String)"dryRun");
        OptionBuilder.withArgName((String)"serde-prop-key");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Specify the key for serde property to be updated. serdePropKey option is valid only with updateLocation option.");
        SERDE_PROP_KEY = OptionBuilder.create((String)"serdePropKey");
        OptionBuilder.withArgName((String)"table-prop-key");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Specify the key for table property to be updated. tablePropKey option is valid only with updateLocation option.");
        TABLE_PROP_KEY = OptionBuilder.create((String)"tablePropKey");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help information");
        OptionBuilder.withArgName((String)"help");
        HELP = OptionBuilder.create((char)'h');
        OPTIONS = new Options();
        OPTIONS.addOption(LIST_FS_ROOT);
        OPTIONS.addOption(EXECUTE_JDOQL);
        OPTIONS.addOption(UPDATE_LOCATION);
        OPTIONS.addOption(DRY_RUN);
        OPTIONS.addOption(SERDE_PROP_KEY);
        OPTIONS.addOption(TABLE_PROP_KEY);
        OPTIONS.addOption(HELP);
    }
}

