/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaToolTaskCreateUser
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaToolTaskCreateUser.class);

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
    }

    @Override
    void execute() throws HiveMetaException {
        this.schemaTool.testConnectionToMetastore();
        System.out.println("Starting user creation");
        String scriptDir = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreScriptDir();
        String protoCreateFile = this.schemaTool.getMetaStoreSchemaInfo().getCreateUserScript();
        try {
            File createFile = this.subUserAndPassword(scriptDir, protoCreateFile);
            System.out.println("Creation script " + createFile.getAbsolutePath());
            if (!this.schemaTool.isDryRun()) {
                if ("oracle".equals(this.schemaTool.getDbType())) {
                    this.oracleCreateUserHack(createFile);
                } else {
                    this.schemaTool.execSql(createFile.getParent(), createFile.getName());
                }
                System.out.println("User creation completed");
            }
        }
        catch (IOException e) {
            throw new HiveMetaException("User creation FAILED! Metastore unusable !!", e);
        }
    }

    private File subUserAndPassword(String parent, String filename) throws IOException {
        File createFile = File.createTempFile("create-hive-user-" + this.schemaTool.getDbType(), ".sql");
        BufferedWriter writer = new BufferedWriter(new FileWriter(createFile));
        File proto = new File(parent, filename);
        BufferedReader reader = new BufferedReader(new FileReader(proto));
        reader.lines().map(s -> s.replace("_REPLACE_WITH_USER_", this.schemaTool.getHiveUser()).replace("_REPLACE_WITH_PASSWD_", this.schemaTool.getHivePasswd()).replace("_REPLACE_WITH_DB_", this.schemaTool.getHiveDb())).forEach(s -> {
            try {
                writer.write((String)s);
                writer.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write to tmp file ", e);
            }
        });
        reader.close();
        writer.close();
        return createFile;
    }

    private void oracleCreateUserHack(File createFile) throws HiveMetaException {
        LOG.debug("Found oracle, hacking our way through it rather than using SqlLine");
        try (BufferedReader reader = new BufferedReader(new FileReader(createFile));
             Connection conn = this.schemaTool.getConnectionToMetastore(false);
             Statement stmt = conn.createStatement();){
            reader.lines().forEach(s -> {
                assert (s.charAt(s.length() - 1) == ';');
                try {
                    stmt.execute(s.substring(0, s.length() - 1));
                }
                catch (SQLException e) {
                    LOG.error("statement <" + s.substring(0, s.length() - 2) + "> failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            LOG.error("Caught IOException trying to read modified create user script " + createFile.getAbsolutePath(), (Throwable)e);
            throw new HiveMetaException(e);
        }
        catch (HiveMetaException e) {
            LOG.error("Failed to connect to RDBMS", (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            LOG.error("Got SQLException", (Throwable)e);
        }
    }
}

