/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionTxnHandler
extends TxnHandler {
    private static final String CLASS_NAME = CompactionTxnHandler.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int abortedThreshold, long abortedTimeThreshold) throws MetaException {
        return this.findPotentialCompactions(abortedThreshold, abortedTimeThreshold, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int abortedThreshold, long abortedTimeThreshold, long checkInterval) throws MetaException {
        Connection dbConn = null;
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "SELECT DISTINCT \"TC\".\"CTC_DATABASE\", \"TC\".\"CTC_TABLE\", \"TC\".\"CTC_PARTITION\" FROM \"COMPLETED_TXN_COMPONENTS\" \"TC\" " + (checkInterval > 0L ? "LEFT JOIN (   SELECT \"C1\".* FROM \"COMPLETED_COMPACTIONS\" \"C1\"   INNER JOIN (     SELECT MAX(\"CC_ID\") \"CC_ID\" FROM \"COMPLETED_COMPACTIONS\"     GROUP BY \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\"  ) \"C2\"   ON \"C1\".\"CC_ID\" = \"C2\".\"CC_ID\"   WHERE \"C1\".\"CC_STATE\" IN (" + CompactionTxnHandler.quoteChar('a') + "," + CompactionTxnHandler.quoteChar('f') + ")" + ") \"C\" " + "ON \"TC\".\"CTC_DATABASE\" = \"C\".\"CC_DATABASE\" AND \"TC\".\"CTC_TABLE\" = \"C\".\"CC_TABLE\" " + "  AND (\"TC\".\"CTC_PARTITION\" = \"C\".\"CC_PARTITION\" OR (\"TC\".\"CTC_PARTITION\" IS NULL AND \"C\".\"CC_PARTITION\" IS NULL)) " + "WHERE \"C\".\"CC_ID\" IS NOT NULL OR " + this.isWithinCheckInterval("\"TC\".\"CTC_TIMESTAMP\"", checkInterval) : "");
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                while (rs.next()) {
                    CompactionInfo info = new CompactionInfo();
                    info.dbname = rs.getString(1);
                    info.tableName = rs.getString(2);
                    info.partName = rs.getString(3);
                    response.add(info);
                }
                rs.close();
                boolean checkAbortedTimeThreshold = abortedTimeThreshold >= 0L;
                String sCheckAborted = "SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\",MIN(\"TXN_STARTED\"), COUNT(*)FROM \"TXNS\", \"TXN_COMPONENTS\" WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = 'a' GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\"" + (checkAbortedTimeThreshold ? "" : " HAVING COUNT(*) > " + abortedThreshold);
                LOG.debug("Going to execute query <" + sCheckAborted + ">");
                rs = stmt.executeQuery(sCheckAborted);
                long systemTime = System.currentTimeMillis();
                while (rs.next()) {
                    boolean pastTimeThreshold = checkAbortedTimeThreshold && rs.getLong(4) + abortedTimeThreshold < systemTime;
                    int numAbortedTxns = rs.getInt(5);
                    if (numAbortedTxns <= abortedThreshold && !pastTimeThreshold) continue;
                    CompactionInfo info = new CompactionInfo();
                    info.dbname = rs.getString(1);
                    info.tableName = rs.getString(2);
                    info.partName = rs.getString(3);
                    info.tooManyAborts = numAbortedTxns > abortedThreshold;
                    info.hasOldAbort = pastTimeThreshold;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found potential compaction: " + info.toString());
                    }
                    response.add(info);
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to connect to transaction database " + e.getMessage());
                    this.checkRetryable(dbConn, e, "findPotentialCompactions(maxAborted:" + abortedThreshold + ", abortedTimeThreshold:" + abortedTimeThreshold + ")");
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
                CompactionTxnHandler.close(rs, stmt, dbConn);
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
            return response;
        }
        catch (TxnHandler.RetryException e) {
            return this.findPotentialCompactions(abortedThreshold, abortedTimeThreshold, checkInterval);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.SafeToRetry
    public CompactionInfo findNextToCompact(String workerId) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void markCompacted(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_STATE\" = 'r', \"CQ_WORKER_ID\" = NULL WHERE \"CQ_ID\" = " + info.id;
                LOG.debug("Going to execute update <" + s + ">");
                int updCnt = stmt.executeUpdate(s);
                if (updCnt != 1) {
                    LOG.error("Unable to set cq_state=r for compaction record: " + info + ". updCnt=" + updCnt);
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to update compaction queue " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "markCompacted(" + info + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCompacted(info);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToClean() throws MetaException {
        ArrayList<CompactionInfo> arrayList;
        Connection dbConn = null;
        ArrayList<CompactionInfo> rc = new ArrayList<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_TYPE\", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_STATE\" = 'r'";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                CompactionInfo info = new CompactionInfo();
                info.id = rs.getLong(1);
                info.dbname = rs.getString(2);
                info.tableName = rs.getString(3);
                info.partName = rs.getString(4);
                switch (rs.getString(5).charAt(0)) {
                    case 'a': {
                        info.type = CompactionType.MAJOR;
                        break;
                    }
                    case 'i': {
                        info.type = CompactionType.MINOR;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction type " + rs.getString(5));
                    }
                }
                info.runAs = rs.getString(6);
                info.highestWriteId = rs.getLong(7);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found ready to clean: " + info.toString());
                }
                rc.add(info);
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            arrayList = rc;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("Unable to select next element for cleaning, " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findReadyToClean");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException e2) {
                return this.findReadyToClean();
            }
        }
        CompactionTxnHandler.close(rs, stmt, dbConn);
        return arrayList;
    }

    @Override
    public long findMinOpenTxnId() throws MetaException {
        long l;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            l = this.findMinOpenTxnGLB(stmt);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("Unable to findMinOpenTxnId() due to:" + e.getMessage());
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findMinOpenTxnId");
                    throw new MetaException("Unable to execute findMinOpenTxnId() " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException e2) {
                return this.findMinOpenTxnId();
            }
        }
        CompactionTxnHandler.close(rs, stmt, dbConn);
        return l;
    }

    private long findMinOpenTxnGLB(Statement stmt) throws MetaException, SQLException {
        String s = "SELECT \"NTXN_NEXT\" FROM \"NEXT_TXN_ID\"";
        LOG.debug("Going to execute query <" + s + ">");
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
        }
        long hwm = rs.getLong(1);
        s = "SELECT MIN(\"MHL_MIN_OPEN_TXNID\") FROM \"MIN_HISTORY_LEVEL\"";
        LOG.debug("Going to execute query <" + s + ">");
        rs = stmt.executeQuery(s);
        rs.next();
        long minOpenTxnId = rs.getLong(1);
        if (rs.wasNull()) {
            return hwm;
        }
        assert (hwm >= minOpenTxnId) : "(hwm, minOpenTxnId)=(" + hwm + "," + minOpenTxnId + ")";
        return minOpenTxnId;
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markCleaned(CompactionInfo info) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running markCleaned with CompactionInfo: " + info.toString());
        }
        try {
            Connection dbConn = null;
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                dbConn = this.getDbConn(2);
                pStmt = dbConn.prepareStatement("SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_STATE\", \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\", \"CQ_START\", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\", \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ?");
                pStmt.setLong(1, info.id);
                rs = pStmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalStateException("No record with CQ_ID=" + info.id + " found in COMPACTION_QUEUE");
                }
                info = CompactionInfo.loadFullFromCompactionQueue(rs);
                CompactionTxnHandler.close(rs);
                String s = "delete from \"COMPACTION_QUEUE\" where \"CQ_ID\" = ?";
                pStmt = dbConn.prepareStatement(s);
                pStmt.setLong(1, info.id);
                LOG.debug("Going to execute update <" + s + ">");
                int updCount = pStmt.executeUpdate();
                if (updCount != 1) {
                    LOG.error("Unable to delete compaction record: " + info + ".  Update count=" + updCount);
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                }
                s = "INSERT INTO \"COMPLETED_COMPACTIONS\"(\"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\", \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\", \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\") VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?)";
                pStmt = dbConn.prepareStatement(s);
                info.state = (char)115;
                long enqueueTime = this.getDbTime(dbConn);
                CompactionInfo.insertIntoCompletedCompactions(pStmt, info, this.getDbTime(dbConn));
                LOG.debug("Going to execute update <" + s + "> with parameter enqueue time: " + enqueueTime);
                updCount = pStmt.executeUpdate();
                s = "DELETE FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_DATABASE\" = ? AND \"CTC_TABLE\" = ?";
                if (info.partName != null) {
                    s = s + " AND \"CTC_PARTITION\" = ?";
                }
                if (info.highestWriteId != 0L) {
                    s = s + " AND \"CTC_WRITEID\" <= ?";
                }
                pStmt = dbConn.prepareStatement(s);
                int paramCount = 1;
                pStmt.setString(paramCount++, info.dbname);
                pStmt.setString(paramCount++, info.tableName);
                if (info.partName != null) {
                    pStmt.setString(paramCount++, info.partName);
                }
                if (info.highestWriteId != 0L) {
                    pStmt.setLong(paramCount++, info.highestWriteId);
                }
                LOG.debug("Going to execute update <" + s + ">");
                updCount = pStmt.executeUpdate();
                if (updCount < 1) {
                    LOG.error("Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
                }
                LOG.debug("Removed " + updCount + " records from completed_txn_components");
                s = "SELECT DISTINCT \"TXN_ID\" FROM \"TXNS\", \"TXN_COMPONENTS\" WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = 'a' AND \"TC_DATABASE\" = ? AND \"TC_TABLE\" = ?";
                if (info.highestWriteId != 0L) {
                    s = s + " AND \"TC_WRITEID\" <= ?";
                }
                if (info.partName != null) {
                    s = s + " AND \"TC_PARTITION\" = ?";
                }
                pStmt = dbConn.prepareStatement(s);
                paramCount = 1;
                pStmt.setString(paramCount++, info.dbname);
                pStmt.setString(paramCount++, info.tableName);
                if (info.highestWriteId != 0L) {
                    pStmt.setLong(paramCount++, info.highestWriteId);
                }
                if (info.partName != null) {
                    pStmt.setString(paramCount++, info.partName);
                }
                LOG.debug("Going to execute update <" + s + ">");
                rs = pStmt.executeQuery();
                ArrayList<Long> txnids = new ArrayList<Long>();
                ArrayList<String> questions = new ArrayList<String>();
                while (rs.next()) {
                    long id = rs.getLong(1);
                    txnids.add(id);
                    questions.add("?");
                }
                if (txnids.size() > 0) {
                    ArrayList<String> queries = new ArrayList<String>();
                    StringBuilder prefix = new StringBuilder();
                    StringBuilder suffix = new StringBuilder();
                    prefix.append("DELETE FROM \"TXN_COMPONENTS\" WHERE ");
                    suffix.append(" AND \"TC_DATABASE\" = ?");
                    suffix.append(" AND \"TC_TABLE\" = ?");
                    if (info.partName != null) {
                        suffix.append(" AND \"TC_PARTITION\" = ?");
                    }
                    List<Integer> counts = TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, suffix, questions, "\"TC_TXNID\"", true, false);
                    int totalCount = 0;
                    for (int i = 0; i < queries.size(); ++i) {
                        String query = (String)queries.get(i);
                        int insertCount = counts.get(i);
                        LOG.debug("Going to execute update <" + query + ">");
                        pStmt = dbConn.prepareStatement(query);
                        for (int j = 0; j < insertCount; ++j) {
                            pStmt.setLong(j + 1, (Long)txnids.get(totalCount + j));
                        }
                        totalCount += insertCount;
                        paramCount = insertCount + 1;
                        pStmt.setString(paramCount++, info.dbname);
                        pStmt.setString(paramCount++, info.tableName);
                        if (info.partName != null) {
                            pStmt.setString(paramCount++, info.partName);
                        }
                        int rc = pStmt.executeUpdate();
                        LOG.debug("Removed " + rc + " records from txn_components");
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from compaction queue " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "markCleaned(" + info + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, pStmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCleaned(info);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanTxnToWriteIdTable() throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                long minAbortedTxnId;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                long minUncommittedTxnId = this.findMinOpenTxnGLB(stmt);
                String s = "SELECT MIN(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STATE\" = " + CompactionTxnHandler.quoteChar('a');
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next() && (minAbortedTxnId = rs.getLong(1)) > 0L) {
                    minUncommittedTxnId = Math.min(minAbortedTxnId, minUncommittedTxnId);
                }
                s = "DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" < " + minUncommittedTxnId;
                LOG.debug("Going to execute delete <" + s + ">");
                int rc = stmt.executeUpdate(s);
                LOG.info("Removed " + rc + " rows from TXN_TO_WRITE_ID with Txn Low-Water-Mark: " + minUncommittedTxnId);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from txns table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "cleanTxnToWriteIdTable");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.cleanTxnToWriteIdTable();
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanEmptyAbortedTxns() throws MetaException {
        try {
            ArrayList<Long> txnids;
            ResultSet rs;
            Statement stmt;
            Connection dbConn;
            block9: {
                dbConn = null;
                stmt = null;
                rs = null;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "SELECT \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_ID\" NOT IN (SELECT \"TC_TXNID\" FROM \"TXN_COMPONENTS\") AND \"TXN_STATE\" = 'a'";
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                txnids = new ArrayList<Long>();
                while (rs.next()) {
                    txnids.add(rs.getLong(1));
                }
                CompactionTxnHandler.close(rs);
                if (txnids.size() > 0) break block9;
                CompactionTxnHandler.close(rs, stmt, dbConn);
                return;
            }
            try {
                Collections.sort(txnids);
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder();
                StringBuilder suffix = new StringBuilder();
                prefix.append("DELETE FROM \"TXNS\" WHERE ");
                suffix.append("");
                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"TXN_ID\"", false, false);
                for (String query : queries) {
                    LOG.debug("Going to execute update <" + query + ">");
                    int rc = stmt.executeUpdate(query);
                    LOG.info("Removed " + rc + "  empty Aborted transactions from TXNS");
                }
                LOG.info("Aborted transactions removed from TXNS: " + txnids);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from txns table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "cleanEmptyAbortedTxns");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.cleanEmptyAbortedTxns();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeFromLocalWorkers(String hostname) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_WORKER_ID\" = NULL, \"CQ_START\" = NULL, \"CQ_STATE\" = 'i' WHERE \"CQ_STATE\" = 'w' AND \"CQ_WORKER_ID\" LIKE '" + hostname + "%'";
                LOG.debug("Going to execute update <" + s + ">");
                int updated = stmt.executeUpdate(s);
                LOG.debug("Set " + updated + " compaction queue entries to " + "initiated" + " state for host " + hostname);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to change dead worker's records back to initiated state " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "revokeFromLocalWorkers(hostname:" + hostname + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeFromLocalWorkers(hostname);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeTimedoutWorkers(long timeout) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                long latestValidStart = this.getDbTime(dbConn) - timeout;
                stmt = dbConn.createStatement();
                String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_WORKER_ID\" = NULL, \"CQ_START\" = NULL, \"CQ_STATE\" = 'i' WHERE \"CQ_STATE\" = 'w' AND \"CQ_START\" < " + latestValidStart;
                LOG.debug("Going to execute update <" + s + ">");
                int updated = stmt.executeUpdate(s);
                LOG.info(updated + " compaction queue entries timed out, set back to " + "initiated" + " state. Latest " + "valid start: " + latestValidStart);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to change dead worker's records back to initiated state " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "revokeTimedoutWorkers(timeout:" + timeout + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeTimedoutWorkers(timeout);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<String> findColumnsWithStats(CompactionInfo ci) throws MetaException {
        ArrayList<String> arrayList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding columns with statistics info for CompactionInfo: " + ci.toString());
        }
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            String quote = this.getIdentifierQuoteString(dbConn);
            StringBuilder bldr = new StringBuilder();
            bldr.append("SELECT ").append(quote).append("COLUMN_NAME").append(quote).append(" FROM ").append(quote).append(ci.partName == null ? "TAB_COL_STATS" : "PART_COL_STATS").append(quote).append(" WHERE ").append(quote).append("DB_NAME").append(quote).append(" = ?").append(" AND ").append(quote).append("TABLE_NAME").append(quote).append(" = ?");
            if (ci.partName != null) {
                bldr.append(" AND ").append(quote).append("PARTITION_NAME").append(quote).append(" = ?");
            }
            String s = bldr.toString();
            pStmt = dbConn.prepareStatement(s);
            pStmt.setString(1, ci.dbname);
            pStmt.setString(2, ci.tableName);
            if (ci.partName != null) {
                pStmt.setString(3, ci.partName);
            }
            LOG.debug("Going to execute <" + s + ">");
            rs = pStmt.executeQuery();
            ArrayList<String> columns = new ArrayList<String>();
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            LOG.debug("Found columns to update stats: " + columns + " on " + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName));
            dbConn.commit();
            arrayList = columns;
        }
        catch (SQLException e) {
            try {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findColumnsWithStats(" + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName) + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException ex) {
                return this.findColumnsWithStats(ci);
            }
        }
        CompactionTxnHandler.close(rs, pStmt, dbConn);
        return arrayList;
    }

    @Override
    public void updateCompactorState(CompactionInfo ci, long compactionTxnId) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                int updCount;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String sqlText = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_HIGHEST_WRITE_ID\" = " + ci.highestWriteId + ", \"CQ_RUN_AS\" = " + CompactionTxnHandler.quoteString(ci.runAs) + " WHERE \"CQ_ID\" = " + ci.id;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("About to execute: " + sqlText);
                }
                if ((updCount = stmt.executeUpdate(sqlText)) != 1) {
                    throw new IllegalStateException("Could not find record in COMPACTION_QUEUE for " + ci);
                }
                sqlText = "INSERT INTO \"TXN_COMPONENTS\"(\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", " + (ci.partName == null ? "" : "\"TC_PARTITION\", ") + "\"TC_WRITEID\", " + "\"TC_OPERATION_TYPE\")" + " VALUES(" + compactionTxnId + "," + CompactionTxnHandler.quoteString(ci.dbname) + "," + CompactionTxnHandler.quoteString(ci.tableName) + "," + (ci.partName == null ? "" : CompactionTxnHandler.quoteString(ci.partName) + ",") + ci.highestWriteId + ", " + CompactionTxnHandler.quoteChar(TxnHandler.OperationType.COMPACT.getSqlConst()) + ")";
                if (LOG.isDebugEnabled()) {
                    LOG.debug("About to execute: " + sqlText);
                }
                if ((updCount = stmt.executeUpdate(sqlText)) != 1) {
                    throw new IllegalStateException("Could not find record in COMPACTION_QUEUE for " + ci);
                }
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "updateCompactorState(" + ci + "," + compactionTxnId + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(null, stmt, dbConn);
        }
        catch (TxnHandler.RetryException ex) {
            this.updateCompactorState(ci, compactionTxnId);
        }
    }

    private void checkForDeletion(List<Long> deleteSet, CompactionInfo ci, RetentionCounters rc) {
        switch (ci.state) {
            case 'a': {
                if (--rc.attemptedRetention >= 0) break;
                deleteSet.add(ci.id);
                break;
            }
            case 'f': {
                if (--rc.failedRetention >= 0) break;
                deleteSet.add(ci.id);
                break;
            }
            case 's': {
                if (--rc.succeededRetention >= 0) break;
                deleteSet.add(ci.id);
                break;
            }
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void purgeCompactionHistory() throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        ArrayList<Long> deleteSet = new ArrayList<Long>();
        RetentionCounters rc = null;
        try {
            block12: {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery("SELECT \"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\" FROM \"COMPLETED_COMPACTIONS\" ORDER BY \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_ID\" DESC");
                String lastCompactedEntity = null;
                while (rs.next()) {
                    CompactionInfo ci = new CompactionInfo(rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5).charAt(0));
                    if (!ci.getFullPartitionName().equals(lastCompactedEntity)) {
                        lastCompactedEntity = ci.getFullPartitionName();
                        rc = new RetentionCounters(MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED), this.getFailedCompactionRetention(), MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED));
                    }
                    this.checkForDeletion(deleteSet, ci, rc);
                }
                CompactionTxnHandler.close(rs);
                if (deleteSet.size() > 0) break block12;
                CompactionTxnHandler.close(rs, stmt, dbConn);
                CompactionTxnHandler.closeStmt(pStmt);
                return;
            }
            try {
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder();
                StringBuilder suffix = new StringBuilder();
                prefix.append("DELETE FROM \"COMPLETED_COMPACTIONS\" WHERE ");
                ArrayList<String> questions = new ArrayList<String>(deleteSet.size());
                for (int i = 0; i < deleteSet.size(); ++i) {
                    questions.add("?");
                }
                List<Integer> counts = TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, suffix, questions, "\"CC_ID\"", false, false);
                int totalCount = 0;
                for (int i = 0; i < queries.size(); ++i) {
                    String query = (String)queries.get(i);
                    long insertCount = counts.get(i).intValue();
                    LOG.debug("Going to execute update <" + query + ">");
                    pStmt = dbConn.prepareStatement(query);
                    int j = 0;
                    while ((long)j < insertCount) {
                        pStmt.setLong(j + 1, (Long)deleteSet.get(totalCount + j));
                        ++j;
                    }
                    totalCount = (int)((long)totalCount + insertCount);
                    int count = pStmt.executeUpdate();
                    LOG.debug("Removed " + count + " records from COMPLETED_COMPACTIONS");
                }
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "purgeCompactionHistory()");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    CompactionTxnHandler.closeStmt(pStmt);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
            CompactionTxnHandler.closeStmt(pStmt);
        }
        catch (TxnHandler.RetryException ex) {
            this.purgeCompactionHistory();
        }
    }

    private int getFailedCompactionRetention() {
        int failedThreshold = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        int failedRetention = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED);
        if (failedRetention < failedThreshold) {
            LOG.warn("Invalid configuration " + MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname() + "=" + failedRetention + " < " + (Object)((Object)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + "=" + failedRetention + ".  Will use " + MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname() + "=" + failedRetention);
            failedRetention = failedThreshold;
        }
        return failedRetention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public boolean checkFailedCompactions(CompactionInfo ci) throws MetaException {
        boolean bl;
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            pStmt = dbConn.prepareStatement("SELECT \"CC_STATE\" FROM \"COMPLETED_COMPACTIONS\" WHERE \"CC_DATABASE\" = ? AND \"CC_TABLE\" = ? " + (ci.partName != null ? "AND \"CC_PARTITION\" = ?" : "") + " AND \"CC_STATE\" != " + CompactionTxnHandler.quoteChar('a') + " ORDER BY \"CC_ID\" DESC");
            pStmt.setString(1, ci.dbname);
            pStmt.setString(2, ci.tableName);
            if (ci.partName != null) {
                pStmt.setString(3, ci.partName);
            }
            rs = pStmt.executeQuery();
            int numFailed = 0;
            int numTotal = 0;
            int failedThreshold = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
            while (rs.next() && ++numTotal <= failedThreshold) {
                if (rs.getString(1).charAt(0) == 'f') {
                    ++numFailed;
                    continue;
                }
                --numFailed;
            }
            bl = numFailed == failedThreshold;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                LOG.error("Unable to check for failed compactions " + e.getMessage());
                LOG.debug("Going to rollback");
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "checkFailedCompactions(" + ci + ")");
                LOG.error("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
                catch (TxnHandler.RetryException e2) {
                    return this.checkFailedCompactions(ci);
                }
            }
            CompactionTxnHandler.close(rs, pStmt, dbConn);
            return bl2;
        }
        CompactionTxnHandler.close(rs, pStmt, dbConn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.CannotRetry
    public void markFailed(CompactionInfo ci) throws MetaException {
        block14: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Marking as failed: CompactionInfo: " + ci.toString());
            }
            try {
                Connection dbConn = null;
                Statement stmt = null;
                PreparedStatement pStmt = null;
                ResultSet rs = null;
                String errorMessage = ci.errorMessage;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    pStmt = dbConn.prepareStatement("SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_STATE\", \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\", \"CQ_START\", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\", \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ?");
                    pStmt.setLong(1, ci.id);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        ci = CompactionInfo.loadFullFromCompactionQueue(rs);
                        String s = "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ?";
                        pStmt = dbConn.prepareStatement(s);
                        pStmt.setLong(1, ci.id);
                        LOG.debug("Going to execute update <" + s + ">");
                        int n = pStmt.executeUpdate();
                    } else if (ci.id > 0L) {
                        throw new IllegalStateException("No record with CQ_ID=" + ci.id + " found in COMPACTION_QUEUE");
                    }
                    if (ci.id == 0L) {
                        ci.id = this.generateCompactionQueueId(stmt);
                        ci.state = (char)97;
                        if (ci.type == null) {
                            ci.type = CompactionType.MINOR;
                        }
                        ci.start = this.getDbTime(dbConn);
                        LOG.debug("The failure occurred before we even made an entry in COMPACTION_QUEUE. Generated ID so that we can make an entry in COMPLETED_COMPACTIONS. New Id: " + ci.id);
                    } else {
                        ci.state = (char)102;
                    }
                    CompactionTxnHandler.close(rs, stmt, null);
                    CompactionTxnHandler.closeStmt(pStmt);
                    pStmt = dbConn.prepareStatement("INSERT INTO \"COMPLETED_COMPACTIONS\" (\"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\", \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\", \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\") VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?)");
                    if (errorMessage != null) {
                        ci.errorMessage = errorMessage;
                    }
                    CompactionInfo.insertIntoCompletedCompactions(pStmt, ci, this.getDbTime(dbConn));
                    int updCount = pStmt.executeUpdate();
                    LOG.debug("Inserted " + updCount + " entries into COMPLETED_COMPACTIONS");
                    LOG.debug("Going to commit");
                    CompactionTxnHandler.closeStmt(pStmt);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.warn("markFailed(" + ci.id + "):" + e.getMessage());
                        LOG.debug("Going to rollback");
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "markFailed(" + ci + ")");
                        LOG.error("markFailed(" + ci + ") failed: " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(rs, stmt, null);
                        CompactionTxnHandler.close(null, pStmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(rs, stmt, null);
                    CompactionTxnHandler.close(null, pStmt, dbConn);
                    break block14;
                }
                CompactionTxnHandler.close(rs, stmt, null);
                CompactionTxnHandler.close(null, pStmt, dbConn);
            }
            catch (TxnHandler.RetryException e) {
                this.markFailed(ci);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.Idempotent
    public void setHadoopJobId(String hadoopJobId, long id) {
        block6: {
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_HADOOP_JOB_ID\" = " + CompactionTxnHandler.quoteString(hadoopJobId) + " WHERE \"CQ_ID\" = " + id;
                    LOG.debug("Going to execute <" + s + ">  with jobId: " + hadoopJobId + " and CQ id: " + id);
                    int updateCount = stmt.executeUpdate(s);
                    LOG.debug("Going to commit");
                    CompactionTxnHandler.closeStmt(stmt);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.warn("setHadoopJobId(" + hadoopJobId + "," + id + "):" + e.getMessage());
                        LOG.debug("Going to rollback");
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "setHadoopJobId(" + hadoopJobId + "," + id + ")");
                        LOG.error("setHadoopJobId(" + hadoopJobId + "," + id + ") failed: " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(null, stmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    break block6;
                }
                CompactionTxnHandler.close(null, stmt, dbConn);
            }
            catch (TxnHandler.RetryException e) {
                this.setHadoopJobId(hadoopJobId, id);
            }
        }
    }

    private static class RetentionCounters {
        int attemptedRetention = 0;
        int failedRetention = 0;
        int succeededRetention = 0;

        RetentionCounters(int attemptedRetention, int failedRetention, int succeededRetention) {
            this.attemptedRetention = attemptedRetention;
            this.failedRetention = failedRetention;
            this.succeededRetention = succeededRetention;
        }
    }
}

