/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.io;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class CacheTag
implements Comparable<CacheTag> {
    private static final String ENCODING = "UTF-8";
    protected final String tableName;

    private CacheTag(String tableName) {
        this.tableName = tableName.intern();
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public int compareTo(CacheTag o) {
        if (o == null) {
            return 1;
        }
        return this.tableName.compareTo(o.tableName);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CacheTag)) {
            return false;
        }
        return this.compareTo((CacheTag)obj) == 0;
    }

    public int hashCode() {
        int res = this.tableName.hashCode();
        return res;
    }

    public static final CacheTag build(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new IllegalArgumentException();
        }
        return new TableCacheTag(tableName);
    }

    public static final CacheTag build(String tableName, Map<String, String> partDescMap) {
        if (StringUtils.isEmpty((String)tableName) || partDescMap == null || partDescMap.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] partDescs = new String[partDescMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : partDescMap.entrySet()) {
            partDescs[i++] = CacheTag.encodePartDesc(entry.getKey(), entry.getValue());
        }
        if (partDescs.length == 1) {
            return new SinglePartitionCacheTag(tableName, partDescs[0]);
        }
        return new MultiPartitionCacheTag(tableName, partDescs);
    }

    public static final CacheTag createParentCacheTag(CacheTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException();
        }
        if (tag instanceof MultiPartitionCacheTag) {
            MultiPartitionCacheTag multiPartitionCacheTag = (MultiPartitionCacheTag)tag;
            if (multiPartitionCacheTag.partitionDesc.length > 2) {
                String[] subList = new String[multiPartitionCacheTag.partitionDesc.length - 1];
                for (int i = 0; i < subList.length; ++i) {
                    subList[i] = multiPartitionCacheTag.partitionDesc[i];
                }
                return new MultiPartitionCacheTag(multiPartitionCacheTag.tableName, subList);
            }
            return new SinglePartitionCacheTag(multiPartitionCacheTag.tableName, multiPartitionCacheTag.partitionDesc[0]);
        }
        if (tag instanceof SinglePartitionCacheTag) {
            return new TableCacheTag(tag.tableName);
        }
        int ix = tag.tableName.indexOf(".");
        if (ix <= 0) {
            return null;
        }
        return new TableCacheTag(tag.tableName.substring(0, ix));
    }

    private static String encodePartDesc(String partKey, String partVal) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(URLEncoder.encode(partKey, ENCODING)).append('=').append(URLEncoder.encode(partVal, ENCODING));
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] decodePartDesc(String partDesc) {
        try {
            String[] encodedPartDesc = partDesc.split("=");
            assert (encodedPartDesc.length == 2);
            return new String[]{URLDecoder.decode(encodedPartDesc[0], ENCODING), URLDecoder.decode(encodedPartDesc[1], ENCODING)};
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class MultiPartitionCacheTag
    extends PartitionCacheTag {
        private final String[] partitionDesc;

        private MultiPartitionCacheTag(String tableName, String[] partitionDesc) {
            super(tableName);
            if (partitionDesc != null && partitionDesc.length > 1) {
                for (int i = 0; i < partitionDesc.length; ++i) {
                    partitionDesc[i] = partitionDesc[i].intern();
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.partitionDesc = partitionDesc;
        }

        @Override
        public int compareTo(CacheTag o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof TableCacheTag || o instanceof SinglePartitionCacheTag) {
                return 1;
            }
            MultiPartitionCacheTag other = (MultiPartitionCacheTag)o;
            int tableNameDiff = super.compareTo(other);
            if (tableNameDiff != 0) {
                return tableNameDiff;
            }
            int sizeDiff = this.partitionDesc.length - other.partitionDesc.length;
            if (sizeDiff != 0) {
                return sizeDiff;
            }
            for (int i = 0; i < this.partitionDesc.length; ++i) {
                int partDiff = this.partitionDesc[i].compareTo(other.partitionDesc[i]);
                if (partDiff == 0) continue;
                return partDiff;
            }
            return 0;
        }

        @Override
        public int hashCode() {
            int res = super.hashCode();
            for (String p : this.partitionDesc) {
                res += p.hashCode();
            }
            return res;
        }

        @Override
        public String partitionDescToString() {
            StringBuilder sb = new StringBuilder();
            for (String partDesc : this.partitionDesc) {
                String[] partition = CacheTag.decodePartDesc(partDesc);
                sb.append(partition[0]).append('=').append(partition[1]);
                sb.append('/');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        @Override
        public Map<String, String> getPartitionDescMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String partDesc : this.partitionDesc) {
                String[] partition = CacheTag.decodePartDesc(partDesc);
                result.put(partition[0], partition[1]);
            }
            return result;
        }
    }

    public static final class SinglePartitionCacheTag
    extends PartitionCacheTag {
        private final String partitionDesc;

        private SinglePartitionCacheTag(String tableName, String partitionDesc) {
            super(tableName);
            if (StringUtils.isEmpty((String)partitionDesc)) {
                throw new IllegalArgumentException();
            }
            this.partitionDesc = partitionDesc.intern();
        }

        @Override
        public String partitionDescToString() {
            return String.join((CharSequence)"=", CacheTag.decodePartDesc(this.partitionDesc));
        }

        @Override
        public Map<String, String> getPartitionDescMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            String[] partition = CacheTag.decodePartDesc(this.partitionDesc);
            result.put(partition[0], partition[1]);
            return result;
        }

        @Override
        public int compareTo(CacheTag o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof TableCacheTag) {
                return 1;
            }
            if (o instanceof MultiPartitionCacheTag) {
                return -1;
            }
            SinglePartitionCacheTag other = (SinglePartitionCacheTag)o;
            int tableNameDiff = super.compareTo(other);
            if (tableNameDiff != 0) {
                return tableNameDiff;
            }
            return this.partitionDesc.compareTo(other.partitionDesc);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.partitionDesc.hashCode();
        }
    }

    public static abstract class PartitionCacheTag
    extends CacheTag {
        private PartitionCacheTag(String tableName) {
            super(tableName);
        }

        public abstract String partitionDescToString();

        public abstract Map<String, String> getPartitionDescMap();
    }

    public static final class TableCacheTag
    extends CacheTag {
        private TableCacheTag(String tableName) {
            super(tableName);
        }

        @Override
        public int compareTo(CacheTag o) {
            if (o == null) {
                return 1;
            }
            if (o instanceof SinglePartitionCacheTag || o instanceof MultiPartitionCacheTag) {
                return -1;
            }
            return super.compareTo(o);
        }
    }
}

