/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.schshim;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.schshim.QueueAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairSchedulerQueueAllocator
implements QueueAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(FairSchedulerQueueAllocator.class);
    private static final String YARN_SCHEDULER_FILE_PROPERTY = "yarn.scheduler.fair.allocation.file";
    private String currentlyWatching;
    private AllocationFileLoaderService loaderService;
    private final AtomicReference<AllocationConfiguration> allocationConfiguration = new AtomicReference();

    @Override
    public synchronized AtomicReference<AllocationConfiguration> makeConfigurationFor(Configuration config, String username) throws IOException {
        this.updateWatcher(config);
        return this.allocationConfiguration;
    }

    @Override
    public synchronized void refresh(Configuration config) {
        this.updateWatcher(config);
    }

    @VisibleForTesting
    public String getCurrentlyWatchingFile() {
        return this.currentlyWatching;
    }

    private void updateWatcher(Configuration config) {
        if (this.loaderService != null && StringUtils.equals((String)this.currentlyWatching, (String)config.get(YARN_SCHEDULER_FILE_PROPERTY))) {
            return;
        }
        this.currentlyWatching = config.get(YARN_SCHEDULER_FILE_PROPERTY);
        if (this.loaderService != null) {
            this.loaderService.stop();
        }
        this.loaderService = new AllocationFileLoaderService();
        this.loaderService.init(config);
        this.loaderService.setReloadListener(new AllocationFileLoaderService.Listener(){

            public void onReload(AllocationConfiguration allocs) {
                FairSchedulerQueueAllocator.this.allocationConfiguration.set(allocs);
            }
        });
        try {
            this.loaderService.reloadAllocations();
        }
        catch (Exception ex) {
            LOG.error("Failed to load queue allocations", (Throwable)ex);
        }
        if (this.allocationConfiguration.get() == null) {
            this.allocationConfiguration.set(new AllocationConfiguration(config));
        }
        this.loaderService.start();
    }
}

