/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.spark.IgniteContext$;
import org.apache.ignite.spark.IgniteRDD;
import org.apache.ignite.spark.Logging$;
import org.apache.ignite.spark.Once;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001-\u0011Q\"S4oSR,7i\u001c8uKb$(BA\u0002\u0005\u0003\u0015\u0019\b/\u0019:l\u0015\t)a!\u0001\u0004jO:LG/\u001a\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011Y\u0001!Q1A\u0005\u0002]\tAb\u001d9be.\u001cuN\u001c;fqR,\u0012\u0001\u0007\t\u00033mi\u0011A\u0007\u0006\u0003\u0007\u0019I!\u0001\b\u000e\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011y\u0001!\u0011!Q\u0001\na\tQb\u001d9be.\u001cuN\u001c;fqR\u0004\u0003FA\u000f!!\ti\u0011%\u0003\u0002#\u001d\tIAO]1og&,g\u000e\u001e\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005!1MZ4G!\ria\u0005K\u0005\u0003O9\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\"\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002.U\t\u0019\u0012j\u001a8ji\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"Aq\u0006\u0001B\u0001B\u0003%\u0001'\u0001\u0006ti\u0006tG-\u00197p]\u0016\u0004\"!D\u0019\n\u0005Ir!a\u0002\"p_2,\u0017M\u001c\u0005\u0006i\u0001!\t!N\u0001\u0007y%t\u0017\u000e\u001e \u0015\tYB\u0014H\u000f\t\u0003o\u0001i\u0011A\u0001\u0005\u0006-M\u0002\r\u0001\u0007\u0005\u0006IM\u0002\r!\n\u0005\b_M\u0002\n\u00111\u00011\u0011\u001da\u0004A1A\u0005\nu\naa\u00194h\u00072|W#\u0001 \u0011\u0005]z\u0014B\u0001!\u0003\u0005\u0011yenY3\t\r\t\u0003\u0001\u0015!\u0003?\u0003\u001d\u0019gmZ\"m_\u0002Bq\u0001\u0012\u0001C\u0002\u0013%Q)\u0001\u0006jO:LG/\u001a%p[\u0016,\u0012A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019\u0019FO]5oO\"1q\n\u0001Q\u0001\n\u0019\u000b1\"[4oSR,\u0007j\\7fA!)A\u0007\u0001C\u0001#R!aG\u0015+]\u0011\u0015\u0019\u0006\u000b1\u0001\u0019\u0003\t\u00198\rC\u0003V!\u0002\u0007a+A\u0005taJLgnZ+sYB\u0011qK\u0017\b\u0003\u001baK!!\u0017\b\u0002\rA\u0013X\rZ3g\u0013\ti5L\u0003\u0002Z\u001d!)Q\f\u0015a\u0001a\u000511\r\\5f]RDQ\u0001\u000e\u0001\u0005\u0002}#2A\u000e1b\u0011\u0015\u0019f\f1\u0001\u0019\u0011\u0015)f\f1\u0001W\u0011\u0015!\u0004\u0001\"\u0001d)\t1D\rC\u0003TE\u0002\u0007\u0001\u0004C\u0004g\u0001\t\u0007I\u0011A4\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001i!\tIG.D\u0001k\u0015\tY'$A\u0002tc2L!!\u001c6\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0004p\u0001\u0001\u0006I\u0001[\u0001\fgFd7i\u001c8uKb$\b\u0005C\u0003r\u0001\u0011\u0005!/A\u0005ge>l7)Y2iKV!1/_A\u0004)\r!\u00181\u0002\t\u0006oU<\u0018QA\u0005\u0003m\n\u0011\u0011\"S4oSR,'\u000b\u0012#\u0011\u0005aLH\u0002\u0001\u0003\u0006uB\u0014\ra\u001f\u0002\u0002\u0017F\u0011Ap \t\u0003\u001buL!A \b\u0003\u000f9{G\u000f[5oOB\u0019Q\"!\u0001\n\u0007\u0005\raBA\u0002B]f\u00042\u0001_A\u0004\t\u0019\tI\u0001\u001db\u0001w\n\ta\u000b\u0003\u0004\u0002\u000eA\u0004\rAV\u0001\nG\u0006\u001c\u0007.\u001a(b[\u0016Da!\u001d\u0001\u0005\u0002\u0005EQCBA\n\u00033\ti\u0002\u0006\u0003\u0002\u0016\u0005}\u0001CB\u001cv\u0003/\tY\u0002E\u0002y\u00033!aA_A\b\u0005\u0004Y\bc\u0001=\u0002\u001e\u00119\u0011\u0011BA\b\u0005\u0004Y\b\u0002CA\u0011\u0003\u001f\u0001\r!a\t\u0002\u0011\r\f7\r[3DM\u001e\u0004r!KA\u0013\u0003/\tY\"C\u0002\u0002()\u0012!cQ1dQ\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"1Q\u0001\u0001C\u0001\u0003W!\"!!\f\u0011\t\u0005=\u0012\u0011G\u0007\u0002\t%\u0019\u00111\u0007\u0003\u0003\r%;g.\u001b;f\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\tQa\u00197pg\u0016$2\u0001MA\u001e\u0011%\ti$!\u000e\u0011\u0002\u0003\u0007\u0001'A\ftQV$Hm\\<o\u0013\u001et\u0017\u000e^3P]^{'o[3sg\"9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0013a\u00023p\u00072|7/\u001a\u000b\u0002a!I\u0011q\t\u0001\u0012\u0002\u0013\u0005\u0011\u0011J\u0001\u0010G2|7/\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\n\u0016\u0004a\u000553FAA(!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ec\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0018\u0002T\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0013\u0005\u0005$!!A\t\u0002\u0005\r\u0014!D%h]&$XmQ8oi\u0016DH\u000fE\u00028\u0003K2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qM\n\u0005\u0003Kb!\u0003C\u00045\u0003K\"\t!a\u001b\u0015\u0005\u0005\r\u0004BCA8\u0003K\n\n\u0011\"\u0001\u0002J\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!\"a\u001d\u0002f\u0005\u0005I\u0011BA;\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0004cA$\u0002z%\u0019\u00111\u0010%\u0003\r=\u0013'.Z2u\u0001")
public class IgniteContext
implements Serializable {
    private final transient SparkContext sparkContext;
    private final Once cfgClo;
    private final String igniteHome;
    private final SQLContext sqlContext;

    public static boolean $lessinit$greater$default$3() {
        return IgniteContext$.MODULE$.$lessinit$greater$default$3();
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    private Once cfgClo() {
        return this.cfgClo;
    }

    private String igniteHome() {
        return this.igniteHome;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public <K, V> IgniteRDD<K, V> fromCache(String cacheName) {
        return new IgniteRDD(this, cacheName, null, false);
    }

    public <K, V> IgniteRDD<K, V> fromCache(CacheConfiguration<K, V> cacheCfg) {
        return new IgniteRDD<K, V>(this, cacheCfg.getName(), cacheCfg, false);
    }

    public Ignite ignite() {
        Object object;
        String home = IgniteUtils.getIgniteHome();
        if (home == null && this.igniteHome() != null) {
            Logging$.MODULE$.log().info((Object)new StringBuilder().append((Object)"Setting IGNITE_HOME from driver not as it is not available on this worker: ").append((Object)this.igniteHome()).toString());
            IgniteUtils.nullifyHomeDirectory();
            object = System.setProperty("IGNITE_HOME", this.igniteHome());
        } else {
            object = BoxedUnit.UNIT;
        }
        IgniteConfiguration igniteCfg = this.cfgClo().apply();
        Object object2 = this.sparkContext() == null ? BoxedUnit.UNIT : igniteCfg.setClientMode(true);
        try {
            return Ignition.getOrStart((IgniteConfiguration)igniteCfg);
        }
        catch (IgniteException igniteException) {
            Logging$.MODULE$.log().error((Object)"Failed to start Ignite.", (Throwable)igniteException);
            throw igniteException;
        }
    }

    public boolean close(boolean shutdownIgniteOnWorkers) {
        int workers;
        if (this.sparkContext() != null && shutdownIgniteOnWorkers && (workers = this.sparkContext().getConf().getInt("spark.executor.instances", this.sparkContext().getExecutorStorageStatus().length)) > 0) {
            Logging$.MODULE$.log().info((Object)new StringBuilder().append((Object)"Will stop Ignite nodes on ").append((Object)BoxesRunTime.boxToInteger((int)workers)).append((Object)" workers").toString());
            this.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), workers), workers, ClassTag$.MODULE$.Int()).foreachPartition((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IgniteContext $outer;

                public final void apply(Iterator<Object> it) {
                    this.$outer.org$apache$ignite$spark$IgniteContext$$doClose();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.org$apache$ignite$spark$IgniteContext$$doClose();
    }

    public boolean close$default$1() {
        return false;
    }

    public boolean org$apache$ignite$spark$IgniteContext$$doClose() {
        IgniteConfiguration igniteCfg = this.cfgClo().apply();
        return Ignition.stop((String)igniteCfg.getIgniteInstanceName(), (boolean)false);
    }

    public IgniteContext(SparkContext sparkContext, Function0<IgniteConfiguration> cfgF, boolean standalone) {
        this.sparkContext = sparkContext;
        this.cfgClo = new Once(cfgF);
        this.igniteHome = IgniteUtils.getIgniteHome();
        if (!standalone) {
            int workers = sparkContext.getConf().getInt("spark.executor.instances", sparkContext.getExecutorStorageStatus().length);
            if (workers <= 0) {
                throw new IllegalStateException("No Spark executors found to start Ignite nodes.");
            }
            Logging$.MODULE$.log().info((Object)new StringBuilder().append((Object)"Will start Ignite nodes on ").append((Object)BoxesRunTime.boxToInteger((int)workers)).append((Object)" workers").toString());
            sparkContext.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), workers), workers, ClassTag$.MODULE$.Int()).foreachPartition((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IgniteContext $outer;

                public final void apply(Iterator<Object> it) {
                    this.$outer.ignite();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.ignite();
        this.sqlContext = new SQLContext(sparkContext);
    }

    public IgniteContext(SparkContext sc, String springUrl, boolean client) {
        this(sc, (Function0<IgniteConfiguration>)new Serializable(springUrl){
            public static final long serialVersionUID = 0L;
            private final String springUrl$1;

            public final IgniteConfiguration apply() {
                return (IgniteConfiguration)IgnitionEx.loadConfiguration((String)this.springUrl$1).get1();
            }
            {
                this.springUrl$1 = springUrl$1;
            }
        }, client);
    }

    public IgniteContext(SparkContext sc, String springUrl) {
        this(sc, (Function0<IgniteConfiguration>)new Serializable(springUrl){
            public static final long serialVersionUID = 0L;
            private final String springUrl$2;

            public final IgniteConfiguration apply() {
                return (IgniteConfiguration)IgnitionEx.loadConfiguration((String)this.springUrl$2).get1();
            }
            {
                this.springUrl$2 = springUrl$2;
            }
        }, IgniteContext$.MODULE$.$lessinit$greater$default$3());
    }

    public IgniteContext(SparkContext sc) {
        this(sc, "config/default-config.xml");
    }
}

