/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ldap.internals;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPlainServerCallbackHandler
extends PlainServerCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(LdapPlainServerCallbackHandler.class);
    private DefaultSecurityManager securityManager;

    @Override
    public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.jaasConfigEntries = jaasConfigEntries;
        String ldapUrl = JaasContext.configEntryOption(jaasConfigEntries, "ldap_url", PlainLoginModule.class.getName());
        String userDnTemplate = JaasContext.configEntryOption(jaasConfigEntries, "user_dn_template", PlainLoginModule.class.getName());
        if (ldapUrl == null || userDnTemplate == null) {
            throw new IllegalStateException("ldap_url and/or user_dn_template is missing from the jaas conf file.");
        }
        DefaultLdapRealm realm = new DefaultLdapRealm();
        JndiLdapContextFactory contextFactory = (JndiLdapContextFactory)realm.getContextFactory();
        realm.setUserDnTemplate(userDnTemplate);
        contextFactory.setUrl(ldapUrl);
        this.securityManager = new DefaultSecurityManager((Realm)realm);
    }

    @Override
    protected boolean authenticate(String username, char[] password) {
        if (username == null) {
            return false;
        }
        try {
            this.securityManager.authenticate((AuthenticationToken)new UsernamePasswordToken(username, password));
            return true;
        }
        catch (AuthenticationException e) {
            log.error("Authentication failed", (Throwable)e);
            return false;
        }
    }
}

