/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.auditor;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.server.auditor.AuditEvent;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

@InterfaceStability.Unstable
public interface Auditor
extends Configurable,
AutoCloseable {
    public void audit(AuditEvent var1, AuthorizableRequestContext var2, Map<AclOperation, Set<AuditInformation>> var3);

    public static class AuditInformation {
        private final ResourcePattern resource;
        private final int error;

        public AuditInformation(ResourcePattern resource, int error) {
            this.resource = resource;
            this.error = error;
        }

        public ResourcePattern resource() {
            return this.resource;
        }

        public int error() {
            return this.error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditInformation that = (AuditInformation)o;
            return Objects.equals(this.resource, that.resource) && this.error == that.error;
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.error);
        }
    }
}

