/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.auditor;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.server.auditor.AuditEvent;

@InterfaceStability.Unstable
public class TopicEvent
implements AuditEvent {
    private final Set<AuditedTopic> topics;
    private final EventType eventType;

    public TopicEvent(Set<AuditedTopic> topics, EventType eventType) {
        this.topics = topics;
        this.eventType = eventType;
    }

    public Set<AuditedTopic> topics() {
        return this.topics;
    }

    public EventType eventType() {
        return this.eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicEvent that = (TopicEvent)o;
        return this.topics.equals(that.topics) && this.eventType == that.eventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topics, this.eventType});
    }

    public static class AuditedTopic {
        private final String topicName;
        private final int numPartitions;
        private final int replicationFactor;
        private static final int NO_REPLICATION_FACTOR = -1;
        private static final int NO_PARTITION_NUMBER = -1;

        public AuditedTopic(String topicName) {
            this.topicName = topicName;
            this.numPartitions = -1;
            this.replicationFactor = -1;
        }

        public AuditedTopic(String topicName, int numPartitions, int replicationFactor) {
            this.topicName = topicName;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
        }

        public static AuditedTopic withReplicationFactor(String topicName, int replicationFactor) {
            return new AuditedTopic(topicName, -1, replicationFactor);
        }

        public static AuditedTopic withPartitionNumber(String topicName, int partitionNumber) {
            return new AuditedTopic(topicName, partitionNumber, -1);
        }

        public String name() {
            return this.topicName;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public int replicationFactor() {
            return this.replicationFactor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditedTopic that = (AuditedTopic)o;
            return this.numPartitions == that.numPartitions && this.replicationFactor == that.replicationFactor && Objects.equals(this.topicName, that.topicName);
        }

        public int hashCode() {
            return Objects.hash(this.topicName, this.numPartitions, this.replicationFactor);
        }
    }

    public static enum EventType {
        CREATE,
        DELETE,
        PARTITION_CHANGE,
        REPLICATION_FACTOR_CHANGE;

    }
}

