/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.kafka.common.replica;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.replica.PartitionView;
import org.apache.kafka.common.replica.ReplicaSelector;
import org.apache.kafka.common.replica.ReplicaView;

public class MultiLevelRackAwareReplicaSelector
implements ReplicaSelector {
    @Override
    public Optional<ReplicaView> select(TopicPartition topicPartition, ClientMetadata clientMetadata, PartitionView partitionView) {
        String clientRackId = clientMetadata.rackId();
        if (MultiLevelRackAwareReplicaSelector.validRackId(clientRackId)) {
            List<ReplicaView> result = MultiLevelRackAwareReplicaSelector.longestMatch(MultiLevelRackAwareReplicaSelector.excludeInvalidReplicas(partitionView.replicas()), clientRackId, x -> x.endpoint().rack());
            if (result.isEmpty()) {
                Optional.of(partitionView.leader());
            } else {
                if (result.size() == 1) {
                    return Optional.of(result.get(0));
                }
                return Optional.of(result.get(ThreadLocalRandom.current().nextInt(result.size())));
            }
        }
        return Optional.of(partitionView.leader());
    }

    static <T> List<T> longestMatch(Set<T> itemsToFilter, String stringToMatch, Function<T, String> stringExtractor) {
        if (stringToMatch == null) {
            return new ArrayList<T>(itemsToFilter);
        }
        HashSet<T> matchingSet = new HashSet<T>(itemsToFilter);
        HashSet<Object> previousMatchingSet = new HashSet();
        int from = 0;
        while (from < stringToMatch.length()) {
            int to = stringToMatch.indexOf("/", from + 1);
            if (to < 0) {
                to = stringToMatch.length();
            }
            Iterator it = matchingSet.iterator();
            while (it.hasNext()) {
                String rack = stringExtractor.apply(it.next());
                if (stringToMatch.regionMatches(from, rack, from, to - from)) continue;
                it.remove();
            }
            if (matchingSet.isEmpty()) break;
            previousMatchingSet = new HashSet<T>(matchingSet);
            from = to;
        }
        ArrayList result = matchingSet.isEmpty() ? new ArrayList(previousMatchingSet) : new ArrayList<T>(matchingSet);
        return result;
    }

    private static Set<ReplicaView> excludeInvalidReplicas(Set<ReplicaView> matchingReplicas) {
        return matchingReplicas.stream().filter(x -> MultiLevelRackAwareReplicaSelector.validRackId(x.endpoint().rack())).collect(Collectors.toSet());
    }

    private static boolean validRackId(String clientRackId) {
        return clientRackId != null && !clientRackId.isEmpty() && clientRackId.charAt(0) == '/';
    }
}

