/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.plain.internals;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.plain.PlainAuthenticateCallback;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.utils.Utils;

public class PlainServerCallbackHandler
implements AuthenticateCallbackHandler {
    private static final String JAAS_USER_PREFIX = "user_";
    protected List<AppConfigurationEntry> jaasConfigEntries;

    @Override
    public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.jaasConfigEntries = jaasConfigEntries;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                username = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof PlainAuthenticateCallback) {
                PlainAuthenticateCallback plainCallback = (PlainAuthenticateCallback)callback;
                boolean authenticated = this.authenticate(username, plainCallback.password());
                plainCallback.authenticated(authenticated);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    protected boolean authenticate(String username, char[] password) throws IOException {
        if (username == null) {
            return false;
        }
        String expectedPassword = JaasContext.configEntryOption(this.jaasConfigEntries, JAAS_USER_PREFIX + username, PlainLoginModule.class.getName());
        return expectedPassword != null && Utils.isEqualConstantTime(password, expectedPassword.toCharArray());
    }

    @Override
    public void close() throws KafkaException {
    }
}

