/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.shaded.org.jboss.netty.util.CharsetUtil;
import org.apache.kudu.util.DecimalUtil;
import org.apache.kudu.util.StringUtil;
import org.apache.kudu.util.TimestampUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class PartialRow {
    private final Schema schema;
    private final List<ByteBuffer> varLengthData;
    private final byte[] rowAlloc;
    private final BitSet columnsBitSet;
    private final BitSet nullsBitSet;
    private boolean frozen = false;

    public PartialRow(Schema schema2) {
        this.schema = schema2;
        this.columnsBitSet = new BitSet(this.schema.getColumnCount());
        this.nullsBitSet = schema2.hasNullableColumns() ? new BitSet(this.schema.getColumnCount()) : null;
        this.rowAlloc = new byte[schema2.getRowSize()];
        this.varLengthData = Arrays.asList(new ByteBuffer[this.schema.getColumnCount()]);
    }

    PartialRow(PartialRow row) {
        this.schema = row.schema;
        this.varLengthData = Lists.newArrayListWithCapacity(row.varLengthData.size());
        for (ByteBuffer data : row.varLengthData) {
            if (data == null) {
                this.varLengthData.add(null);
                continue;
            }
            data.reset();
            ByteBuffer clone = ByteBuffer.allocate(data.remaining());
            clone.put(data);
            clone.flip();
            clone.mark();
            this.varLengthData.add(clone);
        }
        this.rowAlloc = (byte[])row.rowAlloc.clone();
        this.columnsBitSet = (BitSet)row.columnsBitSet.clone();
        this.nullsBitSet = row.nullsBitSet == null ? null : (BitSet)row.nullsBitSet.clone();
    }

    public void addBoolean(int columnIndex, boolean val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BOOL);
        this.rowAlloc[this.getPositionInRowAllocAndSetBitSet((int)columnIndex)] = (byte)(val ? 1 : 0);
    }

    public void addBoolean(String columnName, boolean val) {
        this.addBoolean(this.schema.getColumnIndex(columnName), val);
    }

    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.schema.getColumnIndex(columnName));
    }

    public boolean getBoolean(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BOOL);
        this.checkValue(columnIndex);
        byte b = this.rowAlloc[this.schema.getColumnOffset(columnIndex)];
        return b == 1;
    }

    public void addByte(int columnIndex, byte val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT8);
        this.rowAlloc[this.getPositionInRowAllocAndSetBitSet((int)columnIndex)] = val;
    }

    public void addByte(String columnName, byte val) {
        this.addByte(this.schema.getColumnIndex(columnName), val);
    }

    public byte getByte(String columnName) {
        return this.getByte(this.schema.getColumnIndex(columnName));
    }

    public byte getByte(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT8);
        this.checkValue(columnIndex);
        return this.rowAlloc[this.schema.getColumnOffset(columnIndex)];
    }

    public void addShort(int columnIndex, short val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT16);
        Bytes.setShort(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addShort(String columnName, short val) {
        this.addShort(this.schema.getColumnIndex(columnName), val);
    }

    public short getShort(String columnName) {
        return this.getShort(this.schema.getColumnIndex(columnName));
    }

    public short getShort(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT16);
        this.checkValue(columnIndex);
        return Bytes.getShort(this.rowAlloc, this.schema.getColumnOffset(columnIndex));
    }

    public void addInt(int columnIndex, int val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT32);
        Bytes.setInt(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addInt(String columnName, int val) {
        this.addInt(this.schema.getColumnIndex(columnName), val);
    }

    public int getInt(String columnName) {
        return this.getInt(this.schema.getColumnIndex(columnName));
    }

    public int getInt(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT32);
        this.checkValue(columnIndex);
        return Bytes.getInt(this.rowAlloc, this.schema.getColumnOffset(columnIndex));
    }

    public void addLong(int columnIndex, long val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT64, Type.UNIXTIME_MICROS);
        Bytes.setLong(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addLong(String columnName, long val) {
        this.addLong(this.schema.getColumnIndex(columnName), val);
    }

    public long getLong(String columnName) {
        return this.getLong(this.schema.getColumnIndex(columnName));
    }

    public long getLong(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.INT64, Type.UNIXTIME_MICROS);
        this.checkColumnExists(this.schema.getColumnByIndex(columnIndex));
        this.checkValue(columnIndex);
        return Bytes.getLong(this.rowAlloc, this.schema.getColumnOffset(columnIndex));
    }

    public void addFloat(int columnIndex, float val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.FLOAT);
        Bytes.setFloat(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addFloat(String columnName, float val) {
        this.addFloat(this.schema.getColumnIndex(columnName), val);
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.schema.getColumnIndex(columnName));
    }

    public float getFloat(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.FLOAT);
        this.checkValue(columnIndex);
        return Bytes.getFloat(this.rowAlloc, this.schema.getColumnOffset(columnIndex));
    }

    public void addDouble(int columnIndex, double val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.DOUBLE);
        Bytes.setDouble(this.rowAlloc, val, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addDouble(String columnName, double val) {
        this.addDouble(this.schema.getColumnIndex(columnName), val);
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.schema.getColumnIndex(columnName));
    }

    public double getDouble(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.DOUBLE);
        this.checkValue(columnIndex);
        return Bytes.getDouble(this.rowAlloc, this.schema.getColumnOffset(columnIndex));
    }

    public void addDecimal(int columnIndex, BigDecimal val) {
        this.checkNotFrozen();
        ColumnSchema column = this.schema.getColumnByIndex(columnIndex);
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        this.checkColumn(column, Type.DECIMAL);
        BigDecimal coercedVal = DecimalUtil.coerce(val, typeAttributes.getPrecision(), typeAttributes.getScale());
        Bytes.setBigDecimal(this.rowAlloc, coercedVal, typeAttributes.getPrecision(), this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addDecimal(String columnName, BigDecimal val) {
        this.addDecimal(this.schema.getColumnIndex(columnName), val);
    }

    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.schema.getColumnIndex(columnName));
    }

    public BigDecimal getDecimal(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.DECIMAL);
        this.checkColumnExists(this.schema.getColumnByIndex(columnIndex));
        this.checkValue(columnIndex);
        ColumnSchema column = this.schema.getColumnByIndex(columnIndex);
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        return Bytes.getDecimal(this.rowAlloc, this.schema.getColumnOffset(columnIndex), typeAttributes.getPrecision(), typeAttributes.getScale());
    }

    public void addTimestamp(int columnIndex, Timestamp val) {
        this.checkNotFrozen();
        ColumnSchema column = this.schema.getColumnByIndex(columnIndex);
        this.checkColumn(column, Type.UNIXTIME_MICROS);
        long micros = TimestampUtil.timestampToMicros(val);
        Bytes.setLong(this.rowAlloc, micros, this.getPositionInRowAllocAndSetBitSet(columnIndex));
    }

    public void addTimestamp(String columnName, Timestamp val) {
        this.addTimestamp(this.schema.getColumnIndex(columnName), val);
    }

    public Timestamp getTimestamp(String columnName) {
        return this.getTimestamp(this.schema.getColumnIndex(columnName));
    }

    public Timestamp getTimestamp(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.UNIXTIME_MICROS);
        this.checkColumnExists(this.schema.getColumnByIndex(columnIndex));
        this.checkValue(columnIndex);
        long micros = Bytes.getLong(this.rowAlloc, this.schema.getColumnOffset(columnIndex));
        return TimestampUtil.microsToTimestamp(micros);
    }

    public void addString(int columnIndex, String val) {
        this.addStringUtf8(columnIndex, Bytes.fromString(val));
    }

    public void addString(String columnName, String val) {
        this.addStringUtf8(columnName, Bytes.fromString(val));
    }

    public String getString(String columnName) {
        return this.getString(this.schema.getColumnIndex(columnName));
    }

    public String getString(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.STRING);
        this.checkValue(columnIndex);
        return new String(this.getVarLengthData(columnIndex).array(), CharsetUtil.UTF_8);
    }

    public void addStringUtf8(int columnIndex, byte[] val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.STRING);
        this.addVarLengthData(columnIndex, val);
    }

    public void addStringUtf8(String columnName, byte[] val) {
        this.addStringUtf8(this.schema.getColumnIndex(columnName), val);
    }

    public void addBinary(int columnIndex, byte[] val) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BINARY);
        this.addVarLengthData(columnIndex, val);
    }

    public void addBinary(int columnIndex, ByteBuffer value) {
        this.checkNotFrozen();
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BINARY);
        this.addVarLengthData(columnIndex, value);
    }

    public void addBinary(String columnName, byte[] val) {
        this.addBinary(this.schema.getColumnIndex(columnName), val);
    }

    public void addBinary(String columnName, ByteBuffer value) {
        this.addBinary(this.schema.getColumnIndex(columnName), value);
    }

    public byte[] getBinaryCopy(String columnName) {
        return this.getBinaryCopy(this.schema.getColumnIndex(columnName));
    }

    public byte[] getBinaryCopy(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BINARY);
        this.checkValue(columnIndex);
        byte[] data = this.getVarLengthData(columnIndex).array();
        byte[] ret = new byte[data.length];
        System.arraycopy(data, 0, ret, 0, data.length);
        return ret;
    }

    public ByteBuffer getBinary(String columnName) {
        return this.getBinary(this.schema.getColumnIndex(columnName));
    }

    public ByteBuffer getBinary(int columnIndex) {
        this.checkColumn(this.schema.getColumnByIndex(columnIndex), Type.BINARY);
        this.checkValue(columnIndex);
        return this.getVarLengthData(columnIndex);
    }

    private void addVarLengthData(int columnIndex, byte[] val) {
        this.addVarLengthData(columnIndex, ByteBuffer.wrap(val));
    }

    private void addVarLengthData(int columnIndex, ByteBuffer val) {
        ByteBuffer duplicate = val.duplicate();
        duplicate.mark();
        this.varLengthData.set(columnIndex, duplicate);
        this.getPositionInRowAllocAndSetBitSet(columnIndex);
    }

    List<ByteBuffer> getVarLengthData() {
        return this.varLengthData;
    }

    private ByteBuffer getVarLengthData(int columnIndex) {
        return this.varLengthData.get(columnIndex).duplicate();
    }

    public void setNull(int columnIndex) {
        this.setNull(this.schema.getColumnByIndex(columnIndex));
    }

    public void setNull(String columnName) {
        this.setNull(this.schema.getColumn(columnName));
    }

    private void setNull(ColumnSchema column) {
        assert (this.nullsBitSet != null);
        this.checkNotFrozen();
        this.checkColumnExists(column);
        if (!column.isNullable()) {
            throw new IllegalArgumentException(column.getName() + " cannot be set to null");
        }
        int idx = this.schema.getColumns().indexOf(column);
        this.columnsBitSet.set(idx);
        this.nullsBitSet.set(idx);
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.schema.getColumnIndex(columnName));
    }

    public boolean isNull(int columnIndex) {
        this.checkColumnExists(this.schema.getColumnByIndex(columnIndex));
        return this.schema.getColumnByIndex(columnIndex).isNullable() && this.isSetToNull(columnIndex);
    }

    public Object getObject(String columnName) {
        return this.getObject(this.schema.getColumnIndex(columnName));
    }

    public void addObject(String columnName, Object val) {
        this.addObject(this.schema.getColumnIndex(columnName), val);
    }

    public void addObject(int columnIndex, Object val) {
        this.checkNotFrozen();
        ColumnSchema col = this.schema.getColumnByIndex(columnIndex);
        this.checkColumnExists(col);
        try {
            if (val == null) {
                this.setNull(columnIndex);
                return;
            }
            switch (col.getType()) {
                case BOOL: {
                    this.addBoolean(columnIndex, (boolean)((Boolean)val));
                    break;
                }
                case INT8: {
                    this.addByte(columnIndex, (byte)((Byte)val));
                    break;
                }
                case INT16: {
                    this.addShort(columnIndex, (short)((Short)val));
                    break;
                }
                case INT32: {
                    this.addInt(columnIndex, (int)((Integer)val));
                    break;
                }
                case INT64: {
                    this.addLong(columnIndex, (long)((Long)val));
                    break;
                }
                case UNIXTIME_MICROS: {
                    if (val instanceof Timestamp) {
                        this.addTimestamp(columnIndex, (Timestamp)val);
                        break;
                    }
                    this.addLong(columnIndex, (long)((Long)val));
                    break;
                }
                case FLOAT: {
                    this.addFloat(columnIndex, ((Float)val).floatValue());
                    break;
                }
                case DOUBLE: {
                    this.addDouble(columnIndex, (double)((Double)val));
                    break;
                }
                case STRING: {
                    this.addString(columnIndex, (String)val);
                    break;
                }
                case BINARY: {
                    if (val instanceof byte[]) {
                        this.addBinary(columnIndex, (byte[])val);
                        break;
                    }
                    this.addBinary(columnIndex, (ByteBuffer)val);
                    break;
                }
                case DECIMAL: {
                    this.addDecimal(columnIndex, (BigDecimal)val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported column type: " + (Object)((Object)col.getType()));
                }
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value type does not match column type " + (Object)((Object)col.getType()) + " for column " + col.getName());
        }
    }

    public Object getObject(int columnIndex) {
        this.checkColumnExists(this.schema.getColumnByIndex(columnIndex));
        if (this.isNull(columnIndex) || !this.isSet(columnIndex)) {
            return null;
        }
        Type type = this.schema.getColumnByIndex(columnIndex).getType();
        switch (type) {
            case BOOL: {
                return this.getBoolean(columnIndex);
            }
            case INT8: {
                return this.getByte(columnIndex);
            }
            case INT16: {
                return this.getShort(columnIndex);
            }
            case INT32: {
                return this.getInt(columnIndex);
            }
            case INT64: {
                return this.getLong(columnIndex);
            }
            case UNIXTIME_MICROS: {
                return this.getTimestamp(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case DOUBLE: {
                return this.getDouble(columnIndex);
            }
            case STRING: {
                return this.getString(columnIndex);
            }
            case BINARY: {
                return this.getBinaryCopy(columnIndex);
            }
            case DECIMAL: {
                return this.getDecimal(columnIndex);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)type));
    }

    private void checkColumn(ColumnSchema column, Type ... types) {
        this.checkColumnExists(column);
        for (Type type : types) {
            if (!column.getType().equals((Object)type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("%s isn't %s, it's %s", column.getName(), Arrays.toString((Object[])types), column.getType().getName()));
    }

    private void checkColumnExists(ColumnSchema column) {
        if (column == null) {
            throw new IllegalArgumentException("Column name isn't present in the table's schema");
        }
    }

    private void checkValue(int columnIndex) {
        if (!this.isSet(columnIndex)) {
            throw new IllegalArgumentException("Column value is not set");
        }
        if (this.isNull(columnIndex)) {
            throw new IllegalArgumentException("Column value is null");
        }
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("This row was already applied and cannot be modified.");
        }
    }

    private int getPositionInRowAllocAndSetBitSet(int columnIndex) {
        this.columnsBitSet.set(columnIndex);
        return this.schema.getColumnOffset(columnIndex);
    }

    public boolean isSet(String columnName) {
        return this.isSet(this.schema.getColumnIndex(columnName));
    }

    public boolean isSet(int columnIndex) {
        this.checkColumnExists(this.schema.getColumnByIndex(columnIndex));
        return this.columnsBitSet.get(columnIndex);
    }

    boolean isSetToNull(int column) {
        if (this.nullsBitSet == null) {
            return false;
        }
        return this.nullsBitSet.get(column);
    }

    public byte[] encodePrimaryKey() {
        return KeyEncoder.encodePrimaryKey(this);
    }

    public String toString() {
        int numCols = this.schema.getColumnCount();
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (int idx = 0; idx < numCols; ++idx) {
            if (!this.columnsBitSet.get(idx)) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            ColumnSchema col = this.schema.getColumnByIndex(idx);
            sb.append(col.getType().getName());
            if (col.getTypeAttributes() != null) {
                sb.append(col.getTypeAttributes().toStringForType(col.getType()));
            }
            sb.append(' ');
            sb.append(col.getName());
            sb.append('=');
            this.appendCellValueDebugString(idx, sb);
        }
        sb.append(')');
        return sb.toString();
    }

    public String stringifyRowKey() {
        int numRowKeys = this.schema.getPrimaryKeyColumnCount();
        ArrayList<Integer> idxs = new ArrayList<Integer>(numRowKeys);
        for (int i = 0; i < numRowKeys; ++i) {
            idxs.add(i);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        this.appendDebugString(idxs, sb);
        sb.append(")");
        return sb.toString();
    }

    void appendDebugString(List<Integer> idxs, StringBuilder sb) {
        boolean first = true;
        for (int idx : idxs) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            ColumnSchema col = this.schema.getColumnByIndex(idx);
            sb.append(col.getType().getName());
            sb.append(' ');
            sb.append(col.getName());
            sb.append('=');
            this.appendCellValueDebugString(idx, sb);
        }
    }

    void appendShortDebugString(List<Integer> idxs, StringBuilder sb) {
        boolean first = true;
        for (int idx : idxs) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            this.appendCellValueDebugString(idx, sb);
        }
    }

    void appendCellValueDebugString(Integer idx, StringBuilder sb) {
        ColumnSchema col = this.schema.getColumnByIndex(idx);
        Preconditions.checkState(this.columnsBitSet.get(idx), "Column %s is not set", (Object)col.getName());
        if (this.nullsBitSet != null && this.nullsBitSet.get(idx)) {
            sb.append("NULL");
            return;
        }
        switch (col.getType()) {
            case BOOL: {
                sb.append(Bytes.getBoolean(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case INT8: {
                sb.append(Bytes.getByte(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case INT16: {
                sb.append(Bytes.getShort(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case INT32: {
                sb.append(Bytes.getInt(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case INT64: {
                sb.append(Bytes.getLong(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case UNIXTIME_MICROS: {
                sb.append(TimestampUtil.timestampToString(Bytes.getLong(this.rowAlloc, this.schema.getColumnOffset(idx))));
                return;
            }
            case FLOAT: {
                sb.append(Bytes.getFloat(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case DOUBLE: {
                sb.append(Bytes.getDouble(this.rowAlloc, this.schema.getColumnOffset(idx)));
                return;
            }
            case DECIMAL: {
                ColumnTypeAttributes typeAttributes = col.getTypeAttributes();
                sb.append(Bytes.getDecimal(this.rowAlloc, this.schema.getColumnOffset(idx), typeAttributes.getPrecision(), typeAttributes.getScale()));
                return;
            }
            case STRING: 
            case BINARY: {
                ByteBuffer value = this.getVarLengthData().get(idx).duplicate();
                value.reset();
                byte[] data = new byte[value.limit() - value.position()];
                value.get(data);
                if (col.getType() == Type.STRING) {
                    sb.append('\"');
                    StringUtil.appendEscapedSQLString(Bytes.getString(data), sb);
                    sb.append('\"');
                } else {
                    sb.append(Bytes.pretty(data));
                }
                return;
            }
        }
        throw new RuntimeException("unreachable");
    }

    void setMin(int index) {
        ColumnSchema column = this.schema.getColumnByIndex(index);
        Type type = column.getType();
        switch (type) {
            case BOOL: {
                this.addBoolean(index, false);
                break;
            }
            case INT8: {
                this.addByte(index, (byte)-128);
                break;
            }
            case INT16: {
                this.addShort(index, (short)Short.MIN_VALUE);
                break;
            }
            case INT32: {
                this.addInt(index, Integer.MIN_VALUE);
                break;
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                this.addLong(index, Long.MIN_VALUE);
                break;
            }
            case FLOAT: {
                this.addFloat(index, -3.4028235E38f);
                break;
            }
            case DOUBLE: {
                this.addDouble(index, -1.7976931348623157E308);
                break;
            }
            case DECIMAL: {
                ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
                this.addDecimal(index, DecimalUtil.minValue(typeAttributes.getPrecision(), typeAttributes.getScale()));
                break;
            }
            case STRING: {
                this.addStringUtf8(index, AsyncKuduClient.EMPTY_ARRAY);
                break;
            }
            case BINARY: {
                this.addBinary(index, AsyncKuduClient.EMPTY_ARRAY);
                break;
            }
            default: {
                throw new RuntimeException("unreachable");
            }
        }
    }

    void setRaw(int index, byte[] value) {
        ColumnSchema column = this.schema.getColumnByIndex(index);
        Type type = column.getType();
        switch (type) {
            case BOOL: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UNIXTIME_MICROS: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                Preconditions.checkArgument(value.length == column.getTypeSize());
                System.arraycopy(value, 0, this.rowAlloc, this.getPositionInRowAllocAndSetBitSet(index), value.length);
                break;
            }
            case STRING: 
            case BINARY: {
                this.addVarLengthData(index, value);
                break;
            }
            default: {
                throw new RuntimeException("unreachable");
            }
        }
    }

    boolean incrementColumn(int index) {
        ColumnSchema column = this.schema.getColumnByIndex(index);
        Type type = column.getType();
        Preconditions.checkState(this.isSet(index));
        int offset = this.schema.getColumnOffset(index);
        switch (type) {
            case BOOL: {
                boolean isFalse = this.rowAlloc[offset] == 0;
                this.rowAlloc[offset] = 1;
                return isFalse;
            }
            case INT8: {
                byte existing = this.rowAlloc[offset];
                if (existing == 127) {
                    return false;
                }
                this.rowAlloc[offset] = (byte)(existing + 1);
                return true;
            }
            case INT16: {
                short existing = Bytes.getShort(this.rowAlloc, offset);
                if (existing == Short.MAX_VALUE) {
                    return false;
                }
                Bytes.setShort(this.rowAlloc, (short)(existing + 1), offset);
                return true;
            }
            case INT32: {
                int existing = Bytes.getInt(this.rowAlloc, offset);
                if (existing == Integer.MAX_VALUE) {
                    return false;
                }
                Bytes.setInt(this.rowAlloc, existing + 1, offset);
                return true;
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                long existing = Bytes.getLong(this.rowAlloc, offset);
                if (existing == Long.MAX_VALUE) {
                    return false;
                }
                Bytes.setLong(this.rowAlloc, existing + 1L, offset);
                return true;
            }
            case FLOAT: {
                float existing = Bytes.getFloat(this.rowAlloc, offset);
                float incremented = Math.nextAfter(existing, Double.POSITIVE_INFINITY);
                if (existing == incremented) {
                    return false;
                }
                Bytes.setFloat(this.rowAlloc, incremented, offset);
                return true;
            }
            case DOUBLE: {
                double existing = Bytes.getDouble(this.rowAlloc, offset);
                double incremented = Math.nextAfter(existing, Double.POSITIVE_INFINITY);
                if (existing == incremented) {
                    return false;
                }
                Bytes.setDouble(this.rowAlloc, incremented, offset);
                return true;
            }
            case DECIMAL: {
                int precision = column.getTypeAttributes().getPrecision();
                int scale = column.getTypeAttributes().getScale();
                BigDecimal existing = Bytes.getDecimal(this.rowAlloc, offset, precision, scale);
                BigDecimal max = DecimalUtil.maxValue(precision, scale);
                if (existing.equals(max)) {
                    return false;
                }
                BigDecimal smallest = DecimalUtil.smallestValue(scale);
                Bytes.setBigDecimal(this.rowAlloc, existing.add(smallest), precision, offset);
                return true;
            }
            case STRING: 
            case BINARY: {
                ByteBuffer data = this.varLengthData.get(index);
                data.reset();
                int len = data.limit() - data.position();
                byte[] incremented = new byte[len + 1];
                System.arraycopy(data.array(), data.arrayOffset() + data.position(), incremented, 0, len);
                this.addVarLengthData(index, incremented);
                return true;
            }
        }
        throw new RuntimeException("unreachable");
    }

    static boolean isIncremented(PartialRow lower, PartialRow upper, List<Integer> indexes) {
        boolean equals = false;
        ListIterator<Integer> iter = indexes.listIterator(indexes.size());
        while (iter.hasPrevious()) {
            int index = iter.previous();
            if (equals) {
                if (PartialRow.isCellEqual(lower, upper, index)) continue;
                return false;
            }
            if (!lower.isSet(index) && !upper.isSet(index)) continue;
            if (!PartialRow.isCellIncremented(lower, upper, index)) {
                return false;
            }
            equals = true;
        }
        return equals;
    }

    private static boolean isCellEqual(PartialRow a, PartialRow b, int index) {
        Preconditions.checkArgument(a.getSchema().equals(b.getSchema()));
        Preconditions.checkArgument(a.getSchema().getColumnByIndex(index).isKey());
        Preconditions.checkArgument(a.isSet(index));
        Preconditions.checkArgument(b.isSet(index));
        ColumnSchema column = a.getSchema().getColumnByIndex(index);
        Type type = column.getType();
        int offset = a.getSchema().getColumnOffset(index);
        switch (type) {
            case BOOL: {
                return a.rowAlloc[offset] == b.rowAlloc[offset];
            }
            case INT8: {
                return a.rowAlloc[offset] == b.rowAlloc[offset];
            }
            case INT16: {
                return Bytes.getShort(a.rowAlloc, offset) == Bytes.getShort(b.rowAlloc, offset);
            }
            case INT32: {
                return Bytes.getInt(a.rowAlloc, offset) == Bytes.getInt(b.rowAlloc, offset);
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                return Bytes.getLong(a.rowAlloc, offset) == Bytes.getLong(b.rowAlloc, offset);
            }
            case FLOAT: {
                return Bytes.getFloat(a.rowAlloc, offset) == Bytes.getFloat(b.rowAlloc, offset);
            }
            case DOUBLE: {
                return Bytes.getDouble(a.rowAlloc, offset) == Bytes.getDouble(b.rowAlloc, offset);
            }
            case DECIMAL: {
                ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
                int precision = typeAttributes.getPrecision();
                int scale = typeAttributes.getScale();
                return Bytes.getDecimal(a.rowAlloc, offset, precision, scale).equals(Bytes.getDecimal(b.rowAlloc, offset, precision, scale));
            }
            case STRING: 
            case BINARY: {
                ByteBuffer aData = a.varLengthData.get(index).duplicate();
                ByteBuffer bData = b.varLengthData.get(index).duplicate();
                aData.reset();
                bData.reset();
                int aLen = aData.limit() - aData.position();
                int bLen = bData.limit() - bData.position();
                if (aLen != bLen) {
                    return false;
                }
                for (int i = 0; i < aLen; ++i) {
                    if (aData.get(aData.position() + i) == bData.get(bData.position() + i)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new RuntimeException("unreachable");
    }

    private static boolean isCellIncremented(PartialRow lower, PartialRow upper, int index) {
        Preconditions.checkArgument(lower.getSchema().equals(upper.getSchema()));
        Preconditions.checkArgument(lower.getSchema().getColumnByIndex(index).isKey());
        Preconditions.checkArgument(lower.isSet(index));
        Preconditions.checkArgument(upper.isSet(index));
        ColumnSchema column = lower.getSchema().getColumnByIndex(index);
        Type type = column.getType();
        int offset = lower.getSchema().getColumnOffset(index);
        switch (type) {
            case BOOL: {
                return lower.rowAlloc[offset] + 1 == upper.rowAlloc[offset];
            }
            case INT8: {
                byte val = lower.rowAlloc[offset];
                return val != 127 && val + 1 == upper.rowAlloc[offset];
            }
            case INT16: {
                short val = Bytes.getShort(lower.rowAlloc, offset);
                return val != Short.MAX_VALUE && val + 1 == Bytes.getShort(upper.rowAlloc, offset);
            }
            case INT32: {
                int val = Bytes.getInt(lower.rowAlloc, offset);
                return val != Integer.MAX_VALUE && val + 1 == Bytes.getInt(upper.rowAlloc, offset);
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                long val = Bytes.getLong(lower.rowAlloc, offset);
                return val != Long.MAX_VALUE && val + 1L == Bytes.getLong(upper.rowAlloc, offset);
            }
            case FLOAT: {
                float val = Bytes.getFloat(lower.rowAlloc, offset);
                return val != Float.POSITIVE_INFINITY && Math.nextAfter(val, Double.POSITIVE_INFINITY) == Bytes.getFloat(upper.rowAlloc, offset);
            }
            case DOUBLE: {
                double val = Bytes.getDouble(lower.rowAlloc, offset);
                return val != Double.POSITIVE_INFINITY && Math.nextAfter(val, Double.POSITIVE_INFINITY) == Bytes.getDouble(upper.rowAlloc, offset);
            }
            case DECIMAL: {
                ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
                int precision = typeAttributes.getPrecision();
                int scale = typeAttributes.getScale();
                BigDecimal val = Bytes.getDecimal(lower.rowAlloc, offset, precision, scale);
                BigDecimal smallestVal = DecimalUtil.smallestValue(scale);
                return val.add(smallestVal).equals(Bytes.getDecimal(upper.rowAlloc, offset, precision, scale));
            }
            case STRING: 
            case BINARY: {
                ByteBuffer aData = lower.varLengthData.get(index).duplicate();
                ByteBuffer bData = upper.varLengthData.get(index).duplicate();
                aData.reset();
                bData.reset();
                int aLen = aData.limit() - aData.position();
                int bLen = bData.limit() - bData.position();
                if (aLen == Integer.MAX_VALUE || aLen + 1 != bLen || bData.get(bData.limit() - 1) != 0) {
                    return false;
                }
                for (int i = 0; i < aLen; ++i) {
                    if (aData.get(aData.position() + i) == bData.get(bData.position() + i)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new RuntimeException("unreachable");
    }

    public Schema getSchema() {
        return this.schema;
    }

    byte[] getRowAlloc() {
        return this.rowAlloc;
    }

    BitSet getColumnsBitSet() {
        return this.columnsBitSet;
    }

    BitSet getNullsBitSet() {
        return this.nullsBitSet;
    }

    void freeze() {
        this.frozen = true;
    }
}

