/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.base.Splitter;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class CsvParser {
    private final byte separatorByte;
    private final int maxColumnCount;
    private final List<String> columnNames;

    public CsvParser(String columnsSpecification, String separatorStr) {
        byte[] separator = Bytes.fromString(separatorStr);
        Preconditions.checkArgument(separator.length == 1, "CsvParser only supports single-byte separators");
        this.separatorByte = separator[0];
        this.columnNames = Lists.newArrayList(Splitter.on(',').trimResults().split(columnsSpecification));
        this.maxColumnCount = this.columnNames.size();
    }

    public ParsedLine parse(byte[] lineBytes, int length) throws BadCsvLineException {
        ArrayList<Integer> tabOffsets = new ArrayList<Integer>(this.maxColumnCount);
        for (int i = 0; i < length; ++i) {
            if (lineBytes[i] != this.separatorByte) continue;
            tabOffsets.add(i);
        }
        if (tabOffsets.isEmpty()) {
            throw new BadCsvLineException("No delimiter");
        }
        if (lineBytes[length - 1] != this.separatorByte) {
            tabOffsets.add(length);
        }
        if (tabOffsets.size() > this.maxColumnCount) {
            throw new BadCsvLineException("Excessive columns");
        }
        if (tabOffsets.size() < this.maxColumnCount) {
            throw new BadCsvLineException("Not enough columns");
        }
        return new ParsedLine(tabOffsets, lineBytes);
    }

    public static class BadCsvLineException
    extends Exception {
        public BadCsvLineException(String err) {
            super(err);
        }
    }

    class ParsedLine {
        private final List<Integer> tabOffsets;
        private final byte[] lineBytes;

        ParsedLine(List<Integer> tabOffsets, byte[] lineBytes) {
            this.tabOffsets = tabOffsets;
            this.lineBytes = lineBytes;
        }

        public int getColumnOffset(int idx) {
            if (idx > 0) {
                return this.tabOffsets.get(idx - 1) + 1;
            }
            return 0;
        }

        public int getColumnLength(int idx) {
            return this.tabOffsets.get(idx) - this.getColumnOffset(idx);
        }

        public int getColumnCount() {
            return this.tabOffsets.size();
        }

        public byte[] getLineBytes() {
            return this.lineBytes;
        }

        public String getColumnName(int idx) {
            return (String)CsvParser.this.columnNames.get(idx);
        }
    }
}

