/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kudu.mapreduce.CommandLineParser;
import org.apache.kudu.mapreduce.KuduTableInputFormat;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;
import org.apache.kudu.mapreduce.tools.ExportCsvMapper;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ExportCsv
extends Configured
implements Tool {
    static final String NAME = "exportcsv";
    static final String DEFAULT_SEPARATOR = "\t";
    static final String SEPARATOR_CONF_KEY = "exportcsv.separator";
    static final String JOB_NAME_CONF_KEY = "exportcsv.job.name";
    static final String COLUMNS_NAMES_KEY = "exportcsv.column.names";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, ClassNotFoundException {
        Class<ExportCsvMapper> mapperClass = ExportCsvMapper.class;
        conf.set(COLUMNS_NAMES_KEY, args[0]);
        String tableName = args[1];
        Path outputDir = new Path(args[2]);
        String jobName = conf.get(JOB_NAME_CONF_KEY, "exportcsv_" + tableName);
        Job job = new Job(conf, jobName);
        job.setJarByClass(mapperClass);
        job.setInputFormatClass(KuduTableInputFormat.class);
        new KuduTableMapReduceUtil.TableInputFormatConfiguratorWithCommandLineParser(job, tableName, args[0]).configure();
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(mapperClass);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        String usage2 = "Usage: exportcsv <colAa,colB,colC> <table.name> <output.dir>\n\nExports the given table and columns into the specified output path.\nThe column names of the Kudu table must be specified in the form of \ncomma-separated column names.\nOther options that may be specified with -D include:\n'-Dexportcsv.separator=|' - eg separate on pipes instead of tabs\n-Dexportcsv.job.name=jobName - use the specified mapreduce job name for theexport.\n" + CommandLineParser.getHelpSnippet();
        System.err.println(usage2);
    }

    public int run(String[] otherArgs) throws Exception {
        if (otherArgs.length < 3) {
            ExportCsv.usage("Wrong number of arguments: " + otherArgs.length);
            return -1;
        }
        Job job = ExportCsv.createSubmittableJob(this.getConf(), otherArgs);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int status = ToolRunner.run((Tool)new ExportCsv(), (String[])args);
        System.exit(status);
    }
}

