/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.RowResult;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExportCsvMapper
extends Mapper<NullWritable, RowResult, NullWritable, Text> {
    private static final NullWritable NULL_KEY = NullWritable.get();
    private String separator;
    private Schema schema;

    protected void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.separator = conf.get("exportcsv.separator", "\t");
    }

    public void map(NullWritable key, RowResult value, Mapper.Context context) throws IOException {
        this.schema = value.getSchema();
        try {
            context.write((Object)NULL_KEY, (Object)new Text(this.rowResultToString(value)));
        }
        catch (InterruptedException e) {
            throw new IOException("Failing task since it was interrupted", e);
        }
    }

    private String rowResultToString(RowResult value) {
        StringBuilder buf = new StringBuilder();
        block12: for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            ColumnSchema col = this.schema.getColumnByIndex(i);
            if (i != 0) {
                buf.append(this.separator);
            }
            switch (col.getType()) {
                case INT8: {
                    buf.append(value.getByte(i));
                    continue block12;
                }
                case INT16: {
                    buf.append(value.getShort(i));
                    continue block12;
                }
                case INT32: {
                    buf.append(value.getInt(i));
                    continue block12;
                }
                case INT64: {
                    buf.append(value.getLong(i));
                    continue block12;
                }
                case STRING: {
                    buf.append(value.getString(i));
                    continue block12;
                }
                case BINARY: {
                    buf.append(Bytes.pretty(value.getBinaryCopy(i)));
                    continue block12;
                }
                case FLOAT: {
                    buf.append(value.getFloat(i));
                    continue block12;
                }
                case DOUBLE: {
                    buf.append(value.getDouble(i));
                    continue block12;
                }
                case BOOL: {
                    buf.append(value.getBoolean(i));
                    continue block12;
                }
                case UNIXTIME_MICROS: {
                    buf.append(value.getLong(i));
                    continue block12;
                }
                default: {
                    buf.append("<unknown type!>");
                }
            }
        }
        return buf.toString();
    }
}

