/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce.tools;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Type;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.mapreduce.CommandLineParser;
import org.apache.kudu.mapreduce.KuduTableMapReduceUtil;
import org.apache.kudu.mapreduce.tools.ImportParquetMapper;
import org.apache.kudu.mapreduce.tools.ParquetReadSupport;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ImportParquet
extends Configured
implements Tool {
    static final String NAME = "importparquet";
    static final String JOB_NAME_CONF_KEY = "importparquet.job.name";
    static final String PARQUET_INPUT_SCHEMA = "importparquet.input.schema";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, ClassNotFoundException {
        String tableName = args[0];
        Path inputDir = new Path(args[1]);
        ArrayList footers = new ArrayList();
        footers.addAll(ParquetFileReader.readFooters((Configuration)conf, (Path)inputDir));
        MessageType schema2 = ((Footer)footers.get(0)).getParquetMetadata().getFileMetaData().getSchema();
        GroupWriteSupport.setSchema((MessageType)schema2, (Configuration)conf);
        conf.set(PARQUET_INPUT_SCHEMA, schema2.toString());
        String jobName = conf.get(JOB_NAME_CONF_KEY, "importparquet_" + tableName);
        Job job = new Job(conf, jobName);
        job.setJarByClass(ImportParquet.class);
        job.setMapperClass(ImportParquetMapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(ParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((Job)job, ParquetReadSupport.class);
        ParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        CommandLineParser cmdLineParser = new CommandLineParser(conf);
        KuduClient client = cmdLineParser.getClient();
        KuduTable table = client.openTable(tableName);
        for (ColumnSchema columnSchema : table.getSchema().getColumns()) {
            if (schema2.containsField(columnSchema.getName())) {
                if (schema2.getType(columnSchema.getName()).asPrimitiveType().getPrimitiveTypeName().equals((Object)ImportParquet.getTypeName(columnSchema.getType()))) continue;
                throw new IllegalArgumentException("The column type " + ImportParquet.getTypeName(columnSchema.getType()) + " does not exist in Parquet schema");
            }
            throw new IllegalArgumentException("The column " + columnSchema.getName() + " does not exist in Parquet schema");
        }
        for (ColumnDescriptor colDesc : schema2.getColumns()) {
            if (!colDesc.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) continue;
            throw new IllegalArgumentException("Column type not supported in Kudu: " + colDesc);
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        new KuduTableMapReduceUtil.TableOutputFormatConfiguratorWithCommandLineParser(job, tableName).configure();
        return job;
    }

    private static PrimitiveType.PrimitiveTypeName getTypeName(Type type) {
        switch (type) {
            case BOOL: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case INT8: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case INT16: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case STRING: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Type " + type.getName() + " not recognized");
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        String usage2 = "Usage: importparquet<table.name> <input.dir>\n\nImports the given input directory of Apache Parquet data into the specified table.\nOther options that may be specified with -D include:\n-Dimportparquet.job.name=jobName - use the specified mapreduce job name for theimport.\n" + CommandLineParser.getHelpSnippet();
        System.err.println(usage2);
    }

    public int run(String[] otherArgs) throws Exception {
        if (otherArgs.length < 1) {
            ImportParquet.usage("Wrong number of arguments: " + otherArgs.length);
            return -1;
        }
        Job job = ImportParquet.createSubmittableJob(this.getConf(), otherArgs);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int status = ToolRunner.run((Tool)new ImportParquet(), (String[])args);
        System.exit(status);
    }
}

