/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.cookie;

import java.text.ParsePosition;
import java.util.Date;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpHeaderDateFormat;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.cookie.Cookie;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.cookie.CookieDecoder;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.cookie.DefaultCookie;

public final class ClientCookieDecoder
extends CookieDecoder {
    public static final ClientCookieDecoder STRICT = new ClientCookieDecoder(true);
    public static final ClientCookieDecoder LAX = new ClientCookieDecoder(false);

    private ClientCookieDecoder(boolean strict) {
        super(strict);
    }

    public Cookie decode(String header2) {
        char c;
        if (header2 == null) {
            throw new NullPointerException("header");
        }
        int headerLen = header2.length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i != headerLen && (c = header2.charAt(i)) != ',') {
            int valueEnd;
            int valueBegin;
            int nameEnd;
            int nameBegin;
            block13: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                nameEnd = i;
                valueBegin = -1;
                valueEnd = -1;
                if (i != headerLen) {
                    do {
                        char curChar;
                        if ((curChar = header2.charAt(i)) == ';') {
                            nameEnd = i;
                            valueEnd = -1;
                            valueBegin = -1;
                        } else {
                            if (curChar != '=') continue;
                            nameEnd = i++;
                            if (i == headerLen) {
                                valueEnd = 0;
                                valueBegin = 0;
                            } else {
                                valueBegin = i;
                                int semiPos = header2.indexOf(59, i);
                                i = semiPos > 0 ? semiPos : headerLen;
                                valueEnd = i;
                            }
                        }
                        break block13;
                    } while (++i != headerLen);
                    nameEnd = headerLen;
                    valueEnd = -1;
                    valueBegin = -1;
                }
            }
            if (valueEnd > 0 && header2.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (cookieBuilder == null) {
                DefaultCookie cookie = this.initCookie(header2, nameBegin, nameEnd, valueBegin, valueEnd);
                if (cookie == null) {
                    return null;
                }
                cookieBuilder = new CookieBuilder(cookie);
                continue;
            }
            String attrValue = valueBegin == -1 ? null : header2.substring(valueBegin, valueEnd);
            cookieBuilder.appendAttribute(header2, nameBegin, nameEnd, attrValue);
        }
        return cookieBuilder.cookie();
    }

    private static class CookieBuilder {
        private final DefaultCookie cookie;
        private String domain;
        private String path;
        private int maxAge = Integer.MIN_VALUE;
        private String expires;
        private boolean secure;
        private boolean httpOnly;

        public CookieBuilder(DefaultCookie cookie) {
            this.cookie = cookie;
        }

        private int mergeMaxAgeAndExpire(int maxAge, String expires) {
            Date expiresDate;
            if (maxAge != Integer.MIN_VALUE) {
                return maxAge;
            }
            if (expires != null && (expiresDate = HttpHeaderDateFormat.get().parse(expires, new ParsePosition(0))) != null) {
                long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
                return (int)(maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0));
            }
            return Integer.MIN_VALUE;
        }

        public Cookie cookie() {
            this.cookie.setDomain(this.domain);
            this.cookie.setPath(this.path);
            this.cookie.setMaxAge(this.mergeMaxAgeAndExpire(this.maxAge, this.expires));
            this.cookie.setSecure(this.secure);
            this.cookie.setHttpOnly(this.httpOnly);
            return this.cookie;
        }

        public void appendAttribute(String header2, int keyStart, int keyEnd, String value) {
            this.setCookieAttribute(header2, keyStart, keyEnd, value);
        }

        private void setCookieAttribute(String header2, int keyStart, int keyEnd, String value) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(header2, keyStart, value);
            } else if (length == 6) {
                this.parse6(header2, keyStart, value);
            } else if (length == 7) {
                this.parse7(header2, keyStart, value);
            } else if (length == 8) {
                this.parse8(header2, keyStart, value);
            }
        }

        private void parse4(String header2, int nameStart, String value) {
            if (header2.regionMatches(true, nameStart, "Path", 0, 4)) {
                this.path = value;
            }
        }

        private void parse6(String header2, int nameStart, String value) {
            if (header2.regionMatches(true, nameStart, "Domain", 0, 5)) {
                this.domain = value.length() > 0 ? value.toString() : null;
            } else if (header2.regionMatches(true, nameStart, "Secure", 0, 5)) {
                this.secure = true;
            }
        }

        private void setExpire(String value) {
            this.expires = value;
        }

        private void setMaxAge(String value) {
            try {
                this.maxAge = Math.max(Integer.valueOf(value), 0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void parse7(String header2, int nameStart, String value) {
            if (header2.regionMatches(true, nameStart, "Expires", 0, 7)) {
                this.setExpire(value);
            } else if (header2.regionMatches(true, nameStart, "Max-Age", 0, 7)) {
                this.setMaxAge(value);
            }
        }

        private void parse8(String header2, int nameStart, String value) {
            if (header2.regionMatches(true, nameStart, "HTTPOnly", 0, 8)) {
                this.httpOnly = true;
            }
        }
    }
}

