/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx;

import org.apache.kudu.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker07;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import org.apache.kudu.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final long maxFramePayloadLength;

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, Long.MAX_VALUE);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        this.webSocketURL = webSocketURL;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest req) {
        String version2 = req.headers().get("Sec-WebSocket-Version");
        if (version2 != null) {
            if (version2.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
            }
            if (version2.equals(WebSocketVersion.V08.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker08(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
            }
            if (version2.equals(WebSocketVersion.V07.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker07(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
            }
            return null;
        }
        return new WebSocketServerHandshaker00(this.webSocketURL, this.subprotocols, this.maxFramePayloadLength);
    }

    public ChannelFuture sendUnsupportedWebSocketVersionResponse(Channel channel) {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.setStatus(HttpResponseStatus.UPGRADE_REQUIRED);
        res.headers().set("Sec-WebSocket-Version", WebSocketVersion.V13.toHttpHeaderValue());
        return channel.write(res);
    }
}

